#include "AdvMessage.hh"


const std::string AdvMessage::ERROR_LEADER="Error";
const std::string AdvMessage::WARNING_LEADER="Warning";
const std::string AdvMessage::INFO_LEADER="Info";
const std::string AdvMessage::DEBUG_LEADER="Debug";

const std::string AdvMessage::SCOPE="::";
const std::string AdvMessage::SEPARATOR=": ";

//------------------------------------------------------------------------------------------
/**
 *    output a leader std::strings to the standard error output
 *
 *  \param[in] leader     leader std::string
 *  \param[in] className  class name
 *  \param[in] memberName member name
 */
void AdvMessage::outputLeader(const std::string &className, const std::string &memberName) {
    std::cout << className << SCOPE << memberName << SEPARATOR;
}

/**
 *    output a leader std::strings to the standard error output
 *
 *  \param[in] leader     leader std::string
 *  \param[in] className  class name
 *  \param[in] memberName member name
 */
void AdvMessage::outputLeader(const std::string &leader, const std::string &className, const std::string &memberName) {
    std::cerr << leader << SEPARATOR << className << SCOPE << memberName << SEPARATOR;
}

void AdvMessage::outputLeader(const std::string &leader, const std::string &className, const std::string &memberName, const Char *file, const Int4 line) {
    std::cerr << leader << SEPARATOR << className << SCOPE << memberName << SEPARATOR << file << SEPARATOR << line << SEPARATOR;
}

/** oputput a description to the standard error outoput
 *
 *  \param[in] description a message std::string
 */
void AdvMessage::outputMessage(const std::string &description) {
    std::cerr << description << std::endl;
}

//------------------------------------------------------------------------------------------



/**
 *  output an error message with leader to the standard output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
//void AdvMessage::message(const std::string &className, const std::string &memberName, const std::string &description) {
//    outputLeader(className, memberName);
//    outputMessage(description);
//}

/**
 *  output an error message with leader in the given format to the standard output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
//void AdvMessage::message(const std::string &className, const std::string &memberName, const char *format, ...)  {
//    va_list ap;
//
//    outputLeader(className, memberName);
//
//    va_start(ap, format);
//    std::vfprintf(stdout, format, ap);
//    va_end(ap);
//}

/**
 *  output an error message without leader in the given format to the standard output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::message(const char *format, ...)  {
    va_list ap;
    va_start(ap, format);
    std::vfprintf(stdout, format, ap);
    va_end(ap);
}

//------------------------------------------------------------------------------------------
/**
 *  output an error message with leader to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
//void AdvMessage::errorMessage(const std::string &className, const std::string &memberName, const Char *file, const Int4 line, const std::string &description)  {
//    outputLeader(ERROR_LEADER, className, memberName, file, line);
//    outputMessage(description);
//}

/**
 *  output an error message with leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::errorMessage(const std::string &className, const std::string &memberName, const Char *file, const Int4 line, const char *format, ...)  {
    va_list ap;

    outputLeader(ERROR_LEADER, className, memberName, file, line);

    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}






/**
 *  output an error message with leader to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
//void AdvMessage::errorMessage(const std::string &className, const std::string &memberName, const std::string &description)  {
//    outputLeader(ERROR_LEADER, className, memberName);
//    outputMessage(description);
//}

/**
 *  output an error message with leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::errorMessage(const std::string &className, const std::string &memberName, const char *format, ...)  {
    va_list ap;

    outputLeader(ERROR_LEADER, className, memberName);

    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

/**
 *  output an error message without leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::errorMessage(const char *format, ...)  {
    va_list ap;
    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

//------------------------------------------------------------------------------------------
/**
 *  output an warning message with leader to the standard error output
 *  
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
//void AdvMessage::warningMessage(const std::string &className, const std::string &memberName, const Char *file, const Int4 line, const std::string &description)  {
//    outputLeader(WARNING_LEADER, className, memberName);
//    outputMessage(description);
//}

/**
 *  output an warning message with leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::warningMessage(const std::string &className, const std::string &memberName, const Char *file, const Int4 line, const char *format, ...)  {
    va_list ap;

    outputLeader(WARNING_LEADER, className, memberName);

    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

/**
 *  output an warning message with leader to the standard error output
 *  
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
//void AdvMessage::warningMessage(const std::string &className, const std::string &memberName, const std::string &description)  {
//    outputLeader(WARNING_LEADER, className, memberName);
//    outputMessage(description);
//}

/**
 *  output an warning message with leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::warningMessage(const std::string &className, const std::string &memberName, const char *format, ...)  {
    va_list ap;

    outputLeader(WARNING_LEADER, className, memberName);

    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

/**
 *  output an warning message without leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::warningMessage(const char *format, ...)  {
    va_list ap;
    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

//------------------------------------------------------------------------------------------
/**
 *  output an infomation message with leader to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
void AdvMessage::infoMessage(const std::string &className, const std::string &memberName, const std::string &description)  {
    outputLeader(INFO_LEADER, className, memberName);
    outputMessage(description);
}

/**
 *  output an information message with leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::infoMessage(const std::string &className, const std::string &memberName, const char *format, ...)  {
    va_list ap;

    outputLeader(INFO_LEADER, className, memberName);

    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

/**
 *  output an information message without leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::infoMessage(const char *format, ...)  {
    va_list ap;
    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

//------------------------------------------------------------------------------------------
/**
 *  output an debug message with leader to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
void AdvMessage::debugMessage(const std::string &className, const std::string &memberName, const Char *file, const Int4 line, const std::string &description)  {
    outputLeader(DEBUG_LEADER, className, memberName, file, line);
    outputMessage(description);
}

/**
 *  output an debug message with leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::debugMessage(const std::string &className, const std::string &memberName, const Char *file, const Int4 line, const char *format, ...)  {
    va_list ap;

    outputLeader(DEBUG_LEADER, className, memberName, file, line);

    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

/**
 *  output an debug message with leader to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] description a mesage std::string
 */
void AdvMessage::debugMessage(const std::string &className, const std::string &memberName, const std::string &description)  {
    outputLeader(DEBUG_LEADER, className, memberName);
    outputMessage(description);
}

/**
 *  output an debug message with leader in the given format to the standard error output
 *
 *  \param[in] className   the name of the class
 *  \param[in] memberName  the name of the menber in the class
 *  \param[in] format      the format for a message
 *  \param[in] ...         varable argments
 */
void AdvMessage::debugMessage(const std::string &className, const std::string &memberName, const char *format, ...)  {
    va_list ap;

    outputLeader(DEBUG_LEADER, className, memberName);

    va_start(ap, format);
    std::vfprintf(stderr, format, ap);
    va_end(ap);
}

///**
// *  output an debug message without leader in the given format to the standard error output
// *
// *  \param[in] className   the name of the class
// *  \param[in] memberName  the name of the menber in the class
// *  \param[in] format      the format for a message
// *  \param[in] ...         varable argments
// */
//void AdvMessage::debugMessage(const char *format, ...)  {
//    va_list ap;
//    va_start(ap, format);
//    std::vfprintf(stderr, format, ap);
//    va_end(ap);
//}
