# -*- coding: utf-8 -*-
import sys
#from pyqtgraph.Qt import QtCore, QtGui, uic
try:
    import PySide6
except:
    import PySide2
#import pyqtgraph as pg #[tito 20220525] pyqtgraphからである必要性は？
import pyqtgraph.opengl as gl
import numpy as np
from OpenGL.GL import *
import GLAxisItem2
import GLLabelItem
import ViewMainData
import math

from OpenGL.GLU import *
from OpenGL.GLUT import *

class ViewSubData(object):
    LINEAR_SCALE = 0
    LOG_SCALE    = 1

    def __init__(self):

        self.origin    = [0, 0, 0]

        self.transFlag = True
        # 軸
        #-----------------------------------------------
        self.axisVisible = True
        self.axis = GLAxisItem2.GLAxisItem2()
        self.lenXaxis  =  10
        self.lenYaxis  =  10
        self.lenZaxis  =  10
        self.axisWidth =  2
        self.axisType  =  0

        # 軸ラベル
        #-----------------------------------------------
        self.axisFont =GLUT_BITMAP_TIMES_ROMAN_24
        self.xAxisLabel = GLLabelItem.GLLabelItem()
        self.xAxisLabel.setColor([1, 0, 0, 0.6])
        self.xAxisLabel.setText("qx")

        self.yAxisLabel = GLLabelItem.GLLabelItem()
        self.yAxisLabel.setColor([1, 1, 0, 0.6])
        self.yAxisLabel.setText("qy")

        self.zAxisLabel = GLLabelItem.GLLabelItem()
        self.zAxisLabel.setColor([0, 1, 0, 0.6])
        self.zAxisLabel.setText("energy")

        # Axis Tick
        #-----------------------------------------------
        tickNum = 6
        self.axisTickVisible = True
        self.xAxisTick = []
        self.yAxisTick = []
        self.zAxisTick = []
        for i in range(tickNum):
            self.xAxisTick.append(GLLabelItem.GLLabelItem())
            self.xAxisTick[i].setColor([1, 0, 0, 0.6])
            self.xAxisTick[i].setText("")

            self.yAxisTick.append(GLLabelItem.GLLabelItem())
            self.yAxisTick[i].setColor([1, 1, 0, 0.6])
            self.yAxisTick[i].setText("")

            self.zAxisTick.append(GLLabelItem.GLLabelItem())
            self.zAxisTick[i].setColor([0, 1, 0, 0.6])
            self.zAxisTick[i].setText("")

        # Grid
        #-----------------------------------------------
        self.gridXYVisible = False
        self.gridYZVisible = False
        self.gridZXVisible = False
        self.gridSpace = [0.2, 0.2, 1.0]
        self.gridSize  = [10.0, 10.0, 10.0]
        self.gridPos   = [0.0, 0.0, 0.0]
        self.gridXY = gl.GLGridItem()
        self.gridYZ = gl.GLGridItem()
        self.gridYZ.rotate(90.0, 0.0, 1.0, 0.0)
        self.gridZX = gl.GLGridItem()
        self.gridZX.rotate(90.0, 1.0, 0.0, 0.0)


# test
#        self.gridSpace = [0.5, 0.5, 1]
#        self.gridSize  = [4.64, 3.88, 30.4]
#        self.gridPos   = [-0.8, -1.24, 0.4]
##        self.gridPos   = [0, 0, 0]
#        self.gridScaleX = 0.836
#        self.gridScaleY = 1.0
#        self.gridScaleZ = 0.131

        # スケール
        #-----------------------------------------------
        self.scale     = ViewSubData.LOG_SCALE
        self.autoScale = False
        self.scalarRangeMin = 1e-7
        self.scalarRangeMax = 1e-6

        # カラーバー
        #-----------------------------------------------
        # カラーバープリセット
        self.colorBarPreset = 'flame'
         # cyclic, spectrum, thermal, flame, yellowy, bipolar, greyclip, grey


        # Scroll Bar
        #---------------------------------
        self.xscrollMax  = 100
        self.xscrollStep =   2
        self.yscrollMax  = 100
        self.yscrollStep =   2
        self.zscrollMax  = 100
        self.zscrollStep =   2

        #---------------------------------
#        self.updateAxis()
#        self.updateGrid()
#        self.updateAxisLabelFont(self.axisFont)

    def setOrigin(self, x, y, z):
        self.origin[0] = float(x)
        self.origin[1] = float(y)
        self.origin[2] = float(z)

    def updateAxis(self):
        self.axis.setLineWidth(self.axisWidth)
        self.axis.setLineType(self.axisType)

        lenX = self.lenXaxis * self.viewMainData.basicSliceAx1Scale
        lenY = self.lenYaxis * self.viewMainData.basicSliceAx2Scale
        lenZ = self.lenZaxis * self.viewMainData.basicSliceAx3Scale

        self.axis.setSize(lenX, lenY, lenZ)

        x0 = self.origin[0] * self.viewMainData.basicSliceAx1Scale
        y0 = self.origin[1] * self.viewMainData.basicSliceAx2Scale
        z0 = self.origin[2] * self.viewMainData.basicSliceAx3Scale

        scaledOrigin = [x0, y0, z0]
        self.axis.setOrigin(scaledOrigin)


        self.xAxisLabel.setPosition(lenX+x0, y0, z0)
        self.yAxisLabel.setPosition(x0, lenY+y0, z0)
        self.zAxisLabel.setPosition(x0, y0, lenZ+z0)

    def updateGrid(self):
        self.gridXY.resetTransform()
        self.gridYZ.resetTransform()
        self.gridZX.resetTransform()

        gSizeX = self.gridSize[0]
        gSizeY = self.gridSize[1]
        gSizeZ = self.gridSize[2]

        r = 0.0
        if self.origin[0] >= 0:
            r = math.ceil(self.origin[0]/self.gridSpace[0])
        else:
            r = math.floor(self.origin[0]/self.gridSpace[0])
        orgX = r * self.gridSpace[0]
        gSizeX = gSizeX + self.gridSpace[0] * 2

        if self.origin[1] >= 0:
            r = math.ceil(self.origin[1]/self.gridSpace[1])
        else:
            r = math.floor(self.origin[1]/self.gridSpace[1])
        orgY = r * self.gridSpace[1]
        gSizeY = gSizeY + self.gridSpace[1] * 2

        if self.origin[2] >= 0:
            r = math.ceil(self.origin[2]/self.gridSpace[2])
        else:
            r = math.floor(self.origin[2]/self.gridSpace[2])
        orgZ = r * self.gridSpace[2]
        gSizeZ = gSizeZ + self.gridSpace[2] * 2

        #----
        x0 = (orgX + gSizeX/2.0) * self.viewMainData.basicSliceAx1Scale
        y0 = (orgY + gSizeY/2.0) * self.viewMainData.basicSliceAx2Scale
        z0 = self.gridPos[2] * self.viewMainData.basicSliceAx3Scale

        self.gridXY.setSize(gSizeX, gSizeY, gSizeZ)
        self.gridXY.setSpacing(self.gridSpace[0], self.gridSpace[1], self.gridSpace[2])
        self.gridXY.scale(self.viewMainData.basicSliceAx1Scale,
                          self.viewMainData.basicSliceAx2Scale, 1.0)
        self.gridXY.translate(x0, y0, z0)


#        print orgX, orgY, orgZ
#        print self.gridPos
#        print x0, y0, z0
        #----

        self.gridYZ.setSize(gSizeZ, gSizeY, gSizeX)
        self.gridYZ.setSpacing(self.gridSpace[2], self.gridSpace[1], self.gridSpace[0])
        x0 = self.gridPos[0] * self.viewMainData.basicSliceAx1Scale
        y0 = (orgY + gSizeY/2.0) * self.viewMainData.basicSliceAx2Scale
        z0 = (orgZ + gSizeZ/2.0) * self.viewMainData.basicSliceAx3Scale

        self.gridYZ.scale(self.viewMainData.basicSliceAx3Scale,
                          self.viewMainData.basicSliceAx2Scale, 1.0)
        self.gridYZ.rotate(-90, 0, 1, 0)
        self.gridYZ.translate(x0, y0, z0)

        #----

        self.gridZX.setSize(gSizeX, gSizeZ, gSizeY)
        self.gridZX.setSpacing(self.gridSpace[0], self.gridSpace[2], self.gridSpace[2])
        x0 = (orgX + gSizeX/2.0) * self.viewMainData.basicSliceAx1Scale
        y0 = self.gridPos[1] * self.viewMainData.basicSliceAx2Scale
        z0 = (orgZ + gSizeZ/2.0) * self.viewMainData.basicSliceAx3Scale

        self.gridZX.scale(self.viewMainData.basicSliceAx1Scale,
                          self.viewMainData.basicSliceAx3Scale, 1.0)
        self.gridZX.rotate(90, 1, 0, 0)
        self.gridZX.translate(x0, y0, z0)

        # x0 = self.origin[0]
        # y0 = self.origin[1]
        # z0 = self.origin[2]

        # self.gridXY.resetTransform()
        # self.gridYZ.resetTransform()
        # self.gridZX.resetTransform()

        # self.gridXY.scale(self.gridScaleX, self.gridScaleY, 1.0)
        # self.gridXY.translate(x0, y0, z0)

        # self.gridYZ.scale(self.gridScaleZ, self.gridScaleY, 1.0)
        # self.gridYZ.rotate(90, 0, 1, 0)
        # self.gridYZ.translate(x0, y0, z0)

        # self.gridZX.scale(self.gridScaleX, self.gridScaleZ, 1.0)
        # self.gridZX.rotate(90, 1, 0, 0)
        # self.gridZX.translate(x0, y0, z0)

    def updateAxisLabel(self):
        self.xAxisLabel.setText(self.viewMainData.ax1Slice.axisTitle)
        self.yAxisLabel.setText(self.viewMainData.ax2Slice.axisTitle)
        self.zAxisLabel.setText(self.viewMainData.ax3Slice.axisTitle)

    def updateAxisTick(self):
        x0 = self.origin[0] * self.viewMainData.basicSliceAx1Scale
        y0 = self.origin[1] * self.viewMainData.basicSliceAx2Scale
        z0 = self.origin[2] * self.viewMainData.basicSliceAx3Scale

        tickXnum = len(self.xAxisTick)
        dValue = self.lenXaxis/(tickXnum-1)
        for id in range(tickXnum):
            if id == 0 or id == (tickXnum - 1):
                continue
            value = self.origin[0] + dValue * id
            posX  = value * self.viewMainData.basicSliceAx1Scale
            self.xAxisTick[id].setText('%.1f' % value)
            self.xAxisTick[id].setPosition(posX, y0, z0)

        tickYnum = len(self.yAxisTick)
        dValue = self.lenYaxis/(tickYnum-1)
        for id in range(tickYnum):
            if id == 0 or id == (tickYnum - 1):
                continue
            value = self.origin[1] + dValue * id
            posY  =  value * self.viewMainData.basicSliceAx2Scale
            self.yAxisTick[id].setText('%.1f' % value)
            self.yAxisTick[id].setPosition(x0, posY, z0)

        tickZnum = len(self.zAxisTick)
        dValue = self.lenZaxis/(tickZnum-1)
        for id in range(tickZnum):
            if id == 0 or id == (tickZnum - 1):
                continue
            value = self.origin[2] + dValue * id
            posZ  = value * self.viewMainData.basicSliceAx3Scale
            self.zAxisTick[id].setText('%.1f' % value)
            self.zAxisTick[id].setPosition(x0, y0, posZ)


    def updateAxisLabelFont(self, font):
        self.axisFont = font
        self.xAxisLabel.fontType = self.axisFont
        self.yAxisLabel.fontType = self.axisFont
        self.zAxisLabel.fontType = self.axisFont

        tickXnum = len(self.xAxisTick)
        for id in range(tickXnum):
            self.xAxisTick[id].fontType = self.axisFont

        tickYnum = len(self.yAxisTick)
        for id in range(tickXnum):
            self.yAxisTick[id].fontType = self.axisFont

        tickZnum = len(self.zAxisTick)
        for id in range(tickXnum):
            self.zAxisTick[id].fontType = self.axisFont
