/*
$Id: StringTools.hh 1903 2008-03-22 04:32:09Z jisuzuki $
*/


#include "Header.hh"

#ifndef STRINGTOOLS
#define STRINGTOOLS

//!Collection of std::string tools
/*!This class is the collection of std::string tools.
  A std::string is splited into string element with
  a delimiter std::string by using "SplitString( std::string )".
 */
class StringTools
{
public:
  StringTools(){}
  /*!<Constructor. */
 ~StringTools(){}
  /*!<Destructor. */

  std::vector<std::string> SplitString( std::string s, std::string d, bool doTrim=true ); //[inamura 130621]
  std::vector<std::string> SplitString( std::string s );
  /*!<The given std::string is splited into the std::string
   elements with delimiters of "space", "comma" and "tab".
   The results is returned in the vector of string type.
   If argument d is set, d is used as a delimiter and
   "space" and "\n" are ignored when doTrim is true. [inamura 130621]
   */

  Double StringToDouble( std::string s );
  /*!<This method converts a given std::string into the
   value of double.*/
  Float  StringToFloat( std::string s );
  /*!<This method converts a given std::string into the
   value of float.*/
  Int4   StringToInt4( std::string s );
  /*!<This method converts a given std::string into the
   integer.*/
  UInt4   StringToUInt4( std::string s );
  /*!<This method converts a given std::string into the
   integer.*/

  std::string DoubleToString( Double d );
  /*!<This method converts a given value into a string.*/
  std::string FloatToString( Float f );
  /*!<This method converts a given value into a string.*/
  std::string Int4ToString( Int4 i );
  /*!<This method converts a given integer into a string.*/
  std::string UInt4ToString( UInt4 i );
  /*!< Converts an unsigned integer into a string. */

  std::string VecUInt4ToString( std::vector<UInt4> v );
  std::string VecInt4ToString( std::vector<Int4> v );
  std::string VecStringToString( std::vector<std::string> v );
  std::string VecDoubleToString( std::vector<Double> v );


};

#endif
