/*
$Id: StringTools.cc 2556 2013-02-12 07:34:35Z yinamura $
*/


#include "StringTools.hh"
///////////////////////////////////////
std::vector<std::string> StringTools::
SplitString( std::string str )
{
  std::vector<std::string> sc;
  sc.clear();
  std::string Target = str;
  UInt4 TargetSize = (UInt4)(Target.size());
  std::string s;
  s.clear();

  for( UInt4 i=0; i<TargetSize; i++ ){
    if( !( Target[i] == '\t' ||
      Target[i] == ' '  ||
      Target[i] == ','  )  )
      s.push_back( Target[i] );
    else{
      if( s.size() != 0 ){
        sc.push_back( s );
        s.clear();
      }
    }
  }
  if (s.empty()){  // Y.Inamura fixed at 2013/02/12
  }else{
    sc.push_back( s );
  }
  return sc;
}
/////////////////////////////////////// [inamura 130621]-->
std::vector<std::string> StringTools::
SplitString( std::string str, std::string dlm, bool doTrim )
{
  std::vector<std::string> sc;
  sc.clear();
  std::string Target = str;
  std::string Delim = dlm;
  UInt4 TargetSize = (UInt4)(Target.size());
  UInt4 DelimSize = (UInt4)(Delim.size());
  std::string s;
  s.clear();

  for( UInt4 i=0; i<TargetSize; i++ ){
      // Trim space, tab and return off target std::string if they are not delimter.
      if (doTrim){
        bool doSkip = false;
        for ( UInt4 j=0; j<DelimSize; j++ ){
          if( (Delim[j] != ' ') && (Target[i] == ' ') ) doSkip = true;
          if( (Delim[j] != '\t') && (Target[i] == '\t') ) doSkip = true;
          if( (Delim[j] != '\n') && (Target[i] == '\n') ) doSkip = true;
          if (doSkip) break;
        }
        if (doSkip) continue;
      }

      bool isDelim = false;
      for ( UInt4 j=0; j<DelimSize; j++ ){
        if( Target[i] == Delim[j] ) {
          isDelim = true;
          break;
        }
      }

      if (isDelim){
        if( s.size() != 0 ){
          sc.push_back( s );
          s.clear();
        }
      }else{
        s.push_back( Target[i] );
      }
  }

  if (s.empty()){
  }else{
    sc.push_back( s );
  }
  return sc;
}
// <--[inamura 130621]
///////////////////////////////////////
Double StringTools::
StringToDouble( std::string s )
{
  Double d = atof( s.data() );
  return d;
}
///////////////////////////////////////
Float StringTools::
StringToFloat( std::string s )
{
  Float f = (Float)(atof( s.data() ));
  return f;
}
///////////////////////////////////////
Int4 StringTools::
StringToInt4( std::string s )
{
  Int4 i = atoi( s.data() );
  return i;
}
///////////////////////////////////////
UInt4 StringTools::
StringToUInt4( std::string s )
{
  UInt4 i = abs( atoi( s.data() ) );
  return i;
}
///////////////////////////////////////
std::string StringTools::
DoubleToString( Double d )
{
  Char c[1024];
  std::snprintf( c, sizeof(c), "%f", d );
  std::string s = std::string( c );
  return s;
}
///////////////////////////////////////
std::string StringTools::
FloatToString( Float f )
{
  Char c[1024];
  std::snprintf( c, sizeof(c), "%f", f );
  std::string s = std::string( c );
  return s;
}
/////////////////////////////////////
std::string StringTools::
Int4ToString( Int4 i )
{
  Char c[1024];
  std::snprintf( c, sizeof(c), "%d", i );
  std::string s = std::string( c );
  return s;
}
///////////////////////////////////////
std::string StringTools::
UInt4ToString( UInt4 i )
{
  Char c[1024];
  //std::sprintf( c, "%d", i );
  std::snprintf( c, sizeof(c), "%u", i ); // changed by Y.Inamura at 141021
  std::string s = std::string( c );
  return s;
}
///////////////////////////////////////
std::string StringTools::
VecUInt4ToString( std::vector<UInt4> v ){
  std::string r;
  r.clear();
  for( UInt4 i=0; i<v.size()-1; i++ ){
    r = r + UInt4ToString( v[i] ) + " ";
  }
  r = r + UInt4ToString( v[ v.size()-1 ] );
  return r;
}
////////////////////////////////////////
std::string StringTools::
VecInt4ToString( std::vector<Int4> v ){
  std::string r;
  r.clear();
  for( UInt4 i=0; i<v.size()-1; i++ ){
    r = r + Int4ToString( v[i] ) + " ";
  }
  r = r + Int4ToString( v[ v.size()-1 ] );
  return r;
}
////////////////////////////////////////
std::string StringTools::
VecStringToString( std::vector<std::string> v ){
  std::string r;
  r.clear();
  for( UInt4 i=0; i<v.size()-1; i++ ){
    r = r + v[i] + " ";
  }
  r = r + v[ v.size()-1 ];
  return r;
}
////////////////////////////////////////
std::string StringTools::
VecDoubleToString( std::vector<Double> v ){
  std::string r;
  r.clear();
  for( UInt4 i=0; i<v.size()-1; i++ ){
    r = r + DoubleToString( v[i] ) + " ";
  }
  r = r + DoubleToString( v[ v.size()-1 ] );
  return r;
}
////////////////////////////////////////

