/*
$Id: ReadTextFile.hh 2314 2011-12-06 12:57:31Z jisuzuki $
*/


#ifndef READTEXTFILE
#define READTEXTFILE

#include "Header.hh"
#include "SplitString.hh"
#include "CppToPython.hh"


class ReadTextFile
/*
The speed of reading text files with this class is slow,
because each line of targeted text-file will be
analyzed and processed in this class.
*/
{
private:
  std::vector< std::string > *StringBuffer;
  UInt4 CheckFile( std::string FileName );
  void  Read( std::string FileName );
  UInt4 Size;
  SplitString *split;

public:
  ReadTextFile();
  /*!<Constructor. */
 ~ReadTextFile();
  /*!<Destructor. */

  void SetFileName( std::string TargetFileName );
  /*!< Set the target file name in the string type.
    The file size of the target file is estimated in this method.
    The line number of the file can be obtained with "PutSize()".
   */

  void Dump();
  /*!<Dump the contents of target file to STD-out. */
  UInt4 PutSize();
  /*!<Returns the number of lines contained in the target file. */

  std::string Put( UInt4 IndexNumber );
  /*!<Returns IndexNumber-th value in string type format. */

  std::vector<std::string> Put( UInt4 IndexNumber, std::string Delimiter );
  /*!<Returns a vector whose size is defined by the second argument.
   The IndexNumber-th line is devided by using the second argument
   as a delimiter.*/


};

#endif
