/*
$Id: OperatorBase.cc 1958 2008-08-12 00:06:30Z jisuzuki $
*/


#include "OperatorBase.hh"
#ifndef  OPERATORBASE_CC
#define  OPERATORBASE_CC

///////////////////////////////////////////////////
template < class T1, class T2 >
OperatorBase< T1, T2 >::
OperatorBase( )
{
  InputVec.clear();
  OutputVec.clear();
  IsCopiedInput.clear();
}
///////////////////////////////////////////////////
template < class T1, class T2 >
OperatorBase< T1, T2 >::
~OperatorBase( )
{
  UInt4 size_out = (UInt4)(OutputVec.size());
  for( UInt4 i=0; i<size_out; i++ ){
    delete OutputVec[i];
  }
}
//////////////////////////////////////////////////
template < class T1, class T2 >
void OperatorBase< T1, T2 >::
SetInput( T1 InputObj )
{
  T1 *InputObjP = new T1();
  *InputObjP = InputObj;
  InputVec.push_back( InputObjP );
  IsCopiedInput.push_back( true );
}
//////////////////////////////////////////////////
template < class T1, class T2 >
void OperatorBase< T1, T2 >::
SetInputP( T1 *InputObj )
{
  //T1 *InputObjP = new T1();
  //*InputObjP = InputObj;
  //InputVec.push_back( InputObjP );
  InputVec.push_back( InputObj );
  IsCopiedInput.push_back( false );
}
//////////////////////////////////////////////////
template < class T1, class T2 >
void OperatorBase< T1, T2 >::
SetOutput( T2 * OutputObj )
{
  OutputVec.push_back( OutputObj );
}
//////////////////////////////////////////////////
template < class T1, class T2 >
T2 OperatorBase< T1, T2 >::
Put( UInt4 index )
{
  if( OutputVec.size() > index ){
    T2 OutputTmp;
    OutputTmp = *( OutputVec[ index ] );
    return OutputTmp;
  }

  else if( OutputVec.size() == 0 ){
    T2 tmp;
    return tmp;
  }

  else{
    std::cout << "OperatorBase::Put(index)" << std::endl;
    std::cout << "The index is too large." << std::endl;
    std::cout << "The present size of the output storage is "
              << OutputVec.size() << "." << std::endl;
    std::cout << "To avoid causing errors," << std::endl;
    std::cout << "a data object initialized by the constructor "
              << "is returned." << std::endl;
    T2 tmp;
    return tmp;
  }
}
//////////////////////////////////////////////////
/*
template < class T1, class T2 >
T2* OperatorBase< T1, T2 >::
Duplicate( UInt4 index )
{
  if( OutputVec.size() > index ){
    T2 *t = new T2;
    *t = *( OutputVec[index] );
    return t;
  }

  else if( OutputVec.size() == 0 ){
    std::cout << "The size of output storage is zero." << std::endl;
    std::cout << "You should produce and store the results into "
              << "the storage before extracting data.." << std::endl;
  }

  else{
    std::cout << "OperatorBase::Put(index)" << std::endl;
    std::cout << "The input index is too large." << std::endl;
    std::cout << "The present size of the output storage is "
              << OutputVec.size() << "." << std::endl;
    return NULL;
  }

  return NULL;
}
*/
//////////////////////////////////////////////////
template < class T1, class T2 >
void OperatorBase< T1, T2 >::
Clear()
{
  UInt4 size_in = (UInt4)(InputVec.size());
  for( UInt4 i=0; i<size_in; i++ ){
    if (IsCopiedInput[i])
        delete InputVec[i];
  }

  UInt4 size_out = (UInt4)(OutputVec.size());
  for( UInt4 i=0; i<size_out; i++ ){
    delete OutputVec[i];
  }
  InputVec.clear();
  OutputVec.clear();
  IsCopiedInput.clear();
}
//////////////////////////////////////////////////
template < class T1, class T2 >
void OperatorBase< T1, T2 >::
ClearOutput()
{
  UInt4 size_out = (UInt4)(OutputVec.size());
  for( UInt4 i=0; i<size_out; i++ ){
    delete OutputVec[i];
  }
  OutputVec.clear();
}
//////////////////////////////////////////////////

#endif
