/*
$Id: ManipulatorBase.hh 1562 2006-06-08 10:27:20Z suzuki $
*/


#ifndef MANIPULATORBASE_HH
#define MANIPULATORBASE_HH
#include "Header.hh"

//! Manipulator for the data-object.
/*!
  This class is one of the base-class for
  constructing analysis operators.
  The functionality of the operator produced with
  this class is that
  the input data-object is operated some procedures
  in the derived class of this base-class
  and the pointer of input object is passed as output-object
  to the next operator.
  The dynamical data-object assigned to a result-object
  is not produced in the derived class.

  If you want to construct analysis operators whose functions
  are, (1) the type of input-object is not identical to the
  output-object, (2) the number of input or output objects is
  more than two, (3) the output object should be deleted
  by the destructor of the operator.

  See the manual of "OperatorBase".
 */


template < class T >
class ManipulatorBase
{
private:

protected:
  T *Target;

public:
  ManipulatorBase();
  /*!< Constructor */

  ~ManipulatorBase();
  /*!<
    Destructor.
    This method will delete the entry of the target object,
    but the target object will not delete.
  */

  void SetTarget( T *target ){ Target = target; }
  /*!<
    Set the pointer of the target data object.
    The pointer will be returned as output object by "T *Put()"
    after calculating.
   */

  T *Put(){ return Target;  }
  /*!<
    Return the target object operated in the derived class.
    The value of the pointer is identical to the value input by
    "void SetTarget( T* )".
    See the comments of "T *Duplicate()".
   */

  T *Duplicate();
  /*!<
    Return the calculated data-object.
    The contents of the object is identical with the
    object returned by "T* Put()".
    The returned dynamical data-object is constructed
    and copied in this method.
    The returned object should be deleted
    in your application.
   */

  void Clear(){ Target = NULL; }
  /*!<
  This method will delete the entry of the target object,
  but the target object will not delete.
  You can reuse the operator after calling this method.
  */
};

#include "ManipulatorBase.cc"
#endif
