/*
$Id: GaussianEventData.hh 1852 2007-12-27 04:20:32Z jisuzuki $
 */

#ifndef GAUSSIANEVENTDATA
#define GAUSSIANEVENTDATA

#include "Header.hh"
#include "GslRandGenerator.hh"

//! Event data generator with Gaussian function
/*! This class generate event data generator with Gaussian function and
  the class of GslRandGenerator.
 */

class GaussianEventData {

private:

  Double sigma;
  Double ave;
  Int4 ini;
  Int4 fin;
  GslRandGenerator *gr;
protected:
  Double f( Double x );
  UInt4 RandInt( UInt4 Max );
  Int4 RandInt( Int4 Min, Int4 Max );

public:
  GaussianEventData( Double Average, Double Sigma,
                     Int4 Ini, Int4 Fin );
  /*!< Constructor. The shape of Gaussian function is set with the arguments
    of this method. The minimum and maximum return value of the generator are
    Ini and Max. Average and Sigma are the expected value and the
    standard deviation.
   */
 ~GaussianEventData();


  Int4 Next();
  /*!< This method returns an integer. If you create the histogram
    filled with the return values, you will get a Gaussian distributed
    histogram.
   */
  std::vector<Int4> Generate( UInt4 size );
  /*!< This method returns a vector<Int4> vector object whose size is "size".
    The vector is filled the values obtained with "Next()".
   */
};

#endif
