# CentOS7用RPMパッケージ作成用SPECファイル
## 内容
RPMパッケージをビルドするために必要なファイル。

- build.sh -- ビルドスクリプト(deps, manyo用)
- manyo.spec -- 万葉ライブラリSPEC(manyo)
- manyo-deps-mxml-2.9.spec -- mxml(EPELのmxmlが3になったため)
- manyo-deps-nexus-4.3.1.spec -- NeXus SPEC(manyo-deps-nexus)
- manyo-deps-python-matplotlib-1.2.0-15.spec -- MatplotlibのwxPythonモジュール用
  - CentOS7以上ではpython-matplotlib-wxがサポート外となりビルドされなくなったため


## manyo-depsについて
CentOS7では万葉に必要なライブラリ等は標準+EPELでほとんどそろえることができるが、
NeXusおよびMatplotlibのwxPython対応のみが用意されていない。
また、2019年07月の時点でEPELのmxmlが3系列になったため、自動で取得できなくなった。

そのため、これらのパッケージをビルドし、インストールする必要がある。

### python-matplotlib
wxPython用のpython-matplotlibモジュールパッケージ。

ビルドすると、manyo-deps-python-matplotlibとmanyo-deps-python-matplotlib-wxが
作成される。できるだけ標準パッケージを使いたいので、matplotlib本体は
python-matplotlibを使い、manyo-deps-python-matplotlib-wxのみをインストールする。

manyo-deps-python-matplotlib-wxは `Provides: python-matplotlib-wx` にしてある。


## 動作確認環境
- CentOS 7.6.1810
- epel-release, Development Tools


## ビルド手順
### manyo-deps
それぞれの依存パッケージを解決するためにroot権限で `yum-builddep` を実行する。

    % ./build.sh mxml
    % sudo yum -y install ../../rpmbuild/RPMS/x86_64/manyo-deps-mxml-*

    % sudo yum-builddep -y manyo-deps-nexus-4.3.1.spec
    % sudo yum-builddep -y manyo-deps-python-matplotlib-1.2.0-15.spec
    % ./build.sh deps

依存パッケージのインストール

    % sudo yum -y install ../../rpmbuild/RPMS/x86_64/manyo-deps-nexus-*
    % sudo yum -y install ../../rpmbuild/RPMS/x86_64/manyo-deps-python-matplotlib-wx-*

### 万葉ライブラリ
RPMパッケージのビルド

    % sudo yum-builddep -y manyo.spec
    % ./build.sh manyo

万葉ライブラリのインストール

    % sudo yum -y install ../../rpmbuild/RPMS/x86_64/manyo-0*
    % sudo yum -y install ../../rpmbuild/RPMS/x86_64/manyo-devel-*

## 注意事項
### 万葉ライブラリのソースアーカイブファイルの名前について
RPMビルド時のリビジョン、コミット番号はファイル名から得ているため、アーカイブファイル名は
厳密である必要がある(ビルドスクリプトを使った場合は問題ないはず)。

    manyo-<branch>.<最終更新日>git<コミットSHA1の8桁>.tar.gz

から求めている。
