#!/bin/bash
set -xe

rm -rf /tmp/src
cp -av /mnt/src /tmp
chown -R builder:builder /tmp/src
cp -av /mnt/src/contrib/rpm/manyo.spec .
cp -av /mnt/src/contrib/rpm/manyo-*.patch .

# Build and install Manyo-lib
yum-builddep -y manyo.spec
sudo -u builder ./build.sh manyo /tmp/src
yum install -y rpmbuild/RPMS/x86_64/manyo-[0dp]*.rpm

# Copy generated RPMs
DIST=/mnt/src/dist-$(date +%Y%m%d%H%M%S)
mkdir -p $DIST/Source
cp -av rpmbuild/RPMS/x86_64/*.rpm $DIST
cp -av rpmbuild/SRPMS/*.rpm $DIST/Source
chown -R $(ls -lnd . | cut -d" " -f3-4 | sed 's/ /:/') $DIST

