# -*- coding: utf-8 -*-

import unittest

class TestManyoFunctions( unittest.TestCase ):

    StandardFile = "20141106"

    def test_ManyoAveraging( self ):

        import moduleAveraging
        moduleAveraging.ModTest.ElementContainerToText(
            moduleAveraging.e2,"Averaging2.txt" )
        moduleAveraging.ModTest.ElementContainerToText(
            moduleAveraging.e3, "Averaging3.txt" )
        
        self.assertTrue( moduleAveraging.ModTest.CompareTextFile(
            "Averaging2.txt", "Averaging2_" + self.StandardFile + ".txt" ) )
        self.assertTrue( moduleAveraging.ModTest.CompareTextFile(
            "Averaging3.txt", "Averaging3_" + self.StandardFile + ".txt" ) )

    def test_ManyoBinning( self ):

        import moduleBinning
        moduleBinning.ModTest.ElementContainerToText(
            moduleBinning.e2,"Binning2.txt" )
        moduleBinning.ModTest.ElementContainerToText(
            moduleBinning.e3, "Binning3.txt" )
        
        self.assertTrue( moduleBinning.ModTest.CompareTextFile(
            "Binning2.txt", "Binning2_" + self.StandardFile + ".txt" ) )
        self.assertTrue( moduleBinning.ModTest.CompareTextFile(
            "Binning3.txt", "Binning3_" + self.StandardFile + ".txt" ) )

    def test_BoostSerial( self ):
        
        import moduleBoostSerial
        moduleBoostSerial.ModTest.ElementContainerToText(
            moduleBoostSerial.e1r,"BoostSerial.txt" )
        
        self.assertTrue( moduleBoostSerial.ModTest.CompareTextFile(
            "BoostSerial.txt", "BoostSerial_" + self.StandardFile + ".txt" ) )

    def test_NeXus( self ):
        
        import moduleNeXus
        moduleNeXus.ModTest.ElementContainerToText(
            moduleNeXus.e2,"NeXus.txt" )
        
        self.assertTrue( moduleNeXus.ModTest.CompareTextFile(
            "NeXus.txt", "NeXus_" + self.StandardFile + ".txt" ) )


    def test_ArithMeticOperations( self ):
        
        import moduleArithmeticOperations
        
        moduleArithmeticOperations.ModTest.ElementContainerToText(
            moduleArithmeticOperations.eca,"ArithAdd.txt" )
        # ElementContainerを作成して テキストファイルに落とす
        
        moduleArithmeticOperations.ModTest.ElementContainerToText(
            moduleArithmeticOperations.ecs,"ArithSub.txt" )
        moduleArithmeticOperations.ModTest.ElementContainerToText(
            moduleArithmeticOperations.ecm,"ArithMul.txt" )
        moduleArithmeticOperations.ModTest.ElementContainerToText(
            moduleArithmeticOperations.ecd,"ArithDiv.txt" )
        moduleArithmeticOperations.ModTest.ElementContainerToText(
            moduleArithmeticOperations.e2,"Arith2.txt" )

        self.assertTrue( moduleArithmeticOperations.ModTest.CompareTextFile(
            "ArithAdd.txt", "ArithAdd_" + self.StandardFile + ".txt" ) )
        # 上記で作成したテキストファイルと、チェック済みのテキストファイルの
        # 比較を行う
        
        self.assertTrue( moduleArithmeticOperations.ModTest.CompareTextFile(
            "ArithSub.txt", "ArithSub_" + self.StandardFile + ".txt" ) )
        self.assertTrue( moduleArithmeticOperations.ModTest.CompareTextFile(
            "ArithMul.txt", "ArithMul_" + self.StandardFile + ".txt" ) )
        self.assertTrue( moduleArithmeticOperations.ModTest.CompareTextFile(
            "ArithDiv.txt", "ArithDiv_" + self.StandardFile + ".txt" ) )
        
        self.assertTrue( moduleArithmeticOperations.ModTest.CompareTextFile(
            "Arith2.txt", "Arith2_" + self.StandardFile + ".txt" ) )
        
# unittestの継承クラス すべてを実行する
if __name__ == '__main__':
    unittest.main()
    
        



