# Distributed parallel data analysis environment with python script
# has been prepared in Manyo Library with Boost C++ library.

# This environment should be executed with Boost C++ ver. 1.46.1.
# To solve this problem, we will prepare OpenMPI wrapper in future.

# The binary file of remote server has been built and installed
# into the targeted directory.
# The file name of source code of the remote server is
# "SerialPythonServerMain.cpp".


import Manyo
import Manyo.SerialPySrv as MS

# preparing data container which will be send to the remote server
# and analyze on the remote.
e1 = Manyo.ElementContainer()
vec = Manyo.MakeDoubleVector( 100 )
for i in range( 100 ):
    e1.Add( "x"+str(i), vec )

# Making the class object for parallel processing
cli = MS.SerialPythonServerClient( "localhost", "8888" )

# This object, vector<string>, will be executed on the remote server.
# The data object of "EX" in the script is prepared automatically.
PyCom = Manyo.MakeStringVector()
PyCom.push_back( "e = Manyo.ElementContainer()" )
PyCom.push_back( "EX.Receive(e)" )
PyCom.push_back( "EX.Transmit(e)" )
PyCom.push_back( "del( e )" )


# The script is transmitted to the remote server with
# the value of time-out of 3000 milli-seconds.
# The return value of this method is True or False.
Flag = cli.Start( PyCom, 3000 )


# If the return value is True, you can communicate with the remote server.
if Flag == True:
    Nex = cli.refSNE()
    Nex.Transmit( e1 )
    er = Manyo.ElementContainer()
    Nex.Receive( er )

