/*
 * $Id:$
 */

#include <boost/lexical_cast.hpp>
#include "SerialNeutronExchanger.hh"

class SerialPythonServerClient {
private:
  //! Boost ASIO iostream object to the remote host for the second connection
  class ASIO_local *Al;

  //! serializationized network stream for the second connection
  class SerialNeutronExchanger *SNE;

  std::string remhost;    // remote host is saved for the second connection
  std::string remport;    //
  UInt4 new_port;        // port number for the second connection
  UInt4 key;            // authentication key for the second connection

public:
  SerialPythonServerClient(const std::string remotehost, const std::string remoteport) :
    Al(NULL), SNE(NULL),
    remhost(remotehost), remport(remoteport) {
  }

  ~SerialPythonServerClient() {
    if (SNE!=NULL) delete SNE;
    if (SNE!=NULL) delete Al;
  }

  /**
   *
   * @param  s    python script to execute at remote host
   * @param  umax    max time for the connection timeout (m sec),
   *                0 means never timed out
   * @return false when connection failed
   */
  bool Start(const std::vector<std::string> &s,
    const UInt4 umax=0);

  class SerialNeutronExchanger &refSNE(void) const;

};
