# -*- coding: utf-8 -*-
import Manyo as m
import Manyo.MLF as mlf
import math

xList = [] # ヒストグラムのBinの定義
for i in range( 20 ):
    xList.append( float( i ) )

yList = [] # intensityが入る
eList = [] # intensityのエラーを入れる

ge = m.GaussianEventData( 50.0, 30.0, 1, 100 )
for i in range( len( xList ) -1 ):
    intensity = float( ge.Next() ) # intensityは乱数を入れる
    err       = math.sqrt( intensity )
    yList.append( intensity )
    eList.append( err )

e1 = m.ElementContainer()
# データコンテナを定義する

e1.Add( "x", xList ) # キー:x で登録する
e1.Add( "y", yList ) # キー:y で登録する
e1.Add( "e", eList ) # キー:e で登録する
e1.SetKeys( "x", "y", "e" ) # ヒストグラムとして認識させる
e1.Dump() # 標準出力に送る

import GnuPlotFormat
# Gnuplotのファイル形式で出してみる
# GnuPlotFormat.pyをカレントディレクトリにコピーしておくこと
GnuPlotFormat.DumpToFile( e1, "TestData.txt" )
GnuPlotFormat.DumpToFileErr( e1, "TestDataErr.txt" )
