/*
$Id: OnLineGnuPlot.hh 2284 2011-07-16 11:54:52Z jisuzuki $
 */

#ifndef ONLINEGNUPLOT
#define ONLINEGNUPLOT

#include "Header.hh"
#include "GslHistogram.hh"
#include "GnuplotInterface.hh"
#include "StringTools.hh"

class OnLineGnuPlot {

private:
  GnuplotInterface *gi;
  //std::vector< std::vector< GslHistogram* > * > *dat;
  void mplot();
  void splot();
  StringTools *st;

protected:
  std::vector< std::vector< GslHistogram* > * > *dat;

public:
  OnLineGnuPlot( std::string command="gnuplot" );
 ~OnLineGnuPlot();

  void e( std::string command ){ gi->e( command ); }
  void SetGrayColor();
  void SetDataObj( std::vector<GslHistogram*> *data,
                   std::vector< std::vector< UInt4 > > dim );
  void SetDataObj( std::vector<GslHistogram*> *data,
                   UInt4 x, UInt4 y );

  void MapPlot();
  void SurfacePlot();

  void MapPlot( UInt4 tof );
  void SurfacePlot( UInt4 tof );

  void TofVsCounts( UInt4 Psd );
};

#endif

/*
// the following is a sample code with this class.

EventDataToHistogramSample *eh =
  new EventDataToHistogramSample( 40, 100 );

// Set parameters and input event data


OnLineGnuPlot *olg = new OnLineGnuPlot();
std::vector< std::vector< UInt4 > > vvu;
std::vector<UInt4> v0;
std::vector<UInt4> v1;
std::vector<UInt4> v2;
for( UInt4 i=0; i<10; i++ ){
  v0.push_back( i );
  v1.push_back( i+10 );
  v2.push_back( i+20 );
}
vvu.push_back(v0);
vvu.push_back(v1);
vvu.push_back(v2);

std::vector<GslHistogram*> * vh = eh->PutGslHistogramVec();
olg->SetDataObj( eh->PutGslHistogramVec(), vvu );
olg -> SurfacePlot();

// input event data

olg -> SurfacePlot(); // show summed data
olg -> SurfacePlot( 20 ); // show tof data

delete olg;
*/
