#ifndef MLFPHYSICALCONSTANTS
#define MLFPHYSICALCONSTANTS

#include "Header.hh"
#include <cmath>
#include "gsl/gsl_const_mksa.h"
#include "gsl/gsl_const_num.h"

/****  Constants ******/

extern const Double MLF_PI;
extern const Double MLF_MASS_NEUTRON;  // Neutron mass [kg]
extern const Double MLF_Mn;            // Neutron mass [kg]
extern const Double MLF_PLANCK;        // Planck constant [Js]
extern const Double MLF_HBAR;          // Planck/2*PI [Js]
extern const Double MLF_NA;            // Avogadro constant [1/mol]
extern const Double MLF_kB;            // Boltzmann constant [J/K]

extern const std::string MLF_MASS_NEUTRON_UNIT;  // Neutron mass [kg]
extern const std::string MLF_Mn_UNIT;            // Neutron mass [kg]
extern const std::string MLF_PLANCK_UNIT;        // Planck constant [Js]
extern const std::string MLF_HBAR_UNIT;          // Planck/2*PI [Js]
extern const std::string MLF_NA_UNIT;            // Avogadro constant [1/mol]
extern const std::string MLF_kB_UNIT;            // Boltzmann constant [J/K]

/**** Unit Exchange ******/
//// mass ////
extern const Double MLF_KG2G;          // 1kg=1000g

//// length ////
extern const Double MLF_MM2M;          // 1[mm]=1e-03[m]
extern const Double MLF_M2MM;

extern const Double MLF_ANGSTROM2M;    // 1[A]=1.e-10[m]
extern const Double MLF_M2ANGSTROM;

extern const Double MLF_FM2M;          // 1[fm]=1.e-15[m]
extern const Double MLF_M2FM;

//// time ////
extern const Double MLF_SEC2MICROSEC;  // 1[sec]=1.e+06[microsec]
extern const Double MLF_MICROSEC2SEC;

//// energy ////
extern const Double MLF_EV2J;          // 1 [eV] = 1.6 [J]
extern const Double MLF_J2EV;          // 1 [J] = 1/1.6 [eV]
extern const Double MLF_MEV2J;         // 1meV=1.e-03eV
extern const Double MLF_J2MEV;

//// cross section ////
extern const Double MLF_BARN2M2;       // 1[barn]=1.e-24[cm^2]=1.e-28[m^2]
extern const Double MLF_M22BARN;

//// pressure ////
extern const Double MLF_ATM2PA;        // 1[atm] = 101325 [Pa]
extern const Double MLF_PA2ATM;

//// angle ////
extern const Double MLF_DEGREE2RADIAN; // 180[degree]=PI[radian]
extern const Double MLF_RADIAN2DEGREE;

/// Mask value ///
extern const Double MLF_MASKVALUE;

#endif
