/*
$Id: GnuplotInterface.hh 1922 2008-04-12 14:06:11Z jisuzuki $
 */

#ifndef GNUPLOTINTERFACE
#define GNUPLOTINTERFACE

#include "Header.hh"
#include "ReadWriteTextFile.hh"


//! Gnuplot interface
/*! Gnuplot in your system is called and gnuplot commands
  are passed with this class.
  Each gnuplot command is passed to the gnuplot through
  the standard input of the Gnuplot connected by the constructor,
  and each gnuplot command is stored in this class object.
  The history of the gnuplot command can be shown and saved to
  files.
 */

class GnuplotInterface
{
private:
  FILE *gid;
  std::vector<std::string> hi;

public:
  GnuplotInterface( std::string Command="gnuplot" );
  /*!< Constructor.
    If Gnuplot is not installed with its command name is "gnuplot"
    in your system, you must specify your gnuplot command.
   */
 ~GnuplotInterface();
  /*!< Destructor. Gnuplot called by the constructor
   is terminated.*/
  void ExeCommand( std::string Command );
  /*!< The argument of this method is sent to
   Gnuplot called by the constructor. */
  void e( std::string Command ){ ExeCommand( Command ); }
  /*!< Alias of ExeCommand(std::string)*/

  void ExeCommandSave( std::string Command );

  void Clear();
  /*!< The buffer storing command history is initialized.
    See the comment of "Save(std::string)".
   */
  void Dump();
  /*!< The contents of the buffer storing command history
    is shown to std-out.
   */
  void Save( std::string FileName );
  /*!< The contents of the butter storing command history
   is saved to the file named "FileName".*/
  void Replot();
  /*!<
    The contents of the butter storing command history
   is executed with this command.
   */
};

#endif
