// File: classAcquireNeutronSourceImageInformation.xml

%feature("docstring") AcquireNeutronSourceImageInformation "C++ includes: AcquireNeutronSourceImageInformation.hh 

";
%feature("docstring") AcquireNeutronSourceImageInformation::AcquireNeutronSourceImageInformation "AcquireNeutronSourceImageInformation::AcquireNeutronSourceImageInformation() AcquireNeutronSourceImageInformation::AcquireNeutronSourceImageInformation Constructor. 

    
AcquireNeutronSourceImageInformation::AcquireNeutronSourceImageInformation(std::string host_name, Bool debug_flag=false) AcquireNeutronSourceImageInformation::AcquireNeutronSourceImageInformation Constructor.
=================================================================================================================================================================================================================

    Args:
        host_name The server name which is the information Web page of neutron source.
        debug_flag The flag to show some parameters under running. ( OFF:false/0, ON:true/1 ) 
    
AcquireNeutronSourceImageInformation::AcquireNeutronSourceImageInformation(Bool debug_flag) AcquireNeutronSourceImageInformation::AcquireNeutronSourceImageInformation Constructor.
====================================================================================================================================================================================

    Args:
        debug_flag The flag to show some parameters under running. ( OFF:false/0, ON:true/1 ) 
";
%feature("docstring") AcquireNeutronSourceImageInformation::~AcquireNeutronSourceImageInformation "AcquireNeutronSourceImageInformation::~AcquireNeutronSourceImageInformation() AcquireNeutronSourceImageInformation::~AcquireNeutronSourceImageInformation Destructor. 

";
%feature("docstring") AcquireNeutronSourceImageInformation::SetSavePath "Int4 AcquireNeutronSourceImageInformation::SetSavePath(const std::string save_path) AcquireNeutronSourceImageInformation::SetSavePath

";
%feature("docstring") AcquireNeutronSourceImageInformation::GetImageInformation "void AcquireNeutronSourceImageInformation::GetImageInformation(const std::string Key) AcquireNeutronSourceImageInformation::GetImageInformation

    
void AcquireNeutronSourceImageInformation::GetImageInformation(const std::string Key, const std::string Start) AcquireNeutronSourceImageInformation::GetImageInformation
    
void AcquireNeutronSourceImageInformation::GetImageInformation(const std::string Key, const std::string Start, const std::string End) AcquireNeutronSourceImageInformation::GetImageInformation
";
%feature("docstring") AcquireNeutronSourceImageInformation::PutImagePath "std::string AcquireNeutronSourceImageInformation::PutImagePath(const std::string Key) AcquireNeutronSourceImageInformation::PutImagePath

    
std::string AcquireNeutronSourceImageInformation::PutImagePath(const std::string Key, const UInt4 year, const UInt4 month, const UInt4 day, const UInt4 hour) AcquireNeutronSourceImageInformation::PutImagePath
";
%feature("docstring") AcquireNeutronSourceImageInformation::PutImageFilename "std::string AcquireNeutronSourceImageInformation::PutImageFilename(const std::string Key) AcquireNeutronSourceImageInformation::PutImageFilename

    
std::string AcquireNeutronSourceImageInformation::PutImageFilename(const std::string Key, const UInt4 year, const UInt4 month, const UInt4 day, const UInt4 hour) AcquireNeutronSourceImageInformation::PutImageFilename
";
// File: classAcquireNeutronSourceInformationBase.xml

%feature("docstring") AcquireNeutronSourceInformationBase "C++ includes: AcquireNeutronSourceInformationBase.hh 

";
%feature("docstring") AcquireNeutronSourceInformationBase::AcquireNeutronSourceInformationBase "AcquireNeutronSourceInformationBase::AcquireNeutronSourceInformationBase() AcquireNeutronSourceInformationBase::AcquireNeutronSourceInformationBase Constructor. 

    
AcquireNeutronSourceInformationBase::AcquireNeutronSourceInformationBase(std::string host_name) AcquireNeutronSourceInformationBase::AcquireNeutronSourceInformationBase Constructor.
======================================================================================================================================================================================

    Args:
        host_name The server name which is the information Web page of neutron source. 
";
%feature("docstring") AcquireNeutronSourceInformationBase::~AcquireNeutronSourceInformationBase "AcquireNeutronSourceInformationBase::~AcquireNeutronSourceInformationBase() AcquireNeutronSourceInformationBase::~AcquireNeutronSourceInformationBase Destructor. 

";
%feature("docstring") AcquireNeutronSourceInformationBase::SetHostName "void AcquireNeutronSourceInformationBase::SetHostName(const std::string host_name) AcquireNeutronSourceInformationBase::SetHostName

";
%feature("docstring") AcquireNeutronSourceInformationBase::SetHostProtocol "void AcquireNeutronSourceInformationBase::SetHostProtocol(const std::string host_protocol) AcquireNeutronSourceInformationBase::SetHostProtocol

";
%feature("docstring") AcquireNeutronSourceInformationBase::SetFilePath "void AcquireNeutronSourceInformationBase::SetFilePath(const std::string file_path) AcquireNeutronSourceInformationBase::SetFilePath

";
%feature("docstring") AcquireNeutronSourceInformationBase::PutHostName "std::string AcquireNeutronSourceInformationBase::PutHostName() AcquireNeutronSourceInformationBase::PutHostName

";
%feature("docstring") AcquireNeutronSourceInformationBase::PutFilePath "std::string AcquireNeutronSourceInformationBase::PutFilePath() AcquireNeutronSourceInformationBase::PutFilePath

";
%feature("docstring") AcquireNeutronSourceInformationBase::InitializeSockaddrIn "Int4 AcquireNeutronSourceInformationBase::InitializeSockaddrIn() AcquireNeutronSourceInformationBase::InitializeSockaddrIn

";
%feature("docstring") AcquireNeutronSourceInformationBase::CreateSocket "Int4 AcquireNeutronSourceInformationBase::CreateSocket() AcquireNeutronSourceInformationBase::CreateSocket

";
%feature("docstring") AcquireNeutronSourceInformationBase::ServerConnect "Int4 AcquireNeutronSourceInformationBase::ServerConnect() AcquireNeutronSourceInformationBase::ServerConnect

";
%feature("docstring") AcquireNeutronSourceInformationBase::SocketClose "void AcquireNeutronSourceInformationBase::SocketClose() AcquireNeutronSourceInformationBase::SocketClose

";
%feature("docstring") AcquireNeutronSourceInformationBase::SendRequest "Int4 AcquireNeutronSourceInformationBase::SendRequest(std::string &request) AcquireNeutronSourceInformationBase::SendRequest

";
%feature("docstring") AcquireNeutronSourceInformationBase::SendRequestHTTP "Int4 AcquireNeutronSourceInformationBase::SendRequestHTTP(std::string &request) AcquireNeutronSourceInformationBase::SendRequestHTTP

";
%feature("docstring") AcquireNeutronSourceInformationBase::SendRequestHTTPS "Int4 AcquireNeutronSourceInformationBase::SendRequestHTTPS(std::string &request) AcquireNeutronSourceInformationBase::SendRequestHTTPS

";
%feature("docstring") AcquireNeutronSourceInformationBase::RecvReply "Int4 AcquireNeutronSourceInformationBase::RecvReply(std::string &recv_data) AcquireNeutronSourceInformationBase::RecvReply

";
%feature("docstring") AcquireNeutronSourceInformationBase::SplitBodyData "Int4 AcquireNeutronSourceInformationBase::SplitBodyData(std::string &recv_data, std::string &body_data) AcquireNeutronSourceInformationBase::SplitBodyData

";
// File: classAcquireNeutronSourceInformationControlBase.xml

%feature("docstring") AcquireNeutronSourceInformationControlBase "C++ includes: AcquireNeutronSourceInformationControlBase.hh 

";
%feature("docstring") AcquireNeutronSourceInformationControlBase::AcquireNeutronSourceInformationControlBase "AcquireNeutronSourceInformationControlBase::AcquireNeutronSourceInformationControlBase() AcquireNeutronSourceInformationControlBase::AcquireNeutronSourceInformationControlBase Constructor. 

    
AcquireNeutronSourceInformationControlBase::AcquireNeutronSourceInformationControlBase(std::string host_name) AcquireNeutronSourceInformationControlBase::AcquireNeutronSourceInformationControlBase Constructor.
==================================================================================================================================================================================================================

    Args:
        host_name The server name which is the information Web page of neutron source. 
";
%feature("docstring") AcquireNeutronSourceInformationControlBase::~AcquireNeutronSourceInformationControlBase "AcquireNeutronSourceInformationControlBase::~AcquireNeutronSourceInformationControlBase() AcquireNeutronSourceInformationControlBase::~AcquireNeutronSourceInformationControlBase Destructor. 

";
%feature("docstring") AcquireNeutronSourceInformationControlBase::AcquireControl "Bool AcquireNeutronSourceInformationControlBase::AcquireControl(const std::string Key) AcquireNeutronSourceInformationControlBase::AcquireControl

";
%feature("docstring") AcquireNeutronSourceInformationControlBase::StringDateToUInt4 "UInt4 AcquireNeutronSourceInformationControlBase::StringDateToUInt4(const std::string Date, UInt4 &year, UInt4 &month, UInt4 &day, UInt4 &hour) AcquireNeutronSourceInformationControlBase::StringDateToUInt4

";
%feature("docstring") AcquireNeutronSourceInformationControlBase::StringTimeToStructTime "UInt4 AcquireNeutronSourceInformationControlBase::StringTimeToStructTime(const std::string date_time, const std::string separator, struct tm *ltm) AcquireNeutronSourceInformationControlBase::StringTimeToStructTime

";
%feature("docstring") AcquireNeutronSourceInformationControlBase::StructTimeToStringTime "std::string AcquireNeutronSourceInformationControlBase::StructTimeToStringTime(struct tm *ltm, const std::string separator) AcquireNeutronSourceInformationControlBase::StructTimeToStringTime

";
// File: classAcquireNeutronSourceTextInformation.xml

%feature("docstring") AcquireNeutronSourceTextInformation "C++ includes: AcquireNeutronSourceTextInformation.hh 

";
%feature("docstring") AcquireNeutronSourceTextInformation::AcquireNeutronSourceTextInformation "AcquireNeutronSourceTextInformation::AcquireNeutronSourceTextInformation() AcquireNeutronSourceTextInformation::AcquireNeutronSourceTextInformation Constructor. 

    
AcquireNeutronSourceTextInformation::AcquireNeutronSourceTextInformation(std::string host_name, Bool debug_flag=false) AcquireNeutronSourceTextInformation::AcquireNeutronSourceTextInformation Constructor.
=============================================================================================================================================================================================================

    Args:
        host_name The server name which is the information Web page of neutron source.
        debug_flag The flag to show some parameters under running. ( OFF:false/0, ON:true/1 ) 
    
AcquireNeutronSourceTextInformation::AcquireNeutronSourceTextInformation(Bool debug_flag) AcquireNeutronSourceTextInformation::AcquireNeutronSourceTextInformation Constructor.
================================================================================================================================================================================

    Args:
        debug_flag The flag to show some parameters under running. ( OFF:false/0, ON:true/1 ) 
";
%feature("docstring") AcquireNeutronSourceTextInformation::~AcquireNeutronSourceTextInformation "AcquireNeutronSourceTextInformation::~AcquireNeutronSourceTextInformation() AcquireNeutronSourceTextInformation::~AcquireNeutronSourceTextInformation Destructor. 

";
%feature("docstring") AcquireNeutronSourceTextInformation::PutCgiPath "std::string AcquireNeutronSourceTextInformation::PutCgiPath(const std::string Key) AcquireNeutronSourceTextInformation::PutCgiPath

";
%feature("docstring") AcquireNeutronSourceTextInformation::PutStepKey "std::string AcquireNeutronSourceTextInformation::PutStepKey(const std::string Key, const Int4 StepTime) AcquireNeutronSourceTextInformation::PutStepKey

";
%feature("docstring") AcquireNeutronSourceTextInformation::SetRequestMessage "Int4 AcquireNeutronSourceTextInformation::SetRequestMessage(const std::string Key, const std::string Start, const std::string End, const std::string StepKey) AcquireNeutronSourceTextInformation::SetRequestMessage

";
%feature("docstring") AcquireNeutronSourceTextInformation::SplitValueData "UInt4 AcquireNeutronSourceTextInformation::SplitValueData(const std::string &body_data, std::string &info_data) AcquireNeutronSourceTextInformation::SplitValueData

";
%feature("docstring") AcquireNeutronSourceTextInformation::SplitBeamOffData "UInt4 AcquireNeutronSourceTextInformation::SplitBeamOffData(const std::string &body_data, std::string &info_data) AcquireNeutronSourceTextInformation::SplitBeamOffData

";
%feature("docstring") AcquireNeutronSourceTextInformation::ReplaceStr "void AcquireNeutronSourceTextInformation::ReplaceStr(std::string &str, const std::string &from, const std::string &to) AcquireNeutronSourceTextInformation::ReplaceStr

";
%feature("docstring") AcquireNeutronSourceTextInformation::PutValueData "std::vector< Double > AcquireNeutronSourceTextInformation::PutValueData(const std::string Key, const std::string Start, const std::string StepKey, const Int4 bin_step, const std::string data) AcquireNeutronSourceTextInformation::PutValueData

";
%feature("docstring") AcquireNeutronSourceTextInformation::PutValueInformation "Double AcquireNeutronSourceTextInformation::PutValueInformation(const std::string Key) AcquireNeutronSourceTextInformation::PutValueInformation

    
Double AcquireNeutronSourceTextInformation::PutValueInformation(const std::string Key, const std::string Start) AcquireNeutronSourceTextInformation::PutValueInformation
    
std::vector< Double > AcquireNeutronSourceTextInformation::PutValueInformation(const std::string Key, const std::string Start, const std::string End, const Int4 StepTime=0) AcquireNeutronSourceTextInformation::PutValueInformation
";
%feature("docstring") AcquireNeutronSourceTextInformation::PutDateBinInformation "std::vector< std::string > AcquireNeutronSourceTextInformation::PutDateBinInformation() AcquireNeutronSourceTextInformation::PutDateBinInformation

";
%feature("docstring") AcquireNeutronSourceTextInformation::PutTimeBinInformation "std::vector< std::string > AcquireNeutronSourceTextInformation::PutTimeBinInformation() AcquireNeutronSourceTextInformation::PutTimeBinInformation

";
%feature("docstring") AcquireNeutronSourceTextInformation::GetTextInformation "void AcquireNeutronSourceTextInformation::GetTextInformation(const std::string Key) AcquireNeutronSourceTextInformation::GetTextInformation

    
void AcquireNeutronSourceTextInformation::GetTextInformation(const std::string Key, const std::string Start) AcquireNeutronSourceTextInformation::GetTextInformation
    
void AcquireNeutronSourceTextInformation::GetTextInformation(const std::string Key, const std::string Start, const std::string End, const Int4 StepTime=TIME_10) AcquireNeutronSourceTextInformation::GetTextInformation
";
%feature("docstring") AcquireNeutronSourceTextInformation::PutTextFirstInformation "std::vector< std::string > AcquireNeutronSourceTextInformation::PutTextFirstInformation() AcquireNeutronSourceTextInformation::PutTextFirstInformation

";
%feature("docstring") AcquireNeutronSourceTextInformation::PutTextSecondInformation "std::vector< std::string > AcquireNeutronSourceTextInformation::PutTextSecondInformation() AcquireNeutronSourceTextInformation::PutTextSecondInformation

";
%feature("docstring") AcquireNeutronSourceTextInformation::ConvertProtonToCurrent "std::vector< Double > AcquireNeutronSourceTextInformation::ConvertProtonToCurrent(std::vector< Double > proton, const Int4 bin) AcquireNeutronSourceTextInformation::ConvertProtonToCurrent

";
%feature("docstring") AcquireNeutronSourceTextInformation::ConvertCurrentToBeampower "std::vector< Double > AcquireNeutronSourceTextInformation::ConvertCurrentToBeampower(std::vector< Double > Current) AcquireNeutronSourceTextInformation::ConvertCurrentToBeampower

";
%feature("docstring") AcquireNeutronSourceTextInformation::PutShotsCounts "std::vector< UInt4 > AcquireNeutronSourceTextInformation::PutShotsCounts() AcquireNeutronSourceTextInformation::PutShotsCounts

";
// File: classAdvScatAbsoBodyManagerMLF.xml

%feature("docstring") AdvScatAbsoBodyManagerMLF "

    Scatterer and Absoannt
    Koike Soh, AdvanceSoft Corp. (original)
    TANIMORI Souichirou, AdvanceSoft Corp.
    0.0
    C++ includes: AdvScatAbsoBodyManagerMLF.hh 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::AdvScatAbsoBodyManagerMLF "AdvScatAbsoBodyManagerMLF::AdvScatAbsoBodyManagerMLF(void) AdvScatAbsoBodyManagerMLF::AdvScatAbsoBodyManagerMLF A constructor
==============================================================================================================================
    set default atomicDataFile 

    
AdvScatAbsoBodyManagerMLF::AdvScatAbsoBodyManagerMLF(std::string) AdvScatAbsoBodyManagerMLF::AdvScatAbsoBodyManagerMLF
";
%feature("docstring") AdvScatAbsoBodyManagerMLF::~AdvScatAbsoBodyManagerMLF "virtual AdvScatAbsoBodyManagerMLF::~AdvScatAbsoBodyManagerMLF(void) AdvScatAbsoBodyManagerMLF::~AdvScatAbsoBodyManagerMLF A destructor
=======================================================================================================================================
    do nothing 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetAtomSigmaFromVelocityRule "Double AdvScatAbsoBodyManagerMLF::GetAtomSigmaFromVelocityRule(std::string atomname, Char state, double velocity) AdvScatAbsoBodyManagerMLF::GetAtomSigmaFromVelocityRule get measured value of scattering/absorption cross section of the specified nuclide or atom
=====================================================================================================================================================================================================================================================================

    Args:
        atomname atomic name
        state 'a': absorption, 's': scattering, 't': total
        velocity incident neutron velocity

    Returns:
        cross section for specified atom 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetSigmaFromVelocityRule "void AdvScatAbsoBodyManagerMLF::GetSigmaFromVelocityRule(struct ScatAbsoInfo *, struct ScatAbsoInfo *, double, double *, double *, double *) AdvScatAbsoBodyManagerMLF::GetSigmaFromVelocityRule get the cross cection data
============================================================================================================================================================================================================================

    Args:
        *wInfo pointer for struct variable wallInfo
        *bInfo pointer for struct variable bodyInfo
        energy incident energy of neutron
        *sigmaBA absorption cross section for body
        *sigmaWA absorption cross section for wall
        *sigmaWS scattering cross section for wall
        get cross section data for body and wall by use of velocity rule.

    Args:
        *wInfo pointer for struct variable wallInfo
        *bInfo pointer for struct variable bodyInfo
        energy incident energy of neutron
        *sigmaBA absorption cross section for body
        *sigmaWA absorption cross section for wall
        *sigmaWS scattering cross section for wall 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::ReturnSigmaFromVelocityRule "Double AdvScatAbsoBodyManagerMLF::ReturnSigmaFromVelocityRule(struct ScatAbsoInfo *, Double, Char) AdvScatAbsoBodyManagerMLF::ReturnSigmaFromVelocityRule return cross section data obtained by velocity rule.
===============================================================================================================================================================================================================

    Args:
        *info pointer for struct variable AdvScatAbsoBodyManagerDNA
        energy neutron energy
        state 'a' (absorption), 's' (scattering), t: total

    Returns:
        cross section for wall or body
        return cross section obtained by velocity rule.

    Args:
        info pointer for struct variable AdvScatAbsoBodyManagerDNA
        energy incident energy of neutron
        state 'a': absorption, 's': scattering

    Returns:
        cross section for wall or body 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::SetInfoData "void AdvScatAbsoBodyManagerMLF::SetInfoData(std::string filename, struct ScatAbsoInfo *wallInfo, struct ScatAbsoInfo *bodyInfo) AdvScatAbsoBodyManagerMLF::SetInfoData set AdvScatAbsoBodyManagerDNA variables to values from specified file.
==============================================================================================================================================================================================================================================

    Args:
        filename scatterer and/or absorbent data file
        wallInfo information of wall of container
        bodyInfo information of scatterer and/or absorbent
        set value to AdvScatAbsoBodyManagerDNA variable.

    Args:
        filename scatterer and/or absorbent data file
        wallInfo information of wall of container
        bodyInfo information of scatterer and/or absorbent 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::SetSigmaDataNIST "void AdvScatAbsoBodyManagerMLF::SetSigmaDataNIST(Double velocity, std::string atomname, std::string typeCS) AdvScatAbsoBodyManagerMLF::SetSigmaDataNIST set an array to cross section data from the file recorded NIST data.
=============================================================================================================================================================================================================================

    Args:
        velocity
        atomname atomic name
        typeCS type of scattering and absorption data. available values of typeCS 't' sum of scattering cross section and absorption cross sction midefied using user specified velocity
        'a' absorption cross sction midefied using user specified velocity
        's' scattering cross section
        'c' cohrent length
        'i' incoherent length
        array dataCS[][] in the class keeps NIST data in following way, dataCS[0][0] incident neutron velocity at measurement
        dataCS[0][1] user specified data using character symbol
        set sigma by use of database file made by NIST

    Args:
        atomname atomic name
        typeCS mass number, atomic name and scattering type 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetIntegThresholdValue "Double AdvScatAbsoBodyManagerMLF::GetIntegThresholdValue(void) AdvScatAbsoBodyManagerMLF::GetIntegThresholdValue return threshold value used for judgement of convergence in numerial integral
===============================================================================================================================================================================================

    Returns:
        epsilon 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetIntegThresholdRatio "Double AdvScatAbsoBodyManagerMLF::GetIntegThresholdRatio(void) AdvScatAbsoBodyManagerMLF::GetIntegThresholdRatio return threshold value of ratio used for judgement of convergence in numerial integral
========================================================================================================================================================================================================

    Returns:
        epsilonRatio 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::SetIntegThresholdValue "void AdvScatAbsoBodyManagerMLF::SetIntegThresholdValue(Double a) AdvScatAbsoBodyManagerMLF::SetIntegThresholdValue set threshold value used for judgement of convergence in numerial integral
==============================================================================================================================================================================================
    @set epsilon 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::SetIntegThresholdRatio "void AdvScatAbsoBodyManagerMLF::SetIntegThresholdRatio(Double a) AdvScatAbsoBodyManagerMLF::SetIntegThresholdRatio set threshold value Ratio used for judgement of convergence in numerial integral
====================================================================================================================================================================================================
    @set epsilonRatio 

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::SetSigmaCoefficient "void AdvScatAbsoBodyManagerMLF::SetSigmaCoefficient(Double, Double, Double) AdvScatAbsoBodyManagerMLF::SetSigmaCoefficient

    
void AdvScatAbsoBodyManagerMLF::SetSigmaCoefficient(ElementContainerArray, Double, Double) AdvScatAbsoBodyManagerMLF::SetSigmaCoefficient
";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetCohCSF "Double AdvScatAbsoBodyManagerMLF::GetCohCSF() AdvScatAbsoBodyManagerMLF::GetCohCSF

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetIncCSF "Double AdvScatAbsoBodyManagerMLF::GetIncCSF() AdvScatAbsoBodyManagerMLF::GetIncCSF

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetAbsCSF "Double AdvScatAbsoBodyManagerMLF::GetAbsCSF() AdvScatAbsoBodyManagerMLF::GetAbsCSF

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetQDepCohCSF "Double AdvScatAbsoBodyManagerMLF::GetQDepCohCSF(Double) AdvScatAbsoBodyManagerMLF::GetQDepCohCSF

    
std::vector< Double > AdvScatAbsoBodyManagerMLF::GetQDepCohCSF() AdvScatAbsoBodyManagerMLF::GetQDepCohCSF
";
%feature("docstring") AdvScatAbsoBodyManagerMLF::GetQDepCohCSFq "std::vector< Double > AdvScatAbsoBodyManagerMLF::GetQDepCohCSFq() AdvScatAbsoBodyManagerMLF::GetQDepCohCSFq

";
%feature("docstring") AdvScatAbsoBodyManagerMLF::SetDataBaseFile "bool AdvScatAbsoBodyManagerMLF::SetDataBaseFile(std::string filepath) AdvScatAbsoBodyManagerMLF::SetDataBaseFile

";
// File: classArrayOperation.xml

%feature("docstring") ArrayOperation "

    Class to perform array oeprations.
    For example Calculate(ECA, EC, \"+\") carries out ECA(i) + EC for each index. Calculate(ECM, std::vector< std::vector<Double> > , \"/\" ) carries out ECM(i, j) / V[i][j] for each index.
    Common flow of \"Calculate\" method Validate operator
    Compare size of operands
    Check the keys of ElementContainer is set
    Performe calculation
    \"Calculate\" returns true, if calculation successfully ends. It returns false, if either validation fails.
    C++ includes: ArrayOperation.hh 

";
%feature("docstring") ArrayOperation::ArrayOperation "ArrayOperation::ArrayOperation() ArrayOperation::ArrayOperation

";
%feature("docstring") ArrayOperation::Calculate "bool ArrayOperation::Calculate(ElementContainerArray &eca_l, std::string op, const Double d) ArrayOperation::Calculate Apply an operation to each EC with a right operand. 

    
bool ArrayOperation::Calculate(ElementContainerArray &eca_l, std::string op, const std::vector< Double > &vd) ArrayOperation::Calculate Apply an operation to each EC with a same index element of a right operand. 
    
bool ArrayOperation::Calculate(ElementContainerArray &eca_l, std::string op, ElementContainer &ec) ArrayOperation::Calculate Apply an operation to each EC with a right operand. 
    
bool ArrayOperation::Calculate(ElementContainerArray &eca_l, std::string op, ElementContainerArray &eca_r) ArrayOperation::Calculate Apply an operation to each EC with a same index element of a right operand. 
    
bool ArrayOperation::Calculate(ElementContainerMatrix &ecm_l, std::string op, const Double d) ArrayOperation::Calculate Apply an operation to each EC with a right operand. 
    
bool ArrayOperation::Calculate(ElementContainerMatrix &ecm_l, std::string op, const std::vector< Double > &vd, bool direction=true) ArrayOperation::Calculate Apply an operation to each EC with a same index element of a right operand.
==========================================================================================================================================================================================================================================
    Calculate(ECM, vd, \"+\", true) calclulates ECM(j, i) + vd[i] for each index. Calculate(ECM, vd, \"+\", false) calclulates ECM(i, j) + vd[i] for each index. 
    
bool ArrayOperation::Calculate(ElementContainerMatrix &ecm_l, std::string op, ElementContainer &ec) ArrayOperation::Calculate Apply an operation to each EC with a right operand. 
    
bool ArrayOperation::Calculate(ElementContainerMatrix &ecm_l, std::string op, ElementContainerArray &eca_r, bool direction=true) ArrayOperation::Calculate Apply an operation to each EC with a same index element of a right operand.
=======================================================================================================================================================================================================================================
    Calculate(ECM, ECA, \"+\", true) calclulates ECM(j, i) + ECA(i) for each index. Calculate(ECM, ECA, \"+\", false) calclulates ECM(i, j) + ECA(i) for each index. 
    
bool ArrayOperation::Calculate(ElementContainerMatrix &ecm_l, std::string op, ElementContainerMatrix &ecm_r) ArrayOperation::Calculate Apply an operation to each EC with a same index element of a right operand. 
    
bool ArrayOperation::Calculate(ElementContainerMatrix &ecm_l, std::string op, const std::vector< std::vector< Double > > &vvd) ArrayOperation::Calculate Apply an operation to each EC with a same index element of a right operand. 
";
// File: classAverageElementContainerMatrix.xml

%feature("docstring") AverageElementContainerMatrix "

    Average ElementContainer for choppers.
    Function to get average of a seriese of ElementContainers
    C++ includes: AverageElementContainerMatrix.hh 

";
%feature("docstring") AverageElementContainerMatrix::AverageElementContainerMatrix "AverageElementContainerMatrix::AverageElementContainerMatrix() AverageElementContainerMatrix::AverageElementContainerMatrix Constructor. 

    
AverageElementContainerMatrix::AverageElementContainerMatrix(Int4 debug) AverageElementContainerMatrix::AverageElementContainerMatrix Constructor.
===================================================================================================================================================

    Args:
        debug flag for debug 0 for not-use. 
    
AverageElementContainerMatrix::AverageElementContainerMatrix(ElementContainerMatrix *ecm) AverageElementContainerMatrix::AverageElementContainerMatrix Constructor.
====================================================================================================================================================================

    Args:
        ecm ElementContainerMatrix for the target 
    
AverageElementContainerMatrix::AverageElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > psd_vec, std::vector< UInt4 > pixel_vec) AverageElementContainerMatrix::AverageElementContainerMatrix Constructor.
==================================================================================================================================================================================================================================

    Args:
        ecm ElementContainerMatrix for the target
        psd_vec std::vector of psd id for pixels
        pixel_vec std::vector of pixel number at a Psd Id 
    
AverageElementContainerMatrix::AverageElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > psd_vec, std::vector< UInt4 > pixel_vec, Int4 debug) AverageElementContainerMatrix::AverageElementContainerMatrix Constructor.
==============================================================================================================================================================================================================================================

    Args:
        ecm ElementContainerMatrix for the target
        psd_vec std::vector of psd id for pixels
        pixel_vec std::vector of pixel number at a Psd Id
        debug flag for debug 
";
%feature("docstring") AverageElementContainerMatrix::~AverageElementContainerMatrix "AverageElementContainerMatrix::~AverageElementContainerMatrix() AverageElementContainerMatrix::~AverageElementContainerMatrix Destructor. 

";
%feature("docstring") AverageElementContainerMatrix::GetAverage "ElementContainer AverageElementContainerMatrix::GetAverage() AverageElementContainerMatrix::GetAverage Put averaged data.
==========================================================================================================================

    Returns:
        ElementContainer 

    
bool AverageElementContainerMatrix::GetAverage(ElementContainer *_ec) AverageElementContainerMatrix::GetAverage
";
%feature("docstring") AverageElementContainerMatrix::GetSum "ElementContainer AverageElementContainerMatrix::GetSum() AverageElementContainerMatrix::GetSum Put sum data.
=============================================================================================================

    Returns:
        ElementContainer 

    
bool AverageElementContainerMatrix::GetSum(ElementContainer *_ec) AverageElementContainerMatrix::GetSum
";
%feature("docstring") AverageElementContainerMatrix::SetPoints "void AverageElementContainerMatrix::SetPoints(std::vector< UInt4 > psd_vec, std::vector< UInt4 > pixel_vec) AverageElementContainerMatrix::SetPoints Set pixels to be averaged.
================================================================================================================================================================================

    Args:
        psd_vec std::vector of psd id for pixels
        pixel_vec std::vector of pixel number at a Psd Id

    Returns:
        None 

";
// File: classBinDataFileSectionReader.xml

%feature("docstring") BinDataFileSectionReader "C++ includes: BinDataFileSectionReader.hh 

";
%feature("docstring") BinDataFileSectionReader::BinDataFileSectionReader "BinDataFileSectionReader::BinDataFileSectionReader(std::string TargetFileName, size_t ElementSize) BinDataFileSectionReader::BinDataFileSectionReader

";
%feature("docstring") BinDataFileSectionReader::Read "Int4 BinDataFileSectionReader::Read(Int8 FromBegin, Int8 SizeOfData, void *buf) BinDataFileSectionReader::Read

";
%feature("docstring") BinDataFileSectionReader::~BinDataFileSectionReader "BinDataFileSectionReader::~BinDataFileSectionReader() BinDataFileSectionReader::~BinDataFileSectionReader

";
// File: classBoostXmlParser.xml

%feature("docstring") BoostXmlParser "

    Function for read XML file using boost::property_tree.
    This gives a simple way to access to elements by using path-to-element text. Example for path format
    | <node1>
    |     <node2 i= | \"1\" | >
    |          <node3>Target</node3>
    |     </node2>
    |     <node2 i= | \"2\" | >...</node2>
    | </node1>
    When you want to touch \"Target\", the path is \"node1/node2,i=1/node3\" or use XPath format ( poor functions ) like \"node1/node2[@i='1']/node3\"
    C++ includes: BoostXmlParser.hh 

";
%feature("docstring") BoostXmlParser::BoostXmlParser "BoostXmlParser::BoostXmlParser() BoostXmlParser::BoostXmlParser Constructor. 

    
BoostXmlParser::BoostXmlParser(std::string xmlfile) BoostXmlParser::BoostXmlParser Constructor.
================================================================================================
    BoostXmlParser( sting xmlfile )

    Args:
        xmlfile (std::string) path to xml file 
    
BoostXmlParser::BoostXmlParser(std::string key, std::string xmlfile) BoostXmlParser::BoostXmlParser Constructor.
=================================================================================================================
    BoostXmlParser( std::string key, std::string xmlfile )

    Args:
        key (std::string) Key for xml info
        xmlfile (std::string) path to xml file 
";
%feature("docstring") BoostXmlParser::~BoostXmlParser "BoostXmlParser::~BoostXmlParser() BoostXmlParser::~BoostXmlParser Destructor. 

";
%feature("docstring") BoostXmlParser::CreateNewTree "bool BoostXmlParser::CreateNewTree(std::string key=\"\") BoostXmlParser::CreateNewTree Creates new property tree indexed by key.
=================================================================================================================================
    CreateNewTree( [std::string key] )

    Args:
        key (std::string) key for xml info

    Returns:
        true succeeded
        false failed 

";
%feature("docstring") BoostXmlParser::AddElement "bool BoostXmlParser::AddElement(std::string path, std::string cont) BoostXmlParser::AddElement

    
bool BoostXmlParser::AddElement(std::string key, std::string path, std::string cont) BoostXmlParser::AddElement
    
bool BoostXmlParser::AddElement(std::string path, std::vector< std::string > attr_v, std::vector< std::string > val_v) BoostXmlParser::AddElement
    
bool BoostXmlParser::AddElement(std::string key, std::string path, std::vector< std::string > attr_v, std::vector< std::string > val_v) BoostXmlParser::AddElement Adds elements and attributes to a tree.
===========================================================================================================================================================================================================
    AddToTree( [std::string key,] std::string path, std::string cont ); AddToTree( [std::string key,] std::string path, std::vector<std::string> attr_v, std::vector<std::string> val_v );

    Args:
        key (std::string) key for xml info
        path (std::string) path to elements and attributes to be added
        cont (std::string) contents to be added
        att_v (std::vector<std::string>) attribute names list
        val_v (std::vector<std::string>) attribute values list

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") BoostXmlParser::RemoveElement "bool BoostXmlParser::RemoveElement(std::string path, std::string attr) BoostXmlParser::RemoveElement

    
bool BoostXmlParser::RemoveElement(std::string key, std::string path, std::string attr) BoostXmlParser::RemoveElement Removes elements or attribute.
=====================================================================================================================================================
    RemoveTree( std::string key, std::string path, std::string attr )

    Args:
        key (std::string) key for xml info
        path (std::string) path to element including attribute to be removed
        attr (std::string) attribute name. if empty, delete tree of given path

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") BoostXmlParser::Save "bool BoostXmlParser::Save(std::string path) BoostXmlParser::Save

    
bool BoostXmlParser::Save(std::string key, std::string path) BoostXmlParser::Save Saves tree to xml file.
==========================================================================================================
    Save( std::string key, std::string path )

    Args:
        key (std::string) key for xml info
        path (std::string) path to file

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") BoostXmlParser::Load "bool BoostXmlParser::Load(std::string arg) BoostXmlParser::Load Load tree from xml file.
=========================================================================================
    Load( std::string key )

    Args:
        key (std::string) key for xml info

    Returns:
        true succeeded
        false failed 

    
bool BoostXmlParser::Load(std::string key, std::string arg) BoostXmlParser::Load Load tree from xml file.
==========================================================================================================
    Load( std::string key, std::string path )

    Args:
        key (std::string) key for xml info
        arg (std::string) path/to/file or xml std::string

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") BoostXmlParser::LoadFromString "bool BoostXmlParser::LoadFromString(std::string xmlstring) BoostXmlParser::LoadFromString Load tree from std::string including xml.
====================================================================================================================================
    LoadFromString( std::string xmlstring )

    Args:
        key (std::string) key for xml info

    Returns:
        true succeeded
        false failed 

    
bool BoostXmlParser::LoadFromString(std::string key, std::string xmlstring) BoostXmlParser::LoadFromString Load tree from std::string including xml.
=====================================================================================================================================================
    LoadFromString( std::string key, std::string xmlstring )

    Args:
        key (std::string) key for xml info
        path (std::string) std::string of xml description

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") BoostXmlParser::isLoadXmlString "bool BoostXmlParser::isLoadXmlString() BoostXmlParser::isLoadXmlString Checks whether XML information is given as std::string or not (file)
============================================================================================================================================
    isLoadXmlString()

    Returns:
        true XML information is given as std::string
        false XML information is given by XML file reading 

";
%feature("docstring") BoostXmlParser::OutToString "std::string BoostXmlParser::OutToString(std::string key, std::string path, bool withIndent) BoostXmlParser::OutToString Output element tree included by given element path as std::string of xml.
==================================================================================================================================================================================================
    OutToString( std::string key, std::string path, bool withIndent )

    Args:
        key (std::string) key for xml info
        path (std::string) path to xml element
        withIndent (bool) whether output std::string is formatted by indent

    Returns:
        xml std::strings 

    
std::string BoostXmlParser::OutToString(std::string path, bool withIndent) BoostXmlParser::OutToString Output element tree included by given element path as std::string of xml.
=================================================================================================================================================================================
    OutToString( std::string path, bool withIndent )

    Args:
        path (std::string) path to xml element
        withIndent (bool) whether output std::string is formatted by indent

    Returns:
        xml std::strings 
    
std::string BoostXmlParser::OutToString(bool withIndent) BoostXmlParser::OutToString Output element tree included by given element path as std::string of xml.
===============================================================================================================================================================
    OutToString( bool withIndent )

    Args:
        withIndent (bool) whether output std::string is formatted by indent

    Returns:
        xml std::strings 
";
%feature("docstring") BoostXmlParser::OutAllToString "std::string BoostXmlParser::OutAllToString(std::string key, bool withIndent=false) BoostXmlParser::OutAllToString Output all element tree as std::string of xml.
=================================================================================================================================================================
    OutAllToString( std::string key, bool withIndent=false )

    Args:
        key (std::string) key for xml info
        withIndent (bool) whether output std::string is formatted by indent

    Returns:
        xml std::strings 

    
std::string BoostXmlParser::OutAllToString(bool withIndent=false) BoostXmlParser::OutAllToString Output all element tree as std::string of xml.
================================================================================================================================================
    OutAllToString( bool withIndent=false )

    Args:
        withIndent (bool) whether output std::string is formatted by indent

    Returns:
        xml std::strings 
";
%feature("docstring") BoostXmlParser::PutContent "std::string BoostXmlParser::PutContent(std::string path) BoostXmlParser::PutContent

    
std::string BoostXmlParser::PutContent(std::string path, std::string attr) BoostXmlParser::PutContent
    
std::string BoostXmlParser::PutContent(std::string key, std::string path, std::string attr) BoostXmlParser::PutContent
    
std::string BoostXmlParser::PutContent(boost::property_tree::ptree *curNode, std::string path, std::string attr) BoostXmlParser::PutContent Puts contents or attribute directed by a given path under current node.
====================================================================================================================================================================================================================
    PutContent( boost::property_tree::ptree* curNode, std::string path, std::string attr )

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path to element
        attr (std::string) attribute name you want to get

    Returns:
        std::string value 
";
%feature("docstring") BoostXmlParser::putTextContent "std::string BoostXmlParser::putTextContent(std::string key, std::string path, std::string attr=\"\") BoostXmlParser::putTextContent Puts contents or attribute directed by a given path.
=========================================================================================================================================================================================
    putTextContent is used for old code to use MiniXmlReader PutContent( [std::string key,] std::string path, std::string attr )

    Args:
        key (std::string) key for xml info
        path (std::string) path to element
        attr (std::string) attribute name you want to get

    Returns:
        std::string value 

";
%feature("docstring") BoostXmlParser::PutAttValList "std::vector< std::string > BoostXmlParser::PutAttValList(std::string path, std::string attr) BoostXmlParser::PutAttValList

    
std::vector< std::string > BoostXmlParser::PutAttValList(std::string key, std::string path, std::string attr) BoostXmlParser::PutAttValList Puts all attribute-values included in a given path.
================================================================================================================================================================================================
    PutAttValList( [std::string key,] std::string path, std::string attr )

    Args:
        key (std::string) key for xml info
        path (std::string) path to element
        attr (std::string) attribute name you want to get

    Returns:
        (std::vector<std::string>) list of found attributes 
    
std::vector< std::string > BoostXmlParser::PutAttValList(boost::property_tree::ptree *curNode, std::string path, std::string attr) BoostXmlParser::PutAttValList Puts all attribute-values included in a given path under current node.
========================================================================================================================================================================================================================================
    PutAttValList( boost::property_tree::ptree* curNode, std::string path, std::string attr )

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path to element
        attr (std::string) attribute name you want to get

    Returns:
        (std::vector<std::string>) list of found attributes 
";
%feature("docstring") BoostXmlParser::PutElemContList "std::vector< std::string > BoostXmlParser::PutElemContList(std::string path, std::string elename) BoostXmlParser::PutElemContList

    
std::vector< std::string > BoostXmlParser::PutElemContList(std::string key, std::string path, std::string elename) BoostXmlParser::PutElemContList Puts all contents of the element included in a given path.
==============================================================================================================================================================================================================
    PutAttValList( [std::string key,] std::string path, std::string attr )

    Args:
        key (std::string) key for xml info
        path (std::string) path to element
        elename (std::string) included element name you want to get

    Returns:
        (std::vector<std::string>) list of found contents 
    
std::vector< std::string > BoostXmlParser::PutElemContList(boost::property_tree::ptree *curNode, std::string path, std::string elename) BoostXmlParser::PutElemContList Puts all contents of the element included in a given path.
===================================================================================================================================================================================================================================
    PutElemContList( boost::property_tree::ptree* curNode, std::string path, std::string attr )

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path to element
        elename (std::string) included element name you want to get

    Returns:
        (std::vector<std::string>) list of found contents 
";
%feature("docstring") BoostXmlParser::PutNumOfElements "UInt4 BoostXmlParser::PutNumOfElements(std::string path) BoostXmlParser::PutNumOfElements

    
UInt4 BoostXmlParser::PutNumOfElements(std::string key, std::string path) BoostXmlParser::PutNumOfElements Puts the number of elements included in a given path.
=================================================================================================================================================================
    PutNumOfElements( [std::string key,] std::string path )

    Args:
        key (std::string) key for xml info
        path (std::string) path to element
        attr (std::string) attribute name you want to get

    Returns:
        (UInt4) number of elements 
    
UInt4 BoostXmlParser::PutNumOfElements(boost::property_tree::ptree *curNode, std::string path) BoostXmlParser::PutNumOfElements Puts the number of elements included in a given path from current node.
========================================================================================================================================================================================================
    PutNumOfElements( boost::property_tree::ptree* curNode, std::string path )

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path to element
        attr (std::string) attribute name you want to get

    Returns:
        (UInt4) number of elements 
";
%feature("docstring") BoostXmlParser::hasPath "bool BoostXmlParser::hasPath(std::string path) BoostXmlParser::hasPath

    
bool BoostXmlParser::hasPath(std::string key, std::string path) BoostXmlParser::hasPath checks the existence of given path-to-element
======================================================================================================================================
    bool hasPath( [std::string key,] std::string path )

    Args:
        key (std::string) key name for loaded XML info
        path (std::string) path-to-element

    Returns:
        true given path exists
        false given path does not exist 
    
bool BoostXmlParser::hasPath(boost::property_tree::ptree *curNode, std::string path) BoostXmlParser::hasPath checks the existence of given path-to-element
===========================================================================================================================================================
    bool hasPath( boost::property_tree::ptree* curNode, std::string path )

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path-to-element

    Returns:
        true given path exists
        false given path does not exist 
";
%feature("docstring") BoostXmlParser::PutKeys "std::vector< std::string > BoostXmlParser::PutKeys() BoostXmlParser::PutKeys Puts key list.
============================================================================================

    Args:
        None

    Returns:
        std::string std::vector of key list 

";
%feature("docstring") BoostXmlParser::hasKey "bool BoostXmlParser::hasKey(std::string key) BoostXmlParser::hasKey Checks whether xml with given key is loaded or not.
========================================================================================================================

    Args:
        key (std::string) key name

    Returns:
        true loaded xml with given key
        false not loaded xml with given key 

";
%feature("docstring") BoostXmlParser::PutSize "UInt4 BoostXmlParser::PutSize() BoostXmlParser::PutSize Puts the number of added xml info.
===========================================================================================

    Args:
        None

    Returns:
        UInt4 value 

";
%feature("docstring") BoostXmlParser::Clear "void BoostXmlParser::Clear(std::string key=\"\", bool isForced=false) BoostXmlParser::Clear Deletes property tree by a given key.
==================================================================================================================================
    Clear( std::string key=\"\", bool isForced=false )

    Args:
        key (std::string) key for xml info
        isForced (bool) no warning message if key is not found

    Returns:
        None 

";
%feature("docstring") BoostXmlParser::ChangeCurrent "bool BoostXmlParser::ChangeCurrent(std::string key) BoostXmlParser::ChangeCurrent Changes current tree by a given key.
=======================================================================================================================
    ChangeCurrent( std::string key )

    Args:
        key (std::string) key for xml info

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") BoostXmlParser::PutCurrentKey "std::string BoostXmlParser::PutCurrentKey() BoostXmlParser::PutCurrentKey Puts the key of current tree.
========================================================================================================
    PutCurrentKey()

    Returns:
        key (std::string) 

";
%feature("docstring") BoostXmlParser::CopyTree "bool BoostXmlParser::CopyTree(std::string org_key, std::string new_key) BoostXmlParser::CopyTree

";
%feature("docstring") BoostXmlParser::SetQuiet "void BoostXmlParser::SetQuiet(bool isquiet=true) BoostXmlParser::SetQuiet

";
%feature("docstring") BoostXmlParser::PutNode "boost::property_tree::ptree * BoostXmlParser::PutNode(std::string path, std::string attr) BoostXmlParser::PutNode Takes out the node given path and attributes.
================================================================================================================================================================
    PutNode( std::string path, std::string attr );

    Args:
        path (std::string) path to elements and attribute you want to get
        attr (std::string) attribute name you want to get

    Returns:
        node (boost::property_tree::ptree) 

    
boost::property_tree::ptree * BoostXmlParser::PutNode(std::string key, std::string path, std::string attr) BoostXmlParser::PutNode Takes out the node given path and attributes.
=================================================================================================================================================================================
    PutNode( std::string key, std::string path, std::string attr );

    Args:
        key (std::string) key name for loaded XML info
        path (std::string) path to elements and attribute you want to get
        attr (std::string) attribute name you want to get

    Returns:
        node (boost::property_tree::ptree) 
    
boost::property_tree::ptree * BoostXmlParser::PutNode(boost::property_tree::ptree *curNode, std::string path, std::string attr) BoostXmlParser::PutNode Takes out the node given path and attributes.
======================================================================================================================================================================================================
    PutNode( boost::property_tree::ptree* curNode, std::string path, std::string attr );

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path to elements and attribute you want to get under current node
        attr (std::string) attribute name you want to get

    Returns:
        node (boost::property_tree::ptree) 
";
%feature("docstring") BoostXmlParser::PutFoundChildNodes "std::vector< boost::property_tree::ptree * > BoostXmlParser::PutFoundChildNodes(boost::property_tree::ptree *curNode, std::string path) BoostXmlParser::PutFoundChildNodes Takes out all nodes found by current node and given path.
=====================================================================================================================================================================================================================================
    PutFoundChildNodes( boost::property_tree::ptree* curNode, std::string path);

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path to elements and attribute you want to get under current node

    Returns:
        node (boost::property_tree::ptree) 

";
%feature("docstring") BoostXmlParser::PutChildrenElemNames "std::vector< std::string > BoostXmlParser::PutChildrenElemNames(std::string path) BoostXmlParser::PutChildrenElemNames Put list of elements names included in given path.
==========================================================================================================================================================================
    PutChildrenElemNames( std::string path );

    Args:
        path (std::string) path to elements and attribute you want to get under current node

    Returns:
        std::vector<std::string> List of names 

    
std::vector< std::string > BoostXmlParser::PutChildrenElemNames(std::string key, std::string path) BoostXmlParser::PutChildrenElemNames Put list of elements names included in given path.
===========================================================================================================================================================================================
    PutChildrenElemNames( std::string key, std::string path );

    Args:
        key (std::string) key name for loaded XML info
        path (std::string) path to elements and attribute you want to get under current node

    Returns:
        std::vector<std::string> List of names 
    
std::vector< std::string > BoostXmlParser::PutChildrenElemNames(boost::property_tree::ptree *curNode, std::string path) BoostXmlParser::PutChildrenElemNames Put list of elements names included in given path.
================================================================================================================================================================================================================
    PutChildrenElemNames( boost::property_tree::ptree* curNode, std::string path );

    Args:
        curNode (boost::property_tree::ptree) current node
        path (std::string) path to elements and attribute you want to get under current node

    Returns:
        std::vector<std::string> List of names 
";
%feature("docstring") BoostXmlParser::SetDebugMode "void BoostXmlParser::SetDebugMode(bool isDebugMode=true) BoostXmlParser::SetDebugMode Turn on or set debug mode to show behind messages about data treatments.
===============================================================================================================================================================
    Argument isDebugMode affects on QuietMode.
    PutChildrenElemNames( std::string path );

    Args:
        isDebugMode (bool)

    Returns:
        None 

";
// File: classContainerViewer.xml

%feature("docstring") ContainerViewer "C++ includes: ContainerViewer.hh 

";
%feature("docstring") ContainerViewer::ContainerViewer "ContainerViewer::ContainerViewer(std::string Command=\"gnuplot\") ContainerViewer::ContainerViewer

";
%feature("docstring") ContainerViewer::~ContainerViewer "ContainerViewer::~ContainerViewer() ContainerViewer::~ContainerViewer

";
%feature("docstring") ContainerViewer::MapPlot "void ContainerViewer::MapPlot(ElementContainerMatrix M, std::string key) ContainerViewer::MapPlot

    
void ContainerViewer::MapPlot(ElementContainerMatrix M, std::string key, UInt4 tof) ContainerViewer::MapPlot
";
%feature("docstring") ContainerViewer::SurfacePlot "void ContainerViewer::SurfacePlot(ElementContainerMatrix M, std::string key) ContainerViewer::SurfacePlot

    
void ContainerViewer::SurfacePlot(ElementContainerMatrix M, std::string key, UInt4 tof) ContainerViewer::SurfacePlot
";
%feature("docstring") ContainerViewer::SetGrayColor "void ContainerViewer::SetGrayColor() ContainerViewer::SetGrayColor

";
%feature("docstring") ContainerViewer::Histogram "void ContainerViewer::Histogram(ElementContainer ec) ContainerViewer::Histogram

";
%feature("docstring") ContainerViewer::WriteGnuPlotData "void ContainerViewer::WriteGnuPlotData(ElementContainer ec, std::string FileName) ContainerViewer::WriteGnuPlotData

";
// File: classEventDataMonitorBase.xml

%feature("docstring") EventDataMonitorBase "C++ includes: EventDataMonitorBase.hh 

";
%feature("docstring") EventDataMonitorBase::EventDataMonitorBase "EventDataMonitorBase::EventDataMonitorBase(size_t _ElementSize=8) EventDataMonitorBase::EventDataMonitorBase

";
%feature("docstring") EventDataMonitorBase::~EventDataMonitorBase "EventDataMonitorBase::~EventDataMonitorBase() EventDataMonitorBase::~EventDataMonitorBase

";
%feature("docstring") EventDataMonitorBase::ParameterSet "void EventDataMonitorBase::ParameterSet(std::string _WireingFile, std::string _DetectorInfoFile) EventDataMonitorBase::ParameterSet

";
%feature("docstring") EventDataMonitorBase::AddDataFiles "void EventDataMonitorBase::AddDataFiles(std::string TargetT0EventFilePath, std::string TargetEventDataFilePath, UInt4 DaqID) EventDataMonitorBase::AddDataFiles

    
void EventDataMonitorBase::AddDataFiles(std::vector< std::string > TargetT0EventFilePath, std::vector< std::string > TargetEventDatafilePath, std::vector< UInt4 > DaqID) EventDataMonitorBase::AddDataFiles
";
%feature("docstring") EventDataMonitorBase::Increment "virtual void EventDataMonitorBase::Increment(UInt4 index)=0 EventDataMonitorBase::Increment

";
%feature("docstring") EventDataMonitorBase::Output "virtual void EventDataMonitorBase::Output(std::string OutputFileName)=0 EventDataMonitorBase::Output

";
%feature("docstring") EventDataMonitorBase::Clear "virtual void EventDataMonitorBase::Clear()=0 EventDataMonitorBase::Clear

";
%feature("docstring") EventDataMonitorBase::ClearDataFileSets "void EventDataMonitorBase::ClearDataFileSets() EventDataMonitorBase::ClearDataFileSets

";
// File: classEventDataToHistogramBase.xml

%feature("docstring") EventDataToHistogramBase "C++ includes: EventDataToHistogramBase.hh 

";
%feature("docstring") EventDataToHistogramBase::EventDataToHistogramBase "EventDataToHistogramBase::EventDataToHistogramBase() EventDataToHistogramBase::EventDataToHistogramBase

    
EventDataToHistogramBase::EventDataToHistogramBase(UInt4 _NumOfPsd, UInt4 _NumOfPixel) EventDataToHistogramBase::EventDataToHistogramBase
";
%feature("docstring") EventDataToHistogramBase::~EventDataToHistogramBase "EventDataToHistogramBase::~EventDataToHistogramBase() EventDataToHistogramBase::~EventDataToHistogramBase

";
%feature("docstring") EventDataToHistogramBase::Allocate "void EventDataToHistogramBase::Allocate(UInt4 _NumOfPsd, UInt4 _NumOfPixel) EventDataToHistogramBase::Allocate

";
%feature("docstring") EventDataToHistogramBase::PutPsdId "virtual UInt4 EventDataToHistogramBase::PutPsdId(UInt4 DaqChannel, UInt4 module, UInt4 psd)=0 EventDataToHistogramBase::PutPsdId

";
%feature("docstring") EventDataToHistogramBase::PutPixelId "virtual UInt4 EventDataToHistogramBase::PutPixelId(UInt4 PsdId, UInt4 PixelPosition)=0 EventDataToHistogramBase::PutPixelId

";
%feature("docstring") EventDataToHistogramBase::PutPixelPosition "UInt4 EventDataToHistogramBase::PutPixelPosition(UInt4 PsdId, UInt4 pl, UInt4 pr) EventDataToHistogramBase::PutPixelPosition

";
%feature("docstring") EventDataToHistogramBase::SetPsdParam "void EventDataToHistogramBase::SetPsdParam(UInt4 PsdId, Double A, Double B, Double C) EventDataToHistogramBase::SetPsdParam

";
%feature("docstring") EventDataToHistogramBase::SetTofBin "void EventDataToHistogramBase::SetTofBin(UInt4 PixelId, std::vector< Double > tof) EventDataToHistogramBase::SetTofBin

    
void EventDataToHistogramBase::SetTofBin(UInt4 PixelId, Double *tof, UInt4 Size) EventDataToHistogramBase::SetTofBin
";
%feature("docstring") EventDataToHistogramBase::SetTofBin_DeltaT_Const "void EventDataToHistogramBase::SetTofBin_DeltaT_Const(UInt4 PixelId, Double Ini, Double Fin, Double DeltaT) EventDataToHistogramBase::SetTofBin_DeltaT_Const

";
%feature("docstring") EventDataToHistogramBase::SetTofBin_DeltaToverT_Const "void EventDataToHistogramBase::SetTofBin_DeltaToverT_Const(UInt4 PixelId, Double Ini, Double Fin, Double DeltaToverT) EventDataToHistogramBase::SetTofBin_DeltaToverT_Const

";
%feature("docstring") EventDataToHistogramBase::Increment "void EventDataToHistogramBase::Increment(UInt4 DaqChannel, UChar *data, UInt4 size) EventDataToHistogramBase::Increment

";
%feature("docstring") EventDataToHistogramBase::PutGslHistogram "GslHistogram * EventDataToHistogramBase::PutGslHistogram(UInt4 PixelId) EventDataToHistogramBase::PutGslHistogram

";
%feature("docstring") EventDataToHistogramBase::PutGslHistogramVec "std::vector< GslHistogram * > * EventDataToHistogramBase::PutGslHistogramVec() EventDataToHistogramBase::PutGslHistogramVec

";
%feature("docstring") EventDataToHistogramBase::PutHist "std::vector< Double > EventDataToHistogramBase::PutHist(UInt4 PixelId) EventDataToHistogramBase::PutHist

";
%feature("docstring") EventDataToHistogramBase::PutSum "Double EventDataToHistogramBase::PutSum(UInt4 PixelId) EventDataToHistogramBase::PutSum

";
%feature("docstring") EventDataToHistogramBase::PutBin "std::vector< Double > EventDataToHistogramBase::PutBin(UInt4 PixelId) EventDataToHistogramBase::PutBin

";
%feature("docstring") EventDataToHistogramBase::Reset "void EventDataToHistogramBase::Reset() EventDataToHistogramBase::Reset

";
%feature("docstring") EventDataToHistogramBase::TimeFocParamC0 "virtual Double EventDataToHistogramBase::TimeFocParamC0(UInt4 _pixelid) EventDataToHistogramBase::TimeFocParamC0

";
%feature("docstring") EventDataToHistogramBase::TimeFocParamC1 "virtual Double EventDataToHistogramBase::TimeFocParamC1(UInt4 _pixelid) EventDataToHistogramBase::TimeFocParamC1

";
%feature("docstring") EventDataToHistogramBase::PutElementContainerMatrix "ElementContainerMatrix EventDataToHistogramBase::PutElementContainerMatrix(std::vector< UInt4 > NumObElements) EventDataToHistogramBase::PutElementContainerMatrix

";
%feature("docstring") EventDataToHistogramBase::PutElementContainerMatrixP "ElementContainerMatrix * EventDataToHistogramBase::PutElementContainerMatrixP(std::vector< UInt4 > NumObElements) EventDataToHistogramBase::PutElementContainerMatrixP

";
// File: classGnuplotInterface.xml

%feature("docstring") GnuplotInterface "

    Gnuplot interface.
    Gnuplot in your system is called and gnuplot commands are passed with this class. Each gnuplot command is passed to the gnuplot through the standard input of the Gnuplot connected by the constructor, and each gnuplot command is stored in this class object. The history of the gnuplot command can be shown and saved to files.
    C++ includes: GnuplotInterface.hh 

";
%feature("docstring") GnuplotInterface::GnuplotInterface "GnuplotInterface::GnuplotInterface(std::string Command=\"gnuplot\") GnuplotInterface::GnuplotInterface Constructor. If Gnuplot is not installed with its command name is \"gnuplot\" in your system, you must specify your gnuplot command. 

";
%feature("docstring") GnuplotInterface::~GnuplotInterface "GnuplotInterface::~GnuplotInterface() GnuplotInterface::~GnuplotInterface Destructor. Gnuplot called by the constructor is terminated. 

";
%feature("docstring") GnuplotInterface::ExeCommand "void GnuplotInterface::ExeCommand(std::string Command) GnuplotInterface::ExeCommand The argument of this method is sent to Gnuplot called by the constructor. 

";
%feature("docstring") GnuplotInterface::e "void GnuplotInterface::e(std::string Command) GnuplotInterface::e Alias of ExeCommand(std::string) 

";
%feature("docstring") GnuplotInterface::ExeCommandSave "void GnuplotInterface::ExeCommandSave(std::string Command) GnuplotInterface::ExeCommandSave

";
%feature("docstring") GnuplotInterface::Clear "void GnuplotInterface::Clear() GnuplotInterface::Clear The buffer storing command history is initialized. See the comment of \"Save(std::string)\". 

";
%feature("docstring") GnuplotInterface::Dump "void GnuplotInterface::Dump() GnuplotInterface::Dump The contents of the buffer storing command history is shown to std-out. 

";
%feature("docstring") GnuplotInterface::Save "void GnuplotInterface::Save(std::string FileName) GnuplotInterface::Save The contents of the butter storing command history is saved to the file named \"FileName\". 

";
%feature("docstring") GnuplotInterface::Replot "void GnuplotInterface::Replot() GnuplotInterface::Replot The contents of the butter storing command history is executed with this command. 

";

// File: classMLF_1_1ConvManyoDoxy2Swig_1_1Doxy2SWIG.xml
%feature("docstring") MLF::ConvManyoDoxy2Swig::Doxy2SWIG "

Converts Doxygen generated XML files into a file containing docstrings that can be used by SWIG-1.3.x that have support for feature(\"docstring\").  Once the data is parsed it is stored in self.pieces. ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::__init__ "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.__init__(self, src) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.__init__ Initialize the instance given a source object (file or filename). ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::generate "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.generate(self) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.generate Parses the file set in the initialization.  The resulting data is stored in `self.pieces`. ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::parse "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse Parse a given node.  This function in turn calls the `parse_<nodeType>` functions which handle the respective nodes. ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Document "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Document(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Document";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Text "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Text(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Text";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Element "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Element(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Element Parse an `ELEMENT_NODE`.  This calls specific `do_<tagName>` handers for different elements.  If no handler is available the `generic_parse` method is called.  All tagNames specified in `self.ignores` are simply ignored. ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::add_text "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.add_text(self, value) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.add_text Adds text corresponding to `value` into `self.pieces`. ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::get_specific_nodes "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.get_specific_nodes(self, node, names) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.get_specific_nodes Given a node and a sequence of strings in `names`, return a dictionary containing the names as keys and child `ELEMENT_NODEs`, that have a `tagName` equal to the name. ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::generic_parse "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.generic_parse(self, node, pad=0) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.generic_parse A Generic parser for arbitrary tags in a node.  Parameters:   - node:  A node in the DOM.  - pad: `int` (default: 0)     If 0 the node data is not padded with newlines.  If 1 it    appends a newline after parsing the childNodes.  If 2 it    pads before and after the nodes are processed.  Defaults to    0. ";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::space_parse "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.space_parse(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.space_parse";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_compoundname "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_compoundname(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_compoundname";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_compounddef "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_compounddef(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_compounddef";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_includes "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_includes(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_includes";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterlist "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterlist(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterlist";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_para "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_para(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_para";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_parametername "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_parametername(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_parametername";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterdefinition "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterdefinition(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterdefinition";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_detaileddescription "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_detaileddescription(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_detaileddescription";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_briefdescription "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_briefdescription(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_briefdescription";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_memberdef "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_memberdef(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_memberdef";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_definition "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_definition(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_definition";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_sectiondef "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_sectiondef(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_sectiondef";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_simplesect "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_simplesect(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_simplesect";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_argsstring "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_argsstring(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_argsstring";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_member "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_member(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_member";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::do_doxygenindex "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_doxygenindex(self, node) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.do_doxygenindex";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::write "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.write(self, fname, mode='w') MLF.ConvManyoDoxy2Swig.Doxy2SWIG.write";

%feature("docstring")  MLF::ConvManyoDoxy2Swig::Doxy2SWIG::clean_pieces "MLF.ConvManyoDoxy2Swig.Doxy2SWIG.clean_pieces(self, pieces) MLF.ConvManyoDoxy2Swig.Doxy2SWIG.clean_pieces Cleans the list of strings given as `pieces`.  It replaces multiple newlines by a maximum of 2 and returns a new list. It also wraps the paragraphs nicely. ";

// File: classMlfArraySlicer.xml

%feature("docstring") MlfArraySlicer "

    Clip and integrate data.
    Clip specified region from ElementContainerArray and integrate them to a ElementContainer, while exclude masked point.
    cd = Manyo.MlfArraySlicer( tea ) <- ElementContainerArray ecm = TPC.Execute(0.05) < give Q step
    C++ includes: MlfArraySlicer.hh 

";
%feature("docstring") MlfArraySlicer::MlfArraySlicer "MlfArraySlicer::MlfArraySlicer() MlfArraySlicer::MlfArraySlicer Constructor. 

    
MlfArraySlicer::MlfArraySlicer(ElementContainerMatrix *ecm, std::string keyOfX=\"\", std::string keyOfY=\"\") MlfArraySlicer::MlfArraySlicer Constructor.
==========================================================================================================================================================

    Args:
        eca Target ElementContainerMatrix (TOF or Energy/Q data)
        keyOfX key used as X axis (same as SetAxes)
        keyOfY key used as Y axis (same as SetAxes) 
    
MlfArraySlicer::MlfArraySlicer(ElementContainerArray *eca, std::string keyOfX=\"\", std::string keyOfY=\"\") MlfArraySlicer::MlfArraySlicer Constructor.
=========================================================================================================================================================

    Args:
        eca Target ElementContainerArray (TOF or Energy/Q data)
        keyOfX key used as X axis (same as SetAxes)
        keyOfY key used as Y axis (same as SetAxes) 
";
%feature("docstring") MlfArraySlicer::~MlfArraySlicer "MlfArraySlicer::~MlfArraySlicer() MlfArraySlicer::~MlfArraySlicer Destructor. 

";
%feature("docstring") MlfArraySlicer::SetAxes "bool MlfArraySlicer::SetAxes(std::string keyOfX=\"\", std::string keyOfY=\"\", bool doInitData=true) MlfArraySlicer::SetAxes Set Axes keys.
============================================================================================================================================
    This sets keys to be used as X-axis values or Y-axis std::vector. keyX must be included in the Header of ECA or the Header of EC as Int4, Double, std::vector<Int4> or vectro<Double> which size is same as the number of ECs or plus 1. keyY must be one of the vectors in EC. If not set or invalid keys, X axis is made from \"XRANGE\" std::vector in the Header of EC and Y axis from EC.PutX()

    Args:
        keyOfX key used as X axis
        keyOfY key used as Y axis
        doInitData whether executing initData or not

    Returns:
        true
        false 

";
%feature("docstring") MlfArraySlicer::SetMask "void MlfArraySlicer::SetMask(Double x0, Double y0, Double x1, Double y1) MlfArraySlicer::SetMask Add mask region.
==================================================================================================================

    Args:
        x0 minimam Tof or Energy value
        y0 minimam pixel ID or Q value
        x1 maximam Tof or Energy value
        y1 maximam pixel ID or Q value 

";
%feature("docstring") MlfArraySlicer::IsInvalid "bool MlfArraySlicer::IsInvalid() MlfArraySlicer::IsInvalid

";
%feature("docstring") MlfArraySlicer::ClearMask "void MlfArraySlicer::ClearMask(void) MlfArraySlicer::ClearMask Return if valid data.
=====================================================================================

    Args:
        None @returnValue true or false Clear std::vector of Mask region Clear Mask region std::vector
        None 

";
%feature("docstring") MlfArraySlicer::SetClipRegion "void MlfArraySlicer::SetClipRegion(Double x0, Double y0, Double x1, Double y1, bool checkY=true) MlfArraySlicer::SetClipRegion Add mask region.
================================================================================================================================================

    Args:
        x0 minimam Tof or Energy value
        y0 minimam pixel ID or Q value
        x1 maximam Tof or Energy value
        y1 maximam pixel ID or Q value
        checkY true is to check y0,y1 are in sequence 

";
%feature("docstring") MlfArraySlicer::ClearClipRegion "void MlfArraySlicer::ClearClipRegion(void) MlfArraySlicer::ClearClipRegion Clear std::vector of clip region.
=============================================================================================================
    Clear Mask region std::vector

    Args:
        None 

";
%feature("docstring") MlfArraySlicer::ExecInteg "ElementContainerArray MlfArraySlicer::ExecInteg(bool average, int axis, Double width=0.0, Double bin=0.0) MlfArraySlicer::ExecInteg

    
bool MlfArraySlicer::ExecInteg(ElementContainerArray *_eca, bool average, int axis, Double width=0.0, Double bin=0.0) MlfArraySlicer::ExecInteg Integrate (or calcurate average) each region.
==============================================================================================================================================================================================
    X axis will be TOF or Energy

    Args:
        mode Set if true: average or false:integration
        axis Set axis 0: TOF or Energy 1:index or Q 2:Free cutting
        width Set integ width on free cutting
        bin Set bin of free cutting line 
";
%feature("docstring") MlfArraySlicer::CutAlongX "ElementContainerArray MlfArraySlicer::CutAlongX(bool average=true) MlfArraySlicer::CutAlongX

    
ElementContainer MlfArraySlicer::CutAlongX(Double ymin, Double ymax, bool average=true) MlfArraySlicer::CutAlongX
    
bool MlfArraySlicer::CutAlongX(ElementContainerArray *_eca, bool average=true) MlfArraySlicer::CutAlongX
    
bool MlfArraySlicer::CutAlongX(ElementContainer *_ec, Double ymin, Double ymax, bool average=true) MlfArraySlicer::CutAlongX
";
%feature("docstring") MlfArraySlicer::CutAlongY "ElementContainerArray MlfArraySlicer::CutAlongY(bool average=true) MlfArraySlicer::CutAlongY

    
ElementContainer MlfArraySlicer::CutAlongY(Double xmin, Double xmax, bool average=true) MlfArraySlicer::CutAlongY
    
bool MlfArraySlicer::CutAlongY(ElementContainerArray *_eca, bool average=true) MlfArraySlicer::CutAlongY
    
bool MlfArraySlicer::CutAlongY(ElementContainer *_ec, Double xmin, Double xmax, bool average=true) MlfArraySlicer::CutAlongY
";
%feature("docstring") MlfArraySlicer::CutDiagonal "ElementContainerArray MlfArraySlicer::CutDiagonal(Double width, Double bin, bool average=true) MlfArraySlicer::CutDiagonal

    
ElementContainer MlfArraySlicer::CutDiagonal(Double x0, Double y0, Double x1, Double y1, Double width, Double bin, bool average=true) MlfArraySlicer::CutDiagonal
    
bool MlfArraySlicer::CutDiagonal(ElementContainerArray *_eca, Double width, Double bin, bool average=true) MlfArraySlicer::CutDiagonal
    
bool MlfArraySlicer::CutDiagonal(ElementContainer *_ec, Double x0, Double y0, Double x1, Double y1, Double width, Double bin, bool average=true) MlfArraySlicer::CutDiagonal
";
%feature("docstring") MlfArraySlicer::SetQbin "void MlfArraySlicer::SetQbin(Double bin, Double qmin=0.0, Double qmax=0.0) MlfArraySlicer::SetQbin Set Q bin width and Q range to make Q binning cut.
======================================================================================================================================================
    SetQbin( 0.02 ) : bin=0.02, and Q range is depend on slicing area SetQbin( 0.02, -1, -1 ) : bin=0.02, and Q range uses maximun and minimum of given data SetQbin( 0.01, 0.0, 8.0 ): bin=0.01, and Q range is 0.0 to 8.0

    Args:
        bin Set bin of Q cutting line
        qmin Set minimum value of Q range
        qmax Set maximum value of Q range 

";
%feature("docstring") MlfArraySlicer::SetHeaderToEC "void MlfArraySlicer::SetHeaderToEC(ElementContainer &ec_res, Double y0, Double y1, bool average=true, bool reverse=false) MlfArraySlicer::SetHeaderToEC

";
// File: classMlfDetectorEfficiencyCorrection.xml

%feature("docstring") MlfDetectorEfficiencyCorrection "

    Data Correction of Detector Efficiency.
    This codes are used for the detector efficiency correction.
    Yasuhiro Inamura (J-PARC, MLF)  Usage : direct calculation for each pixel DEC = MlfDetectorEfficiencyCorrection( \"/path/to/DetectorInfo.xml\", \"SUS-304-3He-PSD\" ) DEC.Execute( dat )
    Usage : using approximate values DEC = MlfDetectorEfficiencyCorrection( \"/path/to/DetEffi_SIK-SUS-304-3He-PSD.dat\" ) DEC.Execute( dat )
    The pixel position info must be included in HeaderBase for each ElementContainer with format std::vector<Double> [Px,Py,Pz];
    C++ includes: MlfDetectorEfficiencyCorrection.hh 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::MlfDetectorEfficiencyCorrection "MlfDetectorEfficiencyCorrection::MlfDetectorEfficiencyCorrection() MlfDetectorEfficiencyCorrection::MlfDetectorEfficiencyCorrection

    
MlfDetectorEfficiencyCorrection::MlfDetectorEfficiencyCorrection(std::string _detInfo, std::string _detName, std::string _xsecDataPath=\"\", std::string _xmlPath=\"\") MlfDetectorEfficiencyCorrection::MlfDetectorEfficiencyCorrection
    
MlfDetectorEfficiencyCorrection::MlfDetectorEfficiencyCorrection(std::string _apDataPath) MlfDetectorEfficiencyCorrection::MlfDetectorEfficiencyCorrection Constructor.
========================================================================================================================================================================
    MlfDetectorEfficiencyCorrection() MlfDetectorEfficiencyCorrection( std::string _detInfo, std::string _detName=\"\" )

    Args:
        _detInfo (std::string) path to DetectorInfo.xml which must include <detectorStructure>.
        _detName (std::string) Detector Name like \"SUS304-3He-PSD\". This name must be included <detectorStructure>.
        _xsecDataPath (std::string) path to Xsection table xml file
        _xmlPath (std::string) path to the directory including xml files

    Returns:
        None 
";
%feature("docstring") MlfDetectorEfficiencyCorrection::~MlfDetectorEfficiencyCorrection "MlfDetectorEfficiencyCorrection::~MlfDetectorEfficiencyCorrection() MlfDetectorEfficiencyCorrection::~MlfDetectorEfficiencyCorrection Destructor. 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::Initialize "bool MlfDetectorEfficiencyCorrection::Initialize(std::string _detInfoName, std::string _detName, std::string _xsecDataName=\"\") MlfDetectorEfficiencyCorrection::Initialize Sets DetectorInfo and detNmae.
============================================================================================================================================================================================================
    Sets DetectorInfo (including <detectorStructure>) and detName to set parameters for calculations of detector efficiency.

    Args:
        _detInfo (std::string) path to DetectorInfo.xml which must include <detectorStructure>.
        _detName (std::string) Detector Name like \"SUS304-3He-PSD\". This name must be included <detectorStructure>.

    Returns:
        true suceeded.
        false failed. 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::SetXmlPath "void MlfDetectorEfficiencyCorrection::SetXmlPath(std::string path) MlfDetectorEfficiencyCorrection::SetXmlPath

    
void MlfDetectorEfficiencyCorrection::SetXmlPath(std::vector< std::string > paths) MlfDetectorEfficiencyCorrection::SetXmlPath
";
%feature("docstring") MlfDetectorEfficiencyCorrection::AddXmlPath "void MlfDetectorEfficiencyCorrection::AddXmlPath(std::string path) MlfDetectorEfficiencyCorrection::AddXmlPath Set path(s) to find xml files.
==============================================================================================================================================

    Args:
        path (std::string)
        paths (std::vector<std::string>)

    Returns:
        None 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::Execute "void MlfDetectorEfficiencyCorrection::Execute(ElementContainerMatrix *_ecm) MlfDetectorEfficiencyCorrection::Execute Executes Detector Efficiency correction.
==============================================================================================================================================================

    Args:
        _ecm (ElementContainerMatrix) Target Data

    Returns:
        None 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::ReplaceWithEfficiency "void MlfDetectorEfficiencyCorrection::ReplaceWithEfficiency(ElementContainerMatrix *_ecm) MlfDetectorEfficiencyCorrection::ReplaceWithEfficiency Set Detector Efficiency values into ElementContainer.
=======================================================================================================================================================================================================
    This replaces the intensity of given ElementContainer with the calculated detector efficiency.

    Args:
        _ecm (ElementContainerMatrix) Target Data

    Returns:
        None 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::GetEfficiency "Double MlfDetectorEfficiencyCorrection::GetEfficiency(double Ef, double theta) MlfDetectorEfficiencyCorrection::GetEfficiency Gets detector efficiency value.
==============================================================================================================================================================

    Args:
        Ef (Double) [meV]
        theta (Double) [degree] angle from perpendicular to detector to the incident direction

    Returns:
        double value of efficiency 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::MakeApproximateData "bool MlfDetectorEfficiencyCorrection::MakeApproximateData(std::string path, double Ef_min, double Ef_max, UInt4 Ef_num, double th_min, double th_max, UInt4 th_num) MlfDetectorEfficiencyCorrection::MakeApproximateData Makes data file storing approximate value of detector efficiency.
===========================================================================================================================================================================================================================================================================================

    Args:
        path (std::string) path of data file to be saved
        Ef_min (Double) min value of Ef range [meV]
        Ef_min (Double) max value of Ef range [meV]
        Ef_num (UInt4) the number of Ef range divisions [meV]
        th_min (Double) min value of theta range [meV]
        th_min (Double) max value of theta range [meV]
        th_num (UInt4) the number of theta range divisions [meV]

    Returns:
        true : succeeded.
        false : failed. 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::LoadApproximateData "bool MlfDetectorEfficiencyCorrection::LoadApproximateData(std::string path) MlfDetectorEfficiencyCorrection::LoadApproximateData Loads data from file storing approximate values of detector efficiency.
=========================================================================================================================================================================================================

    Args:
        path (std::string) path of data file to be saved

    Returns:
        true : succeeded.
        false : failed. 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::GetEfficiencyApproximateVal "Double MlfDetectorEfficiencyCorrection::GetEfficiencyApproximateVal(double Ef, double theta) MlfDetectorEfficiencyCorrection::GetEfficiencyApproximateVal Gets detector efficiency approximate value from loaded data file.
============================================================================================================================================================================================================================
    Aproximate value is calculated by interpolation using values matrix with lambda and theta axes.

    Args:
        Ef (Double) [meV]
        theta (Double) [degree] angle from perpendicular to detector to the incident direction

    Returns:
        double value of efficiency 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::EToLambda "Double MlfDetectorEfficiencyCorrection::EToLambda(Double ene) MlfDetectorEfficiencyCorrection::EToLambda Converts enrgy value [meV] to wave length [1/Ang] of neutrons.
========================================================================================================================================================================

    Args:
        ene (Double) [meV]

    Returns:
        double value of wave length 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::LambdaToE "Double MlfDetectorEfficiencyCorrection::LambdaToE(Double lambda) MlfDetectorEfficiencyCorrection::LambdaToE Converts wave length [1/Ang] to enrgy value [meV] of neutrons.
===========================================================================================================================================================================

    Args:
        lambda (Double) [1/Ang]

    Returns:
        double value of eneryg 

";
%feature("docstring") MlfDetectorEfficiencyCorrection::PutApproximateDataRange "std::vector< Double > MlfDetectorEfficiencyCorrection::PutApproximateDataRange(std::string path=\"\") MlfDetectorEfficiencyCorrection::PutApproximateDataRange Returns data range from file storing approximate values of detector efficiency.
===============================================================================================================================================================================================================================================

    Args:
        path (std::string) path of data file to be saved

    Returns:
        std::vector<double> [<Ef_min>, <Ef_max>, <num_of_Ef>, <Th_min>, <Th_max>, <num_of_Th> ] 

";
// File: classMlfMatrixSlicer.xml

%feature("docstring") MlfMatrixSlicer "

    Slice a plane and get a line on the plane.
    Slice a plane specified by 3 points( org, x, y) from a data. and get a line on the plane. The data must be ElementContainerArray or ElementContainerMatrix.
    ups = Utsusemi.MlfMatrixSlicer( data ) <- ElementContainerArray or ElementContainerMatrix. ups.SetAxes(\"Qa\",\"Qb\",\"Qc\") <- Qa,Qb,Qc must be existed as a key of vectors in EC or HeaderBase in EC,ECA,ECM ups.SetPlaneKeys(\"SlicedX\",\"SlicedY\") sliced_eca = Manyo.ElementContaineArray() ups.GetPlane(sliced_eca,[0,0,0],[1,0,0],[0,1,0],0.1,0.05,[-1.0,10.0],[-0.5,5.0],0.2)
    C++ includes: MlfMatrixSlicer.hh 

";
%feature("docstring") MlfMatrixSlicer::MlfMatrixSlicer "MlfMatrixSlicer::MlfMatrixSlicer() MlfMatrixSlicer::MlfMatrixSlicer Constructor. 

    
MlfMatrixSlicer::MlfMatrixSlicer(ElementContainerMatrix *ecm) MlfMatrixSlicer::MlfMatrixSlicer Constructor.
============================================================================================================

    Args:
        ecm Target ElementContainerMatrix 
    
MlfMatrixSlicer::MlfMatrixSlicer(ElementContainerArray *eca) MlfMatrixSlicer::MlfMatrixSlicer Constructor.
===========================================================================================================

    Args:
        eca Target ElementContainerArray 
";
%feature("docstring") MlfMatrixSlicer::~MlfMatrixSlicer "MlfMatrixSlicer::~MlfMatrixSlicer() MlfMatrixSlicer::~MlfMatrixSlicer Destructor. 

";
%feature("docstring") MlfMatrixSlicer::SetTarget "void MlfMatrixSlicer::SetTarget(ElementContainerMatrix *ecm) MlfMatrixSlicer::SetTarget

    
void MlfMatrixSlicer::SetTarget(ElementContainerArray *eca) MlfMatrixSlicer::SetTarget
";
%feature("docstring") MlfMatrixSlicer::SetAxes "bool MlfMatrixSlicer::SetAxes(std::string keyX, std::string keyY, std::string keyZ) MlfMatrixSlicer::SetAxes Specify keys for 3 axes.
======================================================================================================================================

    Args:
        keyX key of X-axis
        keyY key of Y-axis
        keyZ key of Z-axis @returnValue true: sucsess or false: faile 

";
%feature("docstring") MlfMatrixSlicer::IsValid "bool MlfMatrixSlicer::IsValid() MlfMatrixSlicer::IsValid Return if valid data.
===============================================================================

    Args:
        None @returnValue true or false 

";
%feature("docstring") MlfMatrixSlicer::SetPlaneKeys "void MlfMatrixSlicer::SetPlaneKeys(std::string xkey, std::string ykey) MlfMatrixSlicer::SetPlaneKeys Set x and y keys for sliced plane.
========================================================================================================================================
    set std::string keys

    Args:
        xkey key of X data
        ykey key of Y data 

";
%feature("docstring") MlfMatrixSlicer::GetPlane "ElementContainerArray * MlfMatrixSlicer::GetPlane(std::vector< Double > org, std::vector< Double > x, std::vector< Double > y, Double xbin, Double ybin, std::vector< Double > xrange, std::vector< Double > yrange, Double thickness) MlfMatrixSlicer::GetPlane Get sliced plane ( Obsoleted )
================================================================================================================================================================================================================================================================================================

    Args:
        org org point(x,y,z) of plane
        x a point(x,y,z) on x axis of plane
        y a point(x,y,z) on y axis of plane
        xbin bin value for x axis
        ybin bin value for y axis
        xrange (x0,x1)
        yrange (y0,y1)
        thickness thickness of plane @returnValue ElementContainerArray (Sliced plane) 

    
bool MlfMatrixSlicer::GetPlane(ElementContainerArray *eca, std::vector< Double > org, std::vector< Double > x, std::vector< Double > y, Double xbin, Double ybin, std::vector< Double > xrange, std::vector< Double > yrange, Double thickness) MlfMatrixSlicer::GetPlane
    
bool MlfMatrixSlicer::GetPlane(ElementContainerArray *eca, PyObject *org, PyObject *x, PyObject *y, Double xbin, Double ybin, PyObject *xrange, PyObject *yrange, Double thickness) MlfMatrixSlicer::GetPlane Get sliced plane.
================================================================================================================================================================================================================================

    Args:
        eca ElementContainerArray to be filled by slice results
        org org point(x,y,z) of plane
        x a point(x,y,z) on x axis of plane
        y a point(x,y,z) on y axis of plane
        xbin bin value for x axis
        ybin bin value for y axis
        xrange (x0,x1)
        yrange (y0,y1)
        thickness thickness of plane

    Returns:
        true : succeeded
        false failed 
";
%feature("docstring") MlfMatrixSlicer::Slice "bool MlfMatrixSlicer::Slice(ElementContainerArray *eca, std::vector< Double > org, std::vector< Double > ux, std::vector< Double > uy, std::vector< Double > xrange, std::vector< Double > yrange, Double thickness) MlfMatrixSlicer::Slice

    
bool MlfMatrixSlicer::Slice(ElementContainerArray *eca, PyObject *org, PyObject *ux, PyObject *uy, PyObject *xrange, PyObject *yrange, Double thickness) MlfMatrixSlicer::Slice Get sliced plane.
==================================================================================================================================================================================================

    Args:
        eca ElementContainerArray to be filled by slice results
        org org point(x,y,z) of plane
        ux direction std::vector of x-axis
        uy direction std::vector of y-axis
        xrange (x_min,x_max,xbin)
        yrange (y_min,y_max,ybin)
        thickness thickness of plane

    Returns:
        true : succeeded
        false failed 
";
%feature("docstring") MlfMatrixSlicer::GetPlaneAsDetectMap "bool MlfMatrixSlicer::GetPlaneAsDetectMap(ElementContainerArray *ret_eca, std::string keyX, std::string keyY, std::string keyZ, std::vector< Double > zrange, bool withBankGap=true) MlfMatrixSlicer::GetPlaneAsDetectMap

    
bool MlfMatrixSlicer::GetPlaneAsDetectMap(ElementContainerArray *ret_eca, std::string keyX, std::string keyY, std::string keyZ, PyObject *zrange, bool withBankGap=true) MlfMatrixSlicer::GetPlaneAsDetectMap Get sliced plane as DetectMap data.
==================================================================================================================================================================================================================================================
    This includes SetAxes(std::string keyX, std::string keyY, std::string keyZ).

    Args:
        ret_eca ElementContainerArray to be filled by slice results
        keyX key of X-axis (usually \"DETID\") detector direction
        keyY key of Y-axis (usually \"\" ) pixel direction
        keyZ key of Z-axis (usually std::vector key) \"TOF\" direction
        zrange (z0,z1)
        withBankGap true : insert dammy detector between banks ( guide for eyes )

    Returns:
        true : succeeded
        false failed 
";
%feature("docstring") MlfMatrixSlicer::PutDetectMapIndex "std::vector< Int4 > MlfMatrixSlicer::PutDetectMapIndex(UInt4 xind, UInt4 yind) MlfMatrixSlicer::PutDetectMapIndex Get index of original ElementContainer for sliced plane as DetectMap data.
=============================================================================================================================================================================================

    Args:
        xind index of x for sliced plane
        yind index of y for sliced plane @returnValue std::vector<Int4> : empty returns if out of size, <-1,-1> returns if should be ignored 

";
%feature("docstring") MlfMatrixSlicer::SetLineKeys "void MlfMatrixSlicer::SetLineKeys(std::string xkey, std::string ykey) MlfMatrixSlicer::SetLineKeys Set x and y keys for line.
==============================================================================================================================
    set std::string keys

    Args:
        xkey key of X data
        ykey key of Y data 

";
%feature("docstring") MlfMatrixSlicer::GetLine "ElementContainer MlfMatrixSlicer::GetLine(std::vector< Double > start, std::vector< Double > end, Double bin, Double width) MlfMatrixSlicer::GetLine

    
ElementContainer MlfMatrixSlicer::GetLine(PyObject *start, PyObject *end, Double bin, Double width) MlfMatrixSlicer::GetLine Clip and get a line data.
=======================================================================================================================================================
    X axis will be TOF or Energy

    Args:
        start start point(x,y) of line
        end end point(x,y) of line
        bin bin value for x axis
        width width of line @returnValue ElementContainer 
";
%feature("docstring") MlfMatrixSlicer::SetPlane "void MlfMatrixSlicer::SetPlane(ElementContainerArray *plane) MlfMatrixSlicer::SetPlane Set a plane.
====================================================================================================
    set plane data

    Args:
        plane a plane 

";
%feature("docstring") MlfMatrixSlicer::SetAverageMode "void MlfMatrixSlicer::SetAverageMode() MlfMatrixSlicer::SetAverageMode

";
%feature("docstring") MlfMatrixSlicer::SetSummationMode "void MlfMatrixSlicer::SetSummationMode() MlfMatrixSlicer::SetSummationMode

";
%feature("docstring") MlfMatrixSlicer::PutAllAxesRanges "std::vector< Double > MlfMatrixSlicer::PutAllAxesRanges(std::string keyX=\"\", std::string keyY=\"\", std::string keyZ=\"\") MlfMatrixSlicer::PutAllAxesRanges

";
// File: classMlfScatAbsoBodyManager.xml

%feature("docstring") MlfScatAbsoBodyManager "

    Calclates neutron Scattring and absorption on nuclei.
    This code gives crosssections for atoms which are used for the detector efficiency correction.
    Override some methods import parameters from xml files instead of text files.
    Yasuhiro Inamura (J-PARC, MLF)
    C++ includes: MlfScatAbsoBodyManager.hh 

";
%feature("docstring") MlfScatAbsoBodyManager::MlfScatAbsoBodyManager "MlfScatAbsoBodyManager::MlfScatAbsoBodyManager() MlfScatAbsoBodyManager::MlfScatAbsoBodyManager

    
MlfScatAbsoBodyManager::MlfScatAbsoBodyManager(std::string _detectInfoPath, std::string _nistDataPath=\"\") MlfScatAbsoBodyManager::MlfScatAbsoBodyManager
";
%feature("docstring") MlfScatAbsoBodyManager::~MlfScatAbsoBodyManager "MlfScatAbsoBodyManager::~MlfScatAbsoBodyManager() MlfScatAbsoBodyManager::~MlfScatAbsoBodyManager

";
%feature("docstring") MlfScatAbsoBodyManager::SetXmlInfoFile "bool MlfScatAbsoBodyManager::SetXmlInfoFile(std::string detectorInfoPath, std::string _nistDataPath=\"\") MlfScatAbsoBodyManager::SetXmlInfoFile Set full path to DetectorInfo file and Nist data file.
========================================================================================================================================================================================================

    Args:
        detectorInfoPath (std::string)
        _nistDataPath (std::string)

    Returns:
        None 

";
%feature("docstring") MlfScatAbsoBodyManager::SetNistXmlFile "bool MlfScatAbsoBodyManager::SetNistXmlFile(std::string _nistDataPath) MlfScatAbsoBodyManager::SetNistXmlFile

";
%feature("docstring") MlfScatAbsoBodyManager::SetDetectorInfoFile "bool MlfScatAbsoBodyManager::SetDetectorInfoFile(std::string detectorInfoPath) MlfScatAbsoBodyManager::SetDetectorInfoFile

";
%feature("docstring") MlfScatAbsoBodyManager::SetDetName "bool MlfScatAbsoBodyManager::SetDetName(std::string det_name=\"\") MlfScatAbsoBodyManager::SetDetName

";
%feature("docstring") MlfScatAbsoBodyManager::PutDetectorStructureInfo "std::string MlfScatAbsoBodyManager::PutDetectorStructureInfo() MlfScatAbsoBodyManager::PutDetectorStructureInfo

";
%feature("docstring") MlfScatAbsoBodyManager::AddSigmaToXtable "bool MlfScatAbsoBodyManager::AddSigmaToXtable(std::string atomname) MlfScatAbsoBodyManager::AddSigmaToXtable

";
%feature("docstring") MlfScatAbsoBodyManager::DumpXtable "void MlfScatAbsoBodyManager::DumpXtable() MlfScatAbsoBodyManager::DumpXtable

";
%feature("docstring") MlfScatAbsoBodyManager::GetAtomSigmaWithEnergy "Double MlfScatAbsoBodyManager::GetAtomSigmaWithEnergy(std::string atomname, std::string xstype, Double energy) MlfScatAbsoBodyManager::GetAtomSigmaWithEnergy

";
%feature("docstring") MlfScatAbsoBodyManager::GetAtomSigmaWithLambda "Double MlfScatAbsoBodyManager::GetAtomSigmaWithLambda(std::string atomname, std::string xstype, Double lambda) MlfScatAbsoBodyManager::GetAtomSigmaWithLambda

";
%feature("docstring") MlfScatAbsoBodyManager::SetInfoData "void MlfScatAbsoBodyManager::SetInfoData(std::string det_name, struct ScatAbsoInfo *wallInfo, struct ScatAbsoInfo *bodyInfo) MlfScatAbsoBodyManager::SetInfoData set AdvScatAbsoBodyManagerDNA variables to values from specified file.
========================================================================================================================================================================================================================================

    Args:
        filename scatterer and/or absorbent data file
        wallInfo information of wall of container
        bodyInfo information of scatterer and/or absorbent
        set value to AdvScatAbsoBodyManagerDNA variable.

    Args:
        filename scatterer and/or absorbent data file
        wallInfo information of wall of container
        bodyInfo information of scatterer and/or absorbent 

";
%feature("docstring") MlfScatAbsoBodyManager::SetSigmaDataNIST "void MlfScatAbsoBodyManager::SetSigmaDataNIST(Double velocity, std::string atomname, std::string typeCS) MlfScatAbsoBodyManager::SetSigmaDataNIST set an array to cross section data from the file recorded NIST data.
=======================================================================================================================================================================================================================

    Args:
        velocity
        atomname atomic name
        typeCS type of scattering and absorption data. available values of typeCS 't' sum of scattering cross section and absorption cross sction midefied using user specified velocity
        'a' absorption cross sction midefied using user specified velocity
        's' scattering cross section
        'c' cohrent length
        'i' incoherent length
        array dataCS[][] in the class keeps NIST data in following way, dataCS[0][0] incident neutron velocity at measurement
        dataCS[0][1] user specified data using character symbol
        set sigma by use of database file made by NIST

    Args:
        atomname atomic name
        typeCS mass number, atomic name and scattering type 

";
%feature("docstring") MlfScatAbsoBodyManager::GetAtomicWeight "Double MlfScatAbsoBodyManager::GetAtomicWeight(std::string) MlfScatAbsoBodyManager::GetAtomicWeight get atomic weight for the specified nuclide or elemnent 

";
%feature("docstring") MlfScatAbsoBodyManager::GetEfficiency "Double MlfScatAbsoBodyManager::GetEfficiency(Double eneNeutron, Double thetaDetector) MlfScatAbsoBodyManager::GetEfficiency

";
%feature("docstring") MlfScatAbsoBodyManager::GetSigmas "void MlfScatAbsoBodyManager::GetSigmas(Double energy, Double *sigmaDA, Double *sigmaWA, Double *sigmaWS) MlfScatAbsoBodyManager::GetSigmas

";
%feature("docstring") MlfScatAbsoBodyManager::CalcEfficiencyDetector "Double MlfScatAbsoBodyManager::CalcEfficiencyDetector(Double thetaDetector, Double sigmaDA, Double sigmaWS, Double sigmaWA) MlfScatAbsoBodyManager::CalcEfficiencyDetector

";
%feature("docstring") MlfScatAbsoBodyManager::ReturnAbsorptionByDetector "Double MlfScatAbsoBodyManager::ReturnAbsorptionByDetector(Double x, Double theta, Double sigmaDA, Double sigmaWS, Double sigmaWA, Double radiusDetector, Double radiusInnerDetector, Double radiusWall, Double n3He, Double nwall, Double T) MlfScatAbsoBodyManager::ReturnAbsorptionByDetector

";
%feature("docstring") MlfScatAbsoBodyManager::GetMolecularWeight "Double MlfScatAbsoBodyManager::GetMolecularWeight(std::string form) MlfScatAbsoBodyManager::GetMolecularWeight

";
%feature("docstring") MlfScatAbsoBodyManager::GetTotalXsectAve "Double MlfScatAbsoBodyManager::GetTotalXsectAve(std::string form) MlfScatAbsoBodyManager::GetTotalXsectAve

";
%feature("docstring") MlfScatAbsoBodyManager::GetNumberDensity "Double MlfScatAbsoBodyManager::GetNumberDensity(std::string form, Double dencity) MlfScatAbsoBodyManager::GetNumberDensity

";
%feature("docstring") MlfScatAbsoBodyManager::_Transform "bool MlfScatAbsoBodyManager::_Transform(std::string form, std::vector< std::pair< std::string, Double > > &parts) MlfScatAbsoBodyManager::_Transform

";
%feature("docstring") MlfScatAbsoBodyManager::_GetAtomInfo "bool MlfScatAbsoBodyManager::_GetAtomInfo(std::string atomname, std::vector< Double > &info) MlfScatAbsoBodyManager::_GetAtomInfo

";
%feature("docstring") MlfScatAbsoBodyManager::SetDebugMode "void MlfScatAbsoBodyManager::SetDebugMode(bool _isDebug=true) MlfScatAbsoBodyManager::SetDebugMode

";
// File: classOnLineGnuPlot.xml

%feature("docstring") OnLineGnuPlot "C++ includes: OnLineGnuPlot.hh 

";
%feature("docstring") OnLineGnuPlot::OnLineGnuPlot "OnLineGnuPlot::OnLineGnuPlot(std::string command=\"gnuplot\") OnLineGnuPlot::OnLineGnuPlot

";
%feature("docstring") OnLineGnuPlot::~OnLineGnuPlot "OnLineGnuPlot::~OnLineGnuPlot() OnLineGnuPlot::~OnLineGnuPlot

";
%feature("docstring") OnLineGnuPlot::e "void OnLineGnuPlot::e(std::string command) OnLineGnuPlot::e

";
%feature("docstring") OnLineGnuPlot::SetGrayColor "void OnLineGnuPlot::SetGrayColor() OnLineGnuPlot::SetGrayColor

";
%feature("docstring") OnLineGnuPlot::SetDataObj "void OnLineGnuPlot::SetDataObj(std::vector< GslHistogram * > *data, std::vector< std::vector< UInt4 > > dim) OnLineGnuPlot::SetDataObj

    
void OnLineGnuPlot::SetDataObj(std::vector< GslHistogram * > *data, UInt4 x, UInt4 y) OnLineGnuPlot::SetDataObj
";
%feature("docstring") OnLineGnuPlot::MapPlot "void OnLineGnuPlot::MapPlot() OnLineGnuPlot::MapPlot

    
void OnLineGnuPlot::MapPlot(UInt4 tof) OnLineGnuPlot::MapPlot
";
%feature("docstring") OnLineGnuPlot::SurfacePlot "void OnLineGnuPlot::SurfacePlot() OnLineGnuPlot::SurfacePlot

    
void OnLineGnuPlot::SurfacePlot(UInt4 tof) OnLineGnuPlot::SurfacePlot
";
%feature("docstring") OnLineGnuPlot::TofVsCounts "void OnLineGnuPlot::TofVsCounts(UInt4 Psd) OnLineGnuPlot::TofVsCounts

";
// File: classT0TreatToolsBase.xml

%feature("docstring") T0TreatToolsBase "

    Tools for treating T0 event in eventdata.
    updated 130501: define NumOfClocksBeforeFirstT0 130227: define BytesOfOrgEvent for readOrgEvent 100910: delete returnBytesOfEvent and define const BytesOfT0Event
    C++ includes: T0TreatToolsBase.hh 

";
%feature("docstring") T0TreatToolsBase::T0TreatToolsBase "T0TreatToolsBase::T0TreatToolsBase(UInt4 bytes_of_org_event=8) T0TreatToolsBase::T0TreatToolsBase Constructor.
===============================================================================================================

    Args:
        bytes_of_org_event size of event to be read [bytes] 

";
%feature("docstring") T0TreatToolsBase::~T0TreatToolsBase "T0TreatToolsBase::~T0TreatToolsBase() T0TreatToolsBase::~T0TreatToolsBase Destructor. 

";
%feature("docstring") T0TreatToolsBase::readOrgEvent "UInt4 T0TreatToolsBase::readOrgEvent(std::string filename) T0TreatToolsBase::readOrgEvent

    
UInt4 T0TreatToolsBase::readOrgEvent(std::vector< std::string > filenames) T0TreatToolsBase::readOrgEvent Load original event data.
====================================================================================================================================
    This reads original event data from DAQ system to count events from head of file to T0 event and store counts, Pulse ID and its Instrument clock. readOrgEvent( std::string filename ) readOrgEvent( std::vector<std::string> filenames )

    Args:
        filename the file name of event data from DAQ
        filenames the file name list of event data

    Returns:
        0 succeeded in reading file
        1 failed in reading file 
";
%feature("docstring") T0TreatToolsBase::saveT0IndexEvent "UInt4 T0TreatToolsBase::saveT0IndexEvent(std::string filename) T0TreatToolsBase::saveT0IndexEvent Make T0 index file.
======================================================================================================================
    This reads Event Data (RAW), make T0 index and save as file.

    Args:
        filename the file name of event data for T0 index.

    Returns:
        0 succeeded in saving file
        1 failed in saving file 

";
%feature("docstring") T0TreatToolsBase::readT0IndexEventold "UInt4 T0TreatToolsBase::readT0IndexEventold(std::string filename) T0TreatToolsBase::readT0IndexEventold

    
UInt4 T0TreatToolsBase::readT0IndexEventold(std::vector< std::string > filenames) T0TreatToolsBase::readT0IndexEventold
";
%feature("docstring") T0TreatToolsBase::readT0IndexEvent "UInt4 T0TreatToolsBase::readT0IndexEvent(std::string filename) T0TreatToolsBase::readT0IndexEvent

    
UInt4 T0TreatToolsBase::readT0IndexEvent(std::vector< std::string > filenames) T0TreatToolsBase::readT0IndexEvent Read T0 index file.
======================================================================================================================================
    Read T0 index file produced by makeT0Index readT0IndexEvent( std::string filename ) readT0IndexEvent( std::vector<std::string> filenames );

    Args:
        filename the file name of event data for T0 index.
        filenames

    Returns:
        0 succeeded in reading file
        1 failed in readinf file 
";
%feature("docstring") T0TreatToolsBase::putVectorT0Index "std::vector< UInt8 > T0TreatToolsBase::putVectorT0Index() T0TreatToolsBase::putVectorT0Index Put T0 index.
===========================================================================================================
    Put all T0 index as std::vector

    Returns:
        std::vector<UInt4> 

";
%feature("docstring") T0TreatToolsBase::putVectorT0IndexBySec "std::vector< UInt8 > T0TreatToolsBase::putVectorT0IndexBySec(Double start_sec, Double end_sec) T0TreatToolsBase::putVectorT0IndexBySec Put T0 index std::vector between start ana end.
=======================================================================================================================================================================================
    Put T0 index

    Args:
        start_sec (Double)
        end_sec (Double)

    Returns:
        std::vector<UInt4> 

";
%feature("docstring") T0TreatToolsBase::putVectorPulseId "std::vector< UInt8 > T0TreatToolsBase::putVectorPulseId() T0TreatToolsBase::putVectorPulseId Put PulseId.
==========================================================================================================
    Put all PulseIDs as std::vector

    Returns:
        std::vector<UInt8> 

";
%feature("docstring") T0TreatToolsBase::putVectorPulseIdBySec "std::vector< UInt8 > T0TreatToolsBase::putVectorPulseIdBySec(Double start_sec, Double end_sec) T0TreatToolsBase::putVectorPulseIdBySec Put PulseId std::vector between start ana end.
======================================================================================================================================================================================
    Put PulseId index in the range of given parameters

    Args:
        start_sec (Double)
        end_sec (Double)

    Returns:
        std::vector<UInt8> 

";
%feature("docstring") T0TreatToolsBase::putVectorT0Clock "std::vector< Double > T0TreatToolsBase::putVectorT0Clock() T0TreatToolsBase::putVectorT0Clock Put T0 clock.
============================================================================================================
    Put all T0 clocks as std::vector

    Returns:
        std::vector<double> 

";
%feature("docstring") T0TreatToolsBase::makeVectorBySec "void T0TreatToolsBase::makeVectorBySec(Double start_sec, Double end_sec, bool getT0Index=true) T0TreatToolsBase::makeVectorBySec

";
%feature("docstring") T0TreatToolsBase::putT0IndexByPid "std::vector< UInt8 > T0TreatToolsBase::putT0IndexByPid(UInt8 start_pid, UInt8 end_pid) T0TreatToolsBase::putT0IndexByPid Put required region of T0 index.
==========================================================================================================================================================
    Put start and end index of T0 by given Pulse-IDs.

    Args:
        start_pid pulse id at beggining in required region
        end_pid pulse id at last in reaquired region

    Returns:
        std::vector<UInt4> std::vector size is 2. 

";
%feature("docstring") T0TreatToolsBase::putT0IndexByClock "std::vector< UInt8 > T0TreatToolsBase::putT0IndexByClock(Double start_clock, Double end_clock) T0TreatToolsBase::putT0IndexByClock Put required region of T0 index.
====================================================================================================================================================================
    Put start and end index of T0 by given Clocks.

    Args:
        start_clock clock at beggining in required region
        end_clock clock at last in reaquired region

    Returns:
        std::vector<UInt4> std::vector size is 2. 

";
%feature("docstring") T0TreatToolsBase::putT0ClockRegion "std::vector< Double > T0TreatToolsBase::putT0ClockRegion() T0TreatToolsBase::putT0ClockRegion Put the region of clock number of T0.
====================================================================================================================================
    Put two clock numbers for top and last index of T0

    Returns:
        std::vector<double> std::vector size is 2. 

";
%feature("docstring") T0TreatToolsBase::putPidRegion "std::vector< UInt8 > T0TreatToolsBase::putPidRegion() T0TreatToolsBase::putPidRegion Put region of of PID.
===========================================================================================================
    Put first PID and last PID of T0

    Returns:
        std::vector<UInt4> std::vector size is 2. 

";
%feature("docstring") T0TreatToolsBase::putT0ClockDiffAll "std::vector< Double > T0TreatToolsBase::putT0ClockDiffAll() T0TreatToolsBase::putT0ClockDiffAll

";
%feature("docstring") T0TreatToolsBase::putT0ClockDiff "std::vector< Double > T0TreatToolsBase::putT0ClockDiff() T0TreatToolsBase::putT0ClockDiff Put differences of clocks.
=====================================================================================================================
    putT0ClockDiffAll : all differences putT0ClockDiff : sliced list of differences

    Returns:
        std::vector<Double> 

";
%feature("docstring") T0TreatToolsBase::decodeT0ClockEvent "void T0TreatToolsBase::decodeT0ClockEvent(UChar eventClock[], Double *clock) T0TreatToolsBase::decodeT0ClockEvent decode Inst clock event
==========================================================================================================================================

    Args:
        eventClock (UChar) given Inst Clock event
        clock (Double*)

    Returns:
        None 

";
%feature("docstring") T0TreatToolsBase::CheckReliable "bool T0TreatToolsBase::CheckReliable() T0TreatToolsBase::CheckReliable

";
%feature("docstring") T0TreatToolsBase::convertInstClockToDateTime "std::vector< Double > T0TreatToolsBase::convertInstClockToDateTime(Double inst_clock) T0TreatToolsBase::convertInstClockToDateTime convert Instrument Clock (UTC) to Date Time (JST)
=====================================================================================================================================================================================

    Args:
        inst_clock (Double) instrument clock decoded from Instrument clock event [sec]

    Returns:
        std::vector<Double> std::vector of year,month,day,hour,minute,second,sub-second 

";
%feature("docstring") T0TreatToolsBase::convertDateTimeToInstClock "Double T0TreatToolsBase::convertDateTimeToInstClock(std::vector< Double > date_time) T0TreatToolsBase::convertDateTimeToInstClock convert Date Time (JST) to Instrument Clock which its origin is 2008/1/1 00:00:00 ( MLF origin Date Time)
============================================================================================================================================================================================================================================

    Args:
        std::vector<Double> std::vector of year,month,day,hour,minute,second,sub-second

    Returns:
        (Double) instrument clock decoded from Instrument clock event 

";
%feature("docstring") T0TreatToolsBase::putMeasPeriodFromT0 "std::vector< Double > T0TreatToolsBase::putMeasPeriodFromT0() T0TreatToolsBase::putMeasPeriodFromT0 put measuring period from instrument clock event
=====================================================================================================================================================
    This returns std::vector with 12 params. If conversion is failed, size of returned vector is one.

    Args:
        None

    Returns:
        std::vector<Double> std::vector with 12 params for begin time and end time (year,month,day,hour,minute,second,sub-second) x 2 

";
%feature("docstring") T0TreatToolsBase::clearMeasPeriod "void T0TreatToolsBase::clearMeasPeriod() T0TreatToolsBase::clearMeasPeriod clear stored measuring period
=========================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") T0TreatToolsBase::SetBytesOfOrgEvent "void T0TreatToolsBase::SetBytesOfOrgEvent(UInt4 bytes_of_org_event) T0TreatToolsBase::SetBytesOfOrgEvent

";
%feature("docstring") T0TreatToolsBase::setNumOfClocksBeforeFirstT0 "void T0TreatToolsBase::setNumOfClocksBeforeFirstT0(UInt4 num_of_clocks) T0TreatToolsBase::setNumOfClocksBeforeFirstT0

";
%feature("docstring") T0TreatToolsBase::putSlicedT0IndexEvent "std::vector< UInt8 > T0TreatToolsBase::putSlicedT0IndexEvent(UInt8 start_posi, std::string path_to_file, UInt8 *count_to_last) T0TreatToolsBase::putSlicedT0IndexEvent

";
%feature("docstring") T0TreatToolsBase::putSlicedT0IndexEventPy "std::vector< UInt8 > T0TreatToolsBase::putSlicedT0IndexEventPy(UInt8 start_posi, std::string path_to_file) T0TreatToolsBase::putSlicedT0IndexEventPy Put required region of T0 index from T0Index Event file.
==============================================================================================================================================================================================================
    T0Index will be picked up from start_posi to count_to_last.

    Args:
        start_posi T0Index events before start_posi are skipped.
        path_to_file path to event data file
        count_to_last the number of events from start_poti to last. Set 0 when read all events after start_posi.

    Returns:
        std::vector<UInt4> 

";
%feature("docstring") T0TreatToolsBase::putSlicedT0EventInfo "bool T0TreatToolsBase::putSlicedT0EventInfo(UInt8 start_posi, std::vector< std::string > filenames, std::vector< UInt8 > &retCountToLast, std::vector< UInt8 > &retT0Index, std::vector< UInt8 > &retPulseId, std::vector< Double > &retDiffClock, UInt8 lastPulseId=0) T0TreatToolsBase::putSlicedT0EventInfo

";
%feature("docstring") T0TreatToolsBase::putSlicedT0EventInfoPy1 "std::vector< UInt8 > T0TreatToolsBase::putSlicedT0EventInfoPy1(UInt8 start_posi, std::vector< std::string > filenames) T0TreatToolsBase::putSlicedT0EventInfoPy1

";
%feature("docstring") T0TreatToolsBase::putSlicedT0EventInfoPy2 "std::vector< UInt8 > T0TreatToolsBase::putSlicedT0EventInfoPy2(UInt8 start_posi, std::vector< std::string > filenames, UInt8 start_pid=0) T0TreatToolsBase::putSlicedT0EventInfoPy2

";
%feature("docstring") T0TreatToolsBase::putT0SecVector "std::vector< Double > T0TreatToolsBase::putT0SecVector() T0TreatToolsBase::putT0SecVector

";
%feature("docstring") T0TreatToolsBase::dumpMeasPeriodClock "void T0TreatToolsBase::dumpMeasPeriodClock() T0TreatToolsBase::dumpMeasPeriodClock

";
%feature("docstring") T0TreatToolsBase::PutT0Index "std::vector< UInt8 > T0TreatToolsBase::PutT0Index() T0TreatToolsBase::PutT0Index Put T0 Index.
===============================================================================================
    Put T0 Index std::vector. If time slicing is set using by SetRangeOfSingleTimeSlicing return sliced T0 Index std::vector

    Returns:
        std::vector<UInt4> 

";
%feature("docstring") T0TreatToolsBase::PutPulseId "std::vector< UInt8 > T0TreatToolsBase::PutPulseId() T0TreatToolsBase::PutPulseId Put Pulse ID list.
====================================================================================================
    Put Pulse ID std::vector. If time slicing is set using by SetRangeOfSingleTimeSlicing return sliced Pulse ID std::vector

    Returns:
        std::vector<UInt8> 

";
%feature("docstring") T0TreatToolsBase::PutT0ClockDiff "std::vector< Double > T0TreatToolsBase::PutT0ClockDiff() T0TreatToolsBase::PutT0ClockDiff Put differences of instrument clocks.
================================================================================================================================
    If time slicing is set using by SetRangeOfSingleTimeSlicing return sliced clock std::vector

    Returns:
        std::vector<Double> 

";
%feature("docstring") T0TreatToolsBase::PutT0Clock "std::vector< Double > T0TreatToolsBase::PutT0Clock() T0TreatToolsBase::PutT0Clock Put instrument clocks.
=========================================================================================================
    If time slicing is set using by SetRangeOfSingleTimeSlicing return sliced clock std::vector

    Returns:
        std::vector<Double> 

";
%feature("docstring") T0TreatToolsBase::SetRangeOfSingleTimeSlicing "bool T0TreatToolsBase::SetRangeOfSingleTimeSlicing(double startSec, double endSec) T0TreatToolsBase::SetRangeOfSingleTimeSlicing Sets time range for time slice of event data.
===============================================================================================================================================================================
    Values for time are indicated the passed time [sec] from head of event data

    Args:
        startSec start time [sec]
        endSec end time [sec]

    Returns:
        None 

    
bool T0TreatToolsBase::SetRangeOfSingleTimeSlicing(std::string startDate, std::string endDate) T0TreatToolsBase::SetRangeOfSingleTimeSlicing Sets time range for time slice of event data.
===========================================================================================================================================================================================
    Values for time are indicated the passed time [sec] from head of event data std::string format : \"YYYY,MM,DD,hh,mm,ss,s.ss\", \"2011,1,22,13,54,22,0.54\"

    Args:
        startDate start date std::string
        endDate end date std::string

    Returns:
        None 
";
%feature("docstring") T0TreatToolsBase::SetExternalClockInfo "void T0TreatToolsBase::SetExternalClockInfo(std::vector< Double > _t0Time, bool _isReliable=true) T0TreatToolsBase::SetExternalClockInfo

";
%feature("docstring") T0TreatToolsBase::ClearExternalClockInfo "void T0TreatToolsBase::ClearExternalClockInfo() T0TreatToolsBase::ClearExternalClockInfo

";
%feature("docstring") T0TreatToolsBase::PutSlicedOrgEventBySec "bool T0TreatToolsBase::PutSlicedOrgEventBySec(std::vector< std::string > orgfiles, double start_sec, double end_sec, std::string outfile, std::vector< double > extTime) T0TreatToolsBase::PutSlicedOrgEventBySec

";
%feature("docstring") T0TreatToolsBase::PutSlicedOrgEventByKicker "bool T0TreatToolsBase::PutSlicedOrgEventByKicker(std::vector< std::string > orgfiles, UInt4 start_kick, UInt4 end_kick, std::string outfile) T0TreatToolsBase::PutSlicedOrgEventByKicker

";
%feature("docstring") T0TreatToolsBase::DecodePidClockEvent "void T0TreatToolsBase::DecodePidClockEvent(UChar eventPid[], UChar eventClock[], UInt8 *pid, Double *clock) T0TreatToolsBase::DecodePidClockEvent

";
%feature("docstring") T0TreatToolsBase::EncodePidClockEvent "void T0TreatToolsBase::EncodePidClockEvent(UChar eventPid[], UChar eventClock[], UInt8 pid, Double clock) T0TreatToolsBase::EncodePidClockEvent

";
%feature("docstring") T0TreatToolsBase::DumpInfo "void T0TreatToolsBase::DumpInfo(std::string filepath=\"\") T0TreatToolsBase::DumpInfo

    
void T0TreatToolsBase::DumpInfo(std::vector< std::string > filepaths) T0TreatToolsBase::DumpInfo Shows the information included in MLF event data file.
========================================================================================================================================================
    Information about : Measurement period
    The result of check the lack of t0 events (by the increment of T0 ID)

    Args:
        filepath target event data file, if empty, use the loaded event data.

    Returns:
        None 
";
%feature("docstring") T0TreatToolsBase::CheckSequencePulseId "bool T0TreatToolsBase::CheckSequencePulseId(std::string filepath=\"\") T0TreatToolsBase::CheckSequencePulseId Check the sequence of pulse id in given edb/t0b file.
====================================================================================================================================================================

    Args:
        filepath target event data file or t0b file, if empty, use the loaded event/t0b data.

    Returns:
        bool 

";
%feature("docstring") T0TreatToolsBase::CheckSequencePulseId2 "bool T0TreatToolsBase::CheckSequencePulseId2(std::string filepath, std::vector< UInt4 > *ret_pid, std::vector< double > *ret_clock) T0TreatToolsBase::CheckSequencePulseId2 Check the sequence of pulse id in given edb/t0b file and return sequence of pid and clock.
=======================================================================================================================================================================================================================================================================

    Args:
        filepath target event data file or t0b file, if empty, use the loaded event/t0b data.
        ret_pid sequence of pids
        ret_clock sequence of clocks

    Returns:
        bool 

";
