/*
$Id: ContainerViewer.hh 2383 2012-04-27 01:11:45Z jisuzuki $
 */

#ifndef CONTAINERVIEWER
#define CONTAINERVIEWER


#include "Header.hh"
#include "GnuplotInterface.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "StringTools.hh"
#include "WriteTextFile.hh"


class ContainerViewer : public GnuplotInterface
{
private:
  void mplot();
  void splot();
  StringTools *st;
public:
  ContainerViewer( std::string Command="gnuplot" );
 ~ContainerViewer();

  void MapPlot( ElementContainerMatrix M, std::string key );
  void MapPlot( ElementContainerMatrix M, std::string key, UInt4 tof );

  void SurfacePlot( ElementContainerMatrix M, std::string key );
  void SurfacePlot( ElementContainerMatrix M, std::string key, UInt4 tof );

  void SetGrayColor();

  void Histogram( ElementContainer ec );
  void WriteGnuPlotData( ElementContainer ec, std::string FileName );

};

#endif

