#include "Header.hh"

#ifndef BINDATAFILESECTIONREADER
#define BINDATAFILESECTIONREADER

class BinDataFileSectionReader
{

private:

FILE *fp;
size_t ElementSize;
void SetPosition( Int8 FromBegin );

public:

BinDataFileSectionReader( std::string TargetFileName, size_t ElementSize );
// constructor. The first and second arguments are the name of targeted
// binary-file and its data-size of the elements in the file.

Int4 Read( Int8 FromBegin, Int8 SizeOfData, void *buf );
// The binary-data file specified by the first argument of the constructor
// is read. The start point of the reading is set with the first argument
// which is the number of the elements not "bytes".
// The second argument is the number of elements read in this method.
// If the values of first and second arguments are wrong,
// you will receive error messages.
// The data-object pointed by the third argument is not created
// and deleted in this method.

~BinDataFileSectionReader();
// destoractor. The targeted file is closed in this method.

};

#endif
