#ifndef ACQUIRENEUTRONSOURCETEXTINFORMATION
#define ACQUIRENEUTRONSOURCETEXTINFORMATION

#define HOST_NAME    "www-cont.j-parc.jp"
//#define HOST_PROTCOL http
//#define HOST_PORT    80
//#define USER_AGENT   "target Information API/1.00"

/* cgi path of signal keys */
#define H2_ENTRANCE_PATH       "/MLF/cgi/H2TempRead.pl"
#define H2_COUPLED_PATH        "/MLF/cgi/H2TempRead.pl"
#define H2_DECOUPLED_PATH      "/MLF/cgi/H2TempRead.pl"
#define H2_POISON_PATH         "/MLF/cgi/H2TempRead.pl"
//#define CT_MUON_TARGET_PATH    "/MLF/cgi/CTdataRead6.2.pl"
//#define CT_NEUTRON_TARGET_PATH "/MLF/cgi/CTdataRead6.2.pl"
#define CT_NEUTRON_TARGET_PATH "/MLF/cgi/CTdataRead6.6cp.pl"
#define BEAM_STOP_START_PATH   "/MLF/cgi/CTdataRead8.2.pl"
// Changed by Inamura 2021.01.15
//#define CT_NEUTRON_CORRECTED_PATH "/MLF/cgi/CTdataRead6.5cp.pl"
#define CT_NEUTRON_CORRECTED_PATH "/MLF/cgi/CTdataRead6.6cp.pl"
// Changed by Inamura 2023.06.26 for "CT8"
#define CT_MUON_TARGET_PATH    "/MLF/cgi/CTdataRead6.6cp.pl"

/* time step key word*/
#define TIME_KEY_SHOT     "shot"
#define TIME_KEY_SECOND     "second"
#define TIME_KEY_10SECOND "10second"
#define TIME_KEY_MIN      "min"
#define TIME_KEY_HOUR     "hour"
#define TIME_KEY_DAY      "day"
#define TIME_KEY_MONTH    "month"
#define TIME_KEY_SUM      "sum"
#define TIME_KEY_01MIN    "1Min"
#define TIME_KEY_05MIN    "5Min"
#define TIME_KEY_10MIN    "10Min"
#define TIME_KEY_15MIN    "15Min"
#define TIME_KEY_30MIN    "30Min"
#define TIME_KEY_60MIN    "60Min"

/* time at second */
#define TIME_01          1
#define TIME_05          5
#define TIME_10         10
#define TIME_15         15
#define TIME_30         30
#define TIME_60         60
#define TIME_HOUR     3600
#define TIME_DAY     86400
#define TIME_MONTH 2592000

#define ERR_VAL   -1.0e+0    /* Error return value */

//#include <iostream>                                    /* for cout */
//#include <sstream>                                     /* for ostringstream */
//#include <fstream>                                     /* for ofstream */
//#include <iomanip>                                     /* manipulator */
#include <map>                                         /* maultimap */
#include "AcquireNeutronSourceInformationControlBase.hh"
//////////////////////////////////////////////////
class AcquireNeutronSourceTextInformation
  : public AcquireNeutronSourceInformationControlBase
{
private:
    std::ostringstream format1;  /* POST command */
    std::ostringstream format2;  /* host command */
    std::ostringstream format3;  /* content-length */
    std::ostringstream format4;  /* data */
    std::string request;         /* send request message */

    //time_t StartDateTime;        /* Start day and time */

    Bool   DebugFlag;                /* Debug mode OFF = false or 0; ON = true or non zero */
//  UInt2  Port;                     /* The port number to connect */

    std::string lastDataDate;             /* latest date and time with data. */

protected:
    std::vector<std::string> DateAtBin;                 /* List of date at bin span */
    std::vector<std::string> TimeAtBin;                 /* List of time at bin span */
    std::vector<Double> InfomationValue;           /* List of information value */

    std::vector< std::pair<std::string,std::string> > BeamOffOn;  /* List of beam off or on status */
    std::vector<UInt4> ShotsCounts;                /* [inamura 181209] the number of shot tags and counts [std::min(tag),max(tag),counts] */

public:
    AcquireNeutronSourceTextInformation();
        //!< Constructor
        /*!<
         */
    AcquireNeutronSourceTextInformation( std::string host_name, Bool debug_flag = false );
        //!< Constructor
        /*!<
         *   @param host_name    The server name which is the information Web page of neutron source.
         *   @param debug_flag   The flag to show some parameters under running.
         *                       ( OFF:false/0, ON:true/1 )
         */
    AcquireNeutronSourceTextInformation( Bool debug_flag );
        //!< Constructor
        /*!<
         *   @param debug_flag   The flag to show some parameters under running.
         *                       ( OFF:false/0, ON:true/1 )
         */
    virtual ~AcquireNeutronSourceTextInformation();
        //!< Destructor
        /*!<
         */

    std::string PutCgiPath( const std::string Key );
    std::string PutStepKey( const std::string Key, const Int4 StepTime );
    Int4 SetRequestMessage( const std::string Key, const std::string Start, const std::string End, const std::string StepKey );

    UInt4 SplitValueData(const std::string& body_data, std::string& info_data);
    //UInt4 SplitValueData(const std::string date, const std::string& body_data, std::string& info_data);
    UInt4 SplitBeamOffData(const std::string& body_data, std::string& info_data);
    void ReplaceStr( std::string& str, const std::string& from, const std::string& to );
    std::vector<Double> PutValueData( const std::string Key, const std::string Start, const std::string StepKey, const Int4 bin_step, const std::string data );

    Double PutValueInformation( const std::string Key );
    Double PutValueInformation( const std::string Key, const std::string Start );
    std::vector<Double> PutValueInformation( const std::string Key, const std::string Start, const std::string End, const Int4 StepTime = 0 );
    std::vector<std::string> PutDateBinInformation();
    std::vector<std::string> PutTimeBinInformation();

    void GetTextInformation( const std::string Key );
    void GetTextInformation( const std::string Key, const std::string Start );
    void GetTextInformation( const std::string Key, const std::string Start, const std::string End, const Int4 StepTime=TIME_10 );
    std::vector<std::string> PutTextFirstInformation();
    std::vector<std::string> PutTextSecondInformation();
    //std::vector< std::pair<std::string,std::string> > PutTextInformation( const std::string Key );
    //std::vector< std::pair<std::string,std::string> > PutTextInformation( const std::string Key, const std::string Start );
    //std::vector< std::pair<std::string,std::string> > PutTextInformation( const std::string Key, const std::string Start, const std::string End, const Int4 StepTime=TIME_10 );

    //std::vector<Double> ConvertProtonToCurrent(std::vector<Double> proton);
    //std::vector<Double> ConvertProtonToBeampower(std::vector<Double> proton);
    std::vector<Double> ConvertProtonToCurrent(std::vector<Double> proton, const Int4 bin);
    std::vector<Double> ConvertCurrentToBeampower(std::vector<Double> Current);
    std::vector<UInt4> PutShotsCounts(){ return ShotsCounts; } //[inamura 181209]
};

#endif
