#include "AcquireNeutronSourceTextInformation.hh"
//////////////////////////////////////////////////////////////////////
AcquireNeutronSourceTextInformation::
AcquireNeutronSourceTextInformation()
:AcquireNeutronSourceInformationControlBase(){
    std::string hostname=MlfEnvGetProtonServerHostName();
    if (hostname.empty())
        SetHostName( HOST_NAME );
    else
        SetHostName( hostname );
    //DateAtBin = new std::vector<std::string>();
    //TimeAtBin = new std::vector<std::string>();
    //InfomationValue = new std::vector<Double>();

    //BeamOffOn = new std::vector< std::pair<std::string,std::string> >();

    DebugFlag = false;
    ShotsCounts.clear();
    ShotsCounts.resize(3,0); /* [inamura 181209] the number of shot tags and counts [std::min(tag),max(tag),counts] */
    if ( DebugFlag ){
        std::cout << std::endl;
        std::cout << "TextInformation()" << std::endl;
        std::cout << "host_name : " << "(HOST_NAME)" << std::endl;
        std::cout << "DebugFlag : " << DebugFlag << std::endl;
    }
}
//////////////////////////////////////////////////////
AcquireNeutronSourceTextInformation::
AcquireNeutronSourceTextInformation( std::string host_name, Bool debug_flag )
:AcquireNeutronSourceInformationControlBase( host_name ){
    //DateAtBin = new std::vector<std::string>();
    //TimeAtBin = new std::vector<std::string>();
    //InfomationValue = new std::vector<Double>();

    //BeamOffOn = new std::vector< std::pair<std::string,std::string> >();

    DebugFlag = debug_flag;
    ShotsCounts.clear();
    ShotsCounts.resize(3,0); /* [inamura 181209] the number of shot tags and counts [std::min(tag),max(tag),counts] */
    if ( DebugFlag ){
        std::cout << std::endl;
        std::cout << "TextInformation(host_name)" << std::endl;
        std::cout << "host_name : " << host_name << std::endl;
        std::cout << "DebugFlag : " << DebugFlag << std::endl;
    }
}
//////////////////////////////////////////////////////
AcquireNeutronSourceTextInformation::
AcquireNeutronSourceTextInformation( Bool debug_flag )
:AcquireNeutronSourceInformationControlBase( HOST_NAME ){
    //DateAtBin = new std::vector<std::string>();
    //TimeAtBin = new std::vector<std::string>();
    //InfomationValue = new std::vector<Double>();

    //BeamOffOn = new std::vector< std::pair<std::string,std::string> >();

    DebugFlag = debug_flag;
    ShotsCounts.clear();
    ShotsCounts.resize(3,0); /* [inamura 181209] the number of shot tags and counts [std::min(tag),max(tag),counts] */
    if ( DebugFlag ){
        std::cout << std::endl;
        std::cout << "TextInformation()" << std::endl;
        std::cout << "host_name : " << "(HOST_NAME)" << std::endl;
        std::cout << "DebugFlag : " << DebugFlag << std::endl;
    }
}
//////////////////////////////////////////////////////////////////////
AcquireNeutronSourceTextInformation::
~AcquireNeutronSourceTextInformation(){
    //delete DateAtBin;
    //delete TimeAtBin;
    //delete InfomationValue;

    //delete BeamOffOn;
}
//////////////////////////////////////////////////////////////////////
std::string AcquireNeutronSourceTextInformation::
PutCgiPath( const std::string Key ){

    std::string CgiName;

    if ( Key == H2_ENTRANCE ){             /* Moderator temperature (in)*/
        CgiName = H2_ENTRANCE_PATH;
    }
    else if ( Key == H2_COUPLED ){         /* Moderator temperature (Coupled)*/
        CgiName = H2_COUPLED_PATH;
    }
    else if ( Key == H2_DECOUPLED ){       /* Moderator temperature (Decoupled)*/
        CgiName = H2_DECOUPLED_PATH;
    }
    else if ( Key == H2_POISON ){          /* Moderator temperature (Poisoned)*/
        CgiName = H2_POISON_PATH;
    }
    else if ( Key == CT_MUON_TARGET ){     /* Number of incident protons (In front of the muon target) */
        CgiName = CT_MUON_TARGET_PATH;
    }
    else if ( Key == CT_NEUTRON_TARGET ){  /* Number of incident protons (In front of the neutron target)*/
        CgiName = CT_NEUTRON_TARGET_PATH;
    }
    else if ( Key == CT_NEUTRON_CORRECTED_TARGET ){  /* Number of incident protons (In front of the neutron target)*/
        CgiName = CT_NEUTRON_CORRECTED_PATH;
    }
    else if ( Key == BEAM_STOP_START ){    /* Beam stop */
        CgiName = BEAM_STOP_START_PATH;
    }
    else {                                 /* error key word */
        CgiName = "";
        std::cout << Key << " is an invalid keyword!" << std::endl;
    }
    return CgiName;
}
//////////////////////////////////////////////////////////////////////
std::string AcquireNeutronSourceTextInformation::
PutStepKey( const std::string Key, const Int4 StepTime ){

    std::string StepKey;

    if ( Key == H2_ENTRANCE  ||  /* Moderator temperature (in)*/
         Key == H2_COUPLED   ||  /* Moderator temperature (Coupled)*/
         Key == H2_DECOUPLED ||  /* Moderator temperature (Decoupled)*/
         Key == H2_POISON    ){  /* Moderator temperature (Poisoned)*/
        StepKey = " ";
    }
    else if ( Key == CT_MUON_TARGET    ||
              Key == CT_NEUTRON_TARGET ||
              Key == CT_NEUTRON_CORRECTED_TARGET ){  /* Number of incident protons */
        if ( StepTime < 0 ){
            StepKey = TIME_KEY_SUM;
        }
        else if ( StepTime == 0 ){    /* cgi default value */
            StepKey = TIME_KEY_SHOT;
        }
        else if ( StepTime > TIME_DAY ){
            StepKey = TIME_KEY_MONTH;
        }
        else if ( (StepTime % TIME_DAY) == 0 ){
            StepKey = TIME_KEY_DAY;
        }
        else if ( (StepTime % TIME_HOUR) == 0 ){
            StepKey = TIME_KEY_HOUR;
        }
        else if ( (StepTime % TIME_60) == 0 ){
            StepKey = TIME_KEY_MIN;
        }
        else if ( (StepTime % TIME_10) == 0 ){
            StepKey = TIME_KEY_10SECOND;
        }
        else {
            StepKey = TIME_KEY_SECOND;
        }
    }
    else if ( Key == BEAM_STOP_START ){  /* Beam stop */
        if ( StepTime < TIME_01 ){
            StepKey = TIME_KEY_SECOND;
        }
        else if ( StepTime == TIME_60 ){
            StepKey = TIME_KEY_60MIN;
        }
        else if ( StepTime == TIME_30 ){
            StepKey = TIME_KEY_30MIN;
        }
        else if ( StepTime == TIME_15 ){
            StepKey = TIME_KEY_15MIN;
        }
        else if ( StepTime == TIME_10 ){   /* cgi default value */
            StepKey = TIME_KEY_10MIN;
        }
        else if ( StepTime == TIME_05 ){
            StepKey = TIME_KEY_05MIN;
        }
        else if ( StepTime == TIME_01 ){
            StepKey = TIME_KEY_01MIN;
        }
        else {
            StepKey = TIME_KEY_SECOND;
        }
    }
    else {                      /* error key word */
        StepKey.erase();
        std::cout << Key << " is an invalid keyword!" << std::endl;
    }

    return StepKey;
}
//////////////////////////////////////////////////////////////////////
Int4 AcquireNeutronSourceTextInformation::
SetRequestMessage( const std::string Key, const std::string Start, const std::string End, const std::string StepKey ){

    Int4 ret = 0;

    if ( Key == H2_ENTRANCE ){          /* Moderator temperature (in)*/
        format4 << "name01=date%2ctag%2c" << H2ENTRANCE << "&date01=" << Start << "&date02=" << End;
    }
    else if ( Key == H2_COUPLED ){      /* Moderator temperature (Coupled)*/
        format4 << "name01=date%2ctag%2c" << H2COUPLED << "&date01=" << Start << "&date02=" << End;
    }
    else if ( Key == H2_DECOUPLED ){    /* Moderator temperature (Decoupled)*/
        format4 << "name01=date%2ctag%2c" << H2DECOUPLED << "&date01=" << Start << "&date02=" << End;
    }
    else if ( Key == H2_POISON ){       /* Moderator temperature (Poisoned)*/
        format4 << "name01=date%2ctag%2c" << H2POISON << "&date01=" << Start << "&date02=" << End;
    }
    else if ( Key == CT_MUON_TARGET  ){ /* Number of incident protons (In front of the muon target) */
        if ( StepKey == TIME_KEY_SHOT    ||
             StepKey == TIME_KEY_SECOND  ||
             StepKey == TIME_KEY_10SECOND||
             StepKey == TIME_KEY_MIN     ||
             StepKey == TIME_KEY_HOUR    ||
             StepKey == TIME_KEY_DAY     ||
             StepKey == TIME_KEY_MONTH   ||
             StepKey == TIME_KEY_SUM     ){
            //format4 << "datatype=" << StepKey << "&date01=" << Start << "&date02=" << End;
            format4 << "datatype=" << StepKey << "&date01=" << Start << "&date02=" << End << "&unit=tp&form=full";
        }
        else {
            ret = -1;
        }
    }
    else if ( Key == CT_NEUTRON_TARGET ){ /* Number of incident protons (In front of the neutron target)*/
        if ( StepKey == TIME_KEY_SHOT    ||
             StepKey == TIME_KEY_SECOND  ||
             StepKey == TIME_KEY_10SECOND||
             StepKey == TIME_KEY_MIN     ||
             StepKey == TIME_KEY_HOUR    ||
             StepKey == TIME_KEY_DAY     ||
             StepKey == TIME_KEY_MONTH   ||
             StepKey == TIME_KEY_SUM     ){
             //format4 << "datatype=" << StepKey << "&date01=" << Start << "&date02=" << End;
             format4 << "datatype=" << StepKey << "&date01=" << Start << "&date02=" << End << "&unit=tp&form=full";
        }
        else {
            ret = -1;
        }
    }
    else if ( Key == CT_NEUTRON_CORRECTED_TARGET ){ /* Number of incident protons (In front of the neutron target)*/
        if ( StepKey == TIME_KEY_SHOT    ||
             StepKey == TIME_KEY_SECOND  ||
             StepKey == TIME_KEY_10SECOND||
             StepKey == TIME_KEY_MIN     ||
             StepKey == TIME_KEY_HOUR    ||
             StepKey == TIME_KEY_DAY     ||
             StepKey == TIME_KEY_MONTH   ||
             StepKey == TIME_KEY_SUM     ){
            format4 << "datatype=" << StepKey << "&date01=" << Start << "&date02=" << End << "&unit=tp&form=full";
        }
        else {
            ret = -1;
        }
    }
    else if ( Key == BEAM_STOP_START ){  /* Beam stop */
        if ( StepKey == TIME_KEY_SECOND ||
             StepKey == TIME_KEY_01MIN  ||
             StepKey == TIME_KEY_05MIN  ||
             StepKey == TIME_KEY_10MIN  ||
             StepKey == TIME_KEY_15MIN  ||
             StepKey == TIME_KEY_30MIN  ||
             StepKey == TIME_KEY_60MIN  ){
            format4 << "datatype=" << StepKey << "&date01=" << Start << "&date02=" << End;
        }
        else {
            ret = -1;
        }
    }
    else {                      /* error key word */
        ret = -1;
    }

    if ( ret == 0 ) {
        std::string strform = format4.str();
        Int4 length = strform.length();
        strform += "\r\n";

        format1 << "POST " << FilePath << " HTTP/1.0\r\n";
        format2 << "Host: " << HostName << "\r\n";
        format3 << "Content-Length: " << length << "\r\n\r\n";

        request = format1.str() + format2.str() + format3.str() + format4.str();

        format1.str("");                      /* buffer clear */
        format2.str("");
        format3.str("");
        format4.str("");
        format1.clear(std::stringstream::goodbit); /* stream clear */
        format2.clear(std::stringstream::goodbit);
        format3.clear(std::stringstream::goodbit);
        format4.clear(std::stringstream::goodbit);
    }

    //if ( DebugFlag ) {
    //    std::cout << "SetRequestMessage >>>" << std::endl
    //         << request << std::endl
    //         << "<<<<<" << std::endl;
    //}

    return ret;
}
//////////////////////////////////////////////////////////////////////
UInt4 AcquireNeutronSourceTextInformation::
SplitValueData(const std::string& body_data, std::string& info_data) {
//SplitValueData(const std::string date, const std::string& body_data, std::string& info_data) {
    const std::string SEPARATE_KEYt( "<BR>date," );
    const std::string SEPARATE_KEYp( "protons]" );
    const std::string SEPARATE_KEY2( "<BR>\n" );
    UInt4 KEY_LENGTH;
    std::string::size_type start_pos;

    UInt4 ret = 0;
    //if ( DebugFlag ) {
        //std::cout << "body_data in SplitValueData" << std::endl;
        //std::cout << body_data << std::endl;
    //}
    /* find start position at data */
    start_pos = body_data.find( SEPARATE_KEYt );       /* H2in, H2cm, H2dm, H2pm */
    if ( start_pos == std::string::npos ){
        start_pos = body_data.find( SEPARATE_KEYp );   /* CT8, CT9 */
        if ( start_pos == std::string::npos ){
            ret = 0;
        }
        else {
            KEY_LENGTH = SEPARATE_KEYp.length();
        }
    }
    else {
        KEY_LENGTH = SEPARATE_KEYt.length();
    }

    if ( start_pos != std::string::npos ){
        start_pos = body_data.find( SEPARATE_KEY2, start_pos+KEY_LENGTH );
        if ( start_pos == std::string::npos ){
            ret = 0;
        }
        /* set information data */
        else {
            Int4 info_start_pos = start_pos + SEPARATE_KEY2.length();
            Int4 info_length    = body_data.length() - info_start_pos;
            info_data = body_data.substr( info_start_pos, info_length );
            ret = info_length;
        }
    }

    if ( DebugFlag ) {
        std::cout << "info_data in SplitValueData" << std::endl;
        std::cout << "info length " << ret << std::endl;
        std::cout << info_data << std::endl;
    }
    return ret;
}
//////////////////////////////////////////////////////////////////////
UInt4 AcquireNeutronSourceTextInformation::
SplitBeamOffData(const std::string& body_data, std::string& info_data) {
    const std::string SEPARATE_KEY( "<BR>\n<BR>" );
    std::string::size_type start_pos;
    UInt4 ret = 0;

    //if ( DebugFlag ) {
        //std::ofstream fout;
        //fout.open("BeamOffData.txt");
        //fout << body_data << std::endl;
        //fout.close();
        //std::cout << "body_data in SplitBeamOffData" << std::endl;
        //std::cout << body_data << std::endl;
    //}
    /* find start position at data */
    start_pos = body_data.find(SEPARATE_KEY);
    if ( start_pos == std::string::npos ){
        ret = 0;
    }
    /* set information data */
    else {
        Int4 info_start_pos = start_pos + SEPARATE_KEY.length();
        Int4 info_length    = body_data.length() - info_start_pos;
        info_data = body_data.substr( info_start_pos, info_length );
        ret = info_length;
    }

    if ( DebugFlag ) {
        std::cout << "info_data in SplitBeamOffData" << std::endl;
        std::cout << "info length " << ret << std::endl;
        std::cout << info_data << std::endl;
    }
    return ret;
}
//////////////////////////////////////////////////////////////////////
void AcquireNeutronSourceTextInformation::
ReplaceStr(std::string& str, const std::string& from, const std::string& to){
    std::string::size_type pos = 0;

    //if ( DebugFlag ) {
    //    std::cout << "ReplaceStr befor" << std::endl;
    //    std::cout << str << std::endl;
    //}
    while(pos = str.find(from,pos), pos != std::string::npos){
        str.replace(pos, from.length(), to);
        pos += to.length();
    }
    //if ( DebugFlag ) {
    //    std::cout << "ReplaceStr after" << std::endl;
    //    std::cout << str << std::endl;
    //}
}
//////////////////////////////////////////////////////////////////////
std::vector<Double> AcquireNeutronSourceTextInformation::
PutValueData( const std::string Key, const std::string Start, const std::string StepKey, const Int4 bin_step, const std::string data ){

    const std::string BR_TAG ( "<BR>" );
    const std::string COMMA  ( "," );
    const std::string CR ( "\n" );
    //const Double ERR_VAL = -1.0e+0;    /* Error value */
    //Double Unit = 1.0e+12;             /* The number unit of protons in cgi data */

    typedef std::multimap<UInt4,Double> type_MMap;
    type_MMap mt_data;
    type_MMap::iterator it;
    //std::pair<type_MMap::iterator,type_MMap::iterator> pit;
    type_MMap::reverse_iterator rit;

    //std::vector<std::string> DateAtBin;       /* return value */
    //std::vector<std::string> TimeAtBin;       /* return value */
    //std::vector<Double> InfomationValue; /* return value */
    //std::vector<Double> ret;             /* return value (local variable) */

    Int4 index_pos = 0;               /* index for mt_data table */
    UInt4 tag_number;
    Double dataA;
    UInt4 dataCount;

    time_t    timeNow;
    struct tm   tmNow;
    struct tm *ptmNow;
    std::string::size_type s_pos, e_pos, line;
    std::string date;

    time_t  timeStart;
    struct tm tmStart;

    StringTools *st = new StringTools();

    DateAtBin.clear();
    TimeAtBin.clear();
    InfomationValue.clear();
    lastDataDate = std::string( "                   " );
/*=================*/
/*  set start date */
/*=================*/
    if ( (StringTimeToStructTime(Start, "/", &tmStart)) < 0 ){
        std::cout << "Start date and time error!" << std::endl;
        DateAtBin.push_back( std::string("          ") );
        TimeAtBin.push_back( std::string("        ") );
        InfomationValue.push_back( ERR_VAL );
        return InfomationValue;
    }
    timeStart = mktime(&tmStart);
/**************************/
/*  makeing mt_data table */
/**************************/
    Double bin_width = 0.0e0;  /* seconds */
    if ( Key == H2_ENTRANCE  ||
         Key == H2_COUPLED   ||
         Key == H2_DECOUPLED ||
         Key == H2_POISON    ){      /* Moderator temperature */
        if ( bin_step < TIME_10 ) {
            bin_width = 10.000;
        }
        else if ( bin_step > TIME_DAY ){   /* step by month */
            bin_width = (Double)TIME_MONTH;
        }
        else {
            bin_width = (Double)bin_step;
        }
    }
    else if ( Key == CT_MUON_TARGET    ||
              Key == CT_NEUTRON_TARGET ||
              Key == CT_NEUTRON_CORRECTED_TARGET ){ /* Number of incident protons */
        if ( bin_step < TIME_01 ) {
            bin_width = 1.000;
        }
        else if ( bin_step > TIME_DAY ){   /* step by month */
            bin_width = (Double)TIME_MONTH;
        }
        else {
            bin_width = (Double)bin_step;
        }
    }

    s_pos = 0;
    while ( s_pos < data.length() ){
        /* set line end position */
        line = data.find( BR_TAG, s_pos );
        if ( line == std::string::npos ){
            std::cout << "End of line was not found in PutValueData" << std::endl;
            index_pos = -1;
            break;
        }

        /*****************/
        /* date and time */
        /*****************/
        e_pos = data.find( COMMA, s_pos );
        if ( e_pos == std::string::npos ){
            std::cout << "date and time was not found in PutValueData" << std::endl;
            index_pos = -1;
            lastDataDate = std::string( "                   " );
            break;
        }
        else {
            /* H2in, H2cm, H2dm, H2pm, CT8(shot/second), CT9(shot/second) */
            date = data.substr(s_pos,e_pos-s_pos);
            if ( StringTimeToStructTime( date, "-", &tmNow ) < 0 ){
                std::cout << "failed in the conversion of the date and time in PutValueData" << std::endl;
                index_pos = -1;
                lastDataDate = std::string( "                   " );
                break;
            }
            else {
                s_pos = e_pos + 1;
                timeNow = mktime(&tmNow);     /* normalization of time */
                ptmNow  = localtime(&timeNow);
                lastDataDate = StructTimeToStringTime( ptmNow, "/" );   /* saved last date data */
            }
        }
        /* max(date) */
        if ( Key == CT_MUON_TARGET ||
             Key == CT_NEUTRON_TARGET ||
             Key == CT_NEUTRON_CORRECTED_TARGET ){
            if ( StepKey == TIME_KEY_10SECOND ||
                 StepKey == TIME_KEY_MIN      ||
                 StepKey == TIME_KEY_HOUR     ||
                 StepKey == TIME_KEY_DAY      ||
                 StepKey == TIME_KEY_MONTH    ||
                 StepKey == TIME_KEY_SUM      ){
                e_pos = data.find( COMMA, s_pos );
                if ( e_pos == std::string::npos ){
                    std::cout << "max(date) was not found in PutValueData" << std::endl;
                    index_pos = -1;
                    lastDataDate = std::string( "                   " );
                    break;
                }
                else {
                    /* CT8, CT9 (10second/min/hour/day/month/sum) */
                    date = data.substr(s_pos,e_pos-s_pos);
                    if ( StringTimeToStructTime( date, "-", &tmNow ) < 0 ){
                        std::cout << "failed in the conversion of the max(date) in PutValueData" << std::endl;
                        index_pos = -1;
                        lastDataDate = std::string( "                   " );
                        break;
                    }
                    else {
                        s_pos = e_pos + 1;
                        timeNow = mktime(&tmNow);     /* normalization of time */
                        ptmNow  = localtime(&timeNow);
                        lastDataDate = StructTimeToStringTime( ptmNow, "/" );   /* saved last date data */
                    }
                }
            }
        }

        /**************/
        /* tag number */
        /**************/
        e_pos = data.find( COMMA, s_pos );
        if ( e_pos == std::string::npos ){
            std::cout << "tag number was not found in PutValueData" << std::endl;
            index_pos = -1;
            break;
        }
        else {
            /* H2in, H2cm, H2dm, H2pm, CT8(shot/second), CT9(shot/second) */
            tag_number = st->StringToUInt4( data.substr(s_pos,e_pos-s_pos) );
            ShotsCounts[0] = tag_number;
            if ( DebugFlag )
                std::cout << "#[inamura 181209] std::min(tag) = "<<ShotsCounts[0]<<std::endl;
            s_pos = e_pos + 1;
        }
        /* max(tag) */
        if ( Key == CT_MUON_TARGET ||
             Key == CT_NEUTRON_TARGET ||
             Key == CT_NEUTRON_CORRECTED_TARGET ){
            if ( StepKey == TIME_KEY_10SECOND ||
                 StepKey == TIME_KEY_MIN      ||
                 StepKey == TIME_KEY_HOUR     ||
                 StepKey == TIME_KEY_DAY      ||
                 StepKey == TIME_KEY_MONTH    ||
                 StepKey == TIME_KEY_SUM      ){
                e_pos = data.find( COMMA, s_pos );
                if ( e_pos == std::string::npos ){
                    std::cout << "max(tag) was not found in PutValueData" << std::endl;
                    index_pos = -1;
                    break;
                }
                else {
                    /* CT8, CT9 (10second/min/hour/day/month/sum) */
                    tag_number = st->StringToUInt4( data.substr(s_pos,e_pos-s_pos) );
                    ShotsCounts[1]=tag_number;
                    if ( DebugFlag )
                        std::cout << "#[inamura 181209] max(tag) = "<<ShotsCounts[1]<<std::endl;
                    s_pos = e_pos + 1;
                }
            }
        }

        /***********************************/
        /* DATA is H2in/H2cm/H2dm/H2pm/CT8 */
        /***********************************/
        e_pos = data.find( COMMA, s_pos );
        if ( e_pos == std::string::npos ){
            std::cout << "Temperature or CT8 was not found in PutValueData" << std::endl;
            index_pos = -1;
            break;
        }
        else {
            dataA = st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
            s_pos = e_pos + 1;
        }

        /* DATA is CT9 */
        if ( Key == CT_NEUTRON_TARGET  ){ /* Number of incident protons */
            e_pos = data.find( COMMA, s_pos );
            if ( e_pos == std::string::npos ){
                std::cout << "CT9 was not found in PutValueData" << std::endl;
                index_pos = -1;
                break;
            }
            else {
                dataA = st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
                s_pos = e_pos + 1;
            }
        }

        /* DATA is CT8mt */
        if ( Key == CT_MUON_TARGET ||
             Key == CT_NEUTRON_TARGET ){
            if ( StepKey == TIME_KEY_SHOT ){
                e_pos = line;
                //dataA = st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
            }
            else if ( StepKey == TIME_KEY_SECOND   ||
                      StepKey == TIME_KEY_10SECOND ||
                      StepKey == TIME_KEY_MIN      ||
                      StepKey == TIME_KEY_HOUR     ||
                      StepKey == TIME_KEY_DAY      ||
                      StepKey == TIME_KEY_MONTH    ){
                e_pos = data.find( COMMA, s_pos );
                if ( e_pos == std::string::npos ){
                    std::cout << "CT8mt was not found in PutValueData" << std::endl;
                    index_pos = -1;
                    break;
                }
                else {
                    //dataA = st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
                    s_pos = e_pos + 1;
                    /* DATA is count */
                    e_pos = line;
                    dataCount = st->StringToUInt4( data.substr(s_pos,e_pos-s_pos) );
                }
            }
        }
        /* DATA is CT8neutron */
        if ( Key == CT_NEUTRON_CORRECTED_TARGET ){
            for (UInt4 ii=0; ii<3; ii++){
                e_pos = data.find( COMMA, s_pos );
                if (e_pos == std::string::npos ){
                    std::cout << "CT8neutron was not found "<<std::endl;
                    index_pos = -1;
                    break;
                }
                //[inamura 181209] Get counts
                if (ii==2){
                    ShotsCounts[2]=st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
                    if ( DebugFlag )
                        std::cout << "#[inamura 181209] Found count = "<< ShotsCounts[2] << std::endl;

                }
                s_pos = e_pos + 1;
            }
            if ( StepKey == TIME_KEY_SHOT ){
                e_pos = line;
                dataA = st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
            }
            else if ( StepKey == TIME_KEY_SECOND   ||
                      StepKey == TIME_KEY_10SECOND ||
                      StepKey == TIME_KEY_MIN      ||
                      StepKey == TIME_KEY_HOUR     ||
                      StepKey == TIME_KEY_DAY      ||
                      StepKey == TIME_KEY_MONTH    ){
                e_pos = data.find( COMMA, s_pos );
                if ( e_pos == std::string::npos ){
                    std::cout << "CT8neutron was not found in PutValueData" << std::endl;
                    index_pos = -1;
                    break;
                }
                else {
                    //dataA = st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
                    s_pos = e_pos + 1;
                    /* DATA is count */
                    e_pos = line;
                    dataCount = st->StringToUInt4( data.substr(s_pos,e_pos-s_pos) );
                }
            }else{
                e_pos = line;
                dataA=st->StringToDouble( data.substr(s_pos,e_pos-s_pos) );
            }
        }

        /* Next line data */
        s_pos = line + BR_TAG.length();
        while( data.substr(s_pos,1) == CR ){
            s_pos += CR.length();
        }

        /* bin address */
        if ( bin_step < 0 ){               /* step by sum */
            index_pos = 0;
        }
        else if ( bin_step > TIME_DAY ){   /* step by month */
            index_pos = (tmNow.tm_year*12+tmNow.tm_mon) - (tmStart.tm_year*12+tmStart.tm_mon);
            if ( index_pos < 0 ) {
                std::cout << "index value error! " << index_pos << std::endl;
                index_pos = -1;
                break;
            }
        }
        else if ( bin_step == TIME_DAY ){                    /* step by day */
            index_pos = (tmNow.tm_yday) - (tmStart.tm_yday); /* subtraction between the progress days from January 1 */
            if ( index_pos < 0 ) {
                std::cout << "index value error! " << index_pos << std::endl;
                index_pos = -1;
                break;
            }
        }
        else {
            timeNow = mktime(&tmNow);
            index_pos = (Int4)( difftime(timeNow,timeStart) / bin_width );
            if ( index_pos < 0 ) {
                std::cout << "index value error! " << index_pos << std::endl;
                index_pos = -1;
                break;
            }
        }
        mt_data.insert( std::make_pair( index_pos, dataA ) );

    } /* while loop end */

    if ( DebugFlag ){
        std::cout << std::endl;
        std::cout << "mt_data size : " << mt_data.size() << std::endl;
        it = mt_data.begin();
        while( it != mt_data.end() ){
            std::cout << "std::pair data =" << (*it).first << "," << (*it).second << std::endl;
            ++it;
        } /* while loop end */
    }

/*************************/
/*  makeing result table */
/*************************/
    if ( index_pos >= 0 ){
        /*==============================*/
        /*  makeing date and time table */
        /*==============================*/
        rit = mt_data.rbegin();
        Int4 dim_size = (*rit).first;                   /* max index value */
        //std::vector<Double> ret( dim_size+1, 0.0e+0 );  /* dimension size is dim_size+1, and all zero clear */
        for ( Int4 dim = 0; dim <= dim_size; ++dim ){
            /* step by month */
            if ( bin_step > TIME_DAY ){
                if ( dim == 0 ){
                    date = StructTimeToStringTime( &tmStart, "/" );
                }
                else {
                    tmNow.tm_year = tmStart.tm_year;
                    tmNow.tm_mon  = tmStart.tm_mon + dim;
                    tmNow.tm_mday = 1;
                    tmNow.tm_hour = 00;
                    tmNow.tm_min  = 00;
                    tmNow.tm_sec  = 00;
                    timeNow = mktime(&tmNow);     /* normalization of time */
                    ptmNow  = localtime(&timeNow);
                    date = StructTimeToStringTime( ptmNow, "/" );
                }
            }
            /* step by day */
            else if ( bin_step == TIME_DAY ){
                if ( dim == 0 ){
                    date = StructTimeToStringTime( &tmStart, "/" );
                }
                else {
                    tmNow.tm_year = tmStart.tm_year;
                    tmNow.tm_mon  = tmStart.tm_mon;
                    tmNow.tm_mday = tmStart.tm_mday + dim;
                    tmNow.tm_hour = 00;
                    tmNow.tm_min  = 00;
                    tmNow.tm_sec  = 00;
                    timeNow = mktime(&tmNow);     /* normalization of time */
                    ptmNow  = localtime(&timeNow);
                    date = StructTimeToStringTime( ptmNow, "/" );
                }
            }
            /* step by hour,min,sec ... */
            else {
                timeNow = timeStart + (Int4)bin_width * dim;
                ptmNow = localtime(&timeNow);
                date = StructTimeToStringTime( ptmNow, "/" );
            }

            DateAtBin.push_back( date.substr(0,10) );  /* date (ex. "2009/08/31") */
            TimeAtBin.push_back( date.substr(11,8) );  /* time (ex. "00:00:00") */
            InfomationValue.push_back( 0.0e+0 );       /* all zero clear */
        } /* for (dim) loop end */

        /*======================*/
        /*  makeing value table */
        /*======================*/
        it = mt_data.begin();
        if ( Key == H2_ENTRANCE  ||
             Key == H2_COUPLED   ||
             Key == H2_DECOUPLED ||
             Key == H2_POISON    ){ /* Moderator temperature */
            while( it != mt_data.end() ){
                index_pos = (*it).first;
                Int4 n = mt_data.count(index_pos);
                if ( n > 1 ){
                    //pit = mt_data.equal_range(index_pos);
                    for( Int4 t = 0; t < n; ++t, ++it ){
                        InfomationValue[index_pos] += (*it).second;
                    }
                    InfomationValue[index_pos] /= n;   /* average temperature */
                }
                else {
                    InfomationValue[index_pos] = (*it).second;
                    ++it;
                }
            } /* while loop end */
        }
        else if ( Key == CT_MUON_TARGET    ||
                  Key == CT_NEUTRON_TARGET ||
                  Key == CT_NEUTRON_CORRECTED_TARGET ){ /* Number of incident protons */
            while( it != mt_data.end() ){
                index_pos = (*it).first;
                Int4 n = mt_data.count(index_pos);
                if ( n > 1 ){
                    //pit = mt_data.equal_range(index_pos);
                    for( Int4 t = 0; t < n; ++t, ++it ){
                        InfomationValue[index_pos] += (*it).second;
                    }
                    //InfomationValue[index_pos] *= Unit;   /* total protons at bin */
                }
                else {
                    //InfomationValue[index_pos] = (*it).second * Unit;
                    InfomationValue[index_pos] = (*it).second;
                    ++it;
                }
            } /* while loop end */
        }

        if ( DebugFlag ) {
            Int4 vector_size = InfomationValue.size();
            std::cout << std::endl;
            std::cout << "PutValueData size : " << vector_size << std::endl;
            for ( Int4 i = 0; i < vector_size; ++i ){
                std::cout << DateAtBin[i] << "," << TimeAtBin[i] << "," << InfomationValue[i] << std::endl;
            }
        }

        return InfomationValue;
    }
    else {   /* index_pos < 0 */
        //std::vector<Double> ret( 1, ERR_VAL ); /* dimension size is 1, clear at error value data */
        DateAtBin.push_back( std::string("          ") );
        TimeAtBin.push_back( std::string("        ") );
        InfomationValue.push_back( ERR_VAL );
        return InfomationValue;
    }

}
//////////////////////////////////////////////////////////////////////
Double AcquireNeutronSourceTextInformation::
PutValueInformation( const std::string Key ){

    //const Double ERR_VAL = -1.0e+0;    /* Error value */

    std::vector<Double> ret;             /* return value (local variable)*/
    //std::vector<Double> InfomationValue; /* return value */
    std::string workDateBin, workTimeBin;
    Double workValue;

    time_t nowDateTime;
    struct tm *tmNow;
    std::string Start, End;
    Int4 StepTime;

    time(&nowDateTime);                /* get current time */
    tmNow = gmtime(&nowDateTime);      /* UTC */
    tmNow->tm_hour += 9;               /* UTC -> JST */
    nowDateTime = mktime(tmNow);       /* normalization of time */
    tmNow = localtime(&nowDateTime);

    End = StructTimeToStringTime( tmNow, "/" );

    if ( Key == H2_ENTRANCE  ||
         Key == H2_COUPLED   ||
         Key == H2_DECOUPLED ||
         Key == H2_POISON    ){ /* Moderator temperature */
        StepTime = 10;
        tmNow->tm_sec -= 11;
        nowDateTime = mktime(tmNow);       /* normalization of time */
        tmNow = localtime(&nowDateTime);
        Start = StructTimeToStringTime( tmNow, "/" );
    }
    else if ( Key == CT_MUON_TARGET    ||
              Key == CT_NEUTRON_TARGET ||
              Key == CT_NEUTRON_CORRECTED_TARGET ){ /* Number of incident protons */
        StepTime = 0;      /* every shot */
        tmNow->tm_sec -= TIME_01;
        nowDateTime = mktime(tmNow);       /* normalization of time */
        tmNow = localtime(&nowDateTime);
        Start = StructTimeToStringTime( tmNow, "/" );
    }
    else {
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( std::string(" ") );
        TimeAtBin.push_back( std::string(" ") );
        InfomationValue.push_back( ERR_VAL );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 1(sig error)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 1(sig error)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 1(sig error)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* error value return */
    }

    if ( DebugFlag ) {
        std::cout << "Key      : [" << Key << "]" << std::endl;
        std::cout << "Start    : [" << Start << "]" << std::endl;
        std::cout << "End      : [" << End << "]" << std::endl;
        std::cout << "StepTime : [" << StepTime << "]" << std::endl;
    }

    ret = PutValueInformation( Key, Start, End, StepTime );
    if ( ret.empty() ){
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( std::string(" ") );
        TimeAtBin.push_back( std::string(" ") );
        InfomationValue.push_back( ERR_VAL );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 1(ret error)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 1(ret error)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 1(ret error)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* error value return */
    }
    else {
        //workDateBin = DateAtBin.back();
        //workTimeBin = TimeAtBin.back();
        workDateBin = lastDataDate.substr(0,10);
        workTimeBin = lastDataDate.substr(11,8);
        workValue   = ret.back();
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( workDateBin );
        TimeAtBin.push_back( workTimeBin );
        InfomationValue.push_back( workValue );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 1(normal)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 1(normal)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 1(normal)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* CT normal return (value of the last element) */
    }

}
//////////////////////////////////////////////////////////////////////
Double AcquireNeutronSourceTextInformation::
PutValueInformation( const std::string Key, const std::string Start ){

    //const Double ERR_VAL = -1.0e+0;    /* Error value */

    time_t   timeDateTime;
    struct tm *ptmDateTime;
    std::string SearchStart, SearchEnd;
    Int4 StepTime;
    Int4 year;

    std::vector<Double> ret;             /* return value (local variable)*/
    //std::vector<Double> InfomationValue; /* return value */
    std::string workDateBin, workTimeBin;
    Double workValue;

    if ( Key == H2_ENTRANCE  ||
         Key == H2_COUPLED   ||
         Key == H2_DECOUPLED ||
         Key == H2_POISON    ){ /* Moderator temperature */
    }
    else if ( Key == CT_MUON_TARGET    ||
              Key == CT_NEUTRON_TARGET ||
              Key == CT_NEUTRON_CORRECTED_TARGET ){ /* Number of incident protons */
    }
    else {
        std::cout << Key << " is an invalid keyword!" << std::endl;
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( std::string(" ") );
        TimeAtBin.push_back( std::string(" ") );
        InfomationValue.push_back( ERR_VAL );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 2(sig error)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 2(sig error)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 2(sig error)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* error value return */
    }

    /* ************************************************** */
    /* Search Step by Day ( yyyy/01/01 00:00:00 --- now ) */
    /* ************************************************** */
    time(&timeDateTime);                    /* get current time */
    ptmDateTime = gmtime(&timeDateTime);    /* UTC */
    ptmDateTime->tm_hour += 9;              /* UTC -> JST */
    timeDateTime = mktime(ptmDateTime);     /* normalization of time */
    ptmDateTime  = localtime(&timeDateTime);
    SearchEnd    = StructTimeToStringTime( ptmDateTime, "/" );
    year = ptmDateTime->tm_year;

    if ( Start == "" ){
        /* SearchStart yyyy/01/01 00:00:00 */
        //ptmDateTime->tm_year = 0;
        ptmDateTime->tm_mon  = 0;
        ptmDateTime->tm_mday = 1;
        ptmDateTime->tm_hour = 0;
        ptmDateTime->tm_min  = 0;
        ptmDateTime->tm_sec  = 0;
        timeDateTime = mktime(ptmDateTime);     /* normalization of time */
        ptmDateTime  = localtime(&timeDateTime);
        SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );
    }
    else {
        StringTimeToStructTime( Start, "/", ptmDateTime );
        ptmDateTime->tm_year = year;
        timeDateTime = mktime(ptmDateTime);     /* normalization of time */
        ptmDateTime  = localtime(&timeDateTime);
        SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );
    }

    StepTime = TIME_DAY;
    if ( DebugFlag ) {
        std::cout << "Start    : [" << SearchStart << "]" << std::endl;
        std::cout << "End      : [" << SearchEnd << "]" << std::endl;
        std::cout << "StepTime : [" << StepTime << "]" << std::endl;
        std::cout <<  std::endl;
    }
    ret = PutValueInformation( CT_MUON_TARGET, SearchStart, SearchEnd, StepTime );
    if ( ret.empty() ){
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( std::string(" ") );
        TimeAtBin.push_back( std::string(" ") );
        InfomationValue.push_back( ERR_VAL );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 2(search ret error)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 2(search ret error)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 2(dearch ret error)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* error value return */
    }
    else {
        //workDateBin = DateAtBin.back();
        //workTimeBin = TimeAtBin.back();
        workDateBin = lastDataDate.substr(0,10);
        workTimeBin = lastDataDate.substr(11,8);
        workValue   = ret.back();
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( workDateBin );
        TimeAtBin.push_back( workTimeBin );
        InfomationValue.push_back( workValue );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 2(search ret)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 2(search ret)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 2(search ret)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
    }

    /* ********************************************************************************** */
    /* Get information data by sec ( yyyy/mm/dd hh:mm:ss --- yyyy/mm/dd hh:mm:ss+1or10 )  */
    /* ********************************************************************************** */
    //SearchStart = workDateBin + " " + workTimeBin;
    //StringTimeToStructTime( SearchStart, "/", ptmDateTime );
    //ptmDateTime->tm_hour = 0;
    //ptmDateTime->tm_min  = 0;
    //ptmDateTime->tm_sec  = 0;
    //timeDateTime = mktime(ptmDateTime);     /* normalization of time */
    //ptmDateTime  = localtime(&timeDateTime);
    //SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );

    if ( Key == H2_ENTRANCE  ||
         Key == H2_COUPLED   ||
         Key == H2_DECOUPLED ||
         Key == H2_POISON    ){ /* Moderator temperature */
        StepTime = TIME_10; /* every 10 sec */
        StringTimeToStructTime( lastDataDate, "/", ptmDateTime );
        ptmDateTime->tm_sec -= 5;
        timeDateTime = mktime(ptmDateTime);     /* normalization of time */
        ptmDateTime  = localtime(&timeDateTime);
        SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );
        ptmDateTime->tm_sec += 10;
    }
    else if ( Key == CT_MUON_TARGET    ||
              Key == CT_NEUTRON_TARGET ||
              Key == CT_NEUTRON_CORRECTED_TARGET ){ /* Number of incident protons */
        StepTime = TIME_01; /* every sec */
        SearchStart = lastDataDate;
        StringTimeToStructTime( SearchStart, "/", ptmDateTime );
        ptmDateTime->tm_sec += TIME_01;
    }
    else {
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( std::string(" ") );
        TimeAtBin.push_back( std::string(" ") );
        InfomationValue.push_back( ERR_VAL );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 2(get sig error)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 2(get sig error)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 2(get sig error)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* error value return */
    }
    timeDateTime = mktime(ptmDateTime);     /* normalization of time */
    ptmDateTime  = localtime(&timeDateTime);
    SearchEnd    = StructTimeToStringTime( ptmDateTime, "/" );

    if ( DebugFlag ) {
        std::cout << "Key      : [" << Key << "]" << std::endl;
        std::cout << "Start    : [" << SearchStart << "]" << std::endl;
        std::cout << "End      : [" << SearchEnd << "]" << std::endl;
        std::cout << "StepTime : [" << StepTime << "]" << std::endl;
    }
    ret = PutValueInformation( Key, SearchStart, SearchEnd, StepTime );
    if ( ret.empty() ){
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( std::string(" ") );
        TimeAtBin.push_back( std::string(" ") );
        InfomationValue.push_back( ERR_VAL );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 2(get ret error)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 2(get ret error)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 2(get ret error)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* error value return */
    }
    else {
        //workDateBin = DateAtBin.back();
        //workTimeBin = TimeAtBin.back();
        workDateBin = lastDataDate.substr(0,10);
        workTimeBin = lastDataDate.substr(11,8);
        workValue   = ret.back();
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( workDateBin );
        TimeAtBin.push_back( workTimeBin );
        InfomationValue.push_back( workValue );
        //if ( DebugFlag ){
        //    Int4 vector_size = InfomationValue.size();
        //    std::cout << std::endl;
        //    std::cout << "PutValueInformation 2(normal)InfomationValue size : " << vector_size << std::endl;
        //    std::cout << "PutValueInformation 2(normal)Date size : " << DateAtBin.size() << std::endl;
        //    std::cout << "PutValueInformation 2(normal)Time size : " << TimeAtBin.size() << std::endl;
        //    for ( Int4 i = 0; i < vector_size; ++i ){
        //        std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        //    }
        //}
        return InfomationValue.back();  /* CT normal return (value of the last element) */
    }

}
//////////////////////////////////////////////////////////////////////
std::vector<Double> AcquireNeutronSourceTextInformation::
PutValueInformation( const std::string Key, const std::string Start, const std::string End, const Int4 StepTime ){

    //const Double ERR_VAL = -1.0e+0;    /* Error value */

    time_t    timeStart, timeEnd;
    struct tm   tmStart,   tmEnd;

    std::string recv_data( " " );  /* http recve data (with HTTP header) */
    std::string body_data( " " );  /* http body data */
    std::string info_data( " " );  /* value information data */

    //std::vector<std::string> workDateBin;
    //std::vector<std::string> workTimeBin;
    std::vector<Double> ret;              /* return value (local variable)*/
    //std::vector<Double> InfomationValue;  /* return value */

    DateAtBin.clear();
    TimeAtBin.clear();
    InfomationValue.clear();
    DateAtBin.push_back( std::string(" ") );
    TimeAtBin.push_back( std::string(" ") );
    InfomationValue.push_back( ERR_VAL );
    lastDataDate = std::string( "                   " );

    /* parameter check */
    /* check to information key word */
    if ( Key == H2_ENTRANCE  ||    /* Moderator temperature (in)*/
         Key == H2_COUPLED   ||    /* Moderator temperature (Coupled)*/
         Key == H2_DECOUPLED ||    /* Moderator temperature (Decoupled)*/
         Key == H2_POISON    ){    /* Moderator temperature (Poisoned)*/
    }
    else if ( Key == CT_MUON_TARGET    ||   /* Number of incident protons (In front of the muon target) */
              Key == CT_NEUTRON_TARGET ||   /* Number of incident protons (In front of the neutron target)*/
              Key == CT_NEUTRON_CORRECTED_TARGET ){
    }
    else {
        std::cout << Key << " is an invalid keyword!" << std::endl;
        //InfomationValue.push_back( ERR_VAL );
        return InfomationValue;
    }
    /* check to start date and time */
    if ( (StringTimeToStructTime(Start, "/", &tmStart)) < 0 ){
        std::cout << "Start date and time error!" << std::endl;
        //InfomationValue.push_back( ERR_VAL );
        return InfomationValue;
    }
    /* check to end date and time */
    if ( (StringTimeToStructTime(End, "/", &tmEnd)) < 0 ){
        std::cout << "End date and time error!" << std::endl;
        //InfomationValue.push_back( ERR_VAL );
        return InfomationValue;
    }

    /* all parameter ok */
    timeStart = mktime(&tmStart);
    timeEnd   = mktime(&tmEnd);
    //std::string date = (StructTimeToStringTime( &tmStart, "-" )).substr(0,10);

    SetFilePath( PutCgiPath( Key ) );
    std::string StepKey = PutStepKey(Key, StepTime);

    if ( SetRequestMessage(Key, Start, End, StepKey) < 0 ) {
        /* parameter error */
        std::cout << "Parameter error!" << std::endl;
        //InfomationValue.push_back( ERR_VAL );
    }
    else {
        /* check to access control */
        if ( AcquireControl( Key ) ){

            /* Initialization of the address structure */
            if ( DebugFlag ) std::cout << "Initialization of an address structure..." << std::endl;
            if ( InitializeSockaddrIn() < 0 ) {
                std::cout << "Initialization of the address structure failed!" << std::endl;
                //InfomationValue.push_back( ERR_VAL );
            }
            else {
                /* Create a socket */
                if ( DebugFlag ) std::cout << "Create a socket..." << std::endl;
                if ( CreateSocket() < 0 ) {
                    std::cout << "Create of the socket failed!" << std::endl;
                    //InfomationValue.push_back( ERR_VAL );
                }
                else {
                    /* Establish a connection to the server. */
                    if ( DebugFlag ) std::cout << "Connecting to the server...." << std::endl;
                    if ( ServerConnect() < 0 ) {
                        std::cout << "Connection to the server failed!" << std::endl;
                        //InfomationValue.push_back( ERR_VAL );
                    }
                    else {
                        /* Send request */
                        if ( DebugFlag ) {
                            std::cout << "Send to request...." << std::endl;
                            std::cout << request << std::endl;
                        }
                        if ( SendRequest( request ) < 0 ) {
                            std::cout << "Request failed!" << std::endl;
                            //InfomationValue.push_back( ERR_VAL );
                        }
                        else {
                            /* Replies received */
                            if ( DebugFlag ) std::cout << "Replies received...." << std::endl;
                            if ( RecvReply ( recv_data ) < 0 ) {
                                std::cout << "Receive failed!" << std::endl;
                                //InfomationValue.push_back( ERR_VAL );
                            }
                            else {
                                /* body data */
                                if ( DebugFlag ) std::cout << "split body data..." << std::endl;
                                if ( SplitBodyData (recv_data, body_data) <= 0 ) {
                                    if ( DebugFlag ) std::cout << "Split Body failed!" << std::endl;
                                }
                                else {
                                    if ( DebugFlag ) std::cout << "Replace br tag..." << std::endl;
                                    ReplaceStr( body_data, "<br>", "<BR>" );  /* change <br> to <BR> */
                                    /* temperature or protons data */
                                    UInt4 datas;
                                    if ( (datas = SplitValueData(body_data, info_data)) == 0){
                                    //if ( (datas = SplitValueData(date, body_data, info_data)) == 0){
                                        std::cout << "No information data!" << std::endl;
                                        //InfomationValue.push_back( ERR_VAL );
                                    }
                                    else {
                                        /* Extraction of main data */
                                        ret = PutValueData( Key, Start, StepKey, StepTime, info_data );
                                        if ( DebugFlag ) {
                                            Int4 vector_size = ret.size();
                                            std::cout << std::endl;
                                            std::cout << "PutValueInformation ret size : " << vector_size << std::endl;
                                            std::cout << "PutValueInformation Date size : " << DateAtBin.size() << std::endl;
                                            std::cout << "PutValueInformation Time size : " << TimeAtBin.size() << std::endl;
                                            for ( Int4 i = 0; i < vector_size; ++i ){
                                                std::cout << DateAtBin[i] << TimeAtBin[i] << ret[i] << std::endl;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    /* Close connection */
                    SocketClose();
                }
            }

        }
        else {
            //std::cout << "Under access restrictions!" << std::endl;
            //InfomationValue.push_back( ERR_VAL );
        }
    }

    if ( DebugFlag ) {
        Int4 vector_size = InfomationValue.size();
        std::cout << std::endl;
        std::cout << "PutValueInformation InfomationValue size : " << vector_size << std::endl;
        std::cout << "PutValueInformation Date size : " << DateAtBin.size() << std::endl;
        std::cout << "PutValueInformation Time size : " << TimeAtBin.size() << std::endl;
        for ( Int4 i = 0; i < vector_size; ++i ){
            std::cout << DateAtBin[i] << TimeAtBin[i] << InfomationValue[i] << std::endl;
        }
    }

    return InfomationValue;
}
//////////////////////////////////////////////////////////////////////
void AcquireNeutronSourceTextInformation::
GetTextInformation( const std::string Key ){
//std::vector< std::pair<std::string,std::string> > AcquireNeutronSourceTextInformation::
//PutTextInformation( const std::string Key ){

    //std::vector< std::pair<std::string,std::string> > ret;   /* return value (local variable)*/

    time_t nowDateTime;
    struct tm *tmNow;
    std::string Start, End;
    Int4 StepTime;

    time(&nowDateTime);                /* get current time */
    tmNow = gmtime(&nowDateTime);      /* UTC */
    tmNow->tm_hour += 9;               /* UTC -> JST */
    nowDateTime = mktime(tmNow);       /* normalization of time */
    tmNow = localtime(&nowDateTime);

    End = StructTimeToStringTime( tmNow, "/" );

    if ( Key == BEAM_STOP_START ){         /* Beam stop */
        StepTime = TIME_10;                /* 10 Min */
        tmNow->tm_hour = 0;
        tmNow->tm_min  = 0;
        tmNow->tm_sec  = 0;
        nowDateTime = mktime(tmNow);       /* normalization of time */
        tmNow = localtime(&nowDateTime);
        Start = StructTimeToStringTime( tmNow, "/" );   /* Start is YYYY/MM/DD 00:00:00 */
    }
    else {
        BeamOffOn.clear();                 /* All elements are deleted. */
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        return;                            /* error value return */
    }

    if ( DebugFlag ) {
        std::cout << "Key      : [" << Key << "]" << std::endl;
        std::cout << "Start    : [" << Start << "]" << std::endl;
        std::cout << "End      : [" << End << "]" << std::endl;
        std::cout << "StepTime : [" << StepTime << "]" << std::endl;
    }

    //ret = PutTextInformation( Key, Start, End, StepTime );
    GetTextInformation( Key, Start, End, StepTime );
    return;  /* normal return */

}
//////////////////////////////////////////////////////////////////////
void AcquireNeutronSourceTextInformation::
GetTextInformation( const std::string Key, const std::string Start ){
//std::vector< std::pair<std::string,std::string> > AcquireNeutronSourceTextInformation::
//PutTextInformation( const std::string Key, const std::string Start ){

    time_t   timeDateTime;
    struct tm *ptmDateTime;
    std::string SearchStart, SearchEnd;
    Int4 StepTime;
    Int4 year;

    std::vector<Double> ret;             /* return value (local variable)*/
    //std::vector< std::pair<std::string,std::string> > ret;   /* return value (local variable)*/
    std::string workDateBin, workTimeBin;
    Double workValue;

    if ( Key == BEAM_STOP_START ){         /* Beam stop */
    }
    else {
        std::cout << Key << " is an invalid keyword!" << std::endl;
        BeamOffOn.clear();                 /* All elements are deleted. */
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        return;  /* error return */
    }

    /* ************************************************** */
    /* Search Step by Day ( YYYY/01/01 00:00:00 --- now ) */
    /* ************************************************** */
    time(&timeDateTime);                    /* get current time */
    ptmDateTime = gmtime(&timeDateTime);    /* UTC */
    ptmDateTime->tm_hour += 9;              /* UTC -> JST */
    timeDateTime = mktime(ptmDateTime);     /* normalization of time */
    ptmDateTime  = localtime(&timeDateTime);
    SearchEnd    = StructTimeToStringTime( ptmDateTime, "/" );
    year = ptmDateTime->tm_year;

    if ( Start == "" ){
        /* SearchStart YYYY/01/01 00:00:00 */
        //ptmDateTime->tm_year = 0;
        ptmDateTime->tm_mon  = 0;
        ptmDateTime->tm_mday = 1;
        ptmDateTime->tm_hour = 0;
        ptmDateTime->tm_min  = 0;
        ptmDateTime->tm_sec  = 0;
        timeDateTime = mktime(ptmDateTime);     /* normalization of time */
        ptmDateTime  = localtime(&timeDateTime);
        SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );
    }
    else {
        StringTimeToStructTime( Start, "/", ptmDateTime );
        ptmDateTime->tm_year = year;
        timeDateTime = mktime(ptmDateTime);     /* normalization of time */
        ptmDateTime  = localtime(&timeDateTime);
        SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );
    }

    StepTime = TIME_DAY;
    if ( DebugFlag ) {
        std::cout << "Start    : [" << SearchStart << "]" << std::endl;
        std::cout << "End      : [" << SearchEnd << "]" << std::endl;
        std::cout << "StepTime : [" << StepTime << "]" << std::endl;
        std::cout <<  std::endl;
    }
    ret = PutValueInformation( CT_MUON_TARGET, SearchStart, SearchEnd, StepTime );
    if ( ret.empty() ){
        BeamOffOn.clear();                 /* All elements are deleted. */
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        return;  /* error return */
    }
    else {
        workDateBin = lastDataDate.substr(0,10);
        workTimeBin = lastDataDate.substr(11,8);
        workValue   = ret.back();
        DateAtBin.clear();
        TimeAtBin.clear();
        InfomationValue.clear();
        DateAtBin.push_back( workDateBin );
        TimeAtBin.push_back( workTimeBin );
        InfomationValue.push_back( workValue );
    }

    /* ********************************************************************************** */
    /* Get information data by sec ( yyyy/mm/dd hh:mm:ss --- yyyy/mm/dd hh:mm:ss+1or10 )  */
    /* ********************************************************************************** */
    //SearchStart = workDateBin + " " + workTimeBin;
    //StringTimeToStructTime( SearchStart, "/", ptmDateTime );
    //ptmDateTime->tm_hour = 0;
    //ptmDateTime->tm_min  = 0;
    //ptmDateTime->tm_sec  = 0;
    //timeDateTime = mktime(ptmDateTime);     /* normalization of time */
    //ptmDateTime  = localtime(&timeDateTime);
    //SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );

    if ( Key == BEAM_STOP_START ){         /* Beam stop */
        StringTimeToStructTime( lastDataDate, "/", ptmDateTime );
        StepTime = TIME_10;                /* 10 Min */
        ptmDateTime->tm_hour = 0;
        ptmDateTime->tm_min  = 0;
        ptmDateTime->tm_sec  = 0;
        timeDateTime = mktime(ptmDateTime);     /* normalization of time */
        ptmDateTime  = localtime(&timeDateTime);
        SearchStart  = StructTimeToStringTime( ptmDateTime, "/" );

        ptmDateTime->tm_hour = 23;
        ptmDateTime->tm_min  = 59;
        ptmDateTime->tm_sec  = 59;
        timeDateTime = mktime(ptmDateTime);     /* normalization of time */
        ptmDateTime  = localtime(&timeDateTime);
        SearchEnd    = StructTimeToStringTime( ptmDateTime, "/" );
    }
    else {
        BeamOffOn.clear();                 /* All elements are deleted. */
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        return;  /* error return */
    }

    if ( DebugFlag ) {
        std::cout << "Key      : [" << Key << "]" << std::endl;
        std::cout << "Start    : [" << SearchStart << "]" << std::endl;
        std::cout << "End      : [" << SearchEnd << "]" << std::endl;
        std::cout << "StepTime : [" << StepTime << "]" << std::endl;
    }

    //ret = PutTextInformation( Key, SearchStart, SearchEnd, StepTime );
    GetTextInformation( Key, SearchStart, SearchEnd, StepTime );
    return;  /* normal return */

}
//////////////////////////////////////////////////////////////////////
void AcquireNeutronSourceTextInformation::
GetTextInformation( const std::string Key, const std::string Start, const std::string End, const Int4 StepTime ){
//std::vector< std::pair<std::string,std::string> > AcquireNeutronSourceTextInformation::
//PutTextInformation( const std::string Key, const std::string Start, const std::string End, const Int4 StepTime ){

    const std::string BEAM_ON   ( " Now Beam is ON" );
    const std::string BEAM_OFF  ( " Now Beam is OFF" );
    const std::string BEAM_STOP ( "Beam Stop" );
    const std::string BEAM_START( "Beam Start" );
    const std::string SPACE_BEAM( "   Beam Start " );
    const std::string BR_TAG    ( "<BR>" );
    const std::string CR        ( "\n" );

    time_t    timeStart, timeEnd;
    struct tm   tmStart,   tmEnd;

    std::string recv_data( " " );  /* http recve data (with HTTP header) */
    std::string body_data( " " );  /* http body data */
    std::string info_data( " " );  /* value information data */

    //std::vector< std::pair<std::string,std::string> > ret;       /* return value (local variable) */
    //std::vector< std::pair<std::string,std::string> > BeamOffOn; /* return value */
    BeamOffOn.clear();                         /* All elements are deleted. */

    /* parameter check */
    /* check to information key word */
    if ( Key != BEAM_STOP_START ){         /* Beam stop */
        /* Key word Error */
        std::cout << Key << " is an invalid keyword!" << std::endl;
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        //return BeamOffOn;
        return;
    }
    /* check to start date and time */
    if ( StringTimeToStructTime(Start, "/", &tmStart) < 0 ){
        std::cout << "Start date and time error!" << std::endl;
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        //return BeamOffOn;
        return;
    }
    /* check to end date and time */
    if ( StringTimeToStructTime(End, "/", &tmEnd) < 0 ){
        std::cout << "End date and time error!" << std::endl;
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        //return BeamOffOn;
        return;
    }

    /* all parameter ok */
    timeStart = mktime(&tmStart);
    timeEnd   = mktime(&tmEnd);

    SetFilePath( PutCgiPath( Key ) );
    std::string StepKey = PutStepKey(Key, StepTime);

    if ( SetRequestMessage(Key, Start, End, StepKey) < 0 ) {
        /* parameter error */
        std::cout << "Parameter error!" << std::endl;
        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
    }
    else {
        /* check to access control */
        if ( AcquireControl( Key ) ){

            /* Initialization of the address structure */
            if ( DebugFlag ) std::cout << "Initialization of an address structure..." << std::endl;
            if ( InitializeSockaddrIn() < 0 ) {
                std::cout << "Initialization of the address structure failed!" << std::endl;
                BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
            }
            else {
                /* Create a socket */
                if ( DebugFlag ) std::cout << "Create a socket..." << std::endl;
                if ( CreateSocket() < 0 ) {
                    std::cout << "Create of the socket failed!" << std::endl;
                    BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
                }
                else {
                    /* Establish a connection to the server. */
                    if ( DebugFlag ) std::cout << "Connecting to the server...." << std::endl;
                    if ( ServerConnect() < 0 ) {
                        std::cout << "Connection to the server failed!" << std::endl;
                        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
                    }
                    else {
                        /* Send request */
                        if ( DebugFlag ) {
                            std::cout << "Send to request...." << std::endl;
                            std::cout << request << std::endl;
                        }
                        if ( SendRequest( request ) < 0 ) {
                            std::cout << "Request failed!" << std::endl;
                            BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
                        }
                        else {
                            /* Replies received */
                            if ( DebugFlag ) std::cout << "Replies received...." << std::endl;
                            if ( RecvReply ( recv_data ) < 0 ) {
                                std::cout << "Receive failed!" << std::endl;
                                BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
                            }
                            else {
                                /* body data */
                                if ( DebugFlag ) std::cout << "split body data..." << std::endl;
                                if ( SplitBodyData (recv_data, body_data) <= 0 ) {
                                    if ( DebugFlag ) std::cout << "Split Body failed!" << std::endl;
                                }
                                else {
                                    if ( DebugFlag ) std::cout << "Replace br tag..." << std::endl;
                                    ReplaceStr( body_data, "<br>", "<BR>" );  /* change <br> to <BR> */
                                    ReplaceStr( body_data, "beam", "Beam" );  /* change beam to Beam */
                                    /* Beam data */
                                    UInt4 datas;
                                    if ( (datas = SplitBeamOffData(body_data, info_data)) == 0){
                                        std::cout << "No beam data!" << std::endl;
                                        BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
                                    }
                                    else {
                                        /* Extraction of main data */
                                        std::string::size_type s_pos, e_pos;
                                        std::string::size_type data_length, line;
                                        std::string dataA, dataB;

                                        s_pos = 0;
                                        while ( s_pos < datas ){
                                            dataA = dataB = " ";
                                            line = info_data.find(BR_TAG,s_pos);   /* set line end pos */
                                            if ( line == std::string::npos ){
                                                line = datas + 1;
                                            }
                                            else {
                                                line += BR_TAG.length();
                                                if ( info_data.substr(line,1) == CR ) {
                                                    line += CR.length();
                                                }
                                            }
                                            //std::cout << "s_pos, line = " << s_pos << ", " << line << std::endl;

                                            /* Now Beam is ON */
                                            e_pos = info_data.find( BEAM_ON, s_pos );
                                            //std::cout << "ON s_pos, e_pos = " << s_pos << ", " << e_pos << std::endl;
                                            if ( e_pos != std::string::npos && e_pos < line ){
                                                data_length = e_pos + BEAM_ON.length() - s_pos;
                                                dataA = info_data.substr(s_pos,data_length);
                                                //if ( DebugFlag ) std::cout << dataA << ", NULL" << std::endl;
                                                BeamOffOn.push_back( std::make_pair(dataA,std::string(" ")) );
                                                s_pos = line;
                                                continue;
                                            }

                                            /* Now Beam is OFF */
                                            e_pos = info_data.find( BEAM_OFF, s_pos );
                                            //std::cout << "OFF s_pos, e_pos = " << s_pos << ", " << e_pos << std::endl;
                                            if ( e_pos != std::string::npos && e_pos < line ){
                                                data_length = e_pos + BEAM_OFF.length() - s_pos;
                                                dataA = info_data.substr(s_pos,data_length);
                                                //if ( DebugFlag ) std::cout << dataA << ", NULL" << std::endl;
                                                BeamOffOn.push_back( std::make_pair(dataA,std::string(" ")) );
                                                s_pos = line;
                                                continue;
                                            }

                                            /* Beam Stop and Beam Start */
                                            e_pos = info_data.find( SPACE_BEAM, s_pos );
                                            //std::cout << "S/S s_pos, e_pos = " << s_pos << ", " << e_pos << std::endl;
                                            if ( e_pos != std::string::npos && e_pos < line ){
                                                data_length = e_pos - s_pos;
                                                dataA = info_data.substr(s_pos,data_length);
                                                s_pos = info_data.find( BEAM_START, e_pos );
                                                e_pos = info_data.find( BR_TAG, s_pos );
                                                data_length = e_pos - s_pos;
                                                dataB = info_data.substr(s_pos,data_length);
                                                //if ( DebugFlag ) std::cout << dataA << "," << dataB << std::endl;
                                                BeamOffOn.push_back( std::make_pair(dataA,dataB) );
                                                s_pos = line;
                                                continue;
                                            }

                                            /* Beam Stop */
                                            e_pos = info_data.find( BEAM_STOP, s_pos );
                                            if ( e_pos != std::string::npos && e_pos < line ){
                                                e_pos = info_data.find(BR_TAG,s_pos);
                                                if ( e_pos == std::string::npos || e_pos >= line ){
                                                    e_pos = line;
                                                }
                                                data_length = e_pos - s_pos;
                                                dataA = info_data.substr(s_pos,data_length);
                                                //if ( DebugFlag ) std::cout << dataA << ",NULL" << std::endl;
                                                BeamOffOn.push_back( std::make_pair(dataA,std::string(" ")) );
                                                s_pos = line;
                                                continue;
                                            }

                                            /* Beam Start */
                                            e_pos = info_data.find( BEAM_START, s_pos );
                                            if ( e_pos != std::string::npos && e_pos < line ){
                                                e_pos = info_data.find(BR_TAG,s_pos);
                                                if ( e_pos == std::string::npos || e_pos >= line ){
                                                    e_pos = line;
                                                }
                                                data_length = e_pos - s_pos;
                                                dataA = info_data.substr(s_pos,data_length);
                                                //if ( DebugFlag ) std::cout << dataA << ",NULL" << std::endl;
                                                BeamOffOn.push_back( std::make_pair(dataA,std::string(" ")) );
                                                s_pos = line;
                                                continue;
                                            }

                                            /* Loop check */
                                            std::cout << "data split failed!" << std::endl;
                                            break;
                                        }/* End of while loop */

                                    }
                                }
                            }
                        }
                    }
                    /* Close connection */
                    SocketClose();
                }
            }

        }
        else {
            //std::cout << "Under access restrictions!" << std::endl;
            BeamOffOn.push_back( std::make_pair(std::string(" "),std::string(" ")) );
        }
    }

    if ( DebugFlag ) {
        Int4 vector_size = BeamOffOn.size();
        std::cout << std::endl;
        std::cout << "PutTextInformation size :" << vector_size << std::endl;
        for ( Int4 i = 0; i < vector_size; ++i ){
            std::cout << BeamOffOn[i].first << "," << BeamOffOn[i].second << std::endl;
        }
    }

    //return BeamOffOn;
    return;
}
//////////////////////////////////////////////////////////////////////
std::vector<std::string> AcquireNeutronSourceTextInformation::
PutDateBinInformation(){
    return DateAtBin;
}
//////////////////////////////////////////////////////////////////////
std::vector<std::string> AcquireNeutronSourceTextInformation::
PutTimeBinInformation(){
    return TimeAtBin;
}
//////////////////////////////////////////////////////////////////////
std::vector<std::string> AcquireNeutronSourceTextInformation::
PutTextFirstInformation(){
    std::vector<std::string> FirstText;

    if ( BeamOffOn.empty() ){
        FirstText.push_back( std::string(" ") );
    }
    else {
        UInt4 vector_size = BeamOffOn.size();
        for ( UInt4 n = 0; n < vector_size; n++ ){
            FirstText.push_back( BeamOffOn[n].first );
        }
    }

    return FirstText;
}
//////////////////////////////////////////////////////////////////////
std::vector<std::string> AcquireNeutronSourceTextInformation::
PutTextSecondInformation(){
    std::vector<std::string> SecondText;

    if ( BeamOffOn.empty() ){
        SecondText.push_back( std::string(" ") );
    }
    else {
        UInt4 vector_size = BeamOffOn.size();
        for ( UInt4 n = 0; n < vector_size; n++ ){
            SecondText.push_back( BeamOffOn[n].second );
        }
    }

    return SecondText;
}
//////////////////////////////////////////////////////////////////////
std::vector<Double> AcquireNeutronSourceTextInformation::
ConvertProtonToCurrent(std::vector<Double> proton, const Int4 bin){
//ConvertProtonToCurrent(std::vector<Double> proton){
    Double factor = 1.0e+12 * 1.602e-19;
    std::vector<Double> current;

    if ( proton.empty() ){
        current.push_back( ERR_VAL );
    }
    else {
        UInt4 vector_size = proton.size();
        if ( bin < 1 ){
            current.push_back( ERR_VAL );
        }
        else if ( bin == 1 ){
            for ( UInt4 n = 0; n < vector_size; n++ ){
                current.push_back( proton.at(n) * factor );
            }
        }
        else {
            Double seconds = (Double)bin;
            for ( UInt4 n = 0; n < vector_size; n++ ){
                current.push_back( proton.at(n) / seconds * factor );
            }
        }

    }

    return current;
}
//////////////////////////////////////////////////////////////////////
std::vector<Double> AcquireNeutronSourceTextInformation::
ConvertCurrentToBeampower(std::vector<Double> current){
//ConvertProtonToBeampower(std::vector<Double> proton){
    Double factor = 3.0e+9;
    std::vector<Double> BeamPower;

    //if ( proton.empty() ){
    if ( current.empty() ){
        BeamPower.push_back( ERR_VAL );
    }
    else {
        //UInt4 vector_size = proton.size();
        UInt4 vector_size = current.size();
        for ( UInt4 n = 0; n < vector_size; n++ ){
            BeamPower.push_back( current.at(n) * factor );
            //BeamPower.push_back( proton.at(n) * factor );
        }
    }

    return BeamPower;
}
