#ifndef ACQUIRENEUTRONSOURCEINFORMATIONCONTROLBASE
#define ACQUIRENEUTRONSOURCEINFORMATIONCONTROLBASE

#define ACQUIRE_TIME 15     /* access time interval (sec) */
#define ACQUIRE_MAX  150    /* maximum access count */

/* Signal Key */
#define BEAM_POWER            "BP"   /* Beam power */
#define CT_HISTORY            "CT01" /* Beam power history(image) */
#define MODERATOR_TEMPERATURE "H2"   /* Moderator temperature history(image) */
#define JPARC_STATUS          "JP"   /* Status of J-PARC(image) */
#define SHUTTER_STATUS        "ST"   /* Shutter opening-and-closing state(image) */
#define CT_3HOUR              "CT3H" /* Current history 3 hour(image) */
#define CT_1DAY               "CT1D" /* Current history 1 day(image) */
#define H2_ENTRANCE           "H2in" /* Temperature of moderator hydrogen (entrance) */
#define H2ENTRANCE            "h2in" /* for cgi parameter, Temperature of moderator hydrogen (entrance) */
#define H2_COUPLED            "H2cm" /* Temperature of moderator hydrogen (coupled) */
#define H2COUPLED             "h2cm" /* for cgi parameter, Temperature of moderator hydrogen (coupled) */
#define H2_DECOUPLED          "H2dm" /* Temperature of moderator hydrogen (decoupled) */
#define H2DECOUPLED           "h2dm" /* for cgi parameter, Temperature of moderator hydrogen (decoupled) */
#define H2_POISON             "H2pm" /* Temperature of moderator hydrogen (poison) */
#define H2POISON              "h2pm" /* for cgi parameter, Temperature of moderator hydrogen (poison) */
#define CT_MUON_TARGET        "CT8"  /* The number of protons (muon target) */
#define CT_NEUTRON_TARGET     "CT9"  /* The number of protons (neutron target) */
#define BEAM_STOP_START       "BS"   /* Beam stop time */
#define CT_NEUTRON_CORRECTED_TARGET "CT8NEUTRON" /* The number of protons (neutron target corrected with muon target position */

//#include <sys/time>       /* struct timeval */
#include <ctime>
//#include <sstream>                                     /* for ostringstream */
#include <iomanip>                                     /* manipulator */
#include "AcquireNeutronSourceInformationBase.hh"
#include "StringTools.hh"                              /* StringTools at StringDateToUInt4 */
///////////////////////////////////////////////////
class AcquireNeutronSourceInformationControlBase
    : public AcquireNeutronSourceInformationBase
{
private:
protected:
    struct timeval StartingTime;     /* Starting time of this API (micro sec) */
    struct timeval LastTime;         /* Last time of this API (micro sec) */
    UInt4  AccessCount;              /* The demand number of times of this API */

public:
    AcquireNeutronSourceInformationControlBase();
        //!< Constructor
        /*!<
         */
    AcquireNeutronSourceInformationControlBase(std::string host_name);
        //!< Constructor
        /*!<
         *   @param host_name   The server name which is the information Web page of neutron source.
         */
    virtual ~AcquireNeutronSourceInformationControlBase();
        //!< Destructor
        /*!<
         */
    Bool AcquireControl( const std::string Key );

    UInt4 StringDateToUInt4( const std::string Date, UInt4& year, UInt4& month, UInt4& day, UInt4& hour );
    UInt4 StringTimeToStructTime( const std::string date_time, const std::string separator, struct tm *ltm );
    std::string StructTimeToStringTime( struct tm *ltm, const std::string separator );
};

#endif
