#ifndef ACQUIRENEUTRONSOURCEINFORMATIONBASE
#define ACQUIRENEUTRONSOURCEINFORMATIONBASE

#define BUFSIZE 4096

//#include <stdio>
//#include <stdlib>
#include <unistd.h>           /* getopt, optarg, sleep */
#include <netdb.h>            /* gethostbyname() */

#include <sys/types.h>        /* protocol family, opendir */
#include <sys/socket.h>       /* socket system call */
#include <sys/select.h>       /* select system call */
#include <sys/param.h>
#include <sys/stat.h>         /* mkdir */

#include <netinet/in.h>       /* struct sockaddr_in */
#include <arpa/inet.h>        /* inet_aton() */
#include <dirent.h>           /* opendir */

//#include <iostream>
#include <sstream>
//#include <string>           /* strncpy() */

#include "Header.hh"
#include "MlfHeader.hh"

#include <openssl/ssl.h>
#include <openssl/err.h>      /* for ERR_free_strings */

//////////////////////////////////////////////////
class AcquireNeutronSourceInformationBase
{
private:
protected:
    std::string HostName;                /* host name */
    std::string HostProtocol;            /* host protocol (http/https) */
    std::string FilePath;                /* file path */

    struct sockaddr_in sin;         /* The structure for socket */
//  struct hostent *ServHost;       /* The structure for host name and IP address */
//  struct servent *Service;        /* The structure for service */
    Int4 SocketDescriptor;          /* Socket descriptor */

    SSL_CTX *ctx;
    SSL *ssl;

public:
    AcquireNeutronSourceInformationBase();
        //!< Constructor
        /*!<
         */
    AcquireNeutronSourceInformationBase( std::string host_name );
        //!< Constructor
        /*!<
         *   @param host_name    The server name which is the information Web page of neutron source.
         */
    virtual ~AcquireNeutronSourceInformationBase();
        //!< Destructor
        /*!<
         */

    void SetHostName( const std::string host_name );
    void SetHostProtocol( const std::string host_protocol );
    void SetFilePath( const std::string file_path );
    std::string PutHostName();
    std::string PutFilePath();

    Int4 InitializeSockaddrIn ();
    Int4 CreateSocket ();
    Int4 ServerConnect ();
    void SocketClose ();

    Int4 SendRequest (std::string& request);
    Int4 SendRequestHTTP(std::string& request);
    Int4 SendRequestHTTPS(std::string& request);
    Int4 RecvReply (std::string& recv_data);
    Int4 SplitBodyData (std::string& recv_data, std::string& body_data);
    //Int4 SplitBodyData (const std::string Mode, std::string& recv_data, std::string& body_data);
};

#endif
