# -*- coding: utf-8 -*-
import sys
from pyqtgraph.Qt import QtCore, QtGui, uic
import pyqtgraph as pg
import pyqtgraph.opengl as gl
import numpy as np
import math
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from pyqtgraph.opengl.GLGraphicsItem import GLGraphicsItem

class GLLabelItem(GLGraphicsItem):
    def __init__(self,  antialias=True, glOptions='translucent'):
        GLGraphicsItem.__init__(self)
        self.antialias = antialias
        self.setGLOptions(glOptions)
        self.color=[0, 0, 1, .6]
        self.xpos=0
        self.ypos=0
        self.zpos=0
        self.label="label"
        self.fontType = GLUT_BITMAP_TIMES_ROMAN_24
        pass

    def setColor(self,x):
        self.color=x

    def getColor(self):
        return self.color

    def setPosition(self,x,y,z):
        self.xpos=x
        self.ypos=y
        self.zpos=z

    def getPositon(self):
        return [self.xpos,self.ypos,self.zpos]

    def setText(self,val):
        self.label=val

    def getText(self):
        return self.label

    def setTextSize(self,val):
        self.textSize=val

    def getTextSize(self):
        return self.textSize
    
    def setFontType(self,val):
        self.fontType = val
    
    def paint(self):
        self.setupGLState()
        if self.antialias:
            glEnable(GL_LINE_SMOOTH)
            glHint(GL_LINE_SMOOTH_HINT, GL_NICEST)

        self.drawLabel()

    def drawLabel(self):

        glColor4f(self.color[0],
                  self.color[1],
                  self.color[2],
                  self.color[3])
        glRasterPos3f( self.xpos, self.ypos, self.zpos )
        for c in self.label:
            glutBitmapCharacter( self.fontType, ord(c) )
            #GLUT_BITMAP_8_BY_13
            #GLUT_BITMAP_9_BY_15
            #GLUT_BITMAP_HELVETICA_10
            #GLUT_BITMAP_HELVETICA_12
            #GLUT_BITMAP_HELVETICA_18
            #GLUT_BITMAP_TIMES_ROMAN_10
            #GLUT_BITMAP_TIMES_ROMAN_24