# -*- coding: utf-8 -*-
#
# $Date: 2012-08-22 18:06:43 +0900 (水, 22 8 2012) $
# $Rev: 32 $
#
import math

MILLI = 1.0e-3
MICRO = 1.0e-6
NEUTRON_MASS = 1.67492728e-27 #[kg]
ELECTRON_VOLT = 1.60217653e-19 #[J]
MILLI_ELECTRON_VOLT = ELECTRON_VOLT * MILLI
PLANCK_CONST = 6.62606896e-34 # [J*s]
DIRAC_CONST = PLANCK_CONST / 2.0 / math.pi
ANGSTROM = 1.0e-10
ENG_FAC = DIRAC_CONST ** 2 / (2.0 * NEUTRON_MASS) / ANGSTROM ** 2
MEV_ENG_FAC = ENG_FAC / MILLI_ELECTRON_VOLT

# GEOMETRICAL PARAMETERS
GEOM_TINY_VALUE = 1.0e-12

# SCALAR FIELD LIST
ENERGY_TRANSFER = "Energy transfer [meV]"
DETECT_INTENSITY = "Detect intensity"
PIXEL = "Pixel No."

# Q POINT VALUE LIST
QPVAL_ET = ENERGY_TRANSFER
QPVAL_PXNO = PIXEL
QPVAL_PSDID = "PSD"
QPVAL_INSIDE = "is_inside"
