import Manyo as mm # added by inamura (2008.09.04)
import numpy       # added by inamura(2008.09.04)

class simplehistogram(object):
    def __init__(self, elementcontainer):
        self.xkey = elementcontainer.PutXKey()
        self.ykey = elementcontainer.PutYKey()
        self.ekey = elementcontainer.PutEKey()
        self.xvector = numpy.array(elementcontainer.PutX(), dtype='float')
        self.yvector = numpy.array(elementcontainer.PutY(), dtype='float')
        self.evector = numpy.array(elementcontainer.PutE(), dtype='float')
        self.xunit = elementcontainer.PutUnit(self.xkey)
        self.yunit = elementcontainer.PutUnit(self.ykey)
        self.eunit = elementcontainer.PutUnit(self.ekey)
        
    def integrate(self, ini = None, fin = None):
        x0 = self.xvector[0]
        x1 = self.xvector[-1]
        result = 0.0
        result_error = 0.0
        evector = self.evector**2
        if x0<x1:
            if ini != None:
                x0 = max(self.xvector[0], ini)
            if fin != None:
                x1 = min(self.xvector[-1], fin)
        else:
            if ini != None:
                x0 = min(self.xvector[0], ini)
            if fin != None:
                x1 = max(self.xvector[-1], fin)
        for xx in range(len(self.xvector)-1):
            if self.xvector[xx] >= x0 and self.xvector[xx] <= x1 :
                result += abs(self.xvector[xx+1]-self.xvector[xx])*self.yvector[xx]
                result_error +=(self.xvector[xx+1]-self.xvector[xx])**2*evector[xx]
            else:
                pass
        return (result, numpy.sqrt(result_error))
        
    def sum(self, ini = None, fin = None):
        x0 = self.xvector[0]
        x1 = self.xvector[-1]
        result = 0.0
        result_error = 0.0
        evector = self.evector**2
        if ini != None:
            x0 = max(self.xvector[0], ini)
        if fin != None:
            x1 = min(self.xvector[-1], fin)
        for xx in range(len(self.xvector)-1):
            if self.xvector[xx] >= x0 and self.xvector[xx] <= x1 :
                result += self.yvector[xx]
                result_error += evector[xx]
            else:
                pass
        return (result, numpy.sqrt(result_error))
        
    def plot(self):
        import pylab
        pylab.errorbar((self.xvector[1:]+self.xvector[:-1])*0.5, self.yvector, self.evector)
        
        
        
def getmasked(ecm):
    #if type(ecm) != type(ElementContainerMatrix()):
    if not isinstance( ecm, mm.ElementContainerMatrix ):
        raise AttributeError, "Input must be Manyo.ElementContainerMatrix"
    result=[]
    ecmsize=ecm.PutTableSize()
    for ii in range(ecmsize):
        if ecm(ii).PutHeader().PutInt4("MASKED") != 0 :
            result.append((ii,))
        else:
            for jj in range(ecm(ii).PutTableSize()):
                if ecm(ii,jj).PutHeader().PutInt4("MASKED") != 0:
                    result.append((ii,jj))
    return tuple(result)

def ecsub(ec, bg):
    #if type(ec) != type(ElementContainer()):
    #if type(ec) != type(mm.ElementContainer()): # changed by inamura (2008.09.04)
    if not isinstance( ecm, mm.ElementContainer ):
        raise AttributeError, "Input must be Manyo.ElementContainerMatrix"
    yd = ec.PutY()
    xk, yk, ek = ec.PutXKey(), ec.PutYKey(), ec.PutEKey()
    yu = ec.PutUnit(yk)
    #newyd = DoubleVector()
    newyd = mm.MakeDoubleVector() # changed by inamura (2008.09.04)
    for ind in range(yd.capacity()):
        newyd.append(yd[ind]-bg)
    ec.Remove(yk)
    ec.Add(yk,newyd, yu)
    ec.SetKeys(xk, yk, ek)
    return ec


def eccopy(ec): # rewritten by inamura (2008.09.03)
    
    #if type(ec) == type(mm.ElementContainer()):
    if not isinstance( ecm, mm.ElementContainer ):
        return mm.ElementContainer(ec)
    #elif type(ec) == type(mm.ElementContainerArray()):
    elif not isinstance( ecm, mm.ElementContainerArray ):
        return mm.ElementContainerArray(ec)
    #elif type(ec) == type(mm.ElementContainerMatrix()):
    elif not isinstance( ecm, mm.ElementContainerMatrix ):
        return mm.ElementContainerMatrix(ec)
    else:
        return None
    
    '''
    if type(ec) == type(ElementContainer()):
        return ElementContainer(ec)
    elif type(ec) == type(ElementContainerArray()):
        hd = ec.PutHeader()
        result = ElementContainerArray(hd)
        for ii in range(ec.PutTableSize()):
            result.Add(ElementContainer(ec(ii)))
        return result
    elif type(ec) == type(ElementContainerMatrix()):
        hd = ec.PutHeader()
        result = ElementContainerMatrix(hd)
        for ind0 in range(ec.PutTableSize()):
            teca = ElementContainerArray(ec(ind0).PutHeader())
            for ind1 in range(ec(ind0).PutTableSize()):
                tec = ElementContainer(ec(ind0,ind1))
                teca.Add(tec)
            result.Add(teca)
        return result
    return None
    '''
