#!/usr/bin/env python
#
# trignet bit mode is described at only 0d detector series
# trignet bit mode elapsed time = trignet bool list mode elapsed time x0.8
#
#import time
from __future__ import print_function
import glob
import os
import numpy as np
import math

from header import *

#c----------------------------------------------------------------------------

def getTofBin_DT_T_Constant(start_ch,end_ch,ratio_ch):

    start_ch = float(start_ch)
    end_ch   = float(end_ch)
    ratio_ch = float(ratio_ch)
    factor_ch = (ratio_ch+2.)/(2.-ratio_ch)
    if (start_ch==0.0):
	start_ch = 0.025/(ratio_ch)
    #print "start ", start_ch
    #print "end   ", end_ch
    #print "ratio ", ratio_ch
    #print "factor", factor_ch

    num_of_bin = int( math.log(end_ch/start_ch)/math.log(factor_ch))+1
    print("No.of bins", num_of_bin)
    bin = [ math.ceil(start_ch * pow(factor_ch, j)*40)/40.0 for j in range(num_of_bin)]
    return bin

def getTofBin_T_Constant(start_ch,end_ch,delta_ch):
    bin = range(start_ch,end_ch+delta_ch,delta_ch)
    return bin

def getFilePath(runNo,detector,dirname):
    runNo_format='%06d' % runNo
    if os.name == 'posix' or os.name == 'nt':
	# basepath=os.path.join(os.sep,"data",XXX)
	basepath=dirname
	searchName = os.path.join(basepath,
			  XXX+runNo_format+"_????????")
	result=glob.glob(searchName)
	if len(result)>0:
	    dname=result[0]
	else:
	    print(searchName[:-9]+" not found!")
	    return ""
    else:
	dname=os.path.join(os.getcwd())
    #  detectorList = ["0D","MWPC","RPMT","WLSF1","WLSF2","WLSF3","WLSF4","N2 Monitor","He Monitor" ]
    if detector in ["0D","MWPC","RPMT","WLSF1","WLSF2","WLSF3","WLSF4","N2","He", "TRIGNET" ]:
	#if "WLSF" in detector:
	#    detector="WLSF"
	daqId=detectorIDS[detector]["daqID"]
	detId=detectorIDS[detector]["detID"]
    else:
	print("### Wrong detector name! ###")
	return ""

    fname=XXX+runNo_format+"_"+daqId+"_"+detId+"_000.edb"
    datapath=os.path.join(dname,fname)

    result=glob.glob(datapath)
    if len(result)>0:
	dname=result[0]
    else:
	print(datapath+" not found!")
	return ""

    return datapath

#c------------------------------------------------------------------------------

def getNeutronDataTOF(inputParam, dirname, detector="0D", binInfo=(0,40000.0,1000), binType=0,
			t0Normalize=False, trignetData=None, filterCondition=None,
			positionCondition=None,filePosition=None, less_than=-1):

    if isinstance(inputParam,int):
	filename  = getFilePath(inputParam,detector, dirname)
    elif isinstance(inputParam,str) or isinstance(inputParam,unicode):
	filename  = inputParam

    if os.path.exists(filename):

	# file open and seek
	f=open(filename,"rb")

	if filePosition==None:
	    s=f.read()
	else:
	    f.seek(filePosition)
	    s=f.read()
	f.close()

        filenode = filename[:-7]
        elno = 1
        datapath = filenode+str(elno).zfill(3)+".edb"
        result=glob.glob(datapath)

	while len(result) > 0:
	    filename = result[0]
	    print("Find : ", filename)
	    f=open(filename,"rb")
	    s2=f.read()
	    f.close()
	    s += s2
	    elno += 1
	    datapath = filenode+str(elno).zfill(3)+".edb"
	    result=glob.glob(datapath)

	#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	#c trignet bool mode
	pass
	#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	#c trignet bit mode (bit mode elapsed time = bool mode elapsed time x0.8)
	#if filterCondition!=None:
	#    filterCondition1=[ bool(flag) for flag in filterCondition ]
	#    filterCondition2=[ flag!=None for flag in filterCondition ]
	#    filterConditionVal1=0
	#    for i in range(len(filterCondition1)):
	#	filterConditionVal1+=int(filterCondition1[i])<<i
	#    filterConditionVal2=0
	#    for i in range(len(filterCondition2)):
	#	filterConditionVal2+=int(filterCondition2[i])<<i
	#    filterCondition=[filterConditionVal1,filterConditionVal2]
	#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

	# decode raw data
	if detector=="MWPC":
	    ret,pos,t0s = decodeMWPC(s,trignetData,filterCondition,positionCondition)
	elif detector=="RPMT":
	    ret,pos,t0s = decodeRPMT(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF1":
	    ret,pos,t0s = decodeWLSF1(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF2":
	    ret,pos,t0s = decodeWLSF2(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF3":
	    ret,pos,t0s = decodeWLSF3(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF4":
	    ret,pos,t0s = decodeWLSF4(s,trignetData,filterCondition,positionCondition)
	elif detector=="0D":
	    ret,pos,t0s = decode0DDetectorTOF(s,trignetData,filterCondition,positionCondition, less_than)
	elif detector=="N2":
	    ret,pos,t0s = decode0DDetectorTOF(s,trignetData,filterCondition,positionCondition, less_than)
	elif detector=="He":
	    ret,pos,t0s = decode0DDetectorTOF(s,trignetData,filterCondition,positionCondition, less_than)
	# creats_than histogram bin
	if binType==0:
	    bins = getTofBin_T_Constant( int(binInfo[0]),int(binInfo[1]),int(binInfo[2]))
	else:
	    bins = getTofBin_DT_T_Constant(binInfo[0],binInfo[1],binInfo[2])
	#if binType==1:
	#    bins = getTofBin_DT_T_Constant(binInfo[0],binInfo[1],binInfo[2])
	#else:
	#    bins = getTofBin_T_Constant( int(binInfo[0]),int(binInfo[1]),int(binInfo[2]))

	# create histogram
	intensity_array, tof_array =np.histogram(ret,bins=bins,normed=False)
	err_array = np.sqrt(intensity_array)

	# t0 normalize
	print("T0Count\t>> ",t0s)
	if t0Normalize:
	    return intensity_array/float(t0s),err_array/float(t0s),tof_array,t0s,pos
	else:
	    return intensity_array,err_array,tof_array,t0s,pos

    else:
	return [],[],[],0,(0,0)

#c------------------------------------------------------------------------------

def getNeutronData(inputParam, dirname, detector="0D", binInfo=(0,40000.0,1000), binType=0,
			t0Normalize=False, trignetData=None, filterCondition=None,
			positionCondition=None,filePosition=None):

    if isinstance(inputParam,int):
	filename  = getFilePath(inputParam,detector, dirname)
    elif isinstance(inputParam,str) or isinstance(inputParam,unicode):
	filename  = inputParam

    if os.path.exists(filename):

	# file open and seek
	f=open(filename,"rb")

	if filePosition==None:
	    s=f.read()
	else:
	    f.seek(filePosition)
	    s=f.read()
	f.close()

        filenode = filename[:-7]
        elno = 1
        datapath = filenode+str(elno).zfill(3)+".edb"
        result=glob.glob(datapath)

	while len(result) > 0:
	    filename = result[0]
	    print("Find : ", filename)
	    f=open(filename,"rb")
	    s2=f.read()
	    f.close()
	    s += s2
	    elno += 1
	    datapath = filenode+str(elno).zfill(3)+".edb"
	    result=glob.glob(datapath)

	#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	#c trignet bool mode
	pass
	#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	#c trignet bit mode (bit mode elapsed time = bool mode elapsed time x0.8)
	#if filterCondition!=None:
	#    filterCondition1=[ bool(flag) for flag in filterCondition ]
	#    filterCondition2=[ flag!=None for flag in filterCondition ]
	#    filterConditionVal1=0
	#    for i in range(len(filterCondition1)):
	#	filterConditionVal1+=int(filterCondition1[i])<<i
	#    filterConditionVal2=0
	#    for i in range(len(filterCondition2)):
	#	filterConditionVal2+=int(filterCondition2[i])<<i
	#    filterCondition=[filterConditionVal1,filterConditionVal2]
	#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

	# decode raw data
	if detector=="MWPC":
	    ret,pos,t0s = decodeMWPC(s,trignetData,filterCondition,positionCondition)
	elif detector=="RPMT":
	    ret,pos,t0s = decodeRPMT(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF1":
	    ret,pos,t0s = decodeWLSF1(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF2":
	    ret,pos,t0s = decodeWLSF2(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF3":
	    ret,pos,t0s = decodeWLSF3(s,trignetData,filterCondition,positionCondition)
	elif detector=="WLSF4":
	    ret,pos,t0s = decodeWLSF4(s,trignetData,filterCondition,positionCondition)
	elif detector=="0D":
	    ret,pos,t0s = decode0DDetector(s,trignetData,filterCondition,positionCondition)
	elif detector=="N2":
	    ret,pos,t0s = decode0DDetector(s,trignetData,filterCondition,positionCondition)
	elif detector=="He":
	    ret,pos,t0s = decode0DDetector(s,trignetData,filterCondition,positionCondition)
	# create histogram bin
	if binType==0:
	    bins = getTofBin_T_Constant( int(binInfo[0]),int(binInfo[1]),int(binInfo[2]))
	else:
	    bins = getTofBin_DT_T_Constant(binInfo[0],binInfo[1],binInfo[2])
	#if binType==1:
	#    bins = getTofBin_DT_T_Constant(binInfo[0],binInfo[1],binInfo[2])
	#else:
	#    bins = getTofBin_T_Constant( int(binInfo[0]),int(binInfo[1]),int(binInfo[2]))

	# create histogram
	intensity_array, tof_array =np.histogram(ret,bins=bins,normed=False)
	err_array = np.sqrt(intensity_array)

	# t0 normalize
	print("T0Count\t>> ",t0s)
	if t0Normalize:
	    return intensity_array/float(t0s),err_array/float(t0s),tof_array,t0s,pos
	else:
	    return intensity_array,err_array,tof_array,t0s,pos

    else:
	return [],[],[],0,(0,0)

#c------------------------------------------------------------------------------
def getNeutronData2D(inputParam, dirname, detector="MWPC",trignetData=None,filterCondition=None,tofCondition=None,filePosition=None):
    if isinstance(inputParam,int):
	filename  = getFilePath(inputParam,detector,dirname)
    elif isinstance(inputParam,str) or isinstance(inputParam,unicode):
	filename  = inputParam

    if os.path.exists(filename):

	# file open and seek
	f=open(filename,"rb")

	if filePosition==None:
	    s=f.read()
	else:
	    f.seek(filePosition)
	    s=f.read()
	f.close()

        filenode = filename[:-7]
        elno = 1
        datapath = filenode+str(elno).zfill(3)+".edb"
        result=glob.glob(datapath)

	while len(result) > 0:
	    filename = result[0]
	    print("Find : ", filename)
	    f=open(filename,"rb")
	    s2=f.read()
	    f.close()
	    s += s2
	    elno += 1
	    datapath = filenode+str(elno).zfill(3)+".edb"
	    result=glob.glob(datapath)

	# decode raw data
	if detector=="MWPC":
	    ret,pos,t0s = decodeMWPC2D(s,trignetData,filterCondition,tofCondition)

	elif detector=="RPMT":
	    ret,pos,t0s = decodeRPMT2D(s,trignetData,filterCondition,tofCondition)

	elif detector=="WLSF1":
	    ret,pos,t0s = decodeWLSF12D(s,trignetData,filterCondition,tofCondition)

	elif detector=="WLSF2":
	    ret,pos,t0s = decodeWLSF22D(s,trignetData,filterCondition,tofCondition)

	elif detector=="WLSF3":
	    ret,pos,t0s = decodeWLSF32D(s,trignetData,filterCondition,tofCondition)

	elif detector=="WLSF4":
	    ret,pos,t0s = decodeWLSF42D(s,trignetData,filterCondition,tofCondition)
	return ret,pos,t0s

#c-----------------------------------------------------------------------------
def getTrignetData(inputParam,dirname, filePosition=None):

    if isinstance(inputParam,int):
	filename = getFilePath(inputParam,"TRIGNET", dirname)
    elif isinstance(inputParam,str) or isinstance(inputParam,unicode):
	filename = inputParam

    if os.path.exists(filename):
	ret=[]

	# file open and seek
	f=open(filename,"rb")

	if filePosition==None:
	    s=f.read()
	else:
	    f.seek(filePosition)
	    s=f.read()
	f.close()

	# decode raw data
	dataFlag,dataPID,dataPOS = decodeTrignet(s)

	return dataFlag,dataPID,dataPOS
    else:
	return []

#c-----------------------------------------------------------------------------
def getT0List(dataFlag):
    return  [flag[-1] - flag[0] + 1 for flag in dataFlag]

#c-----------------------------------------------------------------------------
def decode0DDetectorTOF(s,trignetData=None,filterCondition=None,positionCondition=None,less_than=-1):
    dataVAL=[]

    initial  = 0
    final    = len(s)

    if trignetData!=None and trignetData!=[] and filterCondition!=None:

	trignetFlag = trignetData[0]
	trignetPID  = trignetData[1]
	trignetPOS  = trignetData[2]
	trignetDataLength = len(trignetFlag)
	trignetIndex=0
	flag=False
	t0_count=0
	trignetFilePos=0
	neutronFilePos=0
	dataVALappend =dataVAL.append
	for neutronFilePos in xrange(initial,final,8):
#AS Start 20150415 kmatsu
#	    if flag and 0x5a==ord(s[neutronFilePos]): # neutron data block
#		tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
#					ord(s[neutronFilePos+2])<<8  |
#					ord(s[neutronFilePos+3]) ) )/40.0
#		#dataVAL.append(tof)
#		dataVALappend(tof)
	    if flag and 0x5a==ord(s[neutronFilePos]): # neutron data block
		ad = ( 0x01 & ( ord(s[neutronFilePos+4])))
		if ad==0:
		    tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
					ord(s[neutronFilePos+2])<<8  |
					ord(s[neutronFilePos+3]) ) )/40.0
		    if (less_than < 0 or tof < less_than):
			tof += 40000
		    dataVALappend(tof)
#AS End
	    if 0x5b==ord(s[neutronFilePos]): # T0 data block
		if trignetIndex >= trignetDataLength:
		    neutronFilePos-=8
		    break
		### compare NeutronData-T0 with TrignetData-T0 -START
		#t0 = 0xFFFFFFFFFF & (ord(s[neutronFilePos+3])<<32 |
		#			ord(s[neutronFilePos+4])<<24 |
		#			ord(s[neutronFilePos+5])<<16 |
		#			ord(s[neutronFilePos+6])<<8  |
		#			ord(s[neutronFilePos+7])      )
		#if t0<trignetPID[trignetIndex]:
		#    flag=False
		#else:
		#    while 1:
		#	if t0 <trignetPID[trignetIndex]:
		#	    flag=False
		#	    break
		#	if t0==trignetPID[trignetIndex]:
		#	    flag=True
		#	    for k in xrange(8):
		#		if filterCondition[k]!=None and \
		#		    trignetFlag[trignetIndex][k]!=filterCondition[k]:
		#		    flag=False
		#		    break
		#	    t=trignetPOS[trignetIndex]
		#	    break
		#	trignetIndex+=1
		### compare NeutronData-T0 with TrignetData-T0 -END

		trignetFilePos=trignetPOS[trignetIndex]

		#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
		#c trignet bool mode
		flag=True
		for k in xrange(8):
		    if filterCondition[k]!=None and trignetFlag[trignetIndex][k]!=filterCondition[k]:
		        flag=False
		        break
		else:
		    t0_count+=1
		#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
		#c trignet bit mode (bit mode elapsed time = bool mode elapsed time x0.8)
		#flag = (filterCondition[1] & trignetFlag[trignetIndex]) == filterCondition[0]
		#if flag:t0_count+=1
		#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
		trignetIndex+=1
	if neutronFilePos!=0:neutronFilePos+=8
    else:
	trignetFilePos=0
	t0_count=0
	neutronFilePos=0
	dataVALappend =dataVAL.append
	for neutronFilePos in xrange(initial,final,8):
#AS Start 20150415 kmatsu
#	    if 0x5a==ord(s[neutronFilePos]): # neutron data block
#		tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
#					ord(s[neutronFilePos+2])<<8  |
#					ord(s[neutronFilePos+3]) ) ) /40
#
#		dataVALappend(tof)
	    if 0x5a==ord(s[neutronFilePos]): # neutron data block
		ad = ( 0x01 & ( ord(s[neutronFilePos+4])))
		if ad==0:
		    tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
					ord(s[neutronFilePos+2])<<8  |
					ord(s[neutronFilePos+3]) ) )/40.0
		    if (less_than < 0 or tof < less_than):
			tof += 40000
		    dataVALappend(tof)
	    elif 0x5b==ord(s[neutronFilePos]): # T0 data bleck

		#t0 = (0xFFFFFFFFFF & (ord(s[neutronFilePos+3])<<32 |
		#			ord(s[neutronFilePos+4])<<24 |
		#			ord(s[neutronFilePos+5])<<16 |
		#			ord(s[neutronFilePos+6])<<8  |
		#			ord(s[neutronFilePos+7])      ))
		t0_count+=1
	if neutronFilePos!=0:neutronFilePos+=8

    return dataVAL,(neutronFilePos,trignetFilePos),t0_count

#c-----------------------------------------------------------------------------
def decode0DDetector(s,trignetData=None,filterCondition=None,positionCondition=None):
    dataVAL=[]

    initial  = 0
    final    = len(s)

    if trignetData!=None and trignetData!=[] and filterCondition!=None:

	trignetFlag = trignetData[0]
	trignetPID  = trignetData[1]
	trignetPOS  = trignetData[2]
	trignetDataLength = len(trignetFlag)
	trignetIndex=0
	flag=False
	t0_count=0
	trignetFilePos=0
	neutronFilePos=0
	dataVALappend =dataVAL.append
	for neutronFilePos in xrange(initial,final,8):
#AS Start 20150415 kmatsu
#	    if flag and 0x5a==ord(s[neutronFilePos]): # neutron data block
#		tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
#					ord(s[neutronFilePos+2])<<8  |
#					ord(s[neutronFilePos+3]) ) )/40.0
#		#dataVAL.append(tof)
#		dataVALappend(tof)
	    if flag and 0x5a==ord(s[neutronFilePos]): # neutron data block
		ad = ( 0x01 & ( ord(s[neutronFilePos+4])))
		if ad==0:
		    tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
					ord(s[neutronFilePos+2])<<8  |
					ord(s[neutronFilePos+3]) ) )/40.0
		    dataVALappend(tof)
#AS End
	    if 0x5b==ord(s[neutronFilePos]): # T0 data block
		if trignetIndex >= trignetDataLength:
		    neutronFilePos-=8
		    break
		### compare NeutronData-T0 with TrignetData-T0 -START
		#t0 = 0xFFFFFFFFFF & (ord(s[neutronFilePos+3])<<32 |
		#			ord(s[neutronFilePos+4])<<24 |
		#			ord(s[neutronFilePos+5])<<16 |
		#			ord(s[neutronFilePos+6])<<8  |
		#			ord(s[neutronFilePos+7])      )
		#if t0<trignetPID[trignetIndex]:
		#    flag=False
		#else:
		#    while 1:
		#	if t0 <trignetPID[trignetIndex]:
		#	    flag=False
		#	    break
		#	if t0==trignetPID[trignetIndex]:
		#	    flag=True
		#	    for k in xrange(8):
		#		if filterCondition[k]!=None and \
		#		    trignetFlag[trignetIndex][k]!=filterCondition[k]:
		#		    flag=False
		#		    break
		#	    t=trignetPOS[trignetIndex]
		#	    break
		#	trignetIndex+=1
		### compare NeutronData-T0 with TrignetData-T0 -END

		trignetFilePos=trignetPOS[trignetIndex]

		#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
		#c trignet bool mode
		flag=True
		for k in xrange(8):
		    if filterCondition[k]!=None and trignetFlag[trignetIndex][k]!=filterCondition[k]:
		        flag=False
		        break
		else:
		    t0_count+=1
		#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
		#c trignet bit mode (bit mode elapsed time = bool mode elapsed time x0.8)
		#flag = (filterCondition[1] & trignetFlag[trignetIndex]) == filterCondition[0]
		#if flag:t0_count+=1
		#c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
		trignetIndex+=1
	if neutronFilePos!=0:neutronFilePos+=8
    else:
	trignetFilePos=0
	t0_count=0
	neutronFilePos=0
	dataVALappend =dataVAL.append
	for neutronFilePos in xrange(initial,final,8):
#AS Start 20150415 kmatsu
#	    if 0x5a==ord(s[neutronFilePos]): # neutron data block
#		tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
#					ord(s[neutronFilePos+2])<<8  |
#					ord(s[neutronFilePos+3]) ) ) /40
#
#		dataVALappend(tof)
	    if 0x5a==ord(s[neutronFilePos]): # neutron data block
		ad = ( 0x01 & ( ord(s[neutronFilePos+4])))
		if ad==0:
		    tof = (0xFFFFFF & ( ord(s[neutronFilePos+1])<<16 |
					ord(s[neutronFilePos+2])<<8  |
					ord(s[neutronFilePos+3]) ) )/40.0
		    dataVALappend(tof)
	    elif 0x5b==ord(s[neutronFilePos]): # T0 data bleck

		#t0 = (0xFFFFFFFFFF & (ord(s[neutronFilePos+3])<<32 |
		#			ord(s[neutronFilePos+4])<<24 |
		#			ord(s[neutronFilePos+5])<<16 |
		#			ord(s[neutronFilePos+6])<<8  |
		#			ord(s[neutronFilePos+7])      ))
		t0_count+=1
	if neutronFilePos!=0:neutronFilePos+=8

    return dataVAL,(neutronFilePos,trignetFilePos),t0_count

#c-----------------------------------------------------------------------------
def decodeMWPC(s,trignetData=None,filterCondition=None,positionCondition=None):
    return decode2DDetector1D(decodeBitInfoMWPC,s,trignetData,filterCondition,positionCondition)

#c----------------------------------------------------------------------------
def decodeMWPC2D(s,trignetData=None,filterCondition=None,tofCondition=None):
    return decode2DDetector2D(decodeBitInfoMWPC,s,trignetData,filterCondition,tofCondition)

#c-----------------------------------------------------------------------------
def decodeRPMT(s,trignetData=None,filterCondition=None,positionCondition=None):
    return decode2DDetector1D(decodeBitInfoRPMT,s,trignetData,filterCondition,positionCondition)

#c-----------------------------------------------------------------------------
def decodeRPMT2D(s,trignetData=None,filterCondition=None,tofCondition=None):
    return decode2DDetector2D(decodeBitInfoRPMT,s,trignetData,filterCondition,tofCondition)

#c-----------------------------------------------------------------------------
def decodeWLSF1(s,trignetData=None,filterCondition=None,positionCondition=None):
    return decode2DDetector1D(decodeBitInfoWLSF1,s,trignetData,filterCondition,positionCondition)

#c-----------------------------------------------------------------------------
def decodeWLSF12D(s,trignetData=None,filterCondition=None,tofCondition=None):
    return decode2DDetector2D(decodeBitInfoWLSF1,s,trignetData,filterCondition,tofCondition)

#c-----------------------------------------------------------------------------
def decodeWLSF2(s,trignetData=None,filterCondition=None,positionCondition=None):
    return decode2DDetector1D(decodeBitInfoWLSF2,s,trignetData,filterCondition,positionCondition)

#c----------------------------------------------------------------------------
def decodeWLSF22D(s,trignetData=None,filterCondition=None,tofCondition=None):
    return decode2DDetector2D(decodeBitInfoWLSF2,s,trignetData,filterCondition,tofCondition)

#c-----------------------------------------------------------------------------
def decodeWLSF3(s,trignetData=None,filterCondition=None,positionCondition=None):
    return decode2DDetector1D(decodeBitInfoWLSF3,s,trignetData,filterCondition,positionCondition)

#c----------------------------------------------------------------------------
def decodeWLSF32D(s,trignetData=None,filterCondition=None,tofCondition=None):
    return decode2DDetector2D(decodeBitInfoWLSF3,s,trignetData,filterCondition,tofCondition)

#c-----------------------------------------------------------------------------
def decodeWLSF4(s,trignetData=None,filterCondition=None,positionCondition=None):
    return decode2DDetector1D(decodeBitInfoWLSF4,s,trignetData,filterCondition,positionCondition)

#c----------------------------------------------------------------------------
def decodeWLSF42D(s,trignetData=None,filterCondition=None,tofCondition=None):
    return decode2DDetector2D(decodeBitInfoWLSF4,s,trignetData,filterCondition,tofCondition)

#c-----------------------------------------------------------------------------
def decodeBitInfoMWPC(s):
    tof = 0xFFFFFF & (ord(s[1]) |
			(ord(s[2])<<8) |
			 ord(s[3])<<16)
    x   = 0xFF & ( (ord(s[5]) & 0b00001111 ) <<4 |   #0x0F
			(ord(s[4]) & 0b11110000 ) >>4  )  #0xF0
    y   = 0xFF &    ord(s[6])
    return tof,255-y,x

#c-----------------------------------------------------------------------------
def decodeBitInfoRPMT(s):
    tof = 0xFFFFFF & (ord(s[1]) |
				 (ord(s[2])<<8) |
				  ord(s[3])<<16)

    x = 0x1FF & ( ord(s[5])<<1) | ((ord(s[4])&0b10000000)>>7)
    y = 0x1FF & ((ord(s[6])&0b11111000)>>3) | ((ord(s[7])&0b00001111)<<5)

    return tof,x,y

#c-----------------------------------------------------------------------------
def decodeBitInfoWLSF1(s):
    return decodeBitInfoWLSF(s,0b00000000)

#c-----------------------------------------------------------------------------
def decodeBitInfoWLSF2(s):
    return decodeBitInfoWLSF(s,0b01000000)

#c-----------------------------------------------------------------------------
def decodeBitInfoWLSF3(s):
    return decodeBitInfoWLSF(s,0b10000000)

#c-----------------------------------------------------------------------------
def decodeBitInfoWLSF4(s):
    return decodeBitInfoWLSF(s,0b11000000)

#c-----------------------------------------------------------------------------
def decodeBitInfoWLSF(s,detectTag):
    tof = 0xFFFFFF & (ord(s[1]) |(ord(s[2])<<8) | ord(s[3])<<16)

    x   = 0xFF & ((ord(s[5])&0b00001111)<<4) | ((ord(s[4])&0b11110000)>>4)
    y   = 0xFF & ((ord(s[6])))

    tagX=x&0b11000000
    tagY=y&0b11000000
    if tagX==detectTag and tagY==detectTag:
	    x=x&0b00111111
	    y=y&0b00111111
	    return tof,x,y
    else:
	    return tof,None,None

#c-----------------------------------------------------------------------------
def decode2DDetector1D(decodeFunc,s,trignetData=None,filterCondition=None,positionCondition=None):
    dataVAL=[]

    initial  = 0
    final    = len(s)

    if trignetData!=None and filterCondition!=None:
	trignetFlag = trignetData[0]
	trignetPID  = trignetData[1]
	trignetPOS  = trignetData[2]
	trignetDataLength = len(trignetFlag)
	trignetIndex=0
	flag=False
	t0_count=0
	trignetFilePos=0
	neutronFilePos=0
	dataVALappend =dataVAL.append
	for neutronFilePos in xrange(initial,final,8):
	    if flag and 0xb5==ord(s[neutronFilePos]): # neutron data block

		tof,x,y = decodeFunc(s[neutronFilePos:neutronFilePos+8])

		if x!=None and y!=None:
		    position=(x,y)
		    condition = checkDetectorCondition(position, positionCondition)
		    if condition:
			#dataVAL.append(tof)
			dataVALappend(tof)
	    if 0xb7==ord(s[neutronFilePos]): # T0 data block
		if trignetIndex >= trignetDataLength:
		    neutronFilePos-=8
		    break
		### compare NeutronData-T0 with TrignetData-T0 -START
		#t0  = 0x7FFFFFFF & ( (ord(s[neutronFilePos+4]) & 0b11111110) >> 1 | # 0xFE
		#			ord(s[neutronFilePos+5]) << 7  |
		#			ord(s[neutronFilePos+6]) << 15 |
		#			ord(s[neutronFilePos+7]) << 23)
		#if t0<trignetPID[trignetIndex]:
		#    flag=False
		#else:
		#    while 1:
		#	if t0 <trignetPID[trignetIndex]:
		#	    flag=False
		#	    break
		#	if t0==trignetPID[trignetIndex]:
		#	    flag=True
		#	    for k in xrange(8):
		#		if filterCondition[k]!=None and \
		#		    trignetFlag[trignetIndex][k]!=filterCondition[k]:
		#		    flag=False
		#		    break
		#	    trignetFilePos=trignetPOS[trignetIndex]
		#	    break
		#	trignetIndex+=1
		### compare NeutronData-T0 with TrignetData-T0 -END

		trignetFilePos=trignetPOS[trignetIndex]
		flag=True
		for k in xrange(8):
		    if filterCondition[k]!=None and trignetFlag[trignetIndex][k]!=filterCondition[k]:
			flag=False
			break
		else:
		    t0_count+=1
		trignetIndex+=1
	if neutronFilePos!=0:neutronFilePos+=8
    else:
	trignetFilePos=0
	t0_count=0
	neutronFilePos=0
	dataVALappend =dataVAL.append

	for neutronFilePos in xrange(initial,final,8):
	    if 0xb5==ord(s[neutronFilePos]): # neutron data block
		tof,x,y = decodeFunc(s[neutronFilePos:neutronFilePos+8])
		#tof = 0xFFFFFF & (ord(s[neutronFilePos+1]) |
		#			(ord(s[neutronFilePos+2])<<8) |
		#			ord(s[neutronFilePos+3])<<16)
		if x!=None and y!=None:
		    condition=True
		    if condition:
			dataVALappend(tof)
		    pass
	    if 0xb7==ord(s[neutronFilePos]): # T0 data block
		t0_count+=1
	if neutronFilePos!=0:neutronFilePos+=8
    return dataVAL,(neutronFilePos,trignetFilePos),t0_count

#c-----------------------------------------------------------------------------
def decode2DDetector2D(decodeFunc,s,trignetData=None,filterCondition=None,tofCondition=None):
    length =512
    dataVAL=[[0 for i in xrange(length)] for j in xrange(length)]

    initial  = 0
    final    = len(s)

    if trignetData!=None and filterCondition!=None:
	trignetFlag = trignetData[0]
	trignetPID  = trignetData[1]
	trignetPOS  = trignetData[2]
	trignetDataLength = len(trignetFlag)
	trignetIndex=0
	flag=False
	t0_count=0
	total_count=0
	trignetFilePos=0
	neutronFilePos=0
	for neutronFilePos in xrange(initial,final,8):
	    if flag and 0xb5==ord(s[neutronFilePos]): # neutron data block

		if ord(s[neutronFilePos+7])^0x3f:
		    while neutronFilePos < final and ord(s[neutronFilePos+4]) != 0xb5 and ord(s[neutronFilePos+4]) != 0xb7:
			neutronFilePos += 4
		    neutronFilePos -= 4

		else:
		    tof,x,y = decodeFunc(s[neutronFilePos:neutronFilePos+8])
		    if x!=None and y!=None:
			if tofCondition ==None or (tofCondition[0] <= tof <= tofCondition[1]):
			    dataVAL[y][x] += 1
			    total_count   += 1

	    elif 0xb7==ord(s[neutronFilePos]): # T0 data block
		if trignetIndex >= trignetDataLength:
		    neutronFilePos-=8
		    break
		### compare NeutronData-T0 with TrignetData-T0 -START
		#t0  = 0x7FFFFFFF & ( (ord(s[neutronFilePos+4]) & 0b11111110) >> 1 | # 0xFE
		#			ord(s[neutronFilePos+5]) << 7  |
		#			ord(s[neutronFilePos+6]) << 15 |
		#			ord(s[neutronFilePos+7]) << 23)
		#if t0<trignetPID[trignetIndex]:
		#    flag=False
		#else:
		#    while 1:
		#	if t0 <trignetPID[trignetIndex]:
		#	    flag=False
		#	    break
		#	if t0==trignetPID[trignetIndex]:
		#	    flag=True
		#	    for k in xrange(8):
		#		if filterCondition[k]!=None and \
		#		    trignetFlag[trignetIndex][k]!=filterCondition[k]:
		#		    flag=False
		#		    break
		#	    t=trignetPOS[trignetIndex]
		#	    break
		#	trignetIndex+=1
		### compare NeutronData-T0 with TrignetData-T0 -END

		trignetFilePos=trignetPOS[trignetIndex]

		flag=True
		for k in xrange(8):
		    if filterCondition[k]!=None and trignetFlag[trignetIndex][k]!=filterCondition[k]:
			flag=False
			break
		else:
		    t0_count+=1
		trignetIndex+=1
	    neutronFilePos+=8
	#if neutronFilePos!=0:neutronFilePos+=8
    else:
	t0_count=0
	total_count=0
	trignetFilePos=0
	neutronFilePos=0
	for neutronFilePos in xrange(initial,final,8):
	    if 0xb5==ord(s[neutronFilePos]): # neutron data block

		if ord(s[neutronFilePos+7])^0x3f:
		    while neutronFilePos < final and ord(s[neutronFilePos+4]) != 0xb5 and ord(s[neutronFilePos+4]) != 0xb7:
			neutronFilePos += 4
		    neutronFilePos -= 4

		else:
		    tof,x,y = decodeFunc(s[neutronFilePos:neutronFilePos+8])
		    if x!=None and y!=None:
			if tofCondition ==None or (tofCondition[0] <= tof <= tofCondition[1]):
			    try:
				dataVAL[y][x] += 1
			    except:
		 		print(x,y)
			    total_count   += 1
	    elif 0xb7==ord(s[neutronFilePos]): # T0 data block
		t0_count+=1
	    neutronFilePos+=8
	#if neutronFilePos!=0:neutronFilePos+=8
    #
    return dataVAL,(neutronFilePos,trignetFilePos),t0_count

#c-----------------------------------------------------------------------------
def decodeTrignet(s):

    dataPID   = []
    dataFlag  = []
    dataPOS   = []
    initial   = 0
    final     = len(s)

    val       = 0
    pid       = 0
    dioFlag=[False,False,False,False,False,False,False,False]
    dios=[0]*256
    ini_pid=None
    dio=0
    for i in xrange(initial,final,8):
	if 0x5b==ord(s[i]):
	    pid = 0xFFFFFFFFFF & ( (ord(s[i+3])<<32 |
				ord(s[i+4])<<24 |
				ord(s[i+5])<<16 |
				ord(s[i+6])<<8  |
				ord(s[i+7]) ) )

	    dataPID.append(pid)
	    #c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	    # c trignet bool mode
	    dataFlag.append(dioFlag)
	    #c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	    # c trignet bit mode (bit mode elapsed time = bool mode elapsed time x0.8)
	    #if dio==None:
	    #    dataFlag.append(0)
	    #else:
	    #    dataFlag.append(dio)
	    #c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	    dataPOS.append(i+8)
	    if dio!=None:
		dios[dio]+=1
	elif 0x54==ord(s[i]):
	    dioFlag = [ bool(ord( s[i+7] ) & (1 << j)) for j in xrange(8)]
	    dio=int(ord(s[i+7]))

    #print ""
    #for i in xrange(256):
	#if dios[i]>0:
	#    print "DIO-T0 Entry",i,"\t",\
	#	dios[i],"\t",[ bool(i & (1 << j)) for j in xrange(8)]
    #print ""
    return dataFlag,dataPID,dataPOS

#c------------------------------------------------------------------------------
def checkDetectorCondition(position,positionCondition):

    if positionCondition==None:
	xCondition = True
	yCondition = True
    else:
	x,y=position
	xpositionCondition,ypositionCondition = positionCondition
	xCondition = xpositionCondition[0]<= x <=xpositionCondition[1]
	yCondition = ypositionCondition[0]<= y <=ypositionCondition[1]

    return xCondition and yCondition
#c-------------------------------------------------------------------------------
def getData(runNo,dirname,detector,positionCondition,filterCondition,binType,binInfo,
			  preHistDataY=None,preT0Count=0,trignetFilePosition=None,neutronFilePosition=None):

    if filterCondition!=None:
	trignetData  = getTrignetData(runNo,dirname,filePosition=trignetFilePosition)
    else:
	trignetData  = None

    histDatas = getNeutronData(runNo, dirname, detector=detector,
			binInfo=binInfo, binType=binType,
			t0Normalize=False, trignetData=trignetData,
			filterCondition=filterCondition,
			positionCondition=positionCondition,
			filePosition=neutronFilePosition)

    histDataX=[]
    for val in histDatas[1]:
	histDataX+=[val,val]
    histDataX=histDataX[1:-1]

    histDataY=[]
    for val in histDatas[0]:
	histDataY+=[val,val]

    if preHistDataY!=None:
	histDataY = [y1+y2 for y1,y2 in zip(histDataY,preHistDataY)]

    if trignetFilePosition==None:
	trignetPos=histDatas[3][1]
    else:
	trignetPos=trignetFilePosition+histDatas[3][1]

    if neutronFilePosition==None:
	neutronPos=histDatas[3][0]
    else:
	neutronPos=neutronFilePosition+histDatas[3][0]

    total=sum(histDataY)/2
    t0Count=histDatas[2]+preT0Count

    #print ""
    #print "Neutron Data End Position :",neutronPos
    #print "Trignet Data End Position :",trignetPos
    #print "T0 Count			  :",t0Count
    #print "Total Count		       :",total
    #print ""
    return histDataX,histDataY,t0Count,(neutronPos,trignetPos)

#c-------------------------------------------------------------------------------
if __name__ == '__main__':
    import pylab
    MODE ="1D"

    #runNo	= 122080
    runNo	= 120965
    #detector	= "WLSF1"
    #detector	= "MWPC"
    detector	= "0D"
    #detector	= "RPMT"

    #filterCondition  = [False, True, False, False, True, True, False, False]
    #filterCondition   = None
    filterCondition  = [None, True, None, None, True, True, None, None]

    dirname = '/data/VNR'

    trignetData       = getTrignetData(runNo, dirname)
    #trignetData       = None
    tofCondition      = [0,120000]

    if MODE=="1D":
	# positionCondition = [[0,256],[0,256]]
	positionCondition = None
	binType=0
	#binInfo=(0,40000,100)
	binInfo=(10000,40000,100)

	#histDataX, histDataY, t0Count, (neutronPos,trignetPos) = getData(runNo,dirname,detector,positionCondition,filterCondition,binType,binInfo)

	histDatas    = getNeutronData(runNo, '/data/VNR', detector=detector, binInfo=binInfo, binType=binType,
				t0Normalize=True, trignetData=trignetData,
				filterCondition=filterCondition,
				positionCondition=positionCondition)

	histDataX= (histDatas[1][1:]+histDatas[1][:-1])*0.5
	histDataY= histDatas[0]

	#histDataX=[]
	#for val in histDatas[1]:
	#    histDataX.append(val)
	#    histDataX.append(val)
	#histDataX=histDataX[1:-1]

	#histDataY=[]
	#for val in histDatas[0]:
	#    histDataY.append(val)
	#    histDataY.append(val)

	pylab.xticks(rotation=25)
	pylab.plot(histDataX, histDataY)
	pylab.show()

    if MODE=="2D":
	histDatas = getNeutronData2D(runNo,'/data/VNR', detector=detector,
				tofCondition=tofCondition,
				trignetData=trignetData,
				filterCondition=filterCondition)
	z=histDatas[0]
	x=xrange(512)
	y=xrange(512)
	X,Y = np.meshgrid(x,y)
	Z = np.array(z)

	pylab.pcolormesh(X,Y,Z)
	pylab.ylim(0,512)
	pylab.xlim(0,512)
	pylab.colorbar()
	pylab.show()

