# -*- coding: utf-8 -*-
"""

"""
import vis.DetectMap as dpc
import time
import vis.MPlot as mp
import vis.M2Plot as mp2

# 予約語の定義
ret = None 
vp1 = None
vp2 = None
vc = None
vc2 = None
vc3 = None
ec = None
earray = None
DAT = None
ECM = None
vcm = None
        
###################################################                            
def DetectMap(matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT] ElementContainerMatrix Object 
        @retval None
        """ 
	## Check Size of ElementContainers (pixels) in a ElementContainer( PSD )
	v_size = 0.0
	for i in range( matrix.PutSize() ):
		if v_size==0.0:
			v_size = matrix(i).PutSize()
		elif v_size!=(matrix(i).PutSize()):
			raise UserWarning,"Data includes several banks which the number of pixels are different"
		
        dpc.MapFrame(None, matrix)    
        

###################################################                         
def MPlot(ec=ec):
        """
        Create 1D Plotter and Draw EC
        @param  ec [Def:EC] ElementContainer
        @param  psd      PSD No.    
        @param  pixel    Pixel No.    
        @retval vp1    Instance of Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
	p=mp.MPlot(ec, True)
	
	a_ec = None
	if isinstance( ec, list ):
		a_ec = ec[0]
	else:
		a_ec = ec
	
	h=a_ec.PutHeaderPointer()
	
	if h.CheckKey("XLABEL")==1:
		p.SetXLabel( h.PutString("XLABEL") )
	if h.CheckKey("YLABEL")==1:
		p.SetYLabel( h.PutString("YLABEL") )
	if h.CheckKey("XAxis")==1:
	#	if (h.PutString("XAxis") == "Q"):
	#		p.SetLogX(True)
	#		p.SetXScale(0.03,2)
	#		p.SetLog(True)
	#		p.SetYScale(1e-07,2.0)
	#	elif (h.PutString("XAxis") == "TOF"):
	#		p.SetLog(True)
	#		p.SetYScale(1e-07,2.0)
		p.SetPlotParam(0, ls="-")
	#p.SetMainTitle( title )
        return p
    
###################################################                            
def AddToMPlot(vp1=vp1, ec=ec):
        """
        Add EC to 1D Plotter
        @param  vp1 [Def:vp1] Instance of 1D Plotter
        @param  ec  [Def:EC] ElementContainer
        @retval None
        """ 
        vp1.AddData(ec)  
        
###################################################                         
def M2Plot(matrix=ECM):
        """
        Create 2D Plotter and display 2D Map
        @param  matrix [Def:ECA] ElementContainerArray
        @retval vp2 [Def:vp2] Instance of 2D Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
        return mp2.M2Plot(matrix, True)

###################################################
def ChangeMap(vp2=vp2, matrix=ECM):
        """
        Change 2D Map of M2Plot
	@param  vp2   [Def:vp2]  Instance of 2D Plotter
        @param  matrix [Def:DAT] ElementContainerArray
        @retval None
        """ 
        # Map データの変更
        vp2.ChangeMap(matrix)	

           

# 関数名登録ディクショナリ
_functions = {"DetectMap":DetectMap,
              "MPlot":MPlot,
              "AddToMPlot":AddToMPlot,
              "M2Plot":M2Plot,
	      "ChangeMap":ChangeMap,
	      }
         
_functionsOrder = [
	"DetectMap",
	"MPlot",
	"AddToMPlot",
	"M2Plot",
	"ChangeMap",
	]
