#!/usr/bin/python3
# -*- coding: utf-8 -*-

import utsusemi.SAS.ana.Reduction.FileBaseCommands as FBC

# reserved words for return value in this.
DAT = None
ecs = None
EC = None
ret = None
PyObj = None
Iq = None
Tr = None
ECA = None

#########################################                                
def Save1dDataToText(dat=EC, dirpath = "/home/mlfdev/users", filename="SAS104000.dat", prec=6):
    """
    Save 1d data to text file(s).
    @param dat       (ElementContainer or list of I(q)) 1d data
    @param dirpath   (string)           directory where files are saved
    @param filename  (string)           filename
    @param prec      (int)              precision
    """
    FBC.Save1dDataToText(dat, dirpath, filename, prec)

#########################################                                
def Save1dDataToSrlz(dat=EC, dirpath = "/home/mlfdev/users", filename="SAS104000.srlz"):
    """
    Save 1d data to text file(s).
    @param dat       (ElementContainer or list of I(q)) 1d data
    @param dirpath   (string)           directory where files are saved
    @param filename  (string)           filename
    """
    FBC.Save1dDataToSrlz(dat, dirpath, filename)

#########################################                                
def SaveQzToText(dat=ECA, dirpath = "/home/mlfdev/users", filename="SAS104000_Qz.dat"):
    """
    Save Qz to a text file.
    @param dat          Qz ElementContainerArray
    @param dirpath      directory where files are saved
    @param filename     filename
    @param prec         precision
    """
    FBC.SaveQzToText(dat, dirpath, filename)

#########################################                                
def SaveIqToText(dat=Iq, dirpath = "/home/mlfdev/users", filename="SAS104000_Iq.dat", prec=6):
    """
    Save I(q) to a text file.
    @param dat         I(q) data which is list of ElementContainers
    @param dirpath      directory where files are saved
    @param filename     filename
    @param prec         precision
    """
    FBC.SaveIqToText(dat, dirpath, filename, prec)

#########################################                                
def ManyoDeserializationEC(dirpath = ".", filename=""):
    """
    Deserialize an EC file by Manyo-Lib.
    @param dirpath              directory where files are saved
    @param filename             filename
    @retval EC                 ElementContainer
    """
    return FBC.ManyoDeserializationEC(dirpath, filename)

#########################################                                
def ManyoDeserializationECM(dirpath = ".", filename=""):
    """
    Deserialize an ECM file by Manyo-Lib.
    @param dirpath              directory where files are saved
    @param filename             filename
    @retval DAT                 ElementContainerMatrix
    """
    return FBC.ManyoDeserializationECM(dirpath, filename)

#########################################                                
def ManyoSerialization(dat=DAT, dirpath = "/home/mlfdev/users", filename="SAS104000.srlz"):
    """
    Serialize data by Manyo-Lib.
    @param dat                  data container
    @param dirpath              directory where files are saved
    @param filepath             filename
    """
    FBC.ManyoSerialization(dat, dirpath, filename)

#########################################
def SaveRPMTToText(dat=DAT, dirpath="./", filename="SAS000001_RPMT.txt", lambdaRange="0.7 7.5"):
    """
    Save RPMT data to text
    @param dat             ElementContainerMatrix
    @param dirpath         directory where files are saved
    @param lambdaRange
    @param filepath        file name
    """
    FBC.SaveRPMTToText(dat, dirpath, filename, lambdaRange)

#########################################
def SaveQSpaceToText(dat=DAT, dirpath="/home/mlfdev/users", filename="SAS000001_QSpace.txt", QxRange="1.0 1.2", QyRange="-0.1 0.1", QzRange="-0.4 -0.2", cutoff=0.01):
    """
    Save Q space data to text
    @param dat      (ElementContainerMatrix) Q space ECM
    @param dirpath  (string) Directory where files are saved
    @param filename (string) File name
    @param QxRange  (string) Minimum and maximum qx separated with space
    @param QyRange  (string) Minimum and maximum qy separated with space
    @param QzRange  (string) Minimum and maximum qz separated with space
    @param cutoff   (float) Cutoff value for intensity. If it is negative, it is ignored.
    """
    FBC.SaveQSpaceToText(dat, dirpath, filename, QxRange, QyRange, QzRange, cutoff)

# Dictionary for entry the name of functions
_functions = {
            "Save1dDataToText":Save1dDataToText,
            "Save1dDataToSrlz":Save1dDataToSrlz,
            "ManyoDeserializationEC":ManyoDeserializationEC,
            "ManyoDeserializationECM":ManyoDeserializationECM,
            "ManyoSerialization":ManyoSerialization,
            "SaveQzToText":SaveQzToText,
            "SaveIqToText":SaveIqToText,
            "SaveRPMTToText":SaveRPMTToText,
            "SaveQSpaceToText":SaveQSpaceToText,
            }
