#ifndef BOSEFACTORCHOPPERS
#define BOSEFACTORCHOPPERS

#include "UtsusemiHeader.hh"

//////////////////////////////////
// Bose factor collection
/////////////////////////////////

//! Function to calculate Bose Factor and correct
/*! 
 * 
 */
class BoseFactorChoppers :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    double TargetTemp;
    string Process_Key;
    string commentHead;
    void Initialize();
    void CheckECM();

public:

    BoseFactorChoppers();
        //!< Constructor
        /*!<
         */
    ~BoseFactorChoppers();
        //!< Destructor
        /*!<
         */
    BoseFactorChoppers( ElementContainerMatrix* ecm );
        //!< Constructor
        /*!<
         *  @param ecm  target ElementContainerMatrix
         */
    BoseFactorChoppers( ElementContainerMatrix* ecm, double temp );
        //!< Constructor
        /*!<
         *  @param ecm    target ElementContainerMatrix
         *  @param temp   Temperature
         */
    void SetTemperature( double temp );
        //!< Sets temperature
        /*!<
         *  @param temp   Temperature
         */
    void DoCorrection();
        //!< executes corrections
        /*!<
         *  @return None
         */

};
#endif
