#ifndef WIRINGINFOEDITORREADOUT
#define WIRINGINFOEDITORREADOUT

#include "WiringInfoEditorBase.hh"
#include <algorithm>


class UtsusemiReadoutGateInfo
{
public:
    UtsusemiReadoutGateInfo();
    UtsusemiReadoutGateInfo( const UtsusemiReadoutGateInfo &obj );
    ~UtsusemiReadoutGateInfo();
    Int4 DaqId;
    Int4 ModNo;
};
class WiringInfoEditorReadout:
    public WiringInfoEditorBase
{
private:
    std::string _MessageTag;

protected:
    bool _makeOutputXmlReadout();

public:
    std::vector< UtsusemiReadoutGateInfo* > ReadoutGateStore;

    static const std::string TYPEOFREADOUTGATE;
    static const Int4 DUMP_READOUTGATEINFO;

    WiringInfoEditorReadout();
        //!< Constructor
        /*!<
         */
    WiringInfoEditorReadout( std::string wfile, bool workAsReader=true );
        //!< Constructor
        /*!<
         *   @params wfile (std::string) wiring file path
         *   @param workAsReader (bool)
         */
    ~WiringInfoEditorReadout();
        //!< Destructor
        /*!<
         */
    void Clear( UInt4 index=0 );
        //!< Clears stored parameters
        /*!<
         *   This deletes information by given index.
         *    index = 0 : all (default)
         *    index = 1 : PixelInfo ( and DetInfoList )
         *    index = 2 : TofBinPtnInfo
         *    index = 3 : TofBinInfo
         *    index = 4 : FrameBoundaryInfo
         *    index = 5 : TrigInfoStore
         *    index = 6 : TofMaskPtn
         *    index = 7 : PsdParams
         *    index = 8 : PsdBinInfo
         *    index = 9 : ReadoutGateInfo
         *
         *   @param index (UInt4)
         *   @return None
         */
    bool Read( std::string arg );
        //!< Reads WiringInfo.xml and import information
        /*!<
         *   @param arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string
         *   @retval true : succeeded
         *   @retval false: failed
         */
    bool Write( std::string filepath );
        //!< Writes WiringInfo.xml
        /*!<
         *   @param filepath (std::string)
         *   @retval true : succeeded
         *   @retval false: failed
         */
    std::string OutXml( bool withIndent=false );
        //!< Returns WiringInfo as std::string
        /*!<
         *   @param withIndent(bool) false : output xml without an indent format
         *   @return std::string
         */
    void ImportReadoutGateInfo();

    void Dump( Int4 index=DUMP_ALL );
    bool SetInfoAsReader();

};
#endif
