#include "WiringInfoEditorReadout.hh"
//////////////////////////////////////////////////////////
UtsusemiReadoutGateInfo::
UtsusemiReadoutGateInfo(){
    DaqId=-1;
    ModNo=-1;
}
//////////////////////////////////////////////////////////
UtsusemiReadoutGateInfo::
UtsusemiReadoutGateInfo( const UtsusemiReadoutGateInfo &obj ){
    DaqId=obj.DaqId;
    ModNo=obj.ModNo;
}
//////////////////////////////////////////////////////////
UtsusemiReadoutGateInfo::
~UtsusemiReadoutGateInfo(){
}
//////////////////////////////////////////////////////////
WiringInfoEditorReadout::
WiringInfoEditorReadout(){
    _MessageTag = "WiringInfoEditorReadout::";

}
//////////////////////////////////////////////////////////
WiringInfoEditorReadout::
WiringInfoEditorReadout(std::string wfile, bool workAsReader ){
    _MessageTag = "WiringInfoEditorReadout::";
    ReadoutGateStore.clear();
    _Status = Read( wfile );
    if (_Status)
        _Status = SetInfoAsReader();

}
//////////////////////////////////////////////////////////
WiringInfoEditorReadout::
~WiringInfoEditorReadout(){
    Clear(0);
}
const std::string WiringInfoEditorReadout::TYPEOFREADOUTGATE="READOUTGATE";
const Int4 WiringInfoEditorReadout::DUMP_READOUTGATEINFO=13;
//////////////////////////////////////////////////////////
void WiringInfoEditorReadout::
Clear( UInt4 index ){
    WiringInfoEditorBase::Clear( index );
    if ((index==0)||(index==9)){
        for (UInt4 i=0; i<ReadoutGateStore.size(); i++)
            if (ReadoutGateStore[i]!=NULL) delete ReadoutGateStore[i];
        ReadoutGateStore.clear();
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorReadout::
Read( std::string arg ){
    if (WiringInfoEditorBase::Read( arg )){
        ImportReadoutGateInfo();
        return true;
    }
    return false;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorReadout::
Write( std::string filepath ){

    if (_makeOutputXmlReadout()){
        _parser->Save( KEY_WRITE_XML, filepath );
    }else{
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
std::string WiringInfoEditorReadout::
OutXml( bool withIndent ){
    if (_makeOutputXmlReadout()){
        return _parser->OutToString( KEY_WRITE_XML, "", withIndent );
    }else{
        UtsusemiError( _MessageTag+"OutXml : false to make output XML from given information. " );
        return "";
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorReadout::
ImportReadoutGateInfo(){
    if (_parser->hasPath( KEY_READ_XML,TAG.WINFO )){
        std::string pixelinfo_path = TAG.WINFO+"/"+TAG.WINFO_PIXELINFO;
        if (_parser->hasPath( KEY_READ_XML,pixelinfo_path )){
            std::string daq_path = pixelinfo_path+"/"+TAG.WINFO_PIXELINFO_DAQ;
            std::vector<std::string> daqId_list = _parser->PutAttValList( KEY_READ_XML, daq_path, TAG.WINFO_PIXELINFO_DAQ_AT_ID );
            for (std::vector<std::string>::iterator it_daqId=daqId_list.begin(); it_daqId!=daqId_list.end(); ++it_daqId ){
                std::string a_daq_path = daq_path+","+TAG.WINFO_PIXELINFO_DAQ_AT_ID+"="+(*it_daqId);

                std::vector<std::string> modNo_list = _parser->PutAttValList( KEY_READ_XML, a_daq_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD, TAG.WINFO_PIXELINFO_DAQ_MOD_AT_NO );
                for (std::vector<std::string>::iterator it_modNo=modNo_list.begin(); it_modNo!=modNo_list.end(); ++it_modNo){
                    std::string mod_path = a_daq_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD+","+TAG.WINFO_PIXELINFO_DAQ_MOD_AT_NO+"="+(*it_modNo);
                    std::string det_type = _parser->PutContent( KEY_READ_XML, mod_path, TAG.WINFO_PIXELINFO_DAQ_MOD_AT_TYPE );
                    UInt4 daqId = _st->StringToUInt4( (*it_daqId) );
                    UInt4 modNo = _st->StringToUInt4( (*it_modNo) );

                    if (det_type.find(TYPEOFREADOUTGATE)!=std::string::npos){
                        _AllocatePixelInfo( daqId, modNo );
                        PixelInfo->at(daqId)->ModList[modNo]->type = TYPEOFREADOUTGATE;
                        SetIgnoreModuleType( TYPEOFREADOUTGATE ); //[inamura 170117]
                        //if (PixelInfo->at(daqId)->ModList[modNo]->isAlive) std::cout << "@@@@ isAlive ###"<<std::endl;
                        UtsusemiReadoutGateInfo* tmp = new UtsusemiReadoutGateInfo;
                        tmp->DaqId = daqId;
                        tmp->ModNo = modNo;
                        ReadoutGateStore.push_back(tmp);
                    }
                }
            }
        }
    }
}

//////////////////////////////////////////////////////////
void WiringInfoEditorReadout::
Dump( Int4 index ){
    WiringInfoEditorBase::Dump( index );
    if  ((index==DUMP_ALL)||(index==DUMP_READOUTGATEINFO)){
        std::cout << "======== ReadoutGateInfo ========" << std::endl;
        for (UInt4 i=0; i<ReadoutGateStore.size(); i++){
            if (ReadoutGateStore[i]!=NULL){
                std::cout << "DaqId=" << ReadoutGateStore[i]->DaqId << std::endl;
                std::cout << "ModuleNo=" << ReadoutGateStore[i]->ModNo << std::endl;
            }
        }
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorReadout::
_makeOutputXmlReadout(){
    if (WiringInfoEditorBase::_makeOutputXml()){
    }else{
        UtsusemiError(_MessageTag+"_makeOutputXmlReadout >> _makeOutputXml fails");
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorReadout::
SetInfoAsReader(){
    return WiringInfoEditorBase::SetInfoAsReader();

}


