#ifndef VANADIUMTOOLSCHOPPERS
#define VANADIUMTOOLSCHOPPERS

#include "Header.hh"
#include "ElementContainer.hh"
#include "ElementContainerMatrix.hh"
#include "ElementContainerArray.hh"
#include "TofToEnergyTransfer.hh"
#include "TofToEnergyChoppers.hh"

//////////////////////////////////
// VanadiumToolsChopeprs
/////////////////////////////////

//! Methods to correct data by Vanadium measurements
/*!
 *
 *
 *
 *
 */

class VanadiumToolsChoppers{
private:
    ElementContainerMatrix *keptECM;
    bool CheckDataProcessed( ElementContainerMatrix *ecm, std::string process );
    ElementContainer SummationEnergyRegion( ElementContainerMatrix *ecm, double Emin, double Emax );
    std::string CommentHead;

protected:


public:
    VanadiumToolsChoppers();
        //!< Constructor
        /*!<
         */
    ~VanadiumToolsChoppers();
        //!< Destructor
        /*!<
         */
    ElementContainer MakeWhiteVanData( ElementContainerMatrix *ecm, double Emin, double Emax, double tof_offset );
        //!< makes temporary data for white vanadium correction
        /*!<
         *
         *   @param ecm         Target ElementContainerMatrix
         *   @param Emin        minimum energy in summation region [meV]
         *   @param Emax        maximum energy in summation region [meV]
         *   @param tof_offset  T0 offset value ( has dependency on Energy..)
         *   @return ElementContainer for temporary data for white van correction
         */
    ElementContainer MakeWhiteVanData( ElementContainerMatrix *ecm, double Emin, double Emax );
        //!< makes temporary data for white vanadium correction
        /*!<
         *   This execute MakeWhiteVanData with tof_offset = 0.0
         *   @param ecm         Target ElementContainerMatrix
         *   @param Emin        minimum energy in summation region [meV]
         *   @param Emax        maximum energy in summation region [meV]
         *   @return ElementContainer for temporary data for white van correction
         */
    ElementContainer MakeMonoVanData( ElementContainerMatrix *ecm, double Ei, double deltaEi, double tof_offset );
        //!< makes temporary data for monochromatic vanadium correction
        /*!<
         *
         *   @param ecm         Target ElementContainerMatrix
         *   @param Ei          Incident energy [meV]
         *   @param deltaEi     width of integration region around Ei [meV]
         *   @param tof_offset  T0 offset value ( has dependency on Energy..)
         *   @return ElementContainer for temporary data for white van correction
         */
    ElementContainer MakeMonoVanData( ElementContainerMatrix *ecm, double deltaEi );
        //!< makes temporary data for monochromatic vanadium correction
        /*!<
         *   This execute MakeMonoVanData with Ei imported from Header of Target ECM and tof_offset=0.0
         *   @param ecm         Target ElementContainerMatrix
         *   @param deltaEi     width of integration region around Ei [meV]
         *   @return ElementContainer for temporary data for white van correction
         */
    void CorrectWhiteVan( ElementContainerMatrix *data, ElementContainer wvdata );
        //!< executes correction by white van temporary data
        /*!<
         *   This divides sample data by white van data
         *   @param data        Target ElementContainerMatrix
         *   @param wvdata      white vanadium temporary data
         *   @return None
         */
    ElementContainerMatrix CorrectMonVan( ElementContainerMatrix data, ElementContainer mvdata );
        //!< executes correction by mono van temporary data
        /*!<
         *   This divides sample data by mono van data
         *   @param data        Target ElementContainerMatrix
         *   @param mvdata      monochromatic vanadium temporary data
         *   @return corrected ElementContainerMarix
         */
    ElementContainerMatrix CorrectAllVan( ElementContainerMatrix data, ElementContainer wvdata, ElementContainer mvdata, ElementContainer wmvdata );
        //!< executes correction by both mono and white van temporary data
        /*!<
         *   This divides sample data by both van temporary data
         *   @param data        Target ElementContainerMatrix
         *   @param wvdata      white vanadium temporary data
         *   @param mvdata      monochromatic vanadium temporary data
         *   @param wmvdata     white vanadium at measurement for monochromatic vanaium
         *   @return corrected ElementContainerMarix
         */
    //ElementContainer EncodeVanContainer( ElementContainerMatrix ecm );
    //ElementContainerMatrix DecodeVanContainer( ElementContainer ec );
    ElementContainerMatrix MakeVanECM( ElementContainer ec );
        //!< Puts temporary vanadium data as a format of ElementContainerMatrix
        /*!<
         *   This is used to check how is temporary vanadium data
         *   Before executing this, you must do MakeWhiteVanData or MakeMonoVanData.
         *   @param ec      white or mono vanadium temporary data
         *   @return None
         */
    ElementContainerMatrix MakeVanECM( ElementContainer ec, ElementContainerMatrix ecm );
        //!< Puts temporary vanadium data as a format of ElementContainerMatrix
        /*!<
         *   This makes ElementContainerMatrix of temporary vanaium data
         *   by using given ElementContainer as a base format.
         *
         *   @param ec      white or mono vanadium temporary data
         *   @param ecm     ElementContainerMatrix as a base format
         *   @return None
         */
};
#endif
