#ifndef UTSUSEMIWIRINGINFOEDITORTEMPLATE_HH
#define UTSUSEMIWIRINGINFOEDITORTEMPLATE_HH


/* Header.hh should be included on the top to avoid environments
 * specific issues (see Header.hh for the detail).
 */
#include "Header.hh"

#include  <boost/filesystem.hpp>

#include "UtsusemiHeader.hh"
#include "StringTools.hh"
#include "UtsusemiAnaEnvironReader.hh"
#include "WiringInfoConversionDictionary.hh"
#include "WiringInfoEditorBase.hh"

template <typename T1>
class UtsusemiWiringInfoEditorTemplate
{
private:
    void Initialize();

    StringTools* _stools;
    std::string _MessageTag;
    WiringInfoConversionDictionary *_WD;

protected:
    T1* _WE;


    UInt4 _tofBinPtnId;
    Double _tofOffset;
    Int4 _tofMaskPtnId;
    Int4 _tofOriginShiftByLambda_type;
    std::vector<Double> _tofOriginShiftByLambda_params;
    std::vector<Double> _tofOriginShiftByLambda_lambda;

    std::string _wiringInfoPath;
    //std::string _maskInfoPath;    //[inamura 160830]


public:
    UtsusemiWiringInfoEditorTemplate();
        //!< Constructor
        /*!<
         */
    ~UtsusemiWiringInfoEditorTemplate();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////
    bool _Status;
    std::string _DetType;
    UInt4 _runNo;
    std::vector<UInt4> _runNos;
    std::string _maskInfoPath;     //[inamura 160830]
    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    bool SetRunNo( UInt4 runNo, UInt4 mode_no=0, std::string env_file="" );
    bool SetRunNo( std::string runNos, std::string mode_no="0", std::string env_file="" );
    bool SetRunNo( UInt4 runNo, std::string wfile );
        //!< sets run No and environ_ana.xml
        /*!< This set run number and read environ_ana.xml
         *   to select WiringInfo and DetecorInfo suitable for the run number.
         *   If evn_file is empty(), this uses ${UTSUSEMI_BASE_DIR}/${UTSUSEMI_INST_CODE}/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml.
         *   If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath.
         *       bool SetRunNo( UInt4 runNo, std::string env_file="" )
         *       bool SetRunNo( std::string runNos, std::string env_file="" )
         *
         *   @param runNo    (UInt4)  run number
         *   @param runNos   (std::string) run numbers. format : "1234,1235"
         *   @param env_file (std::string) environ_ana.xml which includes several WiringInfo and DetectorInfo for each run number.
         *   @param wfile    (std::string) set directly WiringInfo file
         *   @retval true     : succeeded
         *   @retval false    : failed
         */
    bool SetRunNoWithWiringInfo( std::string runNos, std::string wfile );//[inamura 170404]
    bool SetConversionParameter( std::string params, UInt4 _ptnId=0 );
        //!< sets conversion parameter for histogram creations
        /*!<     bool SetConversionParameter( std::string params, UInt4 _ptnId=0 )
         *       Format of params
         *        TOF
         *         delta-TOF const :  tof,<min_tof>,<max_tof>,<delta_tof>
         *         d-TOF/TOF const : rtof,<min_tof>,<max_tof>,<racio>
         *
         *        TOF with time forcusing
         *          delta-TOF const : tf-tof,<min_tof>,<max_tof>,<delta_tof>
         *          d-TOF/TOF const : tf-rtof,<min_tof>,<max_tof>,<racio>
         *
         *        Lambda
         *          delta-lambda const        :  lambda,<min_lambda>,<max_lambda>,<delta_lambda>
         *          delta-lambda/lambda const : rlambda,<min_lambda>,<max_lambda>,<racio>
         *
         *        Energy
         *           energy,<min_energy>,<max_energy>,<delta_energy>
         *
         *        Momentum Transfer
         *            q,<min_Q>,<max_Q>,<delta_Q>[,<ki_x>,<ki_y>,<ki_z>]
         *
         *        Energy Transfer
         *            hw,<Ei>,<min_hw>,<max_hw>,<delta_hw>[,<t0_shift>]
         *
         *        d-value
         *            d,<min_d-val>,<max_d-val>,<delta_d-val>
         *
         *   @param params   (std::string) parameters for histogram ceration
         *   @param _ptnId   (UInt4)  ID of this parameters in WiringInfo
         *   @retval true    : succeeded
         *   @retval false   : failed
         */
    bool SetDetRange( std::string params="All" );
        //!< sets detector range for histogram creations
        /*!<     bool SetDetRange( std::string params="All" )
         *       Format of params
         *        "All[:<number_of_pixels>]"                     : use all detectors
         *        "<startDetId>-<endDetId>[:<number_of_pixels>]" : use detectors from <startDetId> to <endDetId>
         *        ( "X-Y:Z,A-B:C,D-E:F..." can be used for more settings in my plan )
         *
         *   @param params   (std::string) parameters for histogram ceration
         *   @retval true    : succeeded
         *   @retval false   : failed
         */
    bool SetFrameInfo( std::string params="None" );
        //!< sets Frame Info for histogram creations
        /*!<     bool SetFrameInfo( std::string params )
         *       Format of params
         *
         *   @param params   (std::string) parameters for histogram ceration
         *   @retval true    : succeeded
         *   @retval false   : failed
         */
    bool SetMaskInfo( std::string params="NoFile", UInt4 _ptnId=0 );
        //!< sets MASK histogram creations
        /*!<     bool SetMaskInfo( std::string params="NoFile", UInt4 _ptnId=0 )
         *       Format of params
         *        "<Mask.xml>[,<TOF-Mask from>-< to > [,<TOF-Mask from>-<to>] ]"
         *            - Mask.xml = "NoFile" if no mask.
         *
         *   @param params   (std::string) detector parameters for histogram ceration
         *   @param _ptnId   (UInt4)  ID of this parameters in WiringInfo
         *   @retval true    : succeeded
         *   @retval false   : failed
         */
    //[inamura 160809]-->
    bool SetTimeDependBackGroundInfo( std::string params="None" );
        //!< sets Tof region to be used for TimeDependBackground correction
        /*!<     bool SetTimeDependBackGroundInfo( std::string params="None" )
         *       Format of params
         *        "None" : not used this background correction
         *        "tof0-tof1" : tof0 is start tof of region, tof1 is last of region
         *
         *   @param params   (std::string) TimeDepend BackGroundRegion
         *   @retval true    : succeeded
         *   @retval false   : failed
         */
    //<--[inamura 160809]
    std::string MakeTempWiringInfo( std::string _path="", bool asFile=false );
        //!< make and save the temporal wiring info to create histogram
        /*!< this returns a path of the saved temporal wiring info file
         *       std::string MakeTempWiringInfo()
         *
         *   @param None
         *   @return (std::string) : the path of output wiring info file
         */
    bool SetDetParam( std::string params="psd" );
        //!< sets detector type
        /*!<     bool SetDetParam( std::string params="psd" )
         *       Format of params
         *        "<detType>"
         *            - detType in {"psd","n2mon","psd-ph","n2mon-ph"}
         *
         *   @param params   (std::string) detector type for histogram creation
         *   @retval true    : succeeded
         *   @retval false   : failed
         */
    UInt4 PutNumOfPixelForDet(UInt4 _detId=0);
};
#include "UtsusemiWiringInfoEditorTemplate.cc"

#endif
