#ifndef UTSUSEMIWIRINGINFOEDITORNEUNET
#define UTSUSEMIWIRINGINFOEDITORNEUNET

/* Header.hh should be included on the top to avoid environments
 * specific issues (see Header.hh for the detail).
 */
#include "Header.hh"

#include  <boost/filesystem.hpp>
#include "UtsusemiHeader.hh"
#include "StringTools.hh"
#include "WiringInfoEditorNeunet.hh"
#include "UtsusemiWiringInfoEditorTemplate.hh"

class UtsusemiWiringInfoEditorNeunet:
    public UtsusemiWiringInfoEditorTemplate< WiringInfoEditorNeunet >
{
private:
    void Initialize();
    std::string _MessageTag;

protected:


public:
    UtsusemiWiringInfoEditorNeunet();
        //!< Constructor
        /*!<
         */
    ~UtsusemiWiringInfoEditorNeunet();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////
    bool _Status;
    bool _withPH;
    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    bool SetDetParam( std::string params="psd" );
        //!< sets detector parameter to use for histogram creations
        /*!<     bool SetDetParam( std::string params="psd" )
         *       Format of params
         *        "<detType>[,<LLD_min> [-<LLD_max>] ]"
         *            - detType in {"psd","n2mon","psd-ph","n2mon-ph"}
         *            - "-PH" means that Pulse Height is calculated at the same time
         *            - default values for LLD are min=0, max=10000
         *
         *   @param params   (std::string) detector parameters for histogram ceration
         *   @retval true    : succeeded
         *   @retval false   : failed
         */

};
#endif
