#ifndef UTSUSEMIEVENTDATACONVERTERNEUNETWITHPHDEP
#define UTSUSEMIEVENTDATACONVERTERNEUNETWITHPHDEP

#include "Header.hh"
#include "UtsusemiEventDataConverterTemplateWithPHDep.hh"
#include "UtsusemiEventCasesDecoderTemplate.hh"
#include "UtsusemiNeunetEventDecoderBase.hh"
#include "UtsusemiFilterTrignet.hh"
#include "UtsusemiGetNeunetHistogram.hh"
#include "T0TreatToolsNeunet.hh"
#include "HeaderBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "StringTools.hh"
#include "SearchInHeader.hh"
////////////////////////////////////
// UtsusemiEventDataConverterNeunetWithPHDep
///////////////////////////////////

//! Load Event Data and convert to Histogram for Inelastic scattering
/*!
 *   LoadParamFiles( "WiringInfo.xml", "DetectorInfo.xml", "CaseInfo.xml" )
 *   LoadTrignetEventFile( runNo, "/data", "" )
 *   SetHistAllocation()
 *   ecm = ElementContainerMatrix()
 *   SetElementContainerMatrix( ecm, runNo, "/data", "" )
 */

class UtsusemiEventDataConverterNeunetWithPHDep:
    public UtsusemiEventDataConverterTemplateWithPHDep< UtsusemiNeunetEventDecoderBase,
                                               UtsusemiEventCasesDecoderTemplate<T0TreatToolsNeunet,UtsusemiFilterTrignet>
                                               >
{
private:
    void Initialize();
    std::string _MessageTag;
    StringTools* stools;
    Int4 _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!< This must be executed after LoadEventDataFiles
         *
         *     _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )
         *   @param ecm          (ElementContainerMatrix*)
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */

public:
    UtsusemiEventDataConverterNeunetWithPHDep();
        //!< Constructor
        /*!<
         */
    ~UtsusemiEventDataConverterNeunetWithPHDep();
        //!< Destructor
        /*!<
         */
    bool LoadParamFiles( std::string w_file, std::string d_file, std::string c_file="" );
        //!< Loads parameter files
        /*!< This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.
         *
         *   @param w_file (std::string) Wiring Info file path
         *   @param d_file (std::string) Detector Info file path
         *   @param c_file (std::string) Case Info file path
         *   @retval true  : succeeded.
         *   @retval false : failed.
         */
    void SetElementContainerNeunetWithPHDep( UInt4 outer_pixel_id, ElementContainer* ec, UInt4 ph_i, UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainer
        /*!<
         *   @param outer_pixel_id (UInt4) pixel_id
         *   @param ec (ElementContainer*)
         *   @param ph_i (UInt4)
         *   @return None
         */
    Int4 LoadEventDataFiles( UInt4 runNumber, std::string pathToData="", std::string pathToT0data="" );
        //!< Loads event data files
        /*!<
         *   @param runNumber (UInt4) run number
         *   @param pathToData (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         */
    Int4 LoadEventDataFiles( std::vector<UInt4> runNumbers, std::string pathToData="", std::string pathToT0data="" );
        //!< Loads event data files
        /*!<
         *   @param runNumbers (<std::vector<UInt4>) a seriese of run numbers
         *   @param pathToData (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         */
    Int4 SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!<
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )
         *
         *   @param ecm          (ElementContainerMatrix*)
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    Int4 SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data="", UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!<
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber,
         *                                std::string pathToData="", std::string pathToT0data="", UInt4 caseId=1 )
         *
         *   @param ecm          (ElementContainerMatrix*)
         *   @param runNumber    (UInt4) run number
         *   @param pathToData   (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    Int4 SetElementContainerMatrix( ElementContainerMatrix* ecm, std::vector<UInt4> runNuber, std::string pathToData, std::string pathToT0data="", UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!<
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, std::vector<UInt4> runNuber,
         *                                std::string pathToData="", std::string pathToT0data="", UInt4 caseId=1 )
         *
         *   @param ecm          (ElementContainerMatrix*)
         *   @param runNumber    (std::vector<UInt4>) the list of run numbers
         *   @param pathToData   (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    void LoadTrignetEventFile( UInt4 runno, std::string pathToData="", std::string pathToT0data="" );
        //!< Reads Trignet Event data file for cases
        /*!<
         *   @param runno (UInt4) The run number
         *   @param pathData (std::string) path to the event data files
         *   @param pathToT0data (std::string) path to the t0 event data files
         *   @return None
         */
    void ReadTrignetEventFile( std::string pathToTrigData, UInt4 index=0 );
        //!< Reads Trignet Event data file for cases
        /*!<
         *   @param pathToTrigData (std::string) path to TrigNET event data files
         *   @param index (UInt4) event file index
         *   @return None
         */
    std::vector<UInt4> DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size );
        //!< Dumps table of cases
        /*!<
         *   @param i1 (UInt4)
         *   @param i2 (UInt4)
         *   @param isI1Size (bool)
         *   @param isI2Size (bool)
         *   @return None
         */
    Int4 SetElementContainerMatrixForPseudOnLineMon( ElementContainerMatrix* ecm, UInt4 caseId=1, UInt4 runNo=999999 );
        //!< Sets histograms to ElementContainermatrix as pseud on-line monitor
        /*!<
         *   @param ecm    (ElementContainerMatrix*)
         *   @param caseId (UInt4) case ID
         *   @param runNo  (UInt4) run number
         *   @param isI2Size (bool)
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    Int4 SetDataPathTest( std::string dataPath, std::string t0Path, UInt4 runNo );
        //!< Checks the function of SetDataPath
        /*!<
         *   @param dataPath  (std::string) Tha path to data folder
         *   @param t0Path  (std::string) Tha path to t0 data folder
         *   @param runNo  (UInt4) run number
         *   @retval  0 : succeed
         *   @retval -1 : failed
         */
    std::vector<Double> PutListOfCounterConditions();
        //!< Puts the list of the counter conditions for trignet
        /*!< This calls UtsusemiFilterTrignet::PutListOfCounterConditions
         *
         *   @param None
         *   @return std::vector<Double>  [CaseId_0_start, CaseId_0_end, CaseId_1_start, ... , CaseId_n_end]
         */
    void SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNumber,
                                    UInt4 det_min, UInt4 det_max, UInt4 num_of_pixel,
                                    UInt4 ph_min, UInt4 ph_max, UInt4 ph_bin,
                                    std::string histparam="tof,0,40000,100",
                                    std::string pathToData="/data", std::string pathToT0data="", UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!<
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber,
         *                                UInt4 det_min, UInt4 det_max, UInt4 num_of_pixel,
         *                                UInt4 ph_min, UInt4 ph_max, UInt4 ph_bin,
         *                                std::string histparam="tof,0,40000,100",
         *                                std::string pathToData="/data", std::string pathToT0data="", UInt4 caseId=1 )
         *
         *   @param ecm          (ElementContainerMatrix*)
         *   @param runNumber    (UInt4) run number
         *   @param det_min      (UInt4) the minumum of the detector id range
         *   @param det_max      (UInt4) the maximum of the detector id range
         *   @param num_of_pixel (UInt4) the number of pixels of one PSD
         *   @param ph_min       (UInt4) the minimum of the pulse height range
         *   @param ph_max       (UInt4) the maximum of the pulse height range
         *   @param ph_bin       (UInt4) the bin width of the pulse height data
         *   @param histparam    (std::string) the paramters of the histogram creations
         *   @param pathToData   (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */

};
#endif
