#ifndef UTSUSEMIEVENTDATACONVERTERMWPC
#define UTSUSEMIEVENTDATACONVERTERMWPC

#include "UtsusemiHeader.hh"
#include "UtsusemiEventDataConverterReadoutTemplate.hh"
#include "UtsusemiEventCasesDecoderTemplate.hh"
#include "UtsusemiReadoutMWPCEventDecoder.hh"
#include "UtsusemiFilterTrignet.hh"
#include "StringTools.hh"

////////////////////////////////////////
// UtsusemiEventDataConverterMWPC
////////////////////////////////////////

//! Load Event Data and convert to Histogram from 2d-scintillation counter PCMT
/*!
 *   LoadParamFiles( "WiringInfo.xml", "DetectorInfo.xml", "CaseInfo.xml" )
 *   LoadTrignetEventFile( runNo, "/data", "" )
 *   SetHistAllocation()
 *   ecm = ElementContainerMatrix()
 *   SetElementContainerMatrix( ecm, runNo, "/data", "" )
 */

class UtsusemiEventDataConverterMWPC:
    public UtsusemiEventDataConverterReadoutTemplate<UtsusemiReadoutMWPCEventDecoder,
                                               UtsusemiEventCasesDecoderTemplate<T0TreatToolsReadout,UtsusemiFilterTrignet>
                                               >
{
private:
    void Initialize();
    std::string _MessageTag;
    StringTools* stools;
    Int4 _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!< This must be executed after LoadEventDataFiles
         *
         *     _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )
         *   @param ecm          (ElementContainerMatrix*)
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    UInt4 _NumOfMulTh;

public:
    UtsusemiEventDataConverterMWPC();
        //!< Constructor
        /*!<
         */
    ~UtsusemiEventDataConverterMWPC();
        //!< Destructor
        /*!<
         */

};
#endif
