#include "UtsusemiCaseInfoReaderTrignet.hh"
//////////////////////////////////////////////////////////
UtsusemiCaseInfoReaderTrignet::
UtsusemiCaseInfoReaderTrignet():
CaseInfoReaderBase(){
    Initialize();
}
//////////////////////////////////////////////////////////
UtsusemiCaseInfoReaderTrignet::
UtsusemiCaseInfoReaderTrignet(std::string filename):
CaseInfoReaderBase(filename){
    Initialize();
    ImportCaseInfo();
}
//////////////////////////////////////////////////////////
UtsusemiCaseInfoReaderTrignet::
~UtsusemiCaseInfoReaderTrignet(){
    delete stools;
    delete _UTD;
    _ClearInfo();
}

//////////////////////////////////////////////////////////
void UtsusemiCaseInfoReaderTrignet::
Initialize(){
    stools = new StringTools();
    _CF_KEY = "CaseInfo";
    _MessageTag = "UtsusemiCaseInfoReaderTrignet >> ";

    _UTD = new UtsusemiTrignetDictionary();

    _TrignetInfo = NULL;
    _TrignetCounter = NULL;
    _CaseAmbiguity = 0;
    _CaseAmbiguity_params.clear();
    _InitialCase = 0;
}
//////////////////////////////////////////////////////////
void UtsusemiCaseInfoReaderTrignet::
_ClearInfo(UInt4 key){
    if ((key==0)||(key==1)){
        if (_TrignetInfo!=NULL){
            for (UInt4 i=0;i<_TrignetInfo->size();i++){
                if (_TrignetInfo->at(i)!=NULL){
                    for (UInt4 j=0;j<_TrignetInfo->at(i)->size();j++){
                        if (_TrignetInfo->at(i)->at(j)!=NULL){
                            delete _TrignetInfo->at(i)->at(j);
                        }
                    }
                    delete _TrignetInfo->at(i);
                }
            }
            delete _TrignetInfo;
            _TrignetInfo=NULL;
        }
    }else if ((key==0)||(key==2)){
        if (_TrignetCounter!=NULL) {
            for (UInt4 i=0;i<_TrignetCounter->size();i++){
                if (_TrignetCounter->at(i)!=NULL) delete _TrignetCounter->at(i);
            }
            delete _TrignetCounter;
            _TrignetCounter=NULL;
        }
    }

}
//////////////////////////////////////////////////////////
Int4 UtsusemiCaseInfoReaderTrignet::
_makeTrignetCondition( std::string xmlpath_trignet, UtsusemiTrignetCondition &trigCond ){
    Int4 ret;

    //ret = trigCond.SetTrig( mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "trig" ) );
    ret = trigCond.SetTrig( mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "io" ) );
    if (ret<0){
        UtsusemiError(_MessageTag+" <trignet> attribute io is invalid.");
        return -1;
    }

    std::string s_index = mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "index" );
    if (s_index!="") trigCond.SetIndex( stools->StringToUInt4( s_index ) );
    else trigCond.SetIndex( 0 );

    std::string s_type =  mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "type" );
    if (s_type!="")
        ret =  trigCond.SetType( s_type );
    else ret =  trigCond.SetType( "DIO" );
    ret = trigCond.SetTitle( mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "title" ) );
    ret = trigCond.SetAttr( mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "attr" ) );

    std::vector<UInt4> v_cont;
    v_cont.clear();

    std::string s_cont = mxReader->putTextContent( _CF_KEY, xmlpath_trignet);
    //std::cout << "UtsusemiCaseInfoReaderTrignet::_makeTrignetCondition xmlpath_trignet,s_cont="<<xmlpath_trignet<<":"+s_cont<<std::endl;
    std::vector<std::string> vs_cont = stools->SplitString(s_cont,",");
    for (UInt4 i=0;i<vs_cont.size();i++){
        // Contents is empty?
        if (vs_cont[i].find("trignet")==std::string::npos){
            //std::cout << "vs_cont[i]=" << vs_cont[i] << std::endl;
        }else{
            vs_cont.clear();
            break;
        }
    }
    //std::cout << "UtsusemiCaseInfoReaderTrignet::_makeTrignetCondition vs_cont.size()="<<vs_cont.size()<<std::endl;

    if (vs_cont.size()<2){
    }else{
        if (trigCond.Type==1){                  // type of 'DIO'
            if (vs_cont.size()!=8){
                return -1;
            }
            for (UInt4 j=0;j<vs_cont.size();j++){
                // DIO off=0, on=1, free=2
                if (vs_cont[j].find("0")!=std::string::npos) v_cont.push_back(0);
                else if (vs_cont[j].find("1")!=std::string::npos) v_cont.push_back(1);
                else v_cont.push_back(2);
                /*
                UInt4 tmp = stools->StringToUInt4( vs_cont[j] );
                // DIO off=0, on=1, free=2
                if ((tmp==0)||(tmp==1)){
                    v_cont.push_back( tmp );
                }else{
                    v_cont.push_back( 2 );
                }
                */
            }
        }else if ((trigCond.Type==2)||(trigCond.Type==3)){ // type of 'LADC1' or 'LADC2'
            if (vs_cont.size()!=2){
                UtsusemiError("ImportCaseInfo..  vs_cont.size !=2 (vs_cont.size()="+stools->UInt4ToString((UInt4)(vs_cont.size())));
                return -1;
            }
            v_cont.push_back( stools->StringToUInt4( vs_cont[0] ) );
            if (vs_cont[1]!=""){
                v_cont.push_back( stools->StringToUInt4( vs_cont[1] ) );
            }else{
                v_cont.push_back( stools->StringToUInt4( 0 ) );  // 0 of second parameter means infinity
            }
        }else if (trigCond.Type==4){                // type of 'HADC'
            if (vs_cont.size()!=4){
                return -1;
            }
            for (UInt4 j=0;j<vs_cont.size();j++){
                v_cont.push_back( stools->StringToUInt4( vs_cont[j] ) );
            }
        }else{
            return -1;
        }
    }
    trigCond.SetCont( v_cont );
    return 0;
}
//////////////////////////////////////////////////////////
Int4 UtsusemiCaseInfoReaderTrignet::
ImportCaseInfo( std::string filename )
{
    if ((filename=="")&&(mxReader==NULL)){
        UtsusemiError(_MessageTag+" No set filename.");
        return -1;
    }

    if (filename!=""){
        if (!(ReadFile( filename ))){
            UtsusemiError(_MessageTag+" No set filename.");
            return -1;
        }
    }
    if (CaseInfoReaderBase::ImportCaseInfo()){
        UtsusemiMessage(_MessageTag+" Found TimeSlicing. Using only this.");
        return 0;
    }
    //std::cout << "@@@@@ ImportCaseInfo" << std::endl;
    std::string xmlpath_root = "caseInfo";

    std::string xmlpath_ambiguity = xmlpath_root+"/caseAmbiguity";
    if (mxReader->hasPath(_CF_KEY,xmlpath_ambiguity)){
        std::string xmlpath_ambiguity_value = xmlpath_ambiguity + "/value";
        if (mxReader->hasPath(_CF_KEY,xmlpath_ambiguity_value)){
            std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath_ambiguity_value );
            if (s_val!="") _CaseAmbiguity = stools->StringToUInt4(s_val);

            std::string xmlpath_ambiguity_params = xmlpath_ambiguity + "/params/tofrange";
            if (mxReader->hasPath(_CF_KEY,xmlpath_ambiguity_params)){
                std::string s_params = mxReader->putTextContent( _CF_KEY, xmlpath_ambiguity_params );
                if (s_params!=""){
                    std::vector<std::string> tmp_params = stools->SplitString( s_params, "," );
                    _CaseAmbiguity_params.clear();
                    for (UInt4 i=0; i<tmp_params.size(); i++)
                        _CaseAmbiguity_params.push_back( stools->StringToDouble( tmp_params[i] ) );
                }
            }
        }else{
            std::string s_amb = mxReader->putTextContent( _CF_KEY, xmlpath_ambiguity );
            if (s_amb!="") _CaseAmbiguity = stools->StringToUInt4(s_amb);
        }
    }

    std::string xmlpath_firstcase = xmlpath_root+"/initialCase";
    if (mxReader->hasPath(_CF_KEY,xmlpath_firstcase)){
        std::string s_fcase = mxReader->putTextContent( _CF_KEY, xmlpath_firstcase );
        if (s_fcase!="") _InitialCase = stools->StringToUInt4(s_fcase);
    }

    std::string xmlpath_base = xmlpath_root+"/filters";
    std::string num_of_filters_st = mxReader->putTextContent( _CF_KEY, xmlpath_base, "n" );
    //std::cout << "@@ xmlpath_base,conts_filt=" << xmlpath_base << "," << num_of_filters_st << std::endl;
    if (num_of_filters_st!=""){

        UInt4 num_of_cases = stools->StringToUInt4(num_of_filters_st);

        if (_TrignetInfo!=NULL) _ClearInfo(1);

        _TrignetInfo = new std::vector< std::vector< UtsusemiTrignetCondGroup* >* >;

        _TrignetInfo->clear();

        for (UInt4 i=0;i<num_of_cases;i++){

            std::string xmlpath_fil = xmlpath_base+"/filter,i="+(stools->Int4ToString(i));
            UInt4 v_case = stools->StringToUInt4( mxReader->putTextContent( _CF_KEY, xmlpath_fil, "case" ) );
            if ((v_case+1)>(_TrignetInfo->size())) {
                _TrignetInfo->resize( v_case+1, NULL );
            }
            if (_TrignetInfo->at(v_case)==NULL){
                _TrignetInfo->at(v_case) = new std::vector< UtsusemiTrignetCondGroup* >;
            }

            UtsusemiTrignetCondGroup* tmp_utc = new UtsusemiTrignetCondGroup();

            // Import Trignet Info
            //std::string xmlpath_triginfo = xmlpath_fil+"/trignetInfo";
            std::string xmlpath_triginfo = xmlpath_fil+"/signal";
            if (mxReader->hasPath(_CF_KEY,xmlpath_triginfo)){

                UInt4 num_of_trignet = stools->StringToUInt4( mxReader->putTextContent( _CF_KEY, xmlpath_triginfo, "n" ) );

                for (UInt4 k=0;k<num_of_trignet;k++){
                    std::string xmlpath_trignet = xmlpath_triginfo+"/trignet,i="+stools->UInt4ToString(k);
                    if (mxReader->hasPath(_CF_KEY,xmlpath_trignet)){
                        std::string s_index = mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "index" );
                        UInt4 ind = 0;
                        if (s_index!=""){

                            UtsusemiTrignetCondition trigCond;
                            if (_makeTrignetCondition( xmlpath_trignet, trigCond )<0){
                                UtsusemiError(_MessageTag+"Fails to import filter/signal/trignet");
                            }else{
                                tmp_utc->AppendTrigCond( trigCond );
                            }

                        }else{
                            UtsusemiError(_MessageTag+" XML tag (filter/trignet) has no index ");
                            return -1;
                        }
                    }else{
                        UtsusemiError(_MessageTag+" False to find XML tag ("+xmlpath_trignet+ ")");
                    }
                }
                std::string isAnd_s = mxReader->putTextContent( _CF_KEY, xmlpath_triginfo, "cnd" );
                if (isAnd_s=="AND"){
                    tmp_utc->MakeCondArrayAndList();
                    tmp_utc->_TriggerCondArrayIsAnd=true;
                }else{
                    tmp_utc->_TriggerCondArrayIsAnd=false;
                }
            } else {
                UtsusemiError(_MessageTag+" False to find XML tag ("+xmlpath_triginfo+")");
            }

            // Import Time Range Info
            std::string xmlpath_time = xmlpath_fil+"/timeRange";
            if (mxReader->hasPath(_CF_KEY,xmlpath_time)){
                std::string s_timeType = mxReader->putTextContent( _CF_KEY, xmlpath_time, "type" );

                UInt4 v_step = 2;
                if (s_timeType=="PASS") v_step=2;
                if (s_timeType=="MLF") v_step=2;
                if (s_timeType=="DATE") v_step=14;

                std::string s_timeRange = mxReader->putTextContent( _CF_KEY, xmlpath_time );

                if (s_timeRange!=""){
                    std::vector<std::string> v_timeRange = stools->SplitString( s_timeRange, "," );
                    if ((v_timeRange.size()%(v_step))==0){
                        for (UInt4 j=0;j<v_timeRange.size();j+=v_step){
                            std::vector<Double> trange;
                            for (UInt4 k=0;k<v_step;k++){
                                trange.push_back( stools->StringToDouble( v_timeRange[j+k] ) );
                            }
                            tmp_utc->AppendTimeRangeCond( s_timeType,trange );
                        }
                    }else{
                        UtsusemiError(_MessageTag+"@@@ Invalid parameters in timeRange");
                    }
                }
            }else{
                UtsusemiError(_MessageTag+" False to find XML tag (" + xmlpath_time + ")");
            }

            // Impoert TOF Range Info
            std::string xmlpath_tof = xmlpath_fil+"/tofRange";
            if (mxReader->hasPath(_CF_KEY,xmlpath_tof)){
                std::string s_tofRange = mxReader->putTextContent( _CF_KEY, xmlpath_tof );
                if (s_tofRange!=""){
                    std::vector<std::string> v_tofRange = stools->SplitString( s_tofRange, "," );
                    if ((v_tofRange.size()%2)==0){
                        for (UInt4 j=0;j<v_tofRange.size();j+=2){
                            std::pair<Double,Double> trange;
                            trange.first = stools->StringToDouble( v_tofRange[j] );
                            trange.second = stools->StringToDouble( v_tofRange[j+1] );
                            tmp_utc->AppendTofRangeCond(trange );
                        }
                    }
                }
            }

            _TrignetInfo->at(v_case)->push_back( tmp_utc );
            //tmp_utc->Dump();
        }
    }

    xmlpath_base = xmlpath_root+"/counters";
    std::string num_counters_st = mxReader->putTextContent( _CF_KEY, xmlpath_base, "n" );
    //std::cout << "@@ xmlpath_base,num_counters=" << xmlpath_base << "," << num_counters_st << std::endl;
    //if (num_counters_st=="") num_counters_st="1";
    if (num_counters_st!=""){
        UInt4 num_of_counters = stools->StringToUInt4( num_counters_st );
        if (_TrignetCounter!=NULL) _ClearInfo(2);
        _TrignetCounter = new std::vector<UtsusemiTrignetCounter*>;
        _TrignetCounter->clear();

        for (UInt4 i=0;i<num_of_counters;i++){
            UtsusemiTrignetCounter* tmp_tc = new UtsusemiTrignetCounter();
            std::string xmlpath_counter = xmlpath_base + "/counter,i=" + stools->UInt4ToString(i);
            std::string type_st = mxReader->putTextContent( _CF_KEY, xmlpath_counter, "type" );
            Int4 ret=0;
            ret = tmp_tc->SetType( type_st );
            if (ret<0){
                UtsusemiError(_MessageTag+"ImportCaseInfo : WARNING :type is invalid in "+xmlpath_base);
            }
            std::string xmlpath_signal = xmlpath_counter+"/signal";
            if (mxReader->hasPath( _CF_KEY, xmlpath_signal )){
                std::string num_signal_s = mxReader->putTextContent( _CF_KEY, xmlpath_signal, "n" );

                if (num_signal_s!=""){
                    UInt4 num_signal = stools->StringToUInt4( num_signal_s );
                    for (UInt4 j=0;j<num_signal;j++){
                        std::string xmlpath_trignet = xmlpath_signal+"/trignet,i="+stools->UInt4ToString(j);
                        if (mxReader->hasPath(_CF_KEY,xmlpath_trignet)){
                            std::string s_trig = mxReader->putTextContent( _CF_KEY, xmlpath_trignet, "io" );
                            if (s_trig==""){
                                UtsusemiError(_MessageTag+" No XML tag (signal/trignet,io)");
                            }else{
                                UtsusemiTrignetCondition trigCond;
                                if (_makeTrignetCondition( xmlpath_trignet,trigCond )<0){
                                    UtsusemiError(_MessageTag+"Fails to import signal/trignet");
                                }else{
                                    if (tmp_tc->Type==0) tmp_tc->AddAsABphase( trigCond );
                                    else if (tmp_tc->Type==1) tmp_tc->AddTriggers( trigCond );
                                    else tmp_tc->AddTriggers( trigCond );
                                }
                            }
                        }else{
                            UtsusemiError(_MessageTag+" No XML tag (signal/trignet) " );
                            return -1;
                        }
                    }//for (j=0;j<num_signal)
                }//if (num_signal_s!="")
            }else{
                UtsusemiError(_MessageTag+" No XML tag (signal) ");
                return -1;
            }

            std::string xmlpath_ignoreKicker = xmlpath_counter+"/ignoreKickerInCondRange";
            if (mxReader->hasPath( _CF_KEY, xmlpath_ignoreKicker )){
                std::string tmp = mxReader->putTextContent( _CF_KEY, xmlpath_ignoreKicker );
                if (tmp.empty()){
                    tmp_tc->ignoreKickerInConditionRange = true;
                }else{
                    tmp.erase(std::remove_if(tmp.begin(), tmp.end(), ::isspace), tmp.end());
                    if ((tmp == "N") || (tmp == "n"))
                        tmp_tc->ignoreKickerInConditionRange = false;
                    else
                        tmp_tc->ignoreKickerInConditionRange = false;
                }
            }

            std::string xmlpath_conv = xmlpath_counter+"/conversionVal";
            if (mxReader->hasPath( _CF_KEY, xmlpath_conv )){
                tmp_tc->SetConvVal( mxReader->putTextContent( _CF_KEY, xmlpath_conv ) );
            }

            std::string xmlpath_org = xmlpath_counter+"/originVal";
            if (mxReader->hasPath( _CF_KEY, xmlpath_org )){
                tmp_tc->SetOrgVal( mxReader->putTextContent( _CF_KEY, xmlpath_org ),
                                   mxReader->putTextContent( _CF_KEY, xmlpath_org, "unit" ) );
                std::string s_priority=mxReader->PutContent( _CF_KEY, xmlpath_org,"priority" );
                if (s_priority!="")
                    if (tmp_tc->SetVirtualKickerPriority( s_priority )<0)
                        UtsusemiWarning(_MessageTag+":: Attribute <counter/originVal, signal> value is invalid.");
            }

            std::string xmlpath_conds = xmlpath_counter+"/conditions";
            if (mxReader->hasPath( _CF_KEY, xmlpath_conds )){
                std::string cond_type = mxReader->putTextContent( _CF_KEY, xmlpath_conds, "type" );
                if (cond_type!=""){
                    tmp_tc->SetConditionType( cond_type );
                    // <cond case="n">[min,max values]</cond>
                    if (cond_type=="1"){
                        std::vector<std::string> case_list = mxReader->PutAttValList( _CF_KEY, xmlpath_conds+"/cond", "case" );
                        for (UInt4 i=0; i<case_list.size(); i++){
                            std::string xmlpath_cond = xmlpath_conds+"/cond,case="+case_list[i];
                            tmp_tc->SetConditionList(stools->StringToUInt4( case_list[i] ),
                                                     mxReader->putTextContent( _CF_KEY, xmlpath_cond )
                                );
                        }
                    // <cond> [min, max, delta values] </cond>
                    }else if (cond_type=="2"){
                        UInt4 max_caseId = 0;
                        if (_TrignetInfo!=NULL) max_caseId = (UInt4)(_TrignetInfo->size())-1;
                        tmp_tc->SetConditionList( max_caseId+1,
                                                           mxReader->putTextContent( _CF_KEY, xmlpath_conds+"/cond" )
                            );
                    }
                }
            }

            std::string xmlpath_cyclic = xmlpath_counter+"/cyclicRegion";
            if (mxReader->hasPath( _CF_KEY, xmlpath_cyclic )){
                std::string cyclic_begin = mxReader->putTextContent( _CF_KEY, xmlpath_cyclic, "begin" );
                std::string cyclic_end = mxReader->putTextContent( _CF_KEY, xmlpath_cyclic, "end" );
                if ((cyclic_begin!="")&&(cyclic_end!=""))
                    tmp_tc->SetCyclicRegion( cyclic_begin, cyclic_end );
            }

            _TrignetCounter->push_back( tmp_tc );

        }//for (UInt4 i=0;i<num_of_counter;i++)
    }else{
        UtsusemiMessage(_MessageTag+" No XML tag (counters) ");
    }
    return 0;
}

//////////////////////////////////////////////////////////
std::vector< std::vector< UtsusemiTrignetCondGroup* >* >* UtsusemiCaseInfoReaderTrignet::
PutTrignetInfo(){
    return _TrignetInfo;

}
//////////////////////////////////////////////////////////
std::vector< UtsusemiTrignetCondGroup* >* UtsusemiCaseInfoReaderTrignet::
PutTrignetInfo( UInt4 caseId ){
    return _TrignetInfo->at(caseId);

}
//////////////////////////////////////////////////////////
UInt4 UtsusemiCaseInfoReaderTrignet::
PutNumOfCases( bool isOnlyFilter ){
    UInt4 ret_filter=0;
    UInt4 ret_counter=0;
    if (_TrignetInfo!=NULL){
        for (UInt4 i=0;i<_TrignetInfo->size();i++){
            if (_TrignetInfo->at(i)!=NULL) ret_filter++;
        }
    }

    if (_TrignetCounter!=NULL){
        for (UInt4 j=0;j<_TrignetCounter->size();j++){
            //std::cout << "@@@ _TrignetCounter->ConditionList->size()=" << _TrignetCounter->at(j)->ConditionList.size() << std::endl;
            if (_TrignetCounter->at(j)->ConditionType==1){
                ret_counter += (UInt4)(_TrignetCounter->at(j)->ConditionList.size());
            }else if (_TrignetCounter->at(j)->ConditionType==2){
                for (UInt4 i=0;i<_TrignetCounter->at(j)->ConditionList.size();i++){
                    std::vector<Double> *rinfo = _TrignetCounter->at(j)->ConditionList[i];
                    if (rinfo!=NULL){
                        ret_counter += (UInt4)((rinfo->at(1)-rinfo->at(0))/rinfo->at(2));
                    }
                }
            }
        }
    }

    if (_TimeSlicing!=NULL){
        UInt4 ret_timer=0;
        for (UInt4 i=1;i<_TimeSlicing->size();i++)
            if (_TimeSlicing->at(i)!=NULL) ret_timer++;
        return ret_timer;
    }

    if (isOnlyFilter) return ret_filter;
    else if (ret_counter==0) return ret_filter;
    else if (ret_filter==0) return ret_counter;
    else return ret_filter*ret_counter;

}
//////////////////////////////////////////////////////////
std::pair<UInt4,UInt4> UtsusemiCaseInfoReaderTrignet::
PutNumOfEachCases(){
    std::pair<UInt4,UInt4> ret;
    ret.first = 0;  // filter case
    ret.second = 0; // counter case

    if (_TrignetInfo!=NULL){
        for (UInt4 i=0;i<_TrignetInfo->size();i++){
            if (_TrignetInfo->at(i)!=NULL) ret.first++;
        }
    }

    if (_TrignetCounter!=NULL){
        for (UInt4 j=0;j<_TrignetCounter->size();j++){
            //std::cout << "@@@ _TrignetCounter->ConditionList->size()=" << _TrignetCounter->at(j)->ConditionList.size() << std::endl;
            if (_TrignetCounter->at(j)->ConditionType==1){
                ret.second += (UInt4)(_TrignetCounter->at(j)->ConditionList.size());
            }else if (_TrignetCounter->at(j)->ConditionType==2){
                for (UInt4 i=0;i<_TrignetCounter->at(j)->ConditionList.size();i++){
                    std::vector<Double> *rinfo = _TrignetCounter->at(j)->ConditionList[i];
                    if (rinfo!=NULL){
                        ret.second += (UInt4)((rinfo->at(1)-rinfo->at(0))/rinfo->at(2));
                    }
                }
            }
        }
    }

    if (_TimeSlicing!=NULL){
        for (UInt4 i=0;i<_TimeSlicing->size();i++){
            if (_TimeSlicing->at(i)!=NULL) ret.first++;
        }
    }

    return ret;
}

//////////////////////////////////////////////////////////
void UtsusemiCaseInfoReaderTrignet::
DumpCases(UInt4 caseId){
    if ((_TrignetInfo==NULL)||(_TrignetInfo->size()<(caseId+1))) {
        UtsusemiWarning(_MessageTag+" No TrignetInfo");
        //return;
    }else{
        std::vector< UtsusemiTrignetCondGroup* >* UTC = _TrignetInfo->at(caseId);
        if (UTC==NULL){
            UtsusemiError(_MessageTag+" No TrignetInfo about CaseId="+stools->UInt4ToString(caseId));
            return;
        }
        //Dump TriggerCondGroupArray
        std::cout <<  _MessageTag+"====== ConditionArray ======" << std::endl;
        for (UInt4 i=0;i<(UTC->size());i++){

            std::cout <<  _MessageTag+"  ====== TriggerCondArray ========" << std::endl;
            for (UInt4 j=0;j<(UTC->at(i)->_TriggerCondArray.size());j++){
                UtsusemiTrignetCondition utc = UTC->at(i)->_TriggerCondArray[j];
                std::cout <<_MessageTag+"      Index=" << utc.Index << ", Trigger=" << utc.Trigger;
                std::cout << ", Type=" << utc.Type << ", Conts=";
                for (UInt4 l=0;l<utc.Contents.size();l++) std::cout << utc.Contents[l] << ",";
                std::cout << std::endl;
            }
        }
        std::cout << _MessageTag+"DumpCases("<< caseId << ")" << std::endl;
        std::cout <<  _MessageTag+"====== TimeArray ========" << std::endl;
        for (UInt4 i=0;i<(UTC->size());i++){
            std::cout << _MessageTag+"  === TimeCondArray ===" << UTC->at(i)->_TimeRangeCondArray.size() << std::endl;
            for (UInt4 j=0;j<(UTC->at(i)->_TimeRangeCondArray.size());j++){
                std::cout << _MessageTag+"    ";
                for (UInt4 k=0;k<(UTC->at(i)->_TimeRangeCondArray[j].size());k++){
                    std::cout << UTC->at(i)->_TimeRangeCondArray[j][k] << ",";
                }
                std::cout << std::endl;
            }
        }
        std::cout << _MessageTag+"====== TofArray =====" << std::endl;
        for (UInt4 i=0;i<UTC->size();i++){
            std::cout <<  _MessageTag+"  ====== TofCondGroup ========" << std::endl;
            for (UInt4 j=0;j<(UTC->at(i)->_TofRangeCondArray.size());j++){
                std::pair<Double,Double> tmp = UTC->at(i)->_TofRangeCondArray[j];
                std::cout << _MessageTag+"    TOF=" << tmp.first << "," << tmp.second << std::endl;
            }
        }
    }

    if (_TimeSlicing!=NULL){
        std::cout << _MessageTag+"====== TimeSlicing =====" << std::endl;
        for (UInt4 i=1; i<(_TimeSlicing->size()); i++){
            std::pair<Double,Double> *tmp = _TimeSlicing->at(i);
            if (tmp!=NULL)
                std::cout << _MessageTag+"  Range [sec]=" << (*tmp).first << "," << (*tmp).second << std::endl;
        }
    }
}
//////////////////////////////////////////////////////////
void UtsusemiCaseInfoReaderTrignet::
DumpCases2(UInt4 caseId){
    if ((_TrignetInfo==NULL)||(_TrignetInfo->size()<(caseId+1))) {
        UtsusemiError(_MessageTag+" No TrignetInfo");
        return;
    }
    std::vector< UtsusemiTrignetCondGroup* >* UTC = _TrignetInfo->at(caseId);
    if (UTC==NULL){
        UtsusemiError(_MessageTag+" No TrignetInfo about CaseId="+stools->UInt4ToString(caseId));
        return;
    }
    //Dump TriggerCondGroupArray
    for (UInt4 i=0;i<(UTC->size());i++) UTC->at(i)->Dump();

}

//////////////////////////////////////////////////////////
void UtsusemiCaseInfoReaderTrignet::
DumpTrignetCounter(){
    if (_TrignetCounter==NULL){
        UtsusemiError(_MessageTag+"Not TrignetCounter is loaded.");;
    }else{
        for (UInt4 i=0;i<_TrignetCounter->size();i++) _TrignetCounter->at(i)->Dump();
    }
    return;
}
