#ifndef UTSUSEMIANAENVIRONREADER
#define UTSUSEMIANAENVIRONREADER


#include "Header.hh"
#include "ElementContainerMatrix.hh"
#include "BoostXmlParser.hh"
#include "StringTools.hh"
#include "UtsusemiHeader.hh"
class AnaEnvironPeriodInfo
{
public:
    AnaEnvironPeriodInfo();
    AnaEnvironPeriodInfo( const AnaEnvironPeriodInfo& obj );
    ~AnaEnvironPeriodInfo();
    std::pair<UInt4,UInt4> Period;
    std::vector<std::string> WiringInfoList;
    std::vector<std::string> DetectorInfoList;
    std::vector<std::string> MaskInfoList;

};

class UtsusemiAnaEnvironReader
{
private:
    void Initialize();
    BoostXmlParser* _parser;
    StringTools* _stools;
    std::string _MessageTag;

public:
    UtsusemiAnaEnvironReader( std::string envFileName, std::string UtsusemiUserXmlPath="" );
        //!< Constructor
        /*!<
         *   @param envFileName (std::string) Xml file name of the histogram creation environment information. If empty, environ_ana.xml is given.
         *   @param UtsusemiUserXmlPath (std::string) The path to the folder storing users xml files
         */
    UtsusemiAnaEnvironReader( UInt4 runNo, bool isQuiet=false );
        //!< Constructor
        /*!<
         *   @param runNo (UInt4) run number which is used to find the environment information xml file stored in the run folder (ex. SIK0123456_20230601/params/Utsusemi/environ_ana.xml).
         *   @param isQuiet (bool) If true, some messages including warning are not shown.
         */
    ~UtsusemiAnaEnvironReader();
        //!< Destructor
        /*!<
         */
    bool _Status;
    std::string _InstCode;
    std::string _OrgWiringInfoFile;
    std::string _OrgDetectorInfoFile;
    std::string _OrgMaskInfoFile;
    std::string _AnaEnvironFile ;
    std::string _UtsusemiParamFolder;
    bool _isQuiet;
    std::vector< AnaEnvironPeriodInfo > _FileHistory;
    static const std::string KEY_READ_XML;
    static const std::string ENV;
    static const std::string ENV_ANA;
    static const std::string ENV_ANA_INSTCODE;
    static const std::string ENV_ANA_ORGWIRINGINFO;
    static const std::string ENV_ANA_ORGDETECTORINFO;
    static const std::string ENV_ANA_FILEHISTORY;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD_STARTRUN;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD_ENDRUN;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD_WIRINGINFO;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD_DETECTORINFO;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD_MASKINFO;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD_PARAMS;
    static const std::string ENV_ANA_FILEHISTORY_PERIOD_PARAMS_AT_MODE;

    bool Read( std::string envFileName, std::string UtsusemiUserXmlPath="" );
        //!< Read the xml file of the histogram creation environment information
        /*!<
         *   @param envFileName (std::string) Xml file name of the histogram creation environment information. If empty, environ_ana.xml is given.
         *   @param UtsusemiUserXmlPath (std::string) The path to the folder storing users xml files
         *   @retval true succeeded.
         *   @retval false failed.
         */
    bool Read( UInt4 runNo, bool isQuiet=false );
        //!< Read the xml file of the histogram creation environment information
        /*!<
         *   @param runNo (UInt4) run number which is used to find the environment information xml file stored in the run folder (ex. SIK0123456_20230601/params/Utsusemi/environ_ana.xml).
         *   @param isQuiet (bool) If true, some messages including warning are not show.
         *   @retval true succeeded.
         *   @retval false failed.
         */
    bool Parse( std::string evnFilePath );
        //!< Parse the xml file of the histogram creation environment information
        /*!<
         *   @param envFileName (std::string) Xml file name of the histogram creation environment information. The empty is forbidden.
         *   @retval true succeeded.
         *   @retval false failed.
         */
    std::vector<std::string> PutParamFiles( UInt4 runNo, UInt4 modeNo=0, bool isFullPath=false );
        //!< Put the parameter xml files (WiringInfo, DetectorInfo and CaseInfo) by given a run number and mode number from the environment information.
        /*!<
         *   @param runNo (UInt4) the run number required to choose the suitable the parameter xml files (WiringInfo, DetectorInfo and CaseInfo).
         *   @param modeNo (UInt4) the mode number to choose the suitable parameter xml files.
         *   @param isFullPath (bool) whether the full path to the parameter xml files returns or not.
         *   @retval true succeeded.
         *   @retval false failed.
         */
    void Dump();
        //!< Show the contents of the environment information xml file
        /*!<
         *   @param None
         *   @retval None
         */

};
#endif
