#ifndef DETECTORINFOEDITORNEUNET
#define DETECTORINFOEDITORNEUNET

#include "DetectorInfoEditorBase.hh"
//////////////////////////////////
// DetectorInfoEditorNeunet
/////////////////////////////////

//!
/*!
 *
 */
class DetectorInfoEditorNeunet:
    public DetectorInfoEditorBase
{
private:

    std::string _MessageTag;

protected:
    void Initialize();
    double CalcPixelSolidAngle( std::vector<Double>* pv, std::vector<Double>* v1 );
        //!< Calculate solid angle
        /*!< pv = pixel position std::vector
         *   v1[0] = the number of pixels on a PSD
         *   v1[1] to v1[8] = PositionInfoVect ( read from XML file )
         * ( v1[1],v1[2],v1[3] ) = P0 vec ( direction std::vector of detector )
         * ( v1[4],v1[5],v1[6] ) = L std::vector (PSD direction and length)
         *   v1[7] = L0 : length between posi of P0 and origin of L vec
         *   v1[8] = diameter of PSD
         *
         *   @param pv (std::vector<Double>*) position std::vector
         *   @param v1 (std::vector<Double>*) parameters
         *   @return None
         */
    std::vector<Double> CrossVectorNorm( std::vector<Double> A, std::vector<Double> B );
        //!< calculates Cross between vectors
        /*!<
         *   @param A (std::vector<Double>)
         *   @param B (std::vector<Double>)
         *   @return A x B with unit length
         */
public:

    DetectorInfoEditorNeunet();
        //!< Constructor
        /*!<
         */
    DetectorInfoEditorNeunet( std::string dfile, bool workAsReader=true );
        //!< Constructor
        /*!<
         *   @param dfile (std::string) DetectorInfo file path to be read
         *   @param workAsReader (bool)
         */
    ~DetectorInfoEditorNeunet();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////
    std::vector< std::vector<Double>* >* detPositionInfoVect;  /**< detector axis vectors*/

    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    void Clear( UInt4 index=0 );
        //!< Clears stored parameters
        /*!<
         *   This deletes information by given index.
         *    index = 0 : all (default)
         *    index = 1 : InstrumentInfo
         *    index = 2 : TfpInfo
         *    index = 3 : TfpCalcParams
         *    index = 4 : PositionInfo
         *    index = 5 : BankInfo
         *
         *   @param index (UInt4)
         *   @return None
         */
    bool Read( std::string arg );
        //!< Reads DetectorInfo.xml and import information
        /*!<
         *   @param arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string
         *   @retval true : succeeded
         *   @retval false: failed
         */
    bool Write( std::string filepath );
        //!< Writes DetectorInfo.xml
        /*!<
         *   @param filepath (std::string)
         *   @retval true : succeeded
         *   @retval false: failed
         */
    std::string OutXml( bool withIndent=false );
        //!< Returns DetectorInfo as std::string
        /*!<
         *   @param withIndent(bool) false : output text without an indent format
         *   @return std::string
         */
    bool _makeOutputXmlNeunet();
        //!< Makes XML format from stored information
        /*!<
         *   @param  None
         *   @retval true    succeded
         *   @retval false   failed
         */
    bool SetInfoAsReader();
        //!< Converts WiringInfo into the format to be read from histogram creation methods
        /*!<
         *   @param  None
         *   @retval true    succeded
         *   @retval false   failed
         */
    void ClearReader( UInt4 index=0 );
        //!< Clears the WiringInfo data to be read from histogram creation methods
        /*!<
         *   @param  index (UInt4)   index of variables to be cleared.
         *   @retval None
         */
    std::vector<double> CalcPsdPixelPosition( UInt4 det_id, UInt4 pixelNo, UInt4 numOfPixel );
        //!< Calculate pixel position
        /*!< This calculates pixel position by given detector ID, Pixel no and number of pixels
         *
         *   @param det_id    (UInt4) detector ID
         *   @param pixelNo   (UInt4) pixel NO in a PSD of det_id ( 0 <= pixelNo < numOfPixel )
         *   @param numOfPixel (UInt4) the number of pixels in a PSD
         *   @return position (std::vector<double>) [px,py,pz]
         */
    Double CalcPsdPixelSolidAngle( UInt4 det_id, UInt4 pixelNo, UInt4 numOfPixel );
        //!< Calculates Solid Angle by given detId and Pixel No
        /*!<
         *   @param det_id (UInt4)
         *   @param pixelNo (UInt4)
         *   @param numOfPixel (UInt4)
         *   @return None
         */
};
#endif
