%global __os_install_post %(echo '%{__os_install_post}' | sed -e 's!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')
%global summary Plotter for Manyo library
%global desc Plotter for Manyo library

# Get branch/date/commit from archive name
%define _tgt %(basename $(find %{_sourcedir} -name "uGao-*.tar.gz" | head -1))
%define _fmt \\(.\\+\\?\\)\\.\\([0-9]\\{6\\}\\)git\\([0-9a-f]\\{8\\}\\)\\.tar\\.gz
%define branch    %(echo %{_tgt} | sed -e "s/^uGao-%{_fmt}$/\\1/")
%define refdate   %(echo %{_tgt} | sed -e 's/^uGao-%{_fmt}$/\\2/')
%define refcommit %(echo %{_tgt} | sed -e 's/^uGao-%{_fmt}$/\\3/')
%{!?ver: %define ver master}
%{!?revdate: %define revdate %{refdate}}
%define cvstype git
%{!?revno: %define revno %{refcommit}}

%define checkout %{cvstype}%{revno}

%define mlfsoft_path /opt/mlfsoft
%define install_path %{mlfsoft_path}/python-utsusemi
#%define py3_install_base %{install_path}/lib/python%{python3_version}
#%define py3_install_path %{py3_install_base}/site-packages
%define py3_install_base %{install_path}
%define py3_install_path %{py3_install_base}

Name:           utsusemi-deps-ugao
Version:        %{ver}.%{revdate}
Release:        0.%{checkout}%{?revsubno}%{?dist}
Summary:        %{summary}
License:        AS IS
URL:            https://mlfinfo.jp/groups/comp/ja/utsusemi.html
Source:         uGao-%{branch}.%{revdate}git%{revno}.tar.gz
BuildArch:      noarch

%description
%{desc}

%package -n utsusemi-deps-python36-ugao
Summary:        %{summary}
Requires:       python36

%description -n utsusemi-deps-python36-ugao
%{desc}

%prep
%setup -T -c
%{__tar} zxvf %{SOURCE0} --strip-component=1

%build

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}%{py3_install_path}/uGao
cp -af * %{buildroot}%{py3_install_path}/uGao
# Python3に未対応のファイルがあるためスキップ -- 2022-12-20 by Okazaki
#%{__python3} -c 'import compileall; compileall.compile_dir("%{buildroot}%{py3_install_path}/uGao", force=1)'
#%{__python3} -O -c 'import compileall; compileall.compile_dir("%{buildroot}%{py3_install_path}/uGao", force=1)'

%check
#%{__python3} setup.py test

%files -n utsusemi-deps-python36-ugao
%dir %{mlfsoft_path}
%dir %{install_path}
%dir %{install_path}/uGao
%{install_path}/uGao/*
#%dir %{install_path}/lib
#%dir %{install_path}/lib/python3.6
#%dir %{install_path}/lib/python3.6/site-packages
#%{install_path}/lib/python3.6/*

%changelog
* Wed Dec 21 2022 Nobuo Okazaki - master.el7
- インストール先ディレクトリを/opt/mlfsoft/python-utsusemi直下にした

* Tue Dec 20 2022 Nobuo Okazaki - master.el7
- Built for CentOS 7
