#! /bin/bash

export TARGET=${1:-/opt/mlfsoft/python3}

if [[ -a ${TARGET} ]]
then
    echo "installation folder ${TARGET} already exist, aborting ..."
    exit
else
    echo "installing into ${TARGET}"
    mkdir -p ${TARGET}
fi

if [[ -w ${TARGET} ]]
then
    echo "have write permission for ${TARGET}, proceeding"
else
    if [[ -a ${TARGET} ]]
    then 
        echo "missing permission for ${TARGET}, aborting, ..."
        exit
    else
        echo "missing permission for parent of ${TARGET}, aborting, ..."
        exit
    fi
fi

export TARGET=$(cd "$TARGET"; pwd)

# compiler settings
export CC=clang-omp
export CXX=clang-omp++
export PyVer=3.7
export UTSUSEMI_REV=1037
export NUM_MULTH=8

# paths
export ROOT=`pwd`
export BUILD=${ROOT}/mlf_build_root
export BUILDLOG=${BUILD}.log
export PY3LIB=${BUILD}/opt/mlfsoft/python${PyVer}
export PYENV=${TARGET}/.env/manyo
export MANYO_PATH=${PY3LIB}/manyo
export UGAO0_PATH=${PY3LIB}/python-ugao
export UTSU0_PATH=${PY3LIB}/python-utsusemi
export UGAO_PATH=${PY3LIB}/python-ugao/uGao
export UTSU_PATH=${PY3LIB}/python-utsusemi/utsusemi
export INSTALL_PATH=${MANYO_PATH}

echo
echo LOGFILE ${BUILDLOG}
echo


# python libs/includes

export PYBIN=`which python${PyVer}`
export NUMPYLIB=`echo $PYBIN | sed 's|bin/python|lib/python|g'`
export NUMPYINC=${NUMPYLIB}/site-packages/numpy/core/include
export PYPATH=`python3-config --includes | tr " " "\n" | cut -c 3- | xargs | tr " " ":"`
export PYLIBS=`python3-config --libs | egrep "^-L" | cut -c 3- | xargs | tr " " ":"`

echo
echo "#"
echo "# tidyup build"
echo "#"
echo

#
# DIR LAYOUT
#

cd ${BUILD}

if [[ -a ${UGAO_PATH} ]]
then
    echo "assume rerunning install on an existing build, skipping tidying up"
else
    mkdir -p ${UGAO0_PATH}
    mkdir -p ${UTSU0_PATH}

    mv uGao ${UGAO_PATH}
    mv Utsusemi/python-utsusemi ${UTSU_PATH}

    for x in SIK VNR AMR HPN
    do
        mv Utsusemi/python-utsusemi-${x} ${UTSU_PATH}/${x}
    done

    mkdir ${UTSU_PATH}/SIK/ana/tmp

    for x in SAS ENG TKtools
    do
        mv Utsusemi-${x}/python-utsusemi-${x} ${UTSU_PATH}/${x}
    done
fi

echo
echo "#"
echo "# set up python"
echo "#"
echo

#
# local python
#


${PYBIN} -m venv --copies ${PYENV}
source ${PYENV}/bin/activate
pip install -U pip >> ${BUILDLOG} 2>&1
pip install six scipy >> ${BUILDLOG} 2>&1

cd ${BUILD}
cp -a ../manyo_template/.* ${TARGET}
cp -a ../manyo_template/* ${TARGET}
mkdir -p ${TARGET}/.opt
cp -a ${PY3LIB}/manyo ${TARGET}/.opt/manyo

#mkdir manyo/lib
#cp manyo/MLF/libMLF.so manyo/lib
#cp manyo/core/libManyo.so manyo/lib

install_name_tool -change libManyo.so ${TARGET}/.opt/manyo/lib/libManyo.so ${TARGET}/.opt/manyo/Manyo/_Manyo.so
install_name_tool -change libManyo.so ${TARGET}/.opt/manyo/lib/libManyo.so ${TARGET}/.opt/manyo/Manyo/MLF/_MLF.so
install_name_tool -change libMLF.so ${TARGET}/.opt/manyo/lib/libMLF.so ${TARGET}/.opt/manyo/Manyo/MLF/_MLF.so


echo
echo "INSTALLATION COMPLETE: ${TARGET}"
echo "to use manyo-capable python run"
echo "   source ${TARGET}/.env/manyo/bin/activate"
echo "to restore terminal run"
echo "   deactivate"
echo
