#! /bin/bash

#source "${HOME}/mlfscripts/setup.sh"
source ../mlf_build_env.sh

export OPT="${APPUTSUSEMI}/.opt"
export OPTLIB="${OPT}/lib/cpp"
export PYROOT="${OPT}/python"
export PYBIN="${PYROOT}/bin/python3.7"
export BAK="${APPUTSUSEMI}_${TIMESTAMP}"

if [[ -a ${PYUTSUSEMI} ]]
then
    echo "${PYUTSUSEMI} exists already"
    exit
fi

if [[ -a "${APPUTSUSEMI}" ]]
then
    echo "backing up ${APPUTSUSEMI}"
    if [[ -w "${APPUTSUSEMI}" ]]
    then 
        mv "${APPUTSUSEMI}" "${BAK}"
    else
        echo "no write permission for ${APPUTSUSEMI}"
        exit
    fi    
fi

/bin/bash ${MLFINIT}/build_py.sh "${PYROOT}"
${PYBIN} -m pip install six scipy PySide2==5.11 matplotlib numpy lxml

mkdir -p ${OPTLIB}
cp -a ${CPPLIB}/* ${OPTLIB}
cd ${OPTLIB}
find . -name \*.dylib -exec ${PYBIN} ${MLFSCRIPTS}/so_fix.py ${OPTLIB}/{} ${OPTLIB} \;



mv "${APPUTSUSEMI}" "${PYUTSUSEMI}"

if [[ -a "$BAK" ]]
then
    mv "${BAK}" "${APPUTSUSEMI}"
fi
