#! /bin/bash

#source "${HOME}/mlfscripts/setup.sh"
source ../mlf_build_env.sh

export OPT="${APPMANYO}/.opt"
export OPTLIB="${OPT}/lib/cpp"

export PYROOT="${OPT}/python"
export PYBIN="${PYROOT}/bin/python3.7"
export BAK="${APPMANYO}_${TIMESTAMP}"

if [[ -a "${PYMANYO}" ]]
then
    echo "${PYMANYO} exists already"
    exit
fi
    
if [[ -a "${APPMANYO}" ]]
then
    echo "backing up ${APPMANYO}"
    if [[ -w "${APPMANYO}" ]]
    then 
        mv "${APPMANYO}" "${BAK}"
    else
        echo "no write permission for ${APPMANYO}"
        exit
    fi
fi

/bin/bash ${MLFINIT}/build_py.sh "${PYROOT}"
${PYBIN} -m pip install six scipy
mkdir -p ${OPTLIB}
cp -a ${CPPLIB}/* ${OPTLIB}
cd ${OPTLIB}
find . -name \*.dylib -exec ${PYBIN} ${MLFSCRIPTS}/so_fix.py ${OPTLIB}/{} ${OPTLIB} \;


mv "${APPMANYO}" "${PYMANYO}"

if [[ -a "$BAK" ]]
then
    mv "${BAK}" "${APPMANYO}"
fi
