#! /bin/bash

#export CPPLIB="${HOME}/mlfdata/cpplibs"
source ../mlf_build_env.sh
export CPPLIB="${MLFBUILDROOTPATH}/mlfdata/cpplibs"

if [[ -a "${CPPLIB}" ]]
then
    echo "not collecting C libraries folder ${CPPLIB} already exists"
else
    mkdir -p "${CPPLIB}"
    cd "${CPPLIB}"

    for x in libNeXus libboost_filesystem-mt libboost_program_options-mt libboost_serialization-mt libboost_system-mt libdf libgsl libgslcblas libhdf5 libiomp5 libmfhdf libmxml libsz libomp 
    do
        echo ${x}
        find /usr/local/lib -name ${x}\*.dylib -exec cp {} ${CPPLIB} \;
    done
fi
cp -n `otool -L ${CPPLIB}/* | grep /usr/local | sort | uniq | awk '{print $1}' | xargs` ${CPPLIB}
chmod u+rw ${CPPLIB}/*

