# macOS用バイナリインストールパッケージについて
作成関連のフォルダとファイルの説明を示す

## 構築環境

1. 任意の作業フォルダ直下に下記のフォルダとファイルを置く
   - mlf_build_env.sh
   - mlfdata
   - mlfinit
   - mlfout
   - mlfrun
   - mlfscripts

2. 環境構築用スクリプトを実施する

   ```
   $ cd mlfinit
   $ ./build_dep.sh
   $ ./setup_cpplibs.sh
   $ ./setup_py_server.sh
   ```

3. Jenkinsのインストールを行う（必要に応じて）

   ```
   $ cd mlfinit
   $ install_jenkins.sh
   ```

4. Jenkinsの設定を行う（詳細は省く）

## フォルダとファイルの説明

### mlf_build_env.sh
各種スクリプトが動作するように最初に読み込まれる初期設定用スクリプトである。

- このファイルのある場所を起点として各種環境変数を設定する
- 200204に追加

### mlfdata
パッケージビルド環境に必要なShared Libraryやテンプレートが入っている。

#### 最初から存在するフォルダ

**manyo_template**
- Manyo Shellアプリ用テンプレート

**nexusformat.diff**
- nexusformatのコードで新しいHDF5に対応させるためのパッチ

**utsusemi_template**
- Utsusemi用アプリのテンプレート



#### mlfinitのスクリプトにより作成されるフォルダ

**cpplib/**
- フォルダ自体はmlfscript/setup.shで作成され、中身はmlfinit/build_cpplibs.shで作成される。

**py_manyo/**
- 万葉ライブラリパッケージの前段階として、このフォルダの下に .opt 以下の構造が構築される。
- $(PYMANYO)で指定、${APPMANYO} (=/Application/Manyo) にリンク

**py_utsusemi/**
- 空蟬パッケージの前段階として、このフォルダの下に .opt 以下の構造が構築される。
- ${PYUTSUSEMI}で指定、${APPUTSUSEMI} (=/Application/Utsusemi)にリンク

**python/**
- Python本体のコンパイルを行い、最終的にパッケージに入れるために用意されており、mlfinit/build_py.sh により作成される

### mlfinit

環境を構築するためのスクリプトが入っている



**readme**
- 業者によるメモ

**build_dep.sh**
- brewの構築（開発環境とScience関連）、clang-ompの確認、nexsusformatのコード取得とコンパイル

**build_py.sh**
- Pythonコードの取得と展開、インストール（第一引数で与えられた場所へ）

**install_jenkins.sh**
- jenkinsをbrew経由でインストール

**setup_cpplibs.sh**
- mlfdata/cpplibsへ必要なライブラリを展開（/usr/local/libからコピー）

**setup_py_server.sh**
- mlfdata/py_manyoがなければsetup_py_manyo_server.sh
- mlfdata/py_utsusemiがなければsetup_py_utsusemi_server.sh

**setup_py_manyo_server.sh**
**setup_py_utsusemi_server.sh**
- それぞれのパッケージに必要なPython3とライブラリをインストール
- build_pyの実行、pipによる six scipy, PySide2などのインストール
- mlfdata/cpplibs/* のコピー

**setup_py_manyo_src.sh**
**setup_py_utsusemi_src.sh**
- それぞれのパッケージに必要なPython3と、pythonパッケージ(six,numpy,scipy,PySide2など）のインストール



### mlfout
作成されたパッケージの保存先

### mlfrun
mlfscript/setup.pyで作成され、ビルド中の一時ファイルが作成される。

### mlfscripts
パッケージの作成に必要なスクリプトが入っている

**build_manyo.sh**
- 万葉ライブラリのソースコードやコンパイル用スクリプト(mlfscripts/manyo_src)一式をtar-ballにする
- 万葉ライブラリのソースコードをコンパイルしてインストールする

**build_utsusemi.sh**
- 空蟬のソースコードやコンパイル用スクリプト(mlfscripts/utsusemi_src)一式をtar-ballにする
- 空蟬のソースコードをコンパイルしてインストールする

**fix_imports_manyo.sh**
**fix_imports_utsusemi.sh**
- manyo/Manyo/MLF/__init__.pyやUsusemi/__init__.pyの書式がpython2形式だったのをpython3形式にするものであるが、すでにそれぞれのMakefile.py3.mac内部で修正済みである。よってこれらのスクリプトは不要であり、すでにbuild_utsusemi.shやbuild_manyo.shではコメントアウトされている。

**fix_imports_ugao.sh**
- インストール時に行っている uGaoのuiファイルをPySide2用に再構築する時に生じるパスのミスを修正する（ただし、uiファイルが正しく整備されれば不要となる）

**fix_ui_uGao.sh**
**fix_ui_utsusemi.sh**
- GUIの.uiファイルをPySide2で再構築するスクリプトであるが、ui2_シリーズを使用しているので無駄なスクリプトである。修正が必要。

**get_last_updated_date.sh**
- git logから最終変更日を取得するスクリプトだが、実際には使用されていないようだ。

**install_jenkins.sh**
- Jenkinsをbrew経由でインストールする。

**installer_manyo.sh**
**installer_utsusemi.sh**
- Jenkinsから呼ばれる.pkgファイルを構築する。

**pystart.sh**
- PYTHONPATHやbinを設定するだけのスクリプトだが、現在は未使用のようだ。installer_utsusemi.shなどでコメントアウト扱い。

**setup.sh**
- もっとも使用頻度の高い、各種環境変数の設定用スクリプト。
- ただし、200204現在では、**mlf_build_env.sh** に置き換えられた。

**so_fix.py**
- shared library (.so) のリンクを書き換えるスクリプト（？）

**test_all.sh**
**test_manyo.sh**
**test_setup.sh**
**test_utsusemi.sh**
**manyo_src/**
**utsusemi_src/**


## 見つけた問題点（200201現在）

### mlfscripts/manyo_src, utsusemi_srcの整理が必要
- 使用するスクリプトが以前のままである
- 使うMakefileが違う
- fix_importsが使用されている
- 不要なスクリプトが同梱されている

### ui2ファイル整備に伴う不要なスクリプトの削除
- fix_ui_utsusemi.py, fix_ui_uGao.py
- fix_imports_ugao.sh
- これらを使用しているスクリプトの修正
