import os
import sys
import glob
import datetime

if len(sys.argv) > 1:
    MANYOPATH = sys.argv[1]
else:
    if "MANYO_PATH" in os.environ:
        MANYOPATH = os.environ["MANYO_PATH"]
    else:
        print("USAGE : python3 create_setenv.py <MANYO_PATH>")
        print("  Arguments:")
        print("            <MANYO_PATH> : Path of MLF software root like /opt/mlfsoft")
        sys.exit(0)

PYVERMAJ = sys.version_info.major
PYVERMIN = sys.version_info.minor
PYVERMIC = sys.version_info.micro

# search pypath
pypath_s = "/opt/homebrew/Cellar/python@{0}.{1}/{0}.{1}.{2}*".format(PYVERMAJ, PYVERMIN, PYVERMIC)
v = glob.glob(pypath_s)
if len(v) == 0:
    print("Not found python3")
    sys.exit(-1)
v.sort()
pypath = os.path.join(v[-1], "Frameworks/Python.framework/Versions/Current")

# search libomp version
l = glob.glob("/opt/homebrew/Cellar/libomp/*")
if len(l) == 0:
    print("Not found libomp")
    sys.exit(-1)
l.sort()
libomp_path = l[-1]

d = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
if os.path.exists(pypath):
    print("OK {}".format(pypath))
    cont = "# Created by create_setenv.py at {}\n".format(d)
    cont += "# Manyo Library Path like /opt/mlfsoft/manyo\n"
    cont += "unset PREFIX\n"
    cont += "export MANYO_PATH={}\n".format(MANYOPATH)
    cont += "\n"
    cont += ("BREWPYPATH="+pypath+"\n")
    cont += "BREWPYINCPATH=${BREWPYPATH}/include/python"
    cont += "{}.{}\n".format(PYVERMAJ, PYVERMIN)
    cont += "BREWPYLIBPATH=${BREWPYPATH}/lib\n"
    cont += "\n"
    cont += "# LIBRARY_PATH for compile\n"
    cont += "export LIBRARY_PATH=${MANYO_PATH}/lib:\\\n"
    cont += "/opt/homebrew/lib:\\\n"
    cont += "/opt/homebrew/opt/openssl/lib:\\\n"
    cont += "/opt/homebrew/opt/zlib/lib:\\\n"
    cont += libomp_path+"/lib:\\\n"
    cont += "${BREWPYLIBPATH}\n"
    cont += "\n"
    cont += "export DYLD_LIBRARY_PATH=${LIBRARY_PATH}\n\n"
    cont += "# INCLUDE_PATH for compile\n"
    cont += "export CPLUS_INCLUDE_PATH=${MANYO_PATH}/include:\\\n"
    cont += "${MANYO_PATH}/include/boost:\\\n"
    cont += "${MANYO_PATH}/include/nexus:\\\n"
    cont += "/opt/homebrew/include/:\\\n"
    cont += "${BREWPYINCPATH}:\\\n"
    cont += "/opt/homebrew/opt/openssl/include:\\\n"
    cont += libomp_path+"/include\n"
    cont += "\n"
    cont += "# Installation path and Python version\n"
    cont += "export INSTALL_PATH=${MANYO_PATH}\n"
    cont += "export PYTHONPATH=${MANYO_PATH}\n"
    cont += ("export PyVer=" + "{}.{}\n".format(PYVERMAJ, PYVERMIN))
    fo = open("setenv.sh", "w")
    fo.write(cont)
    fo.close()

    # Make _setEnvMac
    cont = "# Set environment for macOS\n"
    cont += "# Created by create_setenv.py at {}\n".format(d)
    cont += "# Set path to package root directory\n"
    cont += "# echo '======== _SetEnvUbuntuForMac ==========='\n"
    cont += "_DIR_=$(cd $(dirname $0); pwd)\n"
    cont += "export MLFSOFT_PATH=${_DIR_}/..\n"
    cont += "export MANYO_PATH=${MLFSOFT_PATH}/manyo\n"
    cont += "PYPATH_UTSUSEMI=${MLFSOFT_PATH}/python-utsusemi\n"
    cont += "export UTSUSEMI_BASE_DIR=${PYPATH_UTSUSEMI}/utsusemi\n"
    cont += "PYBIN=${MANYO_PATH}/bin:${UTSUSEMI_BASE_DIR}/bin\n"
    cont += "export PYTHONPATH=${MANYO_PATH}:${PYPATH_UTSUSEMI}:${UTSUSEMI_BASE_DIR}/facade:${UTSUSEMI_BASE_DIR}/${UTSUSEMI_INST_CODE}/facade:\n"
    cont += "export PATH=${PYBIN}:${PATH}\n"
    cont += "\n"
    cont += "# Add LIBRARY_PATH\n"
    cont += ("BREWPYPATH="+pypath+"\n")
    cont += "BREWPYINCPATH=${BREWPYPATH}/include/python"
    cont += "{}.{}\n".format(PYVERMAJ, PYVERMIN)
    cont += "BREWPYLIBPATH=${BREWPYPATH}/lib\n"
    cont += "LIBRARY_PATH=${MANYO_PATH}/lib:/opt/homebrew/lib:/opt/homebrew/opt/openssl/lib:/opt/homebrew/opt/zlib/lib:"
    cont += libomp_path+"/lib:${BREWPYLIBPATH}\n"
    cont += "DYLD_LIBRARY_PATH=${LIBRARY_PATH}\n"
    cont += "export LIBRARY_PATH\n"
    cont += "export DYLD_LIBRARY_PATH\n"
    fo = open("_setEnvMac", "w")
    fo.write(cont)
    fo.close()
else:
    print("FAILURE {}".format(pypath))

