# 空蝉 0.3.7/4.0.0 ビルドツール
## ビルド方法
環境を整えるためにCentOS7のDockerイメージを用意し、その中でビルドする。

### Dockerイメージの作成
dockerディレクトリ内でビルドする。

    % cd docker
    % docker build -t builder .

ビルドしたらこの中で作業可能。

### makeによるビルド
作成したコンテナ内で作業する。ソースディレクトリをコンテナ内の/tmp/srcにマウントしてビルドする。
ソースディレクトリはcontrib/builderである。
make開始時にコンテナも起動される。
manyo, utsusemiをビルドする際にはGitHubからソースを取得するため、GITHUB_TOKENが必要となる。

#### 一括ビルド
依存パッケージも含め、全てをビルドする。
環境にもよるが30分ぐらいかかる。

    % make GITHUB_TOKEN=xxx

#### 段階ビルド
必要に応じてビルドする。

    % make deps
    % make manyo GITHUB_TOKEN=xxx
    % make utsusemi037 GITHUB_TOKEN=xxx
    % make utsusemi4 GITHUB_TOKEN=xxx
    % docker stop builder

無事に終了したらdist内にパッケージが揃っている。
個別にビルドしたい場合は、各パッケージのディレクトリでmakeする。

### コマンドラインでのビルド(高度)
起動した環境に入る。

    % docker exec -ti --user rpmrepo builder bash

これ以降、Dockerコンテナ内での作業になる。

    [container]% cd /tmp/src
    [container]% export GITHUB_TOKEN=xxx
    [container]% ./mkpkg utsusemi-deps-cycler
    ...
    [container]% ./mkpkg utsusemi target_branch 0.3.7
    [container]% ./mkpkg utsusemi target_branch master

空蝉パッケージは一つのSPECで0.3.7および4.0.0に対応しているため、ビルドするブランチを指定する。
ビルドされたパッケージはdistディレクトリに格納される。ビルド後、都度インストールすること。

