%global srcname cycler
%global sum Cycle through lists in various ways (used by matplotlib)
%global desc General purpose library used by matplotlib to cycle through lists for colors,\
marker styles, etc

%define mlfsoft_path /opt/mlfsoft
%define install_root %{mlfsoft_path}/utsusemi
%define with_py2 0

Name:           utsusemi-deps-cycler
Version:        0.10.0
Release:        10%{?dist}
Summary:        %{sum}
License:        BSD
Source0:        https://github.com/matplotlib/cycler/archive/v%{version}/%{name}-%{version}.tar.gz#/%{srcname}-%{version}.tar.gz
URL:            https://github.com/matplotlib/cycler.git
BuildArch:      noarch

%description
%{desc}

%if %{with_py2}
%package -n utsusemi-deps-python2-%{srcname}
Summary:        %{sum}
Requires:       python-six
BuildRequires:  python2-devel python-six python-setuptools python-nose

%description -n utsusemi-deps-python2-%{srcname}
%{desc}
%endif

%package -n utsusemi-deps-python36-%{srcname}
Summary:        %{sum}
Requires:       python36-six
BuildRequires:  python3-devel python36-six python36-setuptools python36-nose

%description -n utsusemi-deps-python36-%{srcname}
%{desc}

%prep
%autosetup -n %{srcname}-%{version}

%build
%if %{with_py2}
%py2_build
%endif
%py3_build

%install
# Must do the python2 install first because the scripts in /usr/bin are
# overwritten with every setup.py install, and in general we want the
# python3 version to be the default.
#py3_install -- --install-purelib %{install_root}/lib
%if %{with_py2}
%py2_install -- --prefix %{install_root}
%endif
%py3_install -- --prefix %{install_root}

%check
%if %{with_py2}
%{__python2} setup.py test
%endif
%{__python3} setup.py test

# Note that there is no %%files section for the unversioned python module if we are building for several python runtimes
%if %{with_py2}
%files -n utsusemi-deps-python2-%{srcname}
#%doc README.rst
#%license LICENSE
#%{python3_sitelib}/*
%dir %{mlfsoft_path}
%dir %{install_root}
%dir %{install_root}/lib
%dir %{install_root}/lib/python2.7
%dir %{install_root}/lib/python2.7/site-packages
%{install_root}/lib/python2.7/*
%endif

%files -n utsusemi-deps-python36-%{srcname}
%dir %{mlfsoft_path}
%dir %{install_root}
%dir %{install_root}/lib
%dir %{install_root}/lib/python3.6
%dir %{install_root}/lib/python3.6/site-packages
%{install_root}/lib/python3.6/*

%changelog
* Fri Nov 22 2019 Nobuo Okazaki - 0.10.0-10.el7
- Built for CentOS 7

* Fri Jul 26 2019 Fedora Release Engineering <releng@fedoraproject.org> - 0.10.0-10
- Rebuilt for https://fedoraproject.org/wiki/Fedora_31_Mass_Rebuild

* Sat Feb 02 2019 Fedora Release Engineering <releng@fedoraproject.org> - 0.10.0-9
- Rebuilt for https://fedoraproject.org/wiki/Fedora_30_Mass_Rebuild

* Fri Jul 13 2018 Fedora Release Engineering <releng@fedoraproject.org> - 0.10.0-8
- Rebuilt for https://fedoraproject.org/wiki/Fedora_29_Mass_Rebuild

* Tue Jun 19 2018 Miro Hrončok <mhroncok@redhat.com> - 0.10.0-7
- Rebuilt for Python 3.7

* Fri Feb 09 2018 Fedora Release Engineering <releng@fedoraproject.org> - 0.10.0-6
- Rebuilt for https://fedoraproject.org/wiki/Fedora_28_Mass_Rebuild

* Tue Jan 16 2018 Iryna Shcherbina <ishcherb@redhat.com> - 0.10.0-5
- Update Python 2 dependency declarations to new packaging standards
  (See https://fedoraproject.org/wiki/FinalizingFedoraSwitchtoPython3)

* Thu Jul 27 2017 Fedora Release Engineering <releng@fedoraproject.org> - 0.10.0-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Mass_Rebuild

* Sat Feb 11 2017 Fedora Release Engineering <releng@fedoraproject.org> - 0.10.0-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_26_Mass_Rebuild

* Tue Dec 13 2016 Stratakis Charalampos <cstratak@redhat.com> - 0.10.0-2
- Rebuild for Python 3.6

* Mon Aug 29 2016 Neal Becker <nbecker@nbecker2> - 0.10.0-1
- Update to 0.10.0

* Tue Jul 19 2016 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.9.0-8
- https://fedoraproject.org/wiki/Changes/Automatic_Provides_for_Python_RPM_Packages

* Thu Feb 04 2016 Fedora Release Engineering <releng@fedoraproject.org> - 0.9.0-7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Sun Nov 15 2015 Neal Becker <ndbecker2@gmail.com> - 0.9.0-6
- Add BR python-nose

* Sun Nov 15 2015 Neal Becker <ndbecker2@gmail.com> - 0.9.0-5
- rebuild for py3.5

* Fri Nov  6 2015 Neal Becker <ndbecker2@gmail.com> - 0.9.0-3
- fix license

* Fri Oct 30 2015 Neal Becker <ndbecker2@gmail.com> - 0.9.0-1
- init

